//Especificaciones de cada tipo de tablero
//Small
#define SMALL_ROWS 8  
#define SMALL_COLS 8
#define SMALL_BOMBS 8
//Medium
#define MEDIUM_ROWS 16
#define MEDIUM_COLS 16
#define MEDIUM_BOMBS 32
//Large
#define LARGE_ROWS 24
#define LARGE_COLS 24
#define LARGE_BOMBS 64

//Opciones para el usario
#define SMALL 0
#define MEDIUM 1
#define LARGE 2
#define QUIT 9

//Corresponden a las columnas del array settings
#define ROW 0
#define COL 1
#define BOMB 2

#define TRUE 1
#define FALSE 0
//Posibles contenidos para los tableros
#define A_BOMB 'B'
#define ZERO '0'
#define HIDDEN '#'
#define EMPTY '_'
#define FLAG 'F'
//Condiciones
#define BOOOM 'X'
#define FOLLOW ','
#define END '!'

typedef unsigned short int USINT;
typedef unsigned int UINT;
USINT settings[3][3]= { {SMALL_ROWS,  SMALL_COLS,  SMALL_BOMBS},
 	                {MEDIUM_ROWS, MEDIUM_COLS, MEDIUM_BOMBS},
	                {LARGE_ROWS,  LARGE_COLS,  LARGE_BOMBS}
                      };
USINT PREF_SIZE;
//Los tableros es una matriz de char's
typedef char TYPE;
typedef TYPE** BOARD;
BOARD sys_board = NULL;
BOARD user_board = NULL;
//Cantidad de bombas establecidas
UINT setted_flags;
//Cantidad de celdas descubiertas
UINT free_cells;
UINT max_free_cells;

//Macros: predicados
#define is_a_bomb(b,r,c)   ((b[r][c]==A_BOMB)?TRUE:FALSE)
#define is_a_flag(b,r,c)   ((b[r][c]==FLAG)?TRUE:FALSE)
#define is_a_number(b,r,c) (('0'<b[r][c] && b[r][c]<='8')?TRUE:FALSE)
#define is_hidden(b,r,c)   ((b[r][c]==HIDDEN)?TRUE:FALSE)
