#include <stdio.h>
#include <stdlib.h>
#include <stdlib.h>
#include <time.h>

#ifndef __INCLUDE_THIS__
#define __INCLUDE_THIS__
#include "params.h"
#include "busca.h"
#endif

/*
Muestra un tablero, numerando las filas y columnas
*/
void show_board(BOARD b) {
  int i,j;
  printf("   ");
  for (j=1; j<=settings[PREF_SIZE][COL]; j++) 
    printf("%3d", j); //Imprime encabezados para columnas
  printf("\n");
  for (i=0; i<settings[PREF_SIZE][ROW]; i++) {
    printf("%3d", i+1); //Imprime encabezados para filas
    for (j=0; j<settings[PREF_SIZE][COL]; j++) {
       printf("%3c", b[i][j]);
    }
    printf("\n"); 
  }
}

/*
Muestra un renglon con el status de banderas colocadas y celdas liberadas
*/
void show_status() {
  printf("Flags %d de %d - Celdas descubiertas %d de %d\n\n", setted_flags, settings[PREF_SIZE][BOMB], free_cells, max_free_cells);
}

/*
Carga valores iniciales en un tablero, cada posicion se llena con el caracter recibido
*/
void set_value_board(BOARD b, char c) {
  int i,j;
  for (i=0; i<settings[PREF_SIZE][ROW]; i++) {
    for (j=0; j<settings[PREF_SIZE][COL]; j++) {
       b[i][j]=c;
    }
  }
}

/*
Funcion para inicializar variables y la semilla randomica
*/
void init() {
  setted_flags = 0;
  free_cells = 0;
  max_free_cells = settings[PREF_SIZE][ROW]*settings[PREF_SIZE][COL]-settings[PREF_SIZE][BOMB];
  srandom(time(NULL));
}

/*
Establece una bandera en la celda cubierta especificada
Si ya existe una bandera la quita
*/
void set_flag(BOARD b, int r, int c) {
  if (is_a_flag(b,r,c)) { //si hay una bandera en esta posicion, se quita
    setted_flags--;       //se decrementa el numero de banderas colocadas
    b[r][c] = HIDDEN;     //se establece nuevamente como celda cubierta
  } else {
    if (is_hidden(b,r,c) && setted_flags < settings[PREF_SIZE][BOMB]) {
      // si es una celda cubierta y aun no se alcanza a la cant max de bombas permitida se pude colocar otra bandera
      setted_flags++;     //se incrementa el numero de banderas colocadas
      b[r][c] = FLAG;
    } else {
      printf("Numero de FLAGs excedido\n");
    }
  }
}

/*
Inserta una bomba en un tablero en la posicion especificada
*/
void insert_bomb(BOARD b, int r, int c) {
   b[r][c] = A_BOMB;
}

/*
Calcula los valores numericos cercanos a las bombas en un tablero dado
Recorre todas las celdas validas que rodean a la posicion indicada
*/
void compute_numbers(BOARD b, int r, int c) {
   int i,j;
   for (i=r-1; i<=r+1; i++) {
     if (i<0 || i>settings[PREF_SIZE][ROW]-1) continue;
     for (j=c-1; j<=c+1; j++) {
       if (j<0 || j>settings[PREF_SIZE][COL]-1) continue;
       if (is_a_bomb(b,i,j) == FALSE)  //si no es una bomba
	  b[i][j]++;		       	       //modifica el valor numerico
     }
  }
}

/*
Carga las bombas en un tablero.
La seleccion de las celdas es aleatoria.
Termina al finalizar la carga del numero de bombas corresp al tablero elegido
*/
void load_bombs(BOARD b) {
  int bombs=0; 				      //contador de bombas
  int row, col;

  while (bombs < settings[PREF_SIZE][BOMB]) { //mientras falten bombas por establecer
      row = rand() % settings[PREF_SIZE][ROW];//se elige fila aleatoriamente      
      col = rand() % settings[PREF_SIZE][COL];//se elige columna aleatoriamente

      if (is_a_bomb(b,row,col)==TRUE) continue;//si hay una bomba alli ignorar y buscar nueva posicion
      insert_bomb(b,row, col); 	              //insertar la bomba
      compute_numbers(b,row,col);             //(re)calcular los valores cercanos a las bombas
      bombs++;				      //sumar una nueva bomba
  } 
}

/*
Verifica si las banderas colocadas cubren todas las bombas
*/
UINT test_bombs(BOARD sys, BOARD user) {
  int i, j;
  for (i=0; i<settings[PREF_SIZE][ROW]; i++)
    for (j=0; j<settings[PREF_SIZE][COL]; j++)
       if (is_a_flag(user,i,j))   //si es una bandera en el tablero del usuario
         if (!is_a_bomb(sys,i,j)) //se verifica si corresponde a una bomba en el tablero de sistema
           return FALSE;          //si no lo es, se retorna FALSE
            
  return TRUE;
}        

/*
Solicita memoria dinamica para almacenar un tablero
Las dimensiones del tablero corresponden a las del tipo de tablero elegido por el usuario
*/
void create_board(BOARD *b) {
  int i;
  //se solicita memoria dinamica para un array de cierta cantidad de TYPE*'s
  *b=(char**)malloc(sizeof(TYPE*)*settings[PREF_SIZE][ROW]);
  for (i=0; i<settings[PREF_SIZE][ROW]; i++) {
     //para cada posicion del array se solicita memoria para un array
     //de cierta cantidad de TYPE's
     (*b)[i]=(char*)malloc(sizeof(TYPE)*settings[PREF_SIZE][COL]);
  }
}

/*
Libera la memoria dinamica asignada a un tablero
*/
void free_board(BOARD *b) {
  int i;
  for (i=0; i<settings[PREF_SIZE][ROW]; i++) 
     free((*b)[i]); //libera cada array correspondiente a cada columna de cada fila
  free(*b);         //libera el array correspondiente a todas las filas
}

/*
Establece la variable global con el tamanyo elegido por usuario
*/
void set_pref(USINT p) {
  PREF_SIZE = p;
}

/*
Descubre la celda elegida y realiza un recorrido por las celdas vecinas
Recursion, se auto-invoca para las celdas vacias vecinas
*/
USINT discover(int r, int c) {
   int i,j;
   if (!is_hidden(user_board,r,c))  return 0; //si la celda ya esta descubierta en el user_board volver 
   if (is_a_bomb(sys_board,r,c)) {	      //chequear si hay una bomba alli
      return BOOOM;  		              //se retorna la condicion correspondiente
   }
   if (is_a_number(sys_board,r,c)) {	      //Si es un numero en sys_board
     user_board[r][c] = sys_board[r][c];      //se establece el valor de sys_board en user_board
     free_cells++;			      //se incrementa el numero de celdas descubiertas
     return 0;
   }
   if (is_a_flag(user_board,r,c))   return 0; //si es una bandera no hacer nada
   
   //Paso recursivo, aplica cuando la celda esta vacia
   user_board[r][c] = EMPTY;		      //Descubrir la celda 
   free_cells++;			      //se incrementa el numero de celdas descubiertas
   for (i=r-1; i<=r+1; i++) {
     //si se va de los bordes, ignorar
     if (i<0 || i>=settings[PREF_SIZE][ROW]) continue;
     for (j=c-1; j<=c+1; j++) {
       //si se va de los bordes, ignorar
       if (j<0 || j>=settings[PREF_SIZE][COL]) continue;
       //si es la misma celda ignorar
       if (i==r && j==c) continue;
       if (is_hidden(user_board,i,j)) {  //chequear solo si es una celda cubierta en el tablero de usuario
         discover(i,j);   //RECURSION: invocacion recursiva a discover
       }
     }
  }
  return 0;
}

/** MAIN FUNCTION **/
int main() {
  UINT pref;		//para almacenar la preferencia del usuario
  UINT row, col;	//para almacenar la fila y columna elegida por el usuario 
  char flag;		//para indicar insercion de bandera
  char condition;	//para indicar la condicion del juego
			//FOLLOW=cont jugando, END=establecio todas las bombas, BOOOM=detono una bomba 
  char status;		//
  
  do {
    printf("Ingrese el tablero de su preferencia: \n");
    printf(" 0) SMALL\n");
    printf(" 1) MEDIUM\n");
    printf(" 2) LARGE\n");
    printf(" %d) QUIT\n", QUIT);
    printf("Preferencia: ");
    scanf("%u", &pref);
    if (pref == QUIT) return 0;
  } while (pref < 0 || pref > 2);
  
  set_pref(pref);   		//setea el tamanyo del tablero
  create_board(&sys_board);	//crea dinamicamente el tablero del sistema
  init();    	    		//seteos generales
  set_value_board(sys_board, ZERO); //seteo en cero para todas las celdas
  load_bombs(sys_board);    	//carga las bombas y computa numeros
  create_board(&user_board);	//crear el tablero para el jugador
  set_value_board(user_board, HIDDEN); //establecer el caracter que cubre las celdas

  do {
     condition = FOLLOW;	//se establece la condicion 
     show_board(user_board);    //muestra el tablero del usuario
     show_status();             //muestra status del juego

     //Eleccion fila y columna  
     do { 
        printf("Ingrese fila: ");
        scanf("%u", &row);
        printf("Ingrese columna: ");
        scanf("%u", &col);
     } while( (row<=0 || row>settings[PREF_SIZE][ROW]) ||  //control de la posicion elegida debe estar
              (col<=0 || col>settings[PREF_SIZE][COL]) );  //dentro de las dimensiones permitidas

     //Desea colocar un flag en esa posicion? 
     do {
        scanf("%c", &flag); //consume un caracter (que quedaba colgado, refinar)
        printf("Ingresa una bandera? (s/n): ");
        scanf("%c", &flag);
     } while(flag!='s' && flag!='S' && flag!='n' && flag!='N'); //control de opcion de bandera

     //Acomodar subindices, pues se indexa desde cero
     row = row-1;
     col = col-1; 
    
     //Setear flag o descubrir celda 
     if (flag!='n' && flag!='N') {
       set_flag(user_board,row,col);		      //setear una bandera en la posicion elegida
       if (setted_flags == settings[PREF_SIZE][BOMB]) //chequea si se han colocado todas las banderas
         condition = END; 			      //si se colocan todas las banderas, finalizar
     } else {
	status = discover(row,col);		      //se descubre una celda (pueden ser varias)
        if (status == BOOOM) {	      		      //se chequea si se ha detonado una bomba
          printf("BOOOOOOOOOOOOOOOOOOOOOOOM!!!!!\n"); //se detona bomba
	  condition = BOOOM;			      //de ser asi se establece la condicion
          break;
        }
	if (free_cells == max_free_cells) {	      //se chequea si se han descubierto todas las celdas posibles
          condition = END;			      //de ser asi se establece la condicion
          break;
        }
     }
  } while(condition==FOLLOW); //continuar mientras no establecio todas las bombas y no detono ninguna 
  
  //Determinar por que se termino el juego 
  switch (condition) {
    case END: 
       if (free_cells == max_free_cells)
         printf("Gano ;) !!\n");
       else {
         if (test_bombs(sys_board,user_board) == TRUE)
           printf("Gano ;) !!\n");
         else {  // caso en que se establecieron todas las banderas pero no en el lugar correcto
           printf("Perdio :( !!\n");
           printf("Banderas mal colocadas!\n");
           printf("SOLUCION:\n"); 
         }
       }
       break;
    case BOOOM:
       printf("Perdio :( !!\n");
       printf("SOLUCION:\n");
       break;
  }
  show_board(sys_board);
  free(sys_board);
  free(user_board);
   
  return 0;
}  
