/*
 * Decompiled with CFR 0.152.
 */
package com.mja.util;

import com.mja.cmp.mjaLabel;
import com.mja.gui.mjaLayout;
import com.mja.util.BasicStr;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;

public class RandomNumber {
    private static final String[] max_options = new String[]{"9", "99", "999", "9999"};
    private static final String[] dec_options = new String[]{"0", "1", "2", "3", "4", "5"};
    private String name;
    private double value;
    private int max;
    private int decimals;
    private boolean allowNegatives;
    private Panel editPanel;
    private TextField tf_name;
    private Choice ch_max;
    private Choice ch_dec;
    private Checkbox cb_allowNegatives;

    public RandomNumber(String string, int n, int n2, boolean bl) {
        this.name = string;
        this.max = n;
        this.decimals = n2;
        this.allowNegatives = bl;
        this.value = RandomNumber.random(this.max, this.decimals, this.allowNegatives);
    }

    public RandomNumber(String string, String string2, String string3, String string4) {
        this.name = string;
        this.max = BasicStr.parseInteger(string2, 9, 9);
        this.decimals = BasicStr.parseInteger(string3, 0, 0);
        this.allowNegatives = !"no".equals(string4) && !"0".equals(string4);
        this.recalculate();
    }

    public void recalculate() {
        this.value = RandomNumber.random(this.max, this.decimals, this.allowNegatives);
    }

    public double getValue() {
        return this.value;
    }

    public String getStrValue(boolean bl) {
        return BasicStr.DoubleToString(this.value, this.decimals, bl);
    }

    public String getStrValue() {
        return this.getStrValue(false);
    }

    public String getName() {
        return this.name;
    }

    public static double random(int n, int n2, boolean bl) {
        double d;
        int n3 = (int)Math.round(Math.pow(10.0, Math.max(0, Math.min(8, n2))));
        do {
            d = (double)Math.max(n, 9) * Math.random();
        } while ((d = (double)((int)Math.round(d * (double)n3)) / (double)n3) == 0.0 || d == 1.0);
        if (bl && Math.random() < 0.5) {
            d = -d;
        }
        return d;
    }

    public Component getVisualComponent() {
        if (this.editPanel == null) {
            this.editPanel = new Panel(new FlowLayout(0, 0, 0));
            this.tf_name = new TextField(1);
            this.ch_max = new Choice();
            int n = 0;
            while (n < max_options.length) {
                this.ch_max.addItem(max_options[n]);
                ++n;
            }
            this.ch_dec = new Choice();
            int n2 = 0;
            while (n2 < dec_options.length) {
                this.ch_dec.addItem(dec_options[n2]);
                ++n2;
            }
            this.cb_allowNegatives = new Checkbox("");
            this.tf_name.setText(this.name);
            this.ch_max.select(String.valueOf(this.max));
            this.ch_dec.select(String.valueOf(this.decimals));
            this.cb_allowNegatives.setState(this.allowNegatives);
            this.editPanel.add(mjaLayout.pair(0.0, 1.0, new mjaLabel("nombre", 2, 2), this.tf_name));
            this.editPanel.add(mjaLayout.pair(0.0, 1.0, new mjaLabel("m\u00e1ximo", 2, 2), this.ch_max));
            this.editPanel.add(mjaLayout.pair(0.0, 1.0, new mjaLabel("decimales", 2, 2), this.ch_dec));
            this.editPanel.add(mjaLayout.pair(1.0, 0.0, new mjaLabel("permitir negativos", 2, 2), this.cb_allowNegatives));
        }
        return this.editPanel;
    }

    public void updateFromControls() {
        this.name = this.tf_name.getText();
        this.max = BasicStr.parseInteger(this.ch_max.getSelectedItem(), 9, 9);
        this.decimals = BasicStr.parseInteger(this.ch_dec.getSelectedItem(), 0, 0);
        this.allowNegatives = this.cb_allowNegatives.getState();
        this.value = RandomNumber.random(this.max, this.decimals, this.allowNegatives);
    }

    public String toString() {
        String string = "no";
        if (this.allowNegatives) {
            string = "si";
        }
        String string2 = "(" + this.name + "," + this.max + "," + this.decimals + "," + string + ")";
        return string2;
    }
}

