/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.cmp.mjaCanvas;
import com.mja.img.mjaImage;
import com.mja.lang.translator;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.Formula;
import com.mja.text.RTF;
import com.mja.text.TColors;
import com.mja.text.TFont;
import com.mja.text.TNode;
import com.mja.text.Text;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextCanvas
extends mjaCanvas
implements Runnable,
FocusListener {
    public static final String UpdateSelectors = "UpdateSelectors";
    public static final String ActivateFormulaButtons = "ActivateFormulaButtons";
    public static final String ActivateTextButtons = "ActivateTextButtons";
    protected boolean editing;
    protected boolean inVerticalMotion;
    protected boolean onlyFormula;
    protected boolean hasFocus;
    protected boolean fixed = true;
    protected volatile boolean updating;
    protected volatile Formula mainF;
    protected volatile Formula F;
    protected Text T;
    protected int dec = 2;
    protected int aL = 0;
    protected volatile int mainFIndex;
    protected mjaImage[] image = new mjaImage[0];
    protected mjaImage[] image2 = new mjaImage[0];
    protected Applet A;
    protected Frame parent;
    protected translator Tr;
    protected Parser parser;
    private ActionListener al;
    private Graphics pg;
    private Graphics bg;
    private Graphics gf;
    private Image fondo;
    private Image pizarra;
    private Image buffer;
    private int minH;
    private boolean pleaseStop;
    private boolean variableSize;
    private Thread thr;
    private boolean show = true;
    private int selectedImage = -1;

    public TextCanvas(Applet applet, Frame frame, translator translator2, Parser parser, TFont tFont, Color color, boolean bl, boolean bl2) {
        this.A = applet;
        this.parent = frame;
        this.Tr = translator2;
        this.parser = parser;
        this.variableSize = bl;
        this.onlyFormula = bl2;
        this.minH = 2 * (tFont.getAscent() + tFont.getDescent()) + 16;
        this.setText(new Text(this.parser, tFont, null, color));
        this.addFocusListener(this);
    }

    public void start() {
        this.updateGraphics();
        this.T.setCursorPos(this.T.firstLine());
        this.updateScreen();
        this.updateCursorThread();
    }

    public void stop() {
        if (this.thr != null) {
            this.pleaseStop = true;
            this.thr.stop();
            this.thr = null;
        }
    }

    public void show(boolean bl) {
        this.show = bl;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    public boolean isShowing() {
        return this.show;
    }

    public boolean onlyFormula() {
        return this.onlyFormula;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (graphics != null) {
            if (!this.show) {
                Color color = this.getBackground();
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                }
            } else if (this.buffer != null && this.buffer.getWidth(this) > 0 && this.buffer.getHeight(this) > 0) {
                graphics.drawImage(this.buffer, 0, 0, this);
            }
        }
    }

    public void setBGColor(Color color) {
        this.setBackground(color);
        if (this.getSize() != null && this.getSize().width > 0 && this.getSize().height > 0 && this.getGraphics() != null) {
            this.updateGraphics();
        }
    }

    void setImages(mjaImage[] mjaImageArray) {
        this.image = mjaImageArray;
    }

    public mjaImage[] getImages() {
        return this.image;
    }

    void setImages2(mjaImage[] mjaImageArray) {
        this.image2 = mjaImageArray;
    }

    public mjaImage[] getImages2() {
        return this.image2;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setExprDefaults(int n, boolean bl, int n2) {
        this.dec = n;
        this.fixed = bl;
        this.aL = n2;
    }

    public String toRTF(boolean bl) {
        RTF rTF = new RTF(this.T);
        String string = rTF.toRTF(bl);
        return string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.al = actionListener;
    }

    public Formula getMainFormula() {
        return this.mainF;
    }

    public void replaceRandomVariables(Vector vector) {
        int n = this.T.begin();
        while (n < this.T.end()) {
            if (this.T.TNode(n).isFormula()) {
                Formula formula = this.T.TNode(n).getFI().getFormula(0);
                formula.replaceRandomVariables(vector, true);
            }
            ++n;
        }
    }

    public void setMainFormula(Formula formula) {
        this.T.TNode(this.mainFIndex).getFI().setFormula(0, formula);
        this.mainF = formula;
        this.F = formula;
    }

    public String getCharAtCursor() {
        String string;
        TNode tNode = null;
        tNode = this.F != null ? this.F.TNode(this.F.firstChar(this.F.getCursorPos())) : this.T.TNode(this.T.firstChar(this.T.getCursorPos()));
        if (tNode.isPureChar() && (string = tNode.getChar()) != null && string.length() >= 1 && string.charAt(0) != '\n' && string.charAt(0) != '\u001a') {
            char c = string.charAt(0);
            return "0x" + Integer.toHexString(c);
        }
        return "";
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public void setMinimumHeight(int n) {
        this.minH = n;
    }

    public int getMinimumHeight() {
        return this.minH;
    }

    public int getCanvasHeight() {
        return 2 + Math.max(this.getTextHeight(), this.getMinimumHeight());
    }

    public int getTextHeight() {
        return this.T.getHeight(this);
    }

    public int getTextWidth() {
        return this.T.getWidth(this);
    }

    public void setText(Text text) {
        this.T = text;
        if (this.onlyFormula) {
            int n = text.firstFormula(text.begin());
            if (n < 0) {
                text.setCursorPos(text.firstChar(text.begin()));
                text.insertFormula(new Formula(this.parser));
                n = text.firstFormula(text.begin());
            }
            this.mainFIndex = n;
            text.setCursorPos(this.mainFIndex);
            this.F = this.mainF = text.TNode(this.mainFIndex).getFI().getFormula(0);
        }
    }

    public Text getText() {
        return this.T;
    }

    public TFont getFirstFont() {
        return this.T.getTFontAtTNode(this.T.firstChar(this.T.begin()));
    }

    public boolean segIsMarked() {
        if (this.F != null) {
            return this.F.segMarked;
        }
        return this.T.segMarked;
    }

    public TColors getCursorColors() {
        if (this.F != null) {
            if (this.F.segMarked) {
                return this.F.getColorsAtTNode(this.F.segMin());
            }
            return this.F.getColorsAtTNode(this.F.getCursorPos());
        }
        if (this.T.segMarked) {
            return this.T.getColorsAtTNode(this.T.segMin());
        }
        return this.T.getColorsAtTNode(this.T.getCursorPos());
    }

    public TFont getCursorTFont() {
        if (this.F != null) {
            return this.T.getTFontAtTNode(this.mainFIndex);
        }
        if (this.T.segMarked) {
            return this.T.getTFontAtTNode(this.T.segMin());
        }
        TFont tFont = this.T.getTFontAtTNode(this.T.getCursorPos());
        return tFont;
    }

    public void insertColors(TColors tColors) {
        if (this.F != null) {
            this.F.insertColors(tColors, true);
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            this.T.insertColors(tColors, true);
            if (this.T.segMarked()) {
                this.T.clean();
                this.updateScreenSegment(this.T.segMin(), this.T.segMax());
            } else {
                this.updateScreenLineAtTNode(this.T.getCursorPos());
            }
        }
        this.updateSize();
        this.paintCursor();
    }

    public void insertTFont(TFont tFont) {
        if (this.F != null) {
            this.T.markSegment(this.T.getCursorPos(), this.T.getCursorPos() + 1);
            this.T.insertTFont(tFont, true);
            this.T.unmarkSegment();
            this.T.clean();
            this.mainFIndex = this.T.getCursorPos();
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            this.T.insertTFont(tFont, true);
            if (this.T.segMarked()) {
                this.updateScreenFromTNode(this.T.segMin());
            } else {
                this.updateScreenFromTNode(this.T.getCursorPos());
            }
        }
        this.updateSize();
        this.paintCursor();
    }

    public void insertFormula(String string) {
        Formula formula = new Formula(this.parser, this.getCursorTFont(), this.getCursorColors().getBackColor(), this.getCursorColors().getTextColor());
        formula.insertString(string);
        this.insertFormula(formula);
    }

    private void insertFormula(Formula formula) {
        if (this.T.segMarked()) {
            this.removeMarkedSegment();
        }
        this.mainFIndex = this.T.getCursorPos();
        this.T.insertFormula(formula);
        formula.setActive(true);
        this.setMainFormula(formula);
        this.updateScreenFromTNode(this.mainFIndex);
        this.updateSize();
        this.paintCursor();
    }

    public void insertChar(char c) {
        this.insertText(new Character(c).toString());
    }

    public void insertText(String string) {
        if (this.F != null) {
            if (this.editing) {
                if (this.F.segMarked()) {
                    this.removeMarkedSegment();
                }
                this.F.insertText(string);
                this.updateScreenFromTNode(this.mainFIndex);
            }
        } else {
            if (this.T.segMarked()) {
                this.removeMarkedSegment();
            }
            TNode tNode = this.T.TNode(this.T.getCursorPos());
            int n = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
            this.T.insertText(string);
            if (string.equals("\n") || n != this.T.getLineHeightAtTNode(this, this.T.getCursorPos() - 1)) {
                this.updateScreenFromTNode(this.T.getCursorPos() - 1);
            } else {
                this.updateScreenLineAtTNode(this.T.getCursorPos());
            }
        }
        this.updateSize();
        this.paintCursor();
    }

    protected void delete() {
        if (this.F != null) {
            if (this.editing) {
                TNode tNode = this.F.TNode(this.F.getCursorPos());
                if (this.F.delete()) {
                    this.updateScreenFromTNode(this.mainFIndex);
                }
            }
        } else {
            TNode tNode = this.T.TNode(this.T.getCursorPos());
            int n = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
            if (this.T.delete()) {
                if ("\n".equals(tNode.getChar()) || n != this.T.getLineHeightAtTNode(this, this.T.getCursorPos())) {
                    this.updateScreenFromTNode(this.T.getCursorPos());
                    this.updateSize();
                } else {
                    this.updateScreenLineAtTNode(this.T.getCursorPos());
                }
            }
        }
        this.updateSize();
        this.paintCursor();
    }

    protected void backSpace() {
        if (this.F != null) {
            if (this.editing) {
                TNode tNode = this.F.TNode(this.F.prevChar(this.F.getCursorPos()));
                if (this.F.backSpace()) {
                    this.updateScreenFromTNode(this.mainFIndex);
                }
            }
        } else {
            TNode tNode = this.T.TNode(this.T.prevChar(this.T.getCursorPos()));
            int n = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
            if (this.T.backSpace()) {
                if ("\n".equals(tNode.getChar()) || n != this.T.getLineHeightAtTNode(this, this.T.getCursorPos())) {
                    this.updateScreenFromTNode(this.T.getCursorPos());
                    this.updateSize();
                } else {
                    this.updateScreenLineAtTNode(this.T.getCursorPos());
                }
            }
        }
        this.updateSize();
        this.paintCursor();
    }

    protected void removeMarkedSegment() {
        if (this.F != null) {
            if (this.editing && this.F.segMarked()) {
                this.F.removeMarkedSegment();
                this.updateScreenFromTNode(this.mainFIndex);
                this.paintCursor();
            }
        } else if (this.T.segMarked()) {
            this.T.removeMarkedSegment();
            this.updateScreenFromTNode(this.T.segMin());
            this.paintCursor();
        }
    }

    public void unmarkSegment() {
        if (this.F != null && this.F.segMarked) {
            this.F.unmarkSegment();
            this.updateScreenFromTNode(this.mainFIndex);
        }
        if (this.T.segMarked) {
            this.T.unmarkSegment();
            this.updateScreenSegment(this.T.segMin(), this.T.segMax());
        }
    }

    protected void updateSelectors() {
        if (this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 1001, UpdateSelectors));
        }
    }

    protected void activateButtons() {
        if (this.al != null) {
            String string = "";
            string = this.F != null ? ActivateFormulaButtons : ActivateTextButtons;
            this.al.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected int getCursorPos() {
        if (this.F != null) {
            return this.F.getCursorPos();
        }
        return this.T.getCursorPos();
    }

    protected void setCursorPos(int n, int n2) {
        int n3 = this.T.getIndexOfLineAtPixel(this, n2);
        int n4 = this.T.getOffsetOfTNodeAtPixel(this, n3, n);
        int n5 = this.T.firstChar(n3 + n4);
        if (!this.onlyFormula) {
            this.T.setCursorPos(n5);
        }
        this.inVerticalMotion = false;
        boolean bl = false;
        if (this.T.TNode(n5).isFormula()) {
            this.mainF = this.T.TNode(n5).getFI().getFormula(0);
            Formula formula = this.mainF.getFormulaAt(n, n2);
            if (formula != null) {
                bl = true;
                this.setActiveFormulaAt(n5, formula, n, n2);
            }
        }
        if (!this.onlyFormula && !bl) {
            this.mainF = null;
            this.setEditingFormula(null);
            this.mainFIndex = -1;
        }
    }

    protected void setCursorPosInText(int n, int n2) {
        int n3 = this.T.getIndexOfLineAtPixel(this, n2);
        int n4 = this.T.getOffsetOfTNodeAtPixel(this, n3, n);
        this.T.setCursorPos(this.T.firstChar(n3 + n4));
        this.inVerticalMotion = false;
    }

    protected void setCursorPosInFormula(int n, int n2) {
        int n3 = this.F.getOffsetOfTNodeAtPixel(this, 0, n);
        this.F.setCursorPos(this.F.firstChar(n3));
        this.inVerticalMotion = false;
    }

    protected void setActiveFormulaAt(int n, Formula formula, int n2, int n3) {
        if (this.F != null) {
            this.F.setActive(false);
            this.updateScreenFromTNode(this.mainFIndex);
        }
        this.F = formula;
        this.mainFIndex = n;
        if (this.F != null) {
            this.F.setActive(true);
            this.setCursorPosInFormula(n2, n3);
            this.F.markSegment(this.F.getCursorPos(), this.F.getCursorPos());
            this.updateScreenFromTNode(this.mainFIndex);
        }
        this.activateButtons();
    }

    protected void setEditingFormula(Formula formula) {
        this.setActiveFormulaAt(this.mainFIndex, formula, 0, 0);
    }

    protected void selectWordAt(int n) {
        if (this.F != null) {
            this.F.markSegment(this.F.begin(), this.F.end());
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            int n2 = n;
            int n3 = n;
            if (!this.T.TNode(n).isWordSeparator()) {
                while (n2 > this.T.begin() && !this.T.TNode(n2 - 1).isWordSeparator()) {
                    --n2;
                }
                while (n2 < n && !this.T.TNode(n2).isChar()) {
                    ++n2;
                }
                while (n3 < this.T.end() && !this.T.TNode(n3 + 1).isWordSeparator()) {
                    ++n3;
                }
                while (n3 > n && !this.T.TNode(n3).isChar()) {
                    --n3;
                }
                this.T.markSegment(n2, n3 + 1);
                this.updateScreen();
                int n4 = n2;
                while (n4 <= n3) {
                    if (this.T.TNode(n4).isFormula()) {
                        TextCanvas.analyseEquation(new Parser(), this.T.TNode(n4).getFI().getFormula(0).toExpresion(true));
                    }
                    ++n4;
                }
            }
        }
    }

    public static void analyseEquation(Parser parser, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = "Analysis:";
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n++ > 0) {
                string2 = string2 + "=";
            }
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + string3;
            Node node = null;
            try {
                node = parser.Analyse(string3, true);
                if (node == null) continue;
                string2 = string2 + node.toExpression();
            }
            catch (Exception exception) {
                System.out.println(string);
                System.out.println(string2);
                exception.printStackTrace();
            }
        }
    }

    protected void selectLineAt(int n) {
        if (this.F != null) {
            this.mainF.markSegment(this.mainF.begin(), this.mainF.end());
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            int n2 = n;
            int n3 = n;
            if (!this.T.TNode(n).isLineSeparator()) {
                while (n2 > this.T.begin() && !this.T.TNode(n2 - 1).isLineSeparator()) {
                    --n2;
                }
                while (n3 < this.T.end() && !this.T.TNode(n3 + 1).isLineSeparator()) {
                    ++n3;
                }
                this.T.markSegment(n2, n3 + 1);
                this.updateScreen();
            }
        }
    }

    protected void updateScreenLineAtTNode(int n) {
        if (this.pg != null) {
            Graphics graphics;
            int n2 = this.T.getY(this, n) - this.T.getLineAscentAtTNode(this, n);
            int n3 = this.T.getY(this, n) + this.T.getLineDescentAtTNode(this, n) + 1;
            this.pg.setClip(0, n2, this.getSize().width, n3 - n2);
            this.pg.drawImage(this.fondo, 0, 0, this);
            this.pg.setClip(0, 0, this.getSize().width, this.getSize().height);
            this.T.drawLineAtTNode(this.pg, this, this.editing, n, false);
            if (this.bg != null) {
                this.bg.setClip(0, n2, this.getSize().width, n3 - n2);
                this.bg.drawImage(this.pizarra, 0, 0, this);
                this.bg.setClip(0, 0, this.getSize().width, this.getSize().height);
            }
            if ((graphics = this.getGraphics()) != null) {
                graphics.setClip(0, n2, this.getSize().width, n3 - n2);
                graphics.drawImage(this.buffer, 0, 0, this);
                graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            }
        }
    }

    protected void updateScreenSegment(int n, int n2) {
        if (this.pg != null) {
            Graphics graphics;
            int n3 = this.T.getY(this, n) - this.T.getLineAscentAtTNode(this, n);
            int n4 = this.T.getY(this, n2) + this.T.getLineDescentAtTNode(this, n2) + 1;
            this.pg.setClip(0, n3, this.getSize().width, n4 - n3);
            this.pg.drawImage(this.fondo, 0, 0, this);
            this.pg.setClip(0, 0, this.getSize().width, this.getSize().height);
            this.T.drawSegment(this.pg, this, this.editing, n, n2);
            if (this.bg != null) {
                this.bg.setClip(0, n3, this.getSize().width, n4 - n3);
                this.bg.drawImage(this.pizarra, 0, 0, this);
                this.bg.setClip(0, 0, this.getSize().width, this.getSize().height);
            }
            if ((graphics = this.getGraphics()) != null) {
                graphics.setClip(0, n3, this.getSize().width, n4 - n3);
                graphics.drawImage(this.buffer, 0, 0, this);
                graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            }
        }
    }

    protected void updateScreenFromTNode(int n) {
        if (this.pg != null) {
            Graphics graphics;
            if (n > this.T.begin()) {
                int n2 = this.T.getY(this, n) - this.T.getLineAscentAtTNode(this, n);
                this.pg.setClip(0, n2, this.getSize().width, this.getSize().height - n2);
            }
            this.pg.drawImage(this.fondo, 0, 0, this);
            this.pg.setClip(0, 0, this.getSize().width, this.getSize().height);
            this.T.drawSegment(this.pg, this, this.editing, n, this.T.end(), false);
            if (this.bg != null) {
                this.bg.drawImage(this.pizarra, 0, 0, this);
            }
            if ((graphics = this.getGraphics()) != null) {
                graphics.drawImage(this.buffer, 0, 0, this);
            }
        }
    }

    public synchronized void updateScreen() {
        if (this.T != null) {
            this.T.calcValues(this.dec, this.fixed, this.aL, this.isEditing());
            this.updateScreenFromTNode(this.T.begin());
        }
    }

    public synchronized void updateBackground() {
        if (this.getBackground() != null && this.gf != null) {
            this.gf.setColor(this.getBackground());
            this.gf.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.updateImages();
    }

    public void updateImages() {
        int n = 0;
        while (n < this.image.length) {
            this.image[n].draw(this.gf, this);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.image2.length) {
            this.image2[n2].draw(this.gf, this);
            ++n2;
        }
    }

    public void selectImage(int n) {
        this.selectedImage = n;
        int n2 = 0;
        while (n2 < this.image.length) {
            if (n2 == this.selectedImage) {
                this.image[n2].setBorderSizeIn(3);
                this.image[n2].setBorderSizeOut(3);
                this.image[n2].setBorderColorIn(Color.yellow);
                this.image[n2].setBorderColorOut(Color.red);
            } else {
                this.image[n2].setBorderSizeIn(0);
                this.image[n2].setBorderSizeOut(0);
            }
            ++n2;
        }
        this.updateImages();
        this.updateScreen();
    }

    public void unSelectImage() {
        this.selectImage(-1);
    }

    public int getSelectedImage() {
        return this.selectedImage;
    }

    public boolean imageIsSelected() {
        return this.selectedImage >= 0 && this.image != null && this.selectedImage < this.image.length;
    }

    void updateGraphics() {
        if (this.getSize() != null && this.getSize().width > 0 && this.getSize().height > 0 && this.getGraphics() != null) {
            this.fondo = this.createImage(this.getSize().width, this.getSize().height);
            this.gf = this.fondo.getGraphics();
            this.updateBackground();
            this.pizarra = this.createImage(this.getSize().width, this.getSize().height);
            this.pg = this.pizarra.getGraphics();
            this.buffer = this.createImage(this.getSize().width, this.getSize().height);
            this.bg = this.buffer.getGraphics();
            this.updateScreen();
        }
    }

    public void updateSize() {
        if (this.variableSize && this.getSize() != null && this.getSize().height != this.getCanvasHeight()) {
            this.setSize(this.getSize().width, this.getCanvasHeight());
            this.updateGraphics();
            this.A.paintAll(this.A.getGraphics());
        }
    }

    protected void paintCursor() {
        try {
            Graphics graphics;
            if (this.isEditing() && this.hasFocus && !this.T.segMarked() && (graphics = this.buffer.getGraphics()) != null) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                TFont tFont;
                if (this.F != null) {
                    tFont = this.F.getTFont();
                    graphics.setColor(this.F.getColorsAtTNode(this.F.getCursorPos()).getTextColor());
                    n5 = this.F.getX(this, this.F.getCursorPos());
                    n3 = n4 = this.F.getY();
                    n2 = Math.min(tFont.getAscent(), this.F.getLineAscentAtTNode(this, this.F.getCursorPos()));
                    n = Math.min(tFont.getDescent(), this.F.getLineDescentAtTNode(this, this.F.getCursorPos()));
                } else {
                    tFont = this.T.getTFontAtTNode(this.T.getCursorPos());
                    graphics.setColor(this.T.getColorsAtTNode(this.T.getCursorPos()).getTextColor());
                    n5 = this.T.getX(this, this.T.getCursorPos());
                    n4 = this.T.getY(this, this.T.getCursorPos());
                    n3 = this.T.getY(this, this.T.getCursorPos());
                    n2 = tFont.getAscent();
                    n = tFont.getDescent();
                }
                int n6 = n2 + n;
                int n7 = n3 - n2;
                int n8 = n3 + n;
                int n9 = 1;
                if (tFont.isBold()) {
                    n9 = 3;
                }
                if (tFont.isItalic()) {
                    int n10 = (int)Math.round((double)n5 + (double)n2 / 4.5);
                    int n11 = (int)Math.round((double)n5 - (double)n / 4.5);
                    if (tFont.isBold()) {
                        Polygon polygon = new Polygon();
                        polygon.addPoint(n10, n7);
                        polygon.addPoint(n10 + n9, n7);
                        polygon.addPoint(n11 + n9, n8);
                        polygon.addPoint(n11, n8);
                        graphics.fillPolygon(polygon);
                    } else {
                        graphics.drawLine(n10, n7, n11, n8);
                    }
                } else {
                    graphics.fillRect(n5, n4 - n2, n9, n6);
                }
                Graphics graphics2 = this.getGraphics();
                if (graphics2 != null) {
                    graphics2.clipRect(n5 - n, n7, n6, n6);
                    graphics2.drawImage(this.buffer, 0, 0, this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void eraseCursor() {
        try {
            Graphics graphics;
            if (this.isEditing() && this.hasFocus && !this.T.segMarked() && (graphics = this.buffer.getGraphics()) != null) {
                int n;
                int n2;
                int n3;
                int n4;
                if (this.F != null) {
                    n4 = this.F.getX(this, this.F.getCursorPos());
                    n3 = this.F.getY();
                    n2 = this.F.getLineAscentAtTNode(this, this.F.getCursorPos());
                    n = this.F.getLineDescentAtTNode(this, this.F.getCursorPos());
                } else {
                    n4 = this.T.getX(this, this.T.getCursorPos());
                    n3 = this.T.getY(this, this.T.getCursorPos());
                    TFont tFont = this.T.getTFontAtTNode(this.T.getCursorPos());
                    n2 = Math.max(tFont.getAscent(), this.T.getLineAscentAtTNode(this, this.T.getCursorPos()));
                    n = Math.max(tFont.getDescent(), this.T.getLineDescentAtTNode(this, this.T.getCursorPos()));
                }
                int n5 = n2 + n;
                int n6 = n3 - n2;
                int n7 = n3 + n;
                graphics.clipRect(n4 - n, n6, n5, n5);
                graphics.drawImage(this.pizarra, 0, 0, this);
                Graphics graphics2 = this.getGraphics();
                if (graphics2 != null) {
                    graphics2.clipRect(n4 - n, n6, n5, n5);
                    graphics2.drawImage(this.buffer, 0, 0, this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateCursorThread() {
        if (this.isEditing()) {
            if (this.thr == null) {
                this.thr = new Thread(this);
                this.thr.start();
            }
        } else {
            this.stop();
        }
    }

    public void run() {
        this.pleaseStop = false;
        try {
            while (!this.pleaseStop) {
                Thread.sleep(400L);
                if (!this.pleaseStop) {
                    if (!this.updating) {
                        this.paintCursor();
                    }
                    Thread.sleep(400L);
                    if (!this.pleaseStop) {
                        if (this.updating) continue;
                        this.eraseCursor();
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 1001, "focus"));
        }
        this.hasFocus = true;
        if (this.F != null) {
            this.F.setActive(true);
            this.updateScreenFromTNode(this.mainFIndex);
        }
        this.paintCursor();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.eraseCursor();
        this.hasFocus = false;
        if (this.F != null) {
            this.F.setActive(false);
            this.updateScreenFromTNode(this.mainFIndex);
        }
    }
}

