/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.TColors;
import com.mja.text.TFont;
import com.mja.text.TNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public class Text
extends BasicText {
    private int leftMargin = 16;
    private int topMargin = 8;
    private int bottomMargin = 8;
    private boolean mustClean;

    public Text(Parser parser) {
        super(parser);
    }

    public Text(Parser parser, TFont tFont) {
        super(parser, tFont);
    }

    public Text(Parser parser, TFont tFont, Color color, Color color2) {
        super(parser, tFont, color, color2);
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public void setTopAndBottomMargin(int n) {
        this.topMargin = n;
        this.bottomMargin = n;
    }

    int getLeftMargin() {
        return this.leftMargin;
    }

    int getTopMargin() {
        return this.topMargin;
    }

    public Text cloneText() {
        Text text = new Text(this.getParser());
        text.info = this.cloneInfo();
        return text;
    }

    void insertText(String string) {
        super.insertText(string);
        if (this.mustClean) {
            this.clean();
        }
    }

    void clearColors(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 < n4) {
            if (this.TNode(n3).isColors()) {
                this.remove(n3);
                --n4;
                continue;
            }
            this.TNode(n3).clearColors();
            ++n3;
        }
    }

    public void insertColors(TColors tColors, boolean bl) {
        if (this.segMarked()) {
            this.insert(new TNode((BasicText)this, this.getColorsAtTNode(this.segMax())), this.segMax());
            this.clearColors(this.segMin(), this.segMax() - 1);
            this.insert(new TNode((BasicText)this, tColors), this.segMin());
            this.setColorsInFormulas(this.segMin(), this.segMax());
        } else {
            TColors tColors2 = this.getColorsAtTNode(this.getCursorPos());
            this.insert(new TNode((BasicText)this, tColors), this.getCursorPos());
            this.insert(new TNode((BasicText)this, tColors2), this.getCursorPos());
            this.setCursorPos(this.getCursorPos() - 1);
            this.setColorsInFormulas(this.getCursorPos());
        }
        this.mustClean = bl;
    }

    void insertTFont(TFont tFont, boolean bl) {
        if (this.segMarked()) {
            this.insert(new TNode((BasicText)this, this.getTFontAtTNode(this.segMax())), this.segMax());
            this.clearFonts(this.segMin() + 1, this.segMax() - 1);
            this.insert(new TNode((BasicText)this, tFont), this.segMin());
            this.setFontsInFormulas(this.segMin(), this.segMax());
        } else {
            TFont tFont2 = this.getTFontAtTNode(this.getCursorPos());
            this.insert(new TNode((BasicText)this, tFont), this.getCursorPos());
            this.insert(new TNode((BasicText)this, tFont2), this.getCursorPos());
            this.setCursorPos(this.getCursorPos() - 1);
            this.setFontsInFormulas(this.getCursorPos());
        }
        this.mustClean = bl;
    }

    private void setFontsInFormulas(int n) {
        TFont tFont = this.getTFontAtTNode(n);
        int n2 = n;
        while (n2 < this.end()) {
            if (this.TNode(n2).isTFont()) break;
            if (this.TNode(n2).isFormula()) {
                Formula formula = this.TNode(n2).getFI().getFormula(0);
                formula.setFonts(tFont);
            }
            ++n2;
        }
    }

    private void setFontsInFormulas(int n, int n2) {
        TFont tFont = this.getTFontAtTNode(n);
        int n3 = n;
        while (n3 < n2) {
            if (this.TNode(n3).isTFont()) {
                tFont = this.TNode(n3).getTFont();
            } else if (this.TNode(n3).isFormula()) {
                Formula formula = this.TNode(n3).getFI().getFormula(0);
                formula.setFonts(tFont);
            }
            ++n3;
        }
    }

    private void setColorsInFormulas(int n) {
        TColors tColors = this.getColorsAtTNode(n);
        int n2 = n;
        while (n2 < this.end()) {
            if (this.TNode(n2).isColors()) break;
            if (this.TNode(n2).isMath()) {
                this.TNode(n2).setColors(tColors);
            }
            ++n2;
        }
    }

    private void setColorsInFormulas(int n, int n2) {
        TColors tColors = this.getColorsAtTNode(n);
        int n3 = n;
        while (n3 < n2) {
            if (this.TNode(n3).isColors()) {
                tColors = this.TNode(n3).getColors();
            } else if (this.TNode(n3).isMath()) {
                this.TNode(n3).setColors(tColors);
            }
            ++n3;
        }
    }

    void insertFormula(String string) {
        this.insert(new TNode((BasicText)this, string, 11), this.getCursorPos());
    }

    void insertFormula(Formula formula) {
        this.insert(new TNode((BasicText)this, formula), this.getCursorPos());
    }

    boolean delete() {
        if (super.delete()) {
            this.clean();
            return true;
        }
        return false;
    }

    boolean backSpace() {
        if (super.backSpace()) {
            this.clean();
            return true;
        }
        return false;
    }

    void removeMarkedSegment() {
        if (this.segMarked()) {
            TColors tColors = this.getColorsAtTNode(this.segMax());
            TFont tFont = this.getTFontAtTNode(this.segMax());
            this.remove(this.segMin(), this.segMax());
            this.insertColors(tColors, false);
            this.insertTFont(tFont, false);
        }
        this.segMarked = false;
    }

    void copy() {
        BasicText.textBuffer = new Vector();
        BasicText.textBuffer.addElement(new TNode((BasicText)this, this.getColorsAtTNode(this.segMin())));
        BasicText.textBuffer.addElement(new TNode((BasicText)this, this.getTFontAtTNode(this.segMin())));
        int n = this.segMax();
        int n2 = this.segMin();
        while (n2 < n) {
            BasicText.textBuffer.addElement(this.TNode(n2).cloneTNode(this));
            ++n2;
        }
    }

    void paste() {
        int n = this.getCursorPos();
        TColors tColors = this.getColorsAtTNode(this.getCursorPos());
        TFont tFont = this.getTFontAtTNode(this.getCursorPos());
        int n2 = 0;
        while (n2 < BasicText.textBuffer.size()) {
            this.insert(((TNode)BasicText.textBuffer.elementAt(n2)).cloneTNode(this), this.getCursorPos());
            ++n2;
        }
        this.insert(new TNode((BasicText)this, tColors), this.getCursorPos());
        this.insert(new TNode((BasicText)this, tFont), this.getCursorPos());
    }

    void clean() {
        Object object = this.getTFont();
        Object object2 = this.getColors();
        int n = this.begin();
        while (n < this.end()) {
            Object object3;
            TNode tNode = this.TNode(n);
            if (tNode.isColors()) {
                object3 = tNode.getColors();
                if (((TColors)object3).equals((TColors)object2)) {
                    this.remove(n);
                    continue;
                }
                object2 = object3;
                ++n;
                continue;
            }
            if (tNode.isTFont()) {
                object3 = tNode.getTFont();
                if (object3.equals(object)) {
                    this.remove(n);
                    continue;
                }
                object = object3;
                ++n;
                continue;
            }
            tNode.clean();
            ++n;
        }
        boolean bl = true;
        boolean bl2 = true;
        n = this.end();
        while (n >= this.begin()) {
            TNode tNode = this.TNode(n);
            if (tNode.isColors()) {
                if (!bl2) {
                    this.remove(n);
                }
                bl2 = false;
            } else if (tNode.isTFont()) {
                if (!bl) {
                    this.remove(n);
                }
                bl = false;
            } else if (tNode.isChar()) {
                bl = true;
                bl2 = true;
            }
            --n;
        }
    }

    int getIndexOfTNodeAtPixel(Component component, int n, int n2) {
        int n3 = this.getIndexOfLineAtPixel(component, n2);
        int n4 = this.getOffsetOfTNodeAtPixel(component, n3, n);
        return this.firstChar(n3 + n4);
    }

    int getIndexOfLineAtPixel(Component component, int n) {
        int n2 = this.firstLine();
        int n3 = this.topMargin + this.getLineHeightAtTNode(component, n2);
        while (n2 < this.end() && n3 < n) {
            int n4 = n2;
            if ((n2 = this.nextLine(n4)) == n4) break;
            n3 += this.getLineHeightAtTNode(component, n2);
        }
        return n2;
    }

    int getOffsetOfTNodeAtPixel(Component component, int n, int n2) {
        int n3;
        int n4 = n3 = this.startOfLine(n);
        int n5 = this.leftMargin;
        while (n4 < this.end() && !this.TNode(n4).isEndOfLine() && n5 + this.getCharVisualLimitAtTNode(component, n4, false) - 3 < n2) {
            n5 += this.getCharWidthAtTNode(component, n4++, false);
        }
        return n4 - n3;
    }

    int getX(Component component, int n) {
        FontMetrics fontMetrics = this.getFontMetrics(component, this.getTFontAtTNode(this.firstLine()));
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            TNode tNode = this.TNode(n3);
            if (tNode.isTFont()) {
                fontMetrics = this.getFontMetrics(component, tNode.getTFont());
            } else if (tNode.isChar()) {
                n2 = "\n".equals(tNode.getChar()) ? 0 : (n2 += tNode.getCharWidth(fontMetrics, component, false));
            }
            ++n3;
        }
        return this.leftMargin + n2;
    }

    int getY(Component component, int n) {
        int n2 = this.topMargin + this.getLineHeightAtTNode(component, n);
        int n3 = this.startOfLine(n);
        int n4 = this.previousLine(n3);
        while (n4 < n3) {
            n2 += this.getLineHeightAtTNode(component, n4);
            n3 = n4;
            n4 = this.previousLine(n3);
        }
        int n5 = n2 - this.getLineDescentAtTNode(component, n);
        return n5;
    }

    int getHeight(Component component) {
        return this.getY(component, this.end()) + this.getLineDescentAtTNode(component, this.end()) + this.bottomMargin;
    }

    int getWidth(Component component) {
        FontMetrics fontMetrics = this.getFontMetrics(component, this.getTFontAtTNode(this.firstLine()));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 <= this.end()) {
            TNode tNode = this.TNode(n3);
            if (tNode.isTFont()) {
                fontMetrics = this.getFontMetrics(component, tNode.getTFont());
            } else if (tNode.isChar()) {
                if ("\n".equals(tNode.getChar())) {
                    n = Math.max(n, n2);
                    n2 = 0;
                } else {
                    int n4 = tNode.getCharWidth(fontMetrics, component, false);
                    n2 += n4;
                }
            }
            ++n3;
        }
        n = Math.max(n, n2);
        return n += 2 * this.leftMargin;
    }

    void drawSegment(Graphics graphics, Component component, boolean bl, int n, int n2) {
        this.drawSegment(graphics, component, bl, n, n2, true);
    }

    void drawSegment(Graphics graphics, Component component, boolean bl, int n, int n2, boolean bl2) {
        graphics.setColor(this.getColors().getTextColor());
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = this.drawLineAtTNode(graphics, component, bl, n4, bl2);
            n3 = Math.max(n3, n5);
            int n6 = n4;
            if ((n4 = this.nextLine(n4)) == n6) break;
        }
    }

    void drawLineAtTNode(Graphics graphics, Component component, boolean bl, int n) {
        this.drawLineAtTNode(graphics, component, bl, n, true);
    }

    private void calcAndSetLineFonts(int n) {
        int n2 = this.startOfLine(n);
        int n3 = Math.min(this.endOfLine(n), this.end());
        TFont tFont = this.getTFontAtTNode(n2);
        int n4 = n2;
        while (n4 < n3) {
            TNode tNode = this.TNode(n4);
            if (tNode.isTFont()) {
                tFont = tNode.getTFont();
            } else if (tNode.isFormula()) {
                Formula formula = tNode.getFI().getFormula(0);
                formula.calcAndSetFonts(tFont);
            }
            ++n4;
        }
    }

    int drawLineAtTNode(Graphics graphics, Component component, boolean bl, int n, boolean bl2) {
        int n2;
        Object object;
        this.calcAndSetLineFonts(n);
        graphics.setColor(this.getColors().getTextColor());
        int n3 = this.startOfLine(n);
        int n4 = Math.min(this.endOfLine(n), this.end());
        int n5 = this.getY(component, n3);
        TFont tFont = this.getTFontAtTNode(n3);
        Font font = tFont.getFont();
        int n6 = n5 - this.getLineAscentAtTNode(component, n3);
        int n7 = this.getLineHeightAtTNode(component, n3);
        if (this.segMarked() && this.segMax() >= n3 && this.segMin() < n4) {
            object = graphics.getColor();
            int n8 = this.getX(component, Math.max(n3, this.segMin()));
            int n9 = this.getX(component, Math.min(this.segMax(), n4));
            if (n8 == this.leftMargin) {
                n8 -= 2;
            }
            graphics.setColor(BasicText.bestBG(Color.white));
            graphics.fillRect(n8, n6, n9 - n8, n7);
            n2 = this.getX(component, n4);
            graphics.setColor((Color)object);
        }
        object = this.getColorsAtTNode(n3, bl2);
        Color color = null;
        if (object != null) {
            color = ((TColors)object).getBackColor();
            if (((TColors)object).getTextColor() != null) {
                graphics.setColor(((TColors)object).getTextColor());
            }
        } else {
            object = new TColors(null, graphics.getColor());
        }
        graphics.setFont(font);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        n2 = tFont.getAscent();
        int n10 = tFont.getDescent();
        int n11 = (n2 - n10) / 2;
        int n12 = tFont.getDescent() / 2;
        int n13 = this.getX(component, n3);
        int n14 = n3;
        while (n14 < n4) {
            boolean bl3 = false;
            boolean bl4 = bl3 = this.segMarked() && this.segMin() <= n14 && n14 < this.segMax();
            if (bl3) {
                graphics.setColor(BasicText.bestFG(Color.white));
            } else {
                graphics.setColor(((TColors)object).getTextColor());
            }
            TNode tNode = this.TNode(n14);
            if (tNode.isColors()) {
                object = tNode.getColors();
                if (object != null) {
                    color = ((TColors)object).getBackColor();
                    if (((TColors)object).getTextColor() != null) {
                        graphics.setColor(((TColors)object).getTextColor());
                    }
                } else {
                    object = new TColors(null, graphics.getColor());
                }
            } else if (tNode.isTFont()) {
                tFont = tNode.getTFont();
                font = tFont.getFont();
                graphics.setFont(font);
                fontMetrics = component.getFontMetrics(font);
                n2 = tFont.getAscent();
                n10 = tFont.getDescent();
                n11 = (n2 - n10) / 2;
                n12 = 2;
            } else if (tNode.isChar()) {
                String string = tNode.getChar();
                if ("\n".equals(string)) {
                    n13 = this.leftMargin;
                    n5 = this.getY(component, n14);
                } else {
                    Object object2;
                    int n15 = tNode.getCharWidth(fontMetrics, component, false);
                    if (!(color == null || this.segMarked() && n14 >= this.segMin() && n14 < this.segMax())) {
                        object2 = graphics.getColor();
                        graphics.setColor(color);
                        graphics.fillRect(n13, n5 - tNode.getA(), n15, tNode.getA() + tNode.getD());
                        graphics.setColor((Color)object2);
                    }
                    if (tNode.isFormula()) {
                        object2 = tNode.getFI().getFormula(0);
                        ((Formula)object2).draw(graphics, component, tFont, n13 + tNode.getdX1(), n5, bl, bl3);
                        graphics.setFont(font);
                    } else {
                        int n16 = n5;
                        if (tNode.isSubIndex()) {
                            n16 = n5 - n11 + n2;
                        } else if (tNode.isSuperIndex()) {
                            n16 = n5 - n11 - n10;
                        }
                        graphics.drawString(string, n13, n16);
                        if (tFont.isUnderline()) {
                            graphics.drawLine(n13, n5 + n12, n13 + n15 - 1, n5 + n12);
                            if (tFont.isBold()) {
                                graphics.drawLine(n13, n5 + n12 + 1, n13 + n15 - 1, n5 + n12 + 1);
                            }
                        }
                        if (tFont.isOverline()) {
                            graphics.drawLine(n13, n5 - n2, n13 + n15 - 1, n5 - n2);
                            if (tFont.isBold()) {
                                graphics.drawLine(n13, n5 - n2 + 1, n13 + n15 - 1, n5 - n2 + 1);
                            }
                        }
                    }
                    n13 += n15;
                }
            }
            ++n14;
        }
        return n7;
    }
}

