/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.FormulaItem;
import com.mja.text.TColors;
import com.mja.text.TFont;
import com.mja.util.BasicStr;
import com.mja.util.RandomNumber;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.Vector;

public class TNode {
    static final int CHAR = 0;
    static final int TFONT = 1;
    static final int COLOR = 2;
    static final int EXPR = 3;
    static final int FRACT = 4;
    static final int RADICAL = 5;
    static final int SUBIX = 6;
    static final int SUPIX = 7;
    static final int SUM = 8;
    static final int INTEGRAL = 9;
    static final int MATRIX = 10;
    static final int FORMULA = 11;
    private int type = 0;
    private TFont f;
    private TColors tc;
    private String s;
    private String expr;
    private String eval;
    private String dec_expr;
    private Node n;
    private Node n_dec;
    private FormulaItem FI;
    private Parser p;
    private int x;
    private int y;
    private int A;
    private int D;
    private int W;
    private int x1;
    private int dx2;
    private int dx1;
    private int he;
    private int extra;
    private boolean fixed = true;
    private int cols = 1;
    private int rows = 1;
    private BasicText parent;

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getX1() {
        return this.x1;
    }

    public int getdX2() {
        return this.dx2;
    }

    public int getdX1() {
        return this.dx1;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getA() {
        return this.A;
    }

    public int getD() {
        return this.D;
    }

    public int getW() {
        return this.W;
    }

    public int gethe() {
        return this.he;
    }

    public int getdx2() {
        return this.extra / 2;
    }

    public FormulaItem getFI() {
        return this.FI;
    }

    private TNode(BasicText basicText) {
        this.parent = basicText;
    }

    public TNode(BasicText basicText, String string) {
        this.parent = basicText;
        this.build(0, string);
    }

    public TNode(BasicText basicText, String string, int n) {
        this.parent = basicText;
        if (n == 6 || n == 7 || n == 11) {
            Formula formula = new Formula(basicText.getParser());
            formula.insertString(string);
            this.build(n, formula);
        } else if (n == 0) {
            this.build(n, string);
        } else {
            new Exception("BAD TNode TYPE").printStackTrace();
        }
    }

    public TNode(BasicText basicText, Formula formula, int n) {
        this.parent = basicText;
        this.build(n, formula);
    }

    public TNode(BasicText basicText, Formula formula) {
        this.parent = basicText;
        this.build(11, formula);
    }

    public TNode(BasicText basicText, TFont tFont) {
        this.parent = basicText;
        this.build(1, tFont);
    }

    public TNode(BasicText basicText, TColors tColors) {
        this.parent = basicText;
        this.build(2, tColors);
    }

    public TNode(BasicText basicText, int n, int n2, FormulaItem formulaItem) {
        this.cols = n;
        this.rows = n2;
        this.parent = basicText;
        this.build(10, formulaItem);
    }

    public TNode(BasicText basicText, FormulaItem formulaItem, int n) {
        this.parent = basicText;
        this.build(n, formulaItem);
    }

    public TNode(BasicText basicText, Parser parser, String string) {
        this.parent = basicText;
        this.p = parser;
        this.expr = string;
        Node node = null;
        try {
            node = parser.Analyse(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.build(3, node);
    }

    BasicText getParent() {
        return this.parent;
    }

    public void setExpr(String string) {
        this.expr = string;
        Node node = null;
        try {
            node = this.p.Analyse(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.build(3, node);
    }

    private void build(int n, Object object) {
        this.type = n;
        if (n == 0) {
            this.s = (String)object;
        } else if (n == 1) {
            this.f = (TFont)object;
        } else if (n == 2) {
            this.tc = (TColors)object;
        } else if (n == 3) {
            this.n = (Node)object;
            this.eval = this.s = " " + this.expr + " ";
        } else if (n == 4 || n == 5 || n == 9 || n == 8 || n == 10) {
            this.FI = (FormulaItem)object;
            this.FI.setParent(this);
        } else if (n == 11 || n == 6 || n == 7) {
            this.FI = new FormulaItem((Formula)object);
            this.FI.setParent(this);
            this.s = this.FI.getFormula(0).toString();
        } else {
            this.type = -1;
        }
    }

    public int getAscent(TFont tFont) {
        int n = tFont.getAscent();
        int n2 = tFont.getDescent();
        this.he = (n - n2) / 2;
        switch (this.type) {
            case 0: 
            case 3: {
                this.A = n;
                break;
            }
            case 7: {
                this.A = this.FI.getFormula(0).getAscent() + this.he + this.FI.getFormula(0).getDescent();
                break;
            }
            case 6: {
                this.A = this.he;
                break;
            }
            case 11: {
                this.A = this.FI.getFormula(0).getAscent();
                break;
            }
            case 4: {
                this.A = this.FI.getFormula(0).getHeight() + this.he;
                break;
            }
            case 5: {
                this.A = Math.max(this.FI.getFormula(1).getAscent(), this.FI.getFormula(0).getHeight() + this.he) + 3;
                break;
            }
            case 8: 
            case 9: {
                this.A = Math.max(n + this.FI.getFormula(1).getHeight() - 1, this.FI.getFormula(2).getAscent());
                break;
            }
            case 10: {
                this.A = this.he + (this.getMatrixHeight() + 1) / 2;
                break;
            }
            default: {
                this.A = 0;
            }
        }
        return this.A;
    }

    public int getDescent(TFont tFont) {
        int n = tFont.getAscent();
        int n2 = tFont.getDescent();
        this.he = (n - n2) / 2;
        switch (this.type) {
            case 0: 
            case 3: {
                this.D = n2;
                break;
            }
            case 4: {
                this.D = this.FI.getFormula(1).getHeight() - this.he;
                break;
            }
            case 6: {
                this.D = this.FI.getFormula(0).getDescent() - this.he + this.FI.getFormula(0).getAscent();
                break;
            }
            case 7: {
                this.D = -this.he;
                break;
            }
            case 11: {
                this.D = this.FI.getFormula(0).getDescent();
                break;
            }
            case 5: {
                this.D = this.FI.getFormula(1).getDescent();
                break;
            }
            case 8: 
            case 9: {
                this.D = Math.max(n2 + this.FI.getFormula(0).getHeight() - 1, this.FI.getFormula(2).getDescent());
                break;
            }
            case 10: {
                this.D = -this.he + (this.getMatrixHeight() + 1) / 2;
                break;
            }
            default: {
                this.D = 0;
            }
        }
        return this.D;
    }

    int getRows() {
        return this.rows;
    }

    int getColumns() {
        return this.cols;
    }

    int getMaxA() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.cols) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.rows) {
                n3 = Math.max(n3, this.FI.getFormula(n4 + n2 * this.rows).getAscent());
                ++n4;
            }
            n = Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    int getMatrixHeight() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cols) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.rows) {
                n4 = Math.max(n4, this.FI.getFormula(n6 + n3 * this.rows).getAscent());
                n5 = Math.max(n5, this.FI.getFormula(n6 + n3 * this.rows).getDescent());
                ++n6;
            }
            n = Math.max(n, n4);
            n2 = Math.max(n2, n5);
            ++n3;
        }
        return this.rows * (n + n2);
    }

    public int getCharWidth(FontMetrics fontMetrics, Component component, boolean bl) {
        this.extra = fontMetrics.stringWidth(" ");
        switch (this.type) {
            case 0: {
                if (!this.isOpSymbol()) {
                    this.extra = 0;
                }
                this.W = fontMetrics.stringWidth(this.getChar());
                if (!bl || !"(".equals(this.getChar()) && !")".equals(this.getChar())) break;
                this.W = fontMetrics.stringWidth("m");
                break;
            }
            case 3: {
                this.W = fontMetrics.stringWidth(this.getChar());
                break;
            }
            case 6: 
            case 7: {
                this.extra = 0;
            }
            case 11: {
                this.W = this.FI.getFormula(0).getFormulaWidth(component);
                if (this.FI.getFormula(0).getParent().isFormula()) {
                    this.dx1 = 0;
                    this.W += this.dx1 + this.dx1;
                    break;
                }
                this.dx1 = 0;
                break;
            }
            case 4: {
                this.W = Math.max(this.FI.getFormula(0).getFormulaWidth(component), this.FI.getFormula(1).getFormulaWidth(component)) + 8;
                break;
            }
            case 5: {
                this.dx2 = fontMetrics.stringWidth("\u221a");
                this.x1 = this.dx2 + this.FI.getFormula(0).getFormulaWidth(component);
                this.W = this.x1 + this.FI.getFormula(1).getFormulaWidth(component);
                break;
            }
            case 8: {
                this.dx2 = fontMetrics.stringWidth("\u2211");
                this.x1 = Math.max(this.dx2, Math.max(this.FI.getFormula(0).getFormulaWidth(component), this.FI.getFormula(1).getFormulaWidth(component)));
                this.W = this.x1 + this.FI.getFormula(2).getFormulaWidth(component);
                break;
            }
            case 9: {
                this.dx2 = fontMetrics.stringWidth("\u222b");
                this.x1 = this.dx2 + Math.max(this.FI.getFormula(0).getFormulaWidth(component), this.FI.getFormula(1).getFormulaWidth(component));
                this.W = this.x1 + 3 + this.FI.getFormula(2).getFormulaWidth(component);
                break;
            }
            case 10: {
                int n = 0;
                int n2 = 0;
                while (n2 < this.rows) {
                    int n3 = this.extra;
                    int n4 = 0;
                    while (n4 < this.cols) {
                        n3 = Math.max(n3, this.FI.getFormula(n2 + n4 * this.rows).getFormulaWidth(component));
                        ++n4;
                    }
                    n = Math.max(n, n3 + this.extra);
                    ++n2;
                }
                this.W = 2 * this.extra + this.cols * n;
                break;
            }
            default: {
                this.W = 0;
                this.extra = 0;
            }
        }
        if (bl) {
            this.W += this.extra;
        }
        return this.W;
    }

    void clearColors() {
        if (this.FI != null) {
            int n = 0;
            while (n < this.FI.size()) {
                this.FI.getFormula(n).clearColors();
                ++n;
            }
        }
    }

    void setColors(TColors tColors) {
        if (this.FI != null) {
            int n = 0;
            while (n < this.FI.size()) {
                this.FI.getFormula(n).setColors(tColors);
                ++n;
            }
        }
    }

    void clean() {
        if (this.FI != null) {
            int n = 0;
            while (n < this.FI.size()) {
                this.FI.getFormula(n).clean();
                ++n;
            }
        }
    }

    public String toString() {
        String string = "";
        switch (this.type) {
            case 0: {
                string = string + "CHAR " + this.s;
                break;
            }
            case 1: {
                string = string + "TFONT " + this.f.toString();
                break;
            }
            case 2: {
                string = string + "COLOR " + this.tc.toString();
                break;
            }
            case 3: {
                string = string + "EXPR " + this.expr;
                break;
            }
            case 5: {
                string = string + "RADICAL " + this.FI.toString();
                break;
            }
            case 6: {
                string = string + "SUBIX " + this.s;
                break;
            }
            case 7: {
                string = string + "SUPIX " + this.s;
                break;
            }
            case 4: {
                string = string + "FRACT " + this.FI.toString();
                break;
            }
            case 8: {
                string = string + "SUM " + this.FI.toString();
                break;
            }
            case 9: {
                string = string + "INTEGRAL " + this.FI.toString();
                break;
            }
            case 10: {
                string = string + "MATRIX " + this.FI.toString();
                break;
            }
            case 11: {
                string = string + "FORMULA " + this.s;
                break;
            }
            default: {
                string = string + "INVALID TNode";
            }
        }
        return string;
    }

    public String toExpresion(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.s;
        switch (this.type) {
            case 0: {
                string = string.replace('\u00b7', '*');
                string = string.replace('\u2022', '*');
                string = string.replace('\u2219', '*');
                if (Node.inAlgebraTutor) {
                    string = BasicStr.replace(string, "#", "eqn");
                    string = BasicStr.replace(string, "@", "eqa");
                    string = BasicStr.replace(string, "~", "eqx");
                    string = BasicStr.replace(string, "[", "num(");
                    string = BasicStr.replace(string, "]", ")");
                }
                stringBuffer.append(string);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                if (BasicStr.hasContent(this.FI.getFormula(0).toExpresion(bl))) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.FI.getFormula(1).toExpresion(bl));
                    stringBuffer.append(")^(1/(");
                    stringBuffer.append(this.FI.getFormula(0).toExpresion(bl));
                    stringBuffer.append("))");
                    break;
                }
                stringBuffer.append("sqrt(" + this.FI.getFormula(1).toExpresion(bl) + ")");
                break;
            }
            case 3: {
                if (bl) {
                    stringBuffer.append(this.expr);
                    break;
                }
                stringBuffer.append("[" + this.expr + "," + this.dec_expr + "," + this.fixed + "]");
                break;
            }
            case 6: {
                stringBuffer.append("_" + this.FI.getFormula(0).toExpresion(bl));
                break;
            }
            case 7: {
                stringBuffer.append("^(" + this.FI.getFormula(0).toExpresion(bl) + ")");
                break;
            }
            case 11: {
                stringBuffer.append(this.FI.getFormula(0).toExpresion(bl));
                break;
            }
            case 4: {
                stringBuffer.append("(");
                stringBuffer.append(this.FI.getFormula(0).toExpresion(bl));
                stringBuffer.append(")/(");
                stringBuffer.append(this.FI.getFormula(1).toExpresion(bl));
                stringBuffer.append(")");
                break;
            }
            case 8: {
                stringBuffer.append("Sum from (" + this.FI.getFormula(0).toExpresion(bl) + ") " + "to (" + this.FI.getFormula(1).toExpresion(bl) + ") " + " (" + this.FI.getFormula(2).toExpresion(bl) + ") ");
                break;
            }
            case 9: {
                stringBuffer.append("Integral from (" + this.FI.getFormula(0).toExpresion(bl) + ") " + "to (" + this.FI.getFormula(1).toExpresion(bl) + ") " + " (" + this.FI.getFormula(2).toExpresion(bl) + ") ");
                break;
            }
            case 10: {
                stringBuffer.append(this.rows + "x" + this.cols + "Matrix ");
                int n = 0;
                while (n < this.cols) {
                    int n2 = 0;
                    while (n2 < this.rows) {
                        stringBuffer.append(this.FI.getFormula(n2 + this.rows * n).toExpresion(bl));
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
        }
        return stringBuffer.toString();
    }

    public boolean isOpSymbol() {
        return this.s != null && (this.s.equals("+") || this.s.equals("-") || this.s.equals("*") || this.s.equals("\u00b7") || this.s.equals("\u2022") || this.s.equals("\u2219") || this.s.equals("/") || this.s.equals("\u00b1") || this.s.equals("="));
    }

    public boolean isEquivalenceDirective() {
        return this.s != null && (this.s.equals("#") || this.s.equals("@") || this.s.equals("~") || this.s.equals("["));
    }

    public boolean isRightSqrBracket() {
        return this.s != null && this.s.equals("]");
    }

    public boolean isNumSymbol() {
        return this.s != null && (this.s.equals("0") || this.s.equals("1") || this.s.equals("2") || this.s.equals("3") || this.s.equals("4") || this.s.equals("5") || this.s.equals("6") || this.s.equals("7") || this.s.equals("8") || this.s.equals("9") || this.s.equals("."));
    }

    public boolean isPureChar() {
        return this.type == 0;
    }

    public boolean isChar() {
        return this.type == 0 || this.type == 3 || this.type == 4 || this.type == 5 || this.type == 8 || this.type == 9 || this.type == 10 || this.type == 6 || this.type == 7 || this.type == 11;
    }

    public boolean isAlgebraicToken() {
        return this.type == 0 && !this.isOpSymbol() && !this.isEquivalenceDirective() || this.type == 4 || this.type == 5 || this.type == 11 || this.type == 6;
    }

    public boolean isTFont() {
        return this.type == 1;
    }

    public boolean isColors() {
        return this.type == 2;
    }

    public boolean isMath() {
        return this.isExpr() || this.isFraction() || this.isRadical() || this.isSum() || this.isIntegral() || this.isMatrix() || this.isSubIndex() || this.isSuperIndex() || this.isFormula();
    }

    public boolean isLineSeparator() {
        return this.isChar() && (this.isEndOfFile() || "\n".equals(this.s));
    }

    public boolean isWordSeparator() {
        return this.isChar() && (this.isWhiteSpace() || ".".equals(this.s) || ",".equals(this.s) || ";".equals(this.s) || ":".equals(this.s));
    }

    public boolean isWhiteSpace() {
        return this.isChar() && (this.isEndOfFile() || "\n".equals(this.s) || " ".equals(this.s));
    }

    public boolean isExpr() {
        return this.type == 3;
    }

    public boolean isFraction() {
        return this.type == 4;
    }

    public boolean isRadical() {
        return this.type == 5;
    }

    public boolean isSum() {
        return this.type == 8;
    }

    public boolean isIntegral() {
        return this.type == 9;
    }

    public boolean isMatrix() {
        return this.type == 10;
    }

    public boolean isSubIndex() {
        return this.type == 6;
    }

    public boolean isSuperIndex() {
        return this.type == 7;
    }

    public boolean isFormula() {
        return this.type == 11;
    }

    public boolean isEndOfLine() {
        return this.isChar() && ("\n".equals(this.s) || this.isEndOfFile());
    }

    public boolean isEndOfFile() {
        return this.isChar() && "\u001a".equals(this.s);
    }

    public int getType() {
        return this.type;
    }

    public void setChar(String string) {
        this.s = string;
    }

    public String getChar() {
        String string = "";
        string = this.isExpr() ? this.eval : this.s;
        return string;
    }

    public TFont getTFont() {
        return this.f;
    }

    public TColors getColors() {
        return this.tc;
    }

    public String getExpr() {
        return this.expr;
    }

    public String getEval() {
        return this.eval;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public void setDecExpr(String string) {
        this.dec_expr = string;
        this.n_dec = null;
        if (string != null) {
            try {
                this.n_dec = this.p.Analyse(this.dec_expr, 2.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getFixed() {
        return this.fixed;
    }

    public String getDecExpr() {
        return this.dec_expr;
    }

    void calcValues(int n, boolean bl, int n2, boolean bl2) {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (bl2) {
                    this.eval = "[expr]";
                    break;
                }
                if (this.n != null) {
                    if (this.n_dec != null) {
                        int n3 = (int)Math.round(this.n_dec.Evaluate(2.0));
                        this.eval = this.n.toString(n3, this.fixed, n2);
                        break;
                    }
                    this.eval = this.n.toString(n, bl, n2);
                    break;
                }
                this.eval = "[error]";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                this.FI.getFormula(0).calcValues(n, bl, n2, bl2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                int n4 = 0;
                while (n4 < this.FI.size()) {
                    this.FI.getFormula(n4).calcValues(n, bl, n2, bl2);
                    ++n4;
                }
                break;
            }
        }
    }

    public void replaceRandomVariables(Vector vector, boolean bl) {
        block0 : switch (this.type) {
            case 0: {
                int n = 0;
                while (n < vector.size()) {
                    RandomNumber randomNumber = (RandomNumber)vector.elementAt(n);
                    if (this.s.equals(randomNumber.getName())) {
                        this.s = randomNumber.getStrValue();
                        if (bl || !this.s.startsWith("-")) break block0;
                        this.s = "(" + this.s + ")";
                        break block0;
                    }
                    ++n;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                this.FI.getFormula(0).replaceRandomVariables(vector, bl);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                int n = 0;
                while (n < this.FI.size()) {
                    this.FI.getFormula(n).replaceRandomVariables(vector, bl);
                    ++n;
                }
                break;
            }
        }
    }

    public TNode cloneTNode(BasicText basicText) {
        TNode tNode = new TNode(basicText);
        switch (this.type) {
            case 0: {
                tNode.build(this.type, this.s);
                break;
            }
            case 1: {
                tNode.build(this.type, this.getTFont());
                break;
            }
            case 2: {
                tNode.build(this.type, this.getColors());
                break;
            }
            case 3: {
                tNode = new TNode(basicText, this.p, this.expr);
                tNode.eval = this.eval;
                tNode.setDecExpr(this.dec_expr);
                tNode.setFixed(this.fixed);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                tNode.build(this.type, this.FI.getFormula(0).cloneFormula());
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                tNode.build(this.type, this.getFI().cloneItem());
            }
        }
        return tNode;
    }
}

