/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.TColors;
import com.mja.text.TFont;
import com.mja.text.TNode;
import com.mja.text.Text;
import com.mja.util.Attribute;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class RTF {
    public static final String RTF_header = "{\\rtf1";
    public static final String RTF_mjaformula = "{\\*\\mjaformula";
    public static final String RTF_expr = "{\\expr";
    public static final String RTF_decimals = "\\decimals";
    public static final String RTF_fixed = "\\fixed";
    public static final String RTF_fraction = "{\\fraction";
    public static final String RTF_num = "{\\num";
    public static final String RTF_den = "{\\den";
    public static final String RTF_radical = "{\\radical";
    public static final String RTF_index = "{\\index";
    public static final String RTF_radicand = "{\\radicand";
    public static final String RTF_sum = "{\\sum";
    public static final String RTF_integral = "{\\integral";
    public static final String RTF_from = "{\\from";
    public static final String RTF_to = "{\\to";
    public static final String RTF_what = "{\\what";
    public static final String RTF_matrix = "{\\matrix";
    public static final String RTF_rows = "\\rows";
    public static final String RTF_columns = "\\columns";
    public static final String RTF_element = "{\\element";
    public static final String RTF_subix = "{\\subix";
    public static final String RTF_supix = "{\\supix";
    public static final int Monospaced = 0;
    public static final int Serif = 1;
    public static final int SansSerif = 2;
    public static final String[] Java2FontNames = new String[]{"Monospaced", "Serif", "SansSerif"};
    public static final String[] Java1FontNames = new String[]{"Courier", "TimesRoman", "Helvetica"};
    public static final String[] WindowsFontNames = new String[]{"Courier New", "Times New Roman", "Arial"};
    public static float defaultFontSize = 12.0f;
    public static float fontScale = 2.0f;
    private static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private StringBuffer RTFsb;
    private boolean RTFafterKeyword;
    private Dictionary RTFcolorTable;
    private Dictionary RTFfontTable;
    private Dictionary RTFstyleTable;
    private int RTFcolorCount;
    private int RTFfontCount;
    private int RTFstyleCount;
    private int RTFusedFontCount;
    private static int RTFunicodeCount;
    private int[] outputConversion;
    private BasicText T;
    protected static CharacterKeywordPair[] textKeywords;
    private boolean endFont;

    public RTF(BasicText basicText) {
        this.T = basicText;
        if (basicText instanceof Text) {
            ((Text)this.T).clean();
        }
        textKeywords = new CharacterKeywordPair[0];
    }

    static String WfontName(String string) {
        int n = 0;
        while (n < Java1FontNames.length) {
            if (Java1FontNames[n].equals(string)) {
                return WindowsFontNames[n];
            }
            if (Java2FontNames[n].equals(string)) {
                return WindowsFontNames[n];
            }
            ++n;
        }
        return WindowsFontNames[0];
    }

    static String JfontName(String string) {
        int n = 0;
        while (n < WindowsFontNames.length) {
            if (WindowsFontNames[n].equals(string)) {
                return Java2FontNames[n];
            }
            ++n;
        }
        return Java2FontNames[0];
    }

    private void writeRTFBegingroup() {
        this.RTFsb.append('{');
        this.RTFafterKeyword = false;
    }

    private void writeRTFEndgroup() {
        this.RTFsb.append('}');
        this.RTFafterKeyword = false;
    }

    private void writeRTFRawString(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.RTFsb.append(string.charAt(n2));
            ++n2;
        }
    }

    private void writeRTFControlWord(String string) {
        this.RTFsb.append('\\');
        this.writeRTFRawString(string);
        this.RTFafterKeyword = true;
    }

    private void writeRTFControlWord(String string, int n) {
        this.RTFsb.append('\\');
        this.writeRTFRawString(string);
        this.writeRTFRawString(String.valueOf(n));
        this.RTFafterKeyword = true;
    }

    private void writeRTFLineBreak() {
        this.RTFafterKeyword = false;
    }

    private void writeRTFText(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            this.writeRTFCharacter(string.charAt(n));
            ++n;
        }
    }

    private void writeRTFCharacter(char c) {
        if (c == '\u00a0') {
            this.RTFsb.append('\\');
            this.RTFsb.append('~');
            this.RTFafterKeyword = false;
            return;
        }
        if (c == '\t') {
            this.writeRTFControlWord("tab");
            return;
        }
        if (c == '\n' || c == '\r') {
            return;
        }
        int n = RTF.convertCharacter(this.outputConversion, c);
        if (n == 0 || n > 127) {
            String string = this.approximationForUnicode(c);
            if (string.length() != RTFunicodeCount) {
                RTFunicodeCount = string.length();
                this.writeRTFControlWord("uc", RTFunicodeCount);
            }
            this.writeRTFControlWord("u", c);
            this.writeRTFRawString(" ");
            this.writeRTFRawString(string);
            this.RTFafterKeyword = false;
            return;
        }
        switch (n) {
            case 92: 
            case 123: 
            case 125: {
                this.RTFsb.append('\\');
                this.RTFafterKeyword = false;
            }
        }
        if (this.RTFafterKeyword) {
            this.RTFsb.append(' ');
            this.RTFafterKeyword = false;
        }
        this.RTFsb.append((char)n);
    }

    private String approximationForUnicode(char c) {
        return "";
    }

    private static int[] outputConversionFromTranslationTable(char[] cArray) {
        int[] nArray = new int[2 * cArray.length];
        int n = 0;
        while (n < cArray.length) {
            nArray[n * 2] = cArray[n];
            nArray[n * 2 + 1] = n;
            ++n;
        }
        return nArray;
    }

    private static int[] outputConversionForName(String string) {
        char[] cArray = new char[256];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)n;
            ++n;
        }
        return RTF.outputConversionFromTranslationTable(cArray);
    }

    private static int convertCharacter(int[] nArray, char c) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] == c) {
                return nArray[n + 1];
            }
            n += 2;
        }
        return 0;
    }

    private void putColorInTable(Color color) {
        if (color != null && this.RTFcolorTable.get(color) == null) {
            this.RTFcolorTable.put(color, new Integer(this.RTFcolorCount));
            ++this.RTFcolorCount;
        }
    }

    private void prepareRTFHeader() {
        this.RTFcolorTable = new Hashtable();
        this.RTFcolorCount = 0;
        this.RTFfontTable = new Hashtable();
        this.RTFfontCount = 0;
        this.RTFfontTable.put(this.T.getTFont().toString(), new Integer(0));
        ++this.RTFfontCount;
        ++this.RTFusedFontCount;
        this.RTFstyleTable = new Hashtable();
        this.RTFstyleCount = 0;
        RTFunicodeCount = 0;
        this.endFont = false;
        this.prepareColors(this.T);
        if (this.endFont) {
            --this.RTFusedFontCount;
        }
        this.RTFsb = new StringBuffer();
    }

    private void prepareColors(BasicText basicText) {
        int n = 0;
        while (n < basicText.end()) {
            this.endFont = false;
            TNode tNode = basicText.TNode(n);
            if (tNode.isColors()) {
                this.putColorInTable(tNode.getColors().getTextColor());
                this.putColorInTable(tNode.getColors().getBackColor());
            } else if (tNode.isTFont()) {
                TFont tFont = tNode.getTFont();
                if (this.RTFfontTable.get(tFont.toString()) == null) {
                    this.RTFfontTable.put(tFont.toString(), new Integer(this.RTFfontCount));
                    ++this.RTFfontCount;
                    ++this.RTFusedFontCount;
                    this.endFont = true;
                } else {
                    this.endFont = false;
                }
            } else if (tNode.isMath() && !tNode.isExpr() && tNode.getFI() != null) {
                int n2 = 0;
                while (n2 < tNode.getFI().size()) {
                    this.prepareColors(tNode.getFI().getFormula(n2));
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void writeRTFHeader() {
        this.writeRTFBegingroup();
        this.writeRTFControlWord("rtf", 1);
        this.writeRTFControlWord("uc", 0);
        this.outputConversion = RTF.outputConversionForName("ansi");
        this.writeRTFLineBreak();
        String[] stringArray = new String[this.RTFfontCount];
        Enumeration enumeration = this.RTFfontTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)this.RTFfontTable.get(string);
            stringArray[n.intValue()] = TFont.getNameFromString(string);
        }
        this.writeRTFBegingroup();
        this.writeRTFControlWord("fonttbl");
        int n = 0;
        while (n < this.RTFfontCount) {
            this.writeRTFControlWord("f", n);
            this.writeRTFControlWord("fcharset", 0);
            this.writeRTFText(RTF.WfontName(stringArray[n]));
            this.writeRTFText(";");
            ++n;
        }
        this.writeRTFEndgroup();
        this.writeRTFLineBreak();
        if (this.RTFcolorCount > 0) {
            Color color;
            Color[] colorArray = new Color[this.RTFcolorCount];
            Enumeration enumeration2 = this.RTFcolorTable.keys();
            while (enumeration2.hasMoreElements()) {
                color = (Color)enumeration2.nextElement();
                Integer n2 = (Integer)this.RTFcolorTable.get(color);
                colorArray[n2.intValue()] = color;
            }
            this.writeRTFBegingroup();
            this.writeRTFControlWord("colortbl");
            int n3 = 0;
            while (n3 < this.RTFcolorCount) {
                color = colorArray[n3];
                if (color != null) {
                    this.writeRTFControlWord("red", color.getRed());
                    this.writeRTFControlWord("green", color.getGreen());
                    this.writeRTFControlWord("blue", color.getBlue());
                }
                this.writeRTFRawString(";");
                ++n3;
            }
            this.writeRTFEndgroup();
            this.writeRTFLineBreak();
        }
    }

    private void writeRTFColor(String string, Color color) {
        Object v;
        if (color != null && (v = this.RTFcolorTable.get(color)) != null) {
            this.writeRTFControlWord(string, ((Number)v).intValue());
        }
    }

    private void writeRTFDocument(BasicText basicText) {
        Object object = null;
        int n = 0;
        float f = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < basicText.end()) {
            Object object2;
            TNode tNode = basicText.TNode(n2);
            if (tNode.isColors()) {
                this.writeRTFColor("cf", tNode.getColors().getTextColor());
                this.writeRTFColor("cb", tNode.getColors().getBackColor());
            } else if (tNode.isTFont()) {
                object2 = tNode.getTFont();
                Object v = this.RTFfontTable.get(((TFont)object2).toString());
                if (v != null) {
                    n = ((Number)v).intValue();
                    if (object == null) {
                        f = ((TFont)object2).getSize();
                        bl = ((TFont)object2).isBold();
                        bl2 = ((TFont)object2).isItalic();
                        bl3 = ((TFont)object2).isUnderline();
                        bl4 = ((TFont)object2).isOverline();
                        this.writeRTFControlWord("f", n);
                        this.writeRTFControlWord("fs", Math.round(f * fontScale));
                        if (bl) {
                            this.writeRTFControlWord("b");
                        }
                        if (bl2) {
                            this.writeRTFControlWord("i");
                        }
                        if (bl3) {
                            this.writeRTFControlWord("ul");
                        }
                        if (bl4) {
                            this.writeRTFControlWord("ol");
                        }
                    } else {
                        if (!((TFont)object2).getName().equals(((TFont)object).getName())) {
                            this.writeRTFControlWord("f", n);
                            f = -1.0f;
                        }
                        if ((float)((TFont)object2).getSize() != f) {
                            f = ((TFont)object2).getSize();
                            this.writeRTFControlWord("fs", Math.round(f * fontScale));
                        }
                        if (((TFont)object2).isBold() != bl) {
                            if (bl) {
                                this.writeRTFControlWord("b0");
                            } else {
                                this.writeRTFControlWord("b");
                            }
                            bl = ((TFont)object2).isBold();
                        }
                        if (((TFont)object2).isItalic() != bl2) {
                            if (bl2) {
                                this.writeRTFControlWord("i0");
                            } else {
                                this.writeRTFControlWord("i");
                            }
                            bl2 = ((TFont)object2).isItalic();
                        }
                        if (((TFont)object2).isUnderline() != bl3) {
                            if (bl3) {
                                this.writeRTFControlWord("ulnone");
                            } else {
                                this.writeRTFControlWord("ul");
                            }
                            bl3 = ((TFont)object2).isUnderline();
                        }
                        if (((TFont)object2).isOverline() != bl4) {
                            if (bl4) {
                                this.writeRTFControlWord("olnone");
                            } else {
                                this.writeRTFControlWord("ol");
                            }
                            bl4 = ((TFont)object2).isOverline();
                        }
                    }
                    object = object2;
                }
            } else if (tNode.isMath()) {
                if (tNode.isFormula()) {
                    this.writeRTFBegingroup();
                    this.writeRTFControlWord(RTF_mjaformula.substring(2));
                }
                this.writeMath(tNode);
                if (tNode.isFormula()) {
                    this.writeRTFEndgroup();
                }
            } else if (tNode.isChar()) {
                object2 = tNode.getChar();
                if (((String)object2).equals("\n")) {
                    this.writeRTFControlWord("par ");
                    this.writeRTFLineBreak();
                } else {
                    this.writeRTFText((String)object2);
                }
            }
            ++n2;
        }
    }

    private void writeMath(TNode tNode) {
        if (tNode.isExpr()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_expr.substring(2));
            this.writeRTFText(tNode.getExpr());
            if (tNode.getDecExpr() != null) {
                this.writeRTFControlWord(RTF_decimals.substring(1));
                this.writeRTFText(tNode.getDecExpr());
                if (!tNode.getFixed()) {
                    this.writeRTFControlWord(RTF_fixed.substring(1) + "0");
                }
            }
            this.writeRTFEndgroup();
        } else if (tNode.isFraction()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_fraction.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_num.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_den.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isRadical()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_radical.substring(2));
            if (BasicStr.hasContent(tNode.getFI().getFormula(0).toExpresion(false))) {
                this.writeRTFBegingroup();
                this.writeRTFControlWord(RTF_index.substring(2));
                this.writeRTFDocument(tNode.getFI().getFormula(0));
                this.writeRTFEndgroup();
                this.writeRTFBegingroup();
                this.writeRTFControlWord(RTF_radicand.substring(2));
                this.writeRTFDocument(tNode.getFI().getFormula(1));
                this.writeRTFEndgroup();
            } else {
                this.writeRTFDocument(tNode.getFI().getFormula(1));
            }
            this.writeRTFEndgroup();
        } else if (tNode.isSum()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_sum.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_from.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_to.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_what.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(2));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isIntegral()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_integral.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_from.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_to.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_what.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(2));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isSubIndex()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_subix.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
        } else if (tNode.isSuperIndex()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_supix.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
        } else if (tNode.isMatrix()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_matrix.substring(2));
            this.writeRTFControlWord(RTF_rows.substring(1));
            this.writeRTFText(String.valueOf(tNode.getRows()));
            this.writeRTFControlWord(RTF_columns.substring(1));
            this.writeRTFText(String.valueOf(tNode.getColumns()));
            int n = 0;
            while (n < tNode.getFI().size()) {
                this.writeRTFBegingroup();
                this.writeRTFControlWord(RTF_element.substring(2));
                this.writeRTFDocument(tNode.getFI().getFormula(n));
                this.writeRTFEndgroup();
                ++n;
            }
            this.writeRTFEndgroup();
        } else {
            this.writeRTFDocument(tNode.getFI().getFormula(0));
        }
    }

    private void writeRTFTrailer() {
        this.writeRTFControlWord("par");
        this.writeRTFLineBreak();
        this.writeRTFEndgroup();
        this.writeRTFLineBreak();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toRTF(boolean bl) {
        if (this.T instanceof Text) {
            ((Text)this.T).clean();
        }
        this.prepareRTFHeader();
        boolean bl2 = false;
        if (bl) {
            boolean bl3 = bl2 = this.RTFcolorCount == 0 && this.RTFusedFontCount == 0;
            if (bl2) {
                int n = 0;
                while (n < this.T.end()) {
                    block14: {
                        TNode tNode = this.T.TNode(n);
                        if (!tNode.isColors() && !tNode.isTFont()) {
                            Object object;
                            if (tNode.isFormula()) {
                                object = tNode.getFI().getFormula(0);
                                if (((BasicText)object).end() == ((BasicText)object).begin() + 1) {
                                    tNode = ((BasicText)object).TNode(((BasicText)object).begin());
                                    if (tNode.isExpr()) {
                                        if (tNode.getDecExpr() == null) {
                                            this.RTFsb.append("[");
                                            this.RTFsb.append(tNode.getExpr());
                                            this.RTFsb.append("]");
                                            break block14;
                                        } else {
                                            bl2 = false;
                                            break;
                                        }
                                    }
                                    bl2 = false;
                                    break;
                                }
                                bl2 = false;
                                break;
                            }
                            if (!tNode.isChar()) {
                                bl2 = false;
                                break;
                            }
                            object = tNode.getChar();
                            if (((String)object).equals("\n")) {
                                this.RTFsb.append("\\n");
                            } else {
                                this.RTFsb.append((String)object);
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        if (!bl2) {
            this.RTFsb = new StringBuffer();
            this.writeRTFHeader();
            this.writeRTFDocument(this.T);
            this.writeRTFTrailer();
        }
        return this.RTFsb.toString();
    }

    public static void parseRTF(String string, BasicText basicText) {
        RTFunicodeCount = 1;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        if (BasicStr.hasContent(string)) {
            if (string.startsWith(RTF_header)) {
                RTF.addText(string.substring(RTF_header.length()), basicText, hashtable, hashtable2);
                int n = RTF_header.length();
            } else {
                basicText.insertString(BasicStr.replace(string, "\\n", "\n"));
            }
        }
        if (basicText instanceof Text) {
            ((Text)basicText).clean();
        }
        basicText.setCursorPos(basicText.firstChar(basicText.begin()));
    }

    private static void addText(String string, BasicText basicText, Hashtable hashtable, Hashtable hashtable2) {
        TFont tFont = basicText.getTFont();
        Color color = basicText.getColors().getTextColor();
        Color color2 = basicText.getColors().getBackColor();
        int n = 0;
        boolean bl = false;
        while (n < string.length()) {
            Attribute attribute = RTF.getNextToken(string, n);
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (attribute.name.equals("\\")) {
                if (bl) {
                    basicText.insertChar('\n');
                    bl = false;
                }
                basicText.insertString(attribute.value);
            } else if (attribute.name.startsWith("{")) {
                if (bl) {
                    basicText.insertChar('\n');
                    bl = false;
                }
                if (attribute.name.startsWith("{\\fonttbl")) {
                    boolean bl2 = hashtable.get("\\f0") != null;
                    RTF.addFonts(hashtable, attribute.name.substring("{\\fonttbl".length()).trim());
                    if (!bl2 && hashtable.get("\\f0") != null) {
                        tFont.setName(RTF.JfontName((String)hashtable.get("\\f0")));
                        if (basicText instanceof Text && !(basicText instanceof Formula)) {
                            ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                        }
                    }
                } else if (attribute.name.startsWith("{\\colortbl")) {
                    RTF.addColors(hashtable2, attribute.name.substring("{\\colortbl".length()).trim());
                } else if (attribute.name.startsWith(RTF_mjaformula)) {
                    Formula formula = null;
                    if (basicText instanceof Formula) {
                        formula = (Formula)basicText;
                    } else if (basicText instanceof Text) {
                        formula = new Formula(basicText.getParser(), basicText.getTFont(), color2, color);
                        ((Text)basicText).insertFormula(formula);
                    }
                    RTF.addText(attribute.name.substring(RTF_mjaformula.length()).trim(), formula, hashtable, hashtable2);
                    if (basicText instanceof Text) {
                        formula.setFonts(tFont.cloneTFont());
                    }
                } else if (attribute.name.startsWith(RTF_expr)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_expr.length()).trim(), 3, hashtable2);
                } else if (attribute.name.startsWith(RTF_fraction)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_fraction.length()).trim(), 4, hashtable2);
                } else if (attribute.name.startsWith(RTF_radical)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_radical.length()).trim(), 5, hashtable2);
                } else if (attribute.name.startsWith(RTF_sum)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_sum.length()).trim(), 8, hashtable2);
                } else if (attribute.name.startsWith(RTF_integral)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_integral.length()).trim(), 9, hashtable2);
                } else if (attribute.name.startsWith(RTF_matrix)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_matrix.length()).trim(), 10, hashtable2);
                } else if (attribute.name.startsWith(RTF_subix)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_subix.length()).trim(), 6, hashtable2);
                } else if (attribute.name.startsWith(RTF_supix)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_supix.length()).trim(), 7, hashtable2);
                }
            } else if (attribute.name.startsWith("\\")) {
                if (attribute.name.equals("\\f")) {
                    Object v = hashtable.get(attribute.name + attribute.value.trim());
                    if (v != null) {
                        tFont.setName(RTF.JfontName((String)v));
                        if (basicText instanceof Text) {
                            ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                        }
                    }
                } else if (attribute.name.equals("\\fs")) {
                    try {
                        tFont.setSize(Integer.parseInt(attribute.value.trim()) / 2);
                        if (basicText instanceof Text) {
                            ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                        }
                    }
                    catch (Exception exception) {}
                } else if (attribute.name.equals("\\cf") || attribute.name.equals("\\cb")) {
                    Object v = hashtable2.get("\\cf" + attribute.value.trim());
                    if (v != null) {
                        if (attribute.name.equals("\\cf")) {
                            color = (Color)v;
                            color2 = null;
                        } else {
                            color2 = (Color)v;
                        }
                        if (basicText instanceof Text) {
                            TColors tColors = new TColors(color2, color);
                            ((Text)basicText).insertColors(tColors, false);
                        }
                    }
                } else if (attribute.name.equals("\\u")) {
                    try {
                        char c = (char)Integer.parseInt(attribute.value.trim());
                        if (bl) {
                            basicText.insertChar('\n');
                            bl = false;
                        }
                        basicText.insertChar(c);
                    }
                    catch (Exception exception) {}
                } else if (attribute.name.startsWith("\\b")) {
                    tFont.setBold(attribute.value.trim().length() == 0);
                    if (basicText instanceof Text) {
                        ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    }
                } else if (attribute.name.startsWith("\\i")) {
                    tFont.setItalic(attribute.value.trim().length() == 0);
                    if (basicText instanceof Text) {
                        ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    }
                } else if (attribute.name.startsWith("\\ulnone")) {
                    tFont.setUnderline(false);
                    if (basicText instanceof Text) {
                        ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    }
                } else if (attribute.name.startsWith("\\ul")) {
                    tFont.setUnderline(true);
                    if (basicText instanceof Text) {
                        ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    }
                } else if (attribute.name.startsWith("\\olnone")) {
                    tFont.setOverline(false);
                    if (basicText instanceof Text) {
                        ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    }
                } else if (attribute.name.startsWith("\\ol")) {
                    tFont.setOverline(true);
                    if (basicText instanceof Text) {
                        ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    }
                } else if (attribute.name.startsWith("\\uc")) {
                    try {
                        RTFunicodeCount = Integer.parseInt(attribute.value.trim());
                    }
                    catch (Exception exception) {}
                } else if (attribute.name.startsWith("\\par")) {
                    if (bl) {
                        basicText.insertChar('\n');
                    }
                    bl = true;
                }
            } else if (!RTF.isWhiteSpace(attribute.name.charAt(0))) {
                if (bl) {
                    basicText.insertChar('\n');
                    bl = false;
                }
                basicText.insertString(attribute.name);
            }
            n += attribute.name.length() + attribute.value.length();
        }
        basicText.setCursorPos(basicText.firstChar(basicText.begin()));
    }

    private static void addMath(Formula formula, String string, int n, Hashtable hashtable) {
        Color color = formula.getColors().getTextColor();
        Color color2 = formula.getColors().getBackColor();
        Formula formula2 = null;
        Formula formula3 = null;
        Formula formula4 = null;
        Formula formula5 = null;
        Formula formula6 = null;
        Formula formula7 = null;
        Formula formula8 = null;
        Formula formula9 = null;
        Formula[][] formulaArray = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        formula2 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        if (n == 4) {
            formula3 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula4 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        } else if (n == 5) {
            formula5 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula6 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        } else if (n == 8 || n == 9) {
            formula7 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula8 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula9 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        } else if (n == -1) {
            formula2 = formula;
        }
        String string2 = "";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = true;
        int n6 = 0;
        while (n6 < string.length()) {
            Attribute attribute = RTF.getNextToken(string, n6);
            if (n == 5 && n6 == 0 && !attribute.name.startsWith(RTF_index)) {
                formula2 = formula6;
            }
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (attribute.name.startsWith("{")) {
                if (attribute.name.startsWith(RTF_expr)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_expr.length()).trim(), 3, hashtable);
                } else if (attribute.name.startsWith(RTF_fraction)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_fraction.length()).trim(), 4, hashtable);
                } else if (attribute.name.startsWith(RTF_radical)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_radical.length()).trim(), 5, hashtable);
                } else if (attribute.name.startsWith(RTF_sum)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_sum.length()).trim(), 8, hashtable);
                } else if (attribute.name.startsWith(RTF_integral)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_integral.length()).trim(), 9, hashtable);
                } else if (attribute.name.startsWith(RTF_matrix)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_matrix.length()).trim(), 10, hashtable);
                } else if (attribute.name.startsWith(RTF_subix)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_subix.length()).trim(), 6, hashtable);
                } else if (attribute.name.startsWith(RTF_supix)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_supix.length()).trim(), 7, hashtable);
                } else if (n == 4) {
                    if (attribute.name.startsWith(RTF_num)) {
                        RTF.addMath(formula3, attribute.name.substring(RTF_num.length()).trim(), -1, hashtable);
                    } else if (attribute.name.startsWith(RTF_den)) {
                        RTF.addMath(formula4, attribute.name.substring(RTF_den.length()).trim(), -1, hashtable);
                    }
                } else if (n == 5) {
                    if (attribute.name.startsWith(RTF_index)) {
                        RTF.addMath(formula5, attribute.name.substring(RTF_index.length()).trim(), -1, hashtable);
                    } else if (attribute.name.startsWith(RTF_radicand)) {
                        RTF.addMath(formula6, attribute.name.substring(RTF_radicand.length()).trim(), -1, hashtable);
                    }
                } else if (n == 8 || n == 9) {
                    if (attribute.name.startsWith(RTF_from)) {
                        RTF.addMath(formula7, attribute.name.substring(RTF_from.length()).trim(), -1, hashtable);
                    } else if (attribute.name.startsWith(RTF_to)) {
                        RTF.addMath(formula8, attribute.name.substring(RTF_to.length()).trim(), -1, hashtable);
                    } else if (attribute.name.startsWith(RTF_what)) {
                        RTF.addMath(formula9, attribute.name.substring(RTF_what.length()).trim(), -1, hashtable);
                    }
                } else if (n == 10 && attribute.name.startsWith(RTF_element)) {
                    if (formulaArray == null) {
                        n2 = Integer.parseInt(string4);
                        n3 = Integer.parseInt(string5);
                        formulaArray = new Formula[n3][n2];
                        n4 = 0;
                        n5 = 0;
                    }
                    formulaArray[n5][n4] = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
                    RTF.addMath(formulaArray[n5][n4], attribute.name.substring(RTF_element.length()).trim(), -1, hashtable);
                    if (n4 + 1 < n2) {
                        ++n4;
                    } else if (n5 + 1 < n3) {
                        n4 = 0;
                        ++n5;
                    }
                }
            } else if (attribute.name.startsWith("\\")) {
                if (attribute.name.equals("\\cf") || attribute.name.equals("\\cb")) {
                    Object v = hashtable.get("\\cf" + attribute.value.trim());
                    if (v != null) {
                        if (attribute.name.equals("\\cf")) {
                            color = (Color)v;
                            color2 = null;
                        } else {
                            color2 = (Color)v;
                        }
                        TColors tColors = new TColors(color2, color);
                        formula2.insertColors(tColors, false);
                    }
                } else if (attribute.name.equals("\\u")) {
                    try {
                        char c = (char)Integer.parseInt(attribute.value.trim());
                        formula2.insertChar(c);
                    }
                    catch (Exception exception) {}
                } else if (n == 3) {
                    if (attribute.name.startsWith(RTF_decimals)) {
                        string3 = "";
                    } else if (attribute.name.startsWith(RTF_fixed)) {
                        bl = attribute.value.trim().length() == 0;
                    }
                } else if (n == 10) {
                    if (attribute.name.startsWith(RTF_rows)) {
                        string4 = "";
                    } else if (attribute.name.startsWith(RTF_columns)) {
                        string5 = "";
                    }
                }
            } else if (!RTF.isWhiteSpace(attribute.name.charAt(0))) {
                switch (n) {
                    case -1: {
                        formula2.insertString(attribute.name);
                        break;
                    }
                    case 3: {
                        if (string3 != null) {
                            string3 = string3 + attribute.name.trim();
                            break;
                        }
                        string2 = string2 + attribute.name.trim();
                        break;
                    }
                    case 10: {
                        if (string5 != null) {
                            string5 = string5 + attribute.name.trim();
                            break;
                        }
                        if (string4 != null) {
                            string4 = string4 + attribute.name.trim();
                            break;
                        }
                        string2 = string2 + attribute.name.trim();
                        break;
                    }
                    default: {
                        formula2.insertString(attribute.name);
                    }
                }
            }
            n6 += attribute.name.length() + attribute.value.length();
        }
        switch (n) {
            case -1: {
                break;
            }
            case 3: {
                formula.insertExpr(string2, string3, bl);
                break;
            }
            case 4: {
                formula.insertFraction(formula3, formula4);
                break;
            }
            case 5: {
                formula.insertRadical(formula5, formula6);
                break;
            }
            case 8: {
                formula.insertSum(formula7, formula8, formula9);
                break;
            }
            case 9: {
                formula.insertIntegral(formula7, formula8, formula9);
                break;
            }
            case 10: {
                formula.insertMatrix(formulaArray);
                break;
            }
            case 6: {
                formula.insertSubIndex(formula2);
                break;
            }
            case 7: {
                formula.insertSuperIndex(formula2);
            }
        }
    }

    private static void addFonts(Hashtable hashtable, String string) {
        int n = 0;
        String string2 = "";
        while (n < string.length()) {
            Attribute attribute = RTF.getNextToken(string, n);
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (!attribute.name.equals("\\") && !attribute.name.startsWith("{")) {
                if (attribute.name.startsWith("\\")) {
                    if (attribute.name.equals("\\f")) {
                        string2 = attribute.name + attribute.value.trim();
                    }
                } else if (!RTF.isWhiteSpace(attribute.name.charAt(0))) {
                    String string3 = attribute.name;
                    if (string3.endsWith(";")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    if (string2.length() > 0) {
                        hashtable.put(string2, string3);
                    }
                    string2 = "";
                }
            }
            n += attribute.name.length() + attribute.value.length();
        }
    }

    private static void addColors(Hashtable hashtable, String string) {
        int n = 0;
        String string2 = "0";
        String string3 = "0";
        String string4 = "0";
        while (n < string.length()) {
            Attribute attribute = RTF.getNextToken(string, n);
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (!attribute.name.equals("\\") && !attribute.name.startsWith("{")) {
                if (attribute.name.startsWith("\\")) {
                    if (attribute.name.startsWith("\\red")) {
                        string2 = attribute.value.trim();
                    } else if (attribute.name.startsWith("\\green")) {
                        string3 = attribute.value.trim();
                    } else if (attribute.name.startsWith("\\blue")) {
                        string4 = attribute.value.trim();
                    }
                } else if (!RTF.isWhiteSpace(attribute.name.charAt(0)) && attribute.name.startsWith(";")) {
                    try {
                        int n2 = Integer.parseInt(string2);
                        int n3 = Integer.parseInt(string3);
                        int n4 = Integer.parseInt(string4);
                        Color color = new Color(n2, n3, n4);
                        String string5 = "\\cf" + String.valueOf(hashtable.size());
                        hashtable.put(string5, color);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = "0";
                    string3 = "0";
                    string4 = "0";
                }
            }
            n += attribute.name.length() + attribute.value.length();
        }
    }

    private static Attribute getNextToken(String string, int n) {
        if (string.charAt(n) == '}') {
            return new Attribute("}", "");
        }
        if (string.charAt(n) == '{') {
            int n2 = n + 1;
            int n3 = 1;
            while (n2 < string.length() && n3 > 0) {
                if (string.charAt(n2) == '}') {
                    --n3;
                } else if (string.charAt(n2) == '{') {
                    ++n3;
                }
                ++n2;
            }
            return new Attribute(string.substring(n, n2), "");
        }
        if (RTF.isWhiteSpace(string.charAt(n))) {
            return new Attribute(new Character(string.charAt(n)).toString(), "");
        }
        if (string.charAt(n) == '\\') {
            if (n + 1 < string.length() && RTF.isCtrlChar(string.charAt(n + 1))) {
                return new Attribute("\\", new Character(string.charAt(n + 1)).toString());
            }
            int n4 = n + 1;
            while (n4 < string.length() && !RTF.isCtrlSep(string.charAt(n4))) {
                ++n4;
            }
            if (n4 < string.length() && string.charAt(n4) == ' ') {
                ++n4;
            }
            String string2 = string.substring(n, n4);
            int n5 = 1;
            while (n5 < string2.length() && !RTF.isNumChar(string2.charAt(n5))) {
                ++n5;
            }
            String string3 = string2.substring(0, n5);
            String string4 = string2.substring(n5);
            if (string3.equals("\\u")) {
                string4 = string4 + string.substring(n4, n4 + RTFunicodeCount);
            }
            return new Attribute(string3, string4);
        }
        int n6 = n + 1;
        while (n6 < string.length() && !RTF.isCtrlChar(string.charAt(n6)) && !RTF.isWhiteSpace(string.charAt(n6))) {
            ++n6;
        }
        return new Attribute(string.substring(n, n6), "");
    }

    private static boolean isCtrlSep(char c) {
        return c == ' ' || c == ';' || RTF.isWhiteSpace(c) || RTF.isCtrlChar(c);
    }

    private static boolean isWhiteSpace(char c) {
        return c == '\r' || c == '\n';
    }

    private static boolean isCtrlChar(char c) {
        return c == '\\' || c == '{' || c == '}';
    }

    private static boolean isNumChar(char c) {
        return c == '-' || c >= '0' && c <= '9';
    }

    static void appendAsChar(StringBuffer stringBuffer, char c) {
        if (c == '{' || c == '}' || c == '\\') {
            stringBuffer.append('\\');
        }
        stringBuffer.append(c);
    }

    static class CharacterKeywordPair {
        public char character;
        public String keyword;

        CharacterKeywordPair() {
        }
    }
}

