/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.FormulaItem;
import com.mja.text.RTF;
import com.mja.text.TColors;
import com.mja.text.TFont;
import com.mja.text.TNode;
import com.mja.text.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public class Formula
extends Text {
    TNode parent;
    private boolean active;
    private boolean assisted;
    private static final int min_font_size = 11;
    private int x0;
    private int x1;
    private int x2;
    private int x3;
    private int xe;
    private int y0;
    private int A;
    private int D;
    private int W;
    static final double sixp = 0.66;
    static final double ixp = 0.8;
    static final double frp = 0.9;

    public Formula(Parser parser) {
        super(parser);
    }

    public Formula(Parser parser, TFont tFont, Color color, Color color2) {
        super(parser, tFont, color, color2);
    }

    public void setAssisted(boolean bl) {
        this.assisted = bl;
        int n = this.begin();
        int n2 = this.end();
        int n3 = n;
        while (n3 < n2) {
            TNode tNode = this.TNode(n3);
            if (tNode.isChar() && tNode.getFI() != null) {
                FormulaItem formulaItem = tNode.getFI();
                formulaItem.setAssisted(this.assisted);
            }
            ++n3;
        }
    }

    public boolean isAssisted() {
        return this.assisted;
    }

    TNode getParent() {
        return this.parent;
    }

    void insertSuperIndex(String string) {
        this.insert(new TNode((BasicText)this, string, 7), this.getCursorPos());
    }

    void insertSuperIndex(Formula formula) {
        this.insert(new TNode((BasicText)this, formula, 7), this.getCursorPos());
    }

    void insertSubIndex(String string) {
        this.insert(new TNode((BasicText)this, string, 6), this.getCursorPos());
    }

    void insertSubIndex(Formula formula) {
        this.insert(new TNode((BasicText)this, formula, 6), this.getCursorPos());
    }

    void insertRadical(String string, String string2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.getParser(), string, string2), 5), this.getCursorPos());
    }

    void insertRadical(Formula formula, Formula formula2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2), 5), this.getCursorPos());
    }

    void insertSum(String string, String string2, String string3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.getParser(), string, string2, string3), 8), this.getCursorPos());
    }

    void insertSum(Formula formula, Formula formula2, Formula formula3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2, formula3), 8), this.getCursorPos());
    }

    void insertIntegral(String string, String string2, String string3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.getParser(), string, string2, string3), 9), this.getCursorPos());
    }

    void insertIntegral(Formula formula, Formula formula2, Formula formula3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2, formula3), 9), this.getCursorPos());
    }

    public void insertMatrix(String[][] stringArray) {
        this.insert(new TNode(this, stringArray.length, stringArray[0].length, new FormulaItem(this.getParser(), stringArray)), this.getCursorPos());
    }

    public void insertMatrix(Formula[][] formulaArray) {
        this.insert(new TNode(this, formulaArray.length, formulaArray[0].length, new FormulaItem(formulaArray)), this.getCursorPos());
    }

    void insertExpr(String string) {
        this.insert(new TNode((BasicText)this, this.parser, string), this.getCursorPos());
    }

    void insertExpr(String string, String string2, boolean bl) {
        TNode tNode = new TNode((BasicText)this, this.parser, string);
        if (string2 != null && string2.length() > 0) {
            tNode.setDecExpr(string2);
            tNode.setFixed(bl);
        }
        this.insert(tNode, this.getCursorPos());
    }

    void insertFraction(String string, String string2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.parser, string, string2), 4), this.getCursorPos());
    }

    void insertFraction(Formula formula, Formula formula2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2), 4), this.getCursorPos());
    }

    void insertFormula(Formula formula) {
        this.insert(new TNode((BasicText)this, formula, 11), this.getCursorPos());
    }

    int getAscent() {
        int n = this.font.getAscent();
        int n2 = this.begin();
        while (n2 < this.end()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar()) {
                n = Math.max(n, tNode.getAscent(this.font));
            }
            ++n2;
        }
        return n;
    }

    int getDescent() {
        int n = this.font.getDescent();
        int n2 = this.begin();
        while (n2 < this.end()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar()) {
                n = Math.max(n, tNode.getDescent(this.font));
            }
            ++n2;
        }
        return n;
    }

    Formula getFormulaAt(int n, int n2) {
        if (this.contains(n, n2)) {
            Formula formula = null;
            int n3 = this.begin();
            while (formula == null && n3 < this.end()) {
                TNode tNode = this.TNode(n3);
                if (tNode.getFI() != null) {
                    int n4 = 0;
                    while (n4 < tNode.getFI().size()) {
                        formula = tNode.getFI().getFormula(n4).getFormulaAt(n, n2);
                        if (formula != null) break;
                        ++n4;
                    }
                }
                ++n3;
            }
            if (formula != null) {
                return formula;
            }
            return this;
        }
        return null;
    }

    int getHeight() {
        return this.getAscent() + this.getDescent();
    }

    int getIndexOfTNodeAtPixel(Component component, int n, int n2) {
        int n3 = this.getOffsetOfTNodeAtPixel(component, 0, n);
        return this.firstChar(n3);
    }

    int getOffsetOfTNodeAtPixel(Component component, int n, int n2) {
        int n3;
        int n4 = n3 = this.begin();
        int n5 = this.x0;
        while (n4 < this.end() && !this.TNode(n4).isEndOfLine() && (double)n5 + 2.0 * (double)this.getCharWidthAtTNode(component, n4, true) / 3.0 < (double)n2) {
            n5 += this.getCharWidthAtTNode(component, n4++, true);
        }
        return n4 - n3;
    }

    int getFormulaWidth(Component component) {
        FontMetrics fontMetrics = component.getFontMetrics(this.font.getFont());
        int n = 0;
        int n2 = this.begin();
        while (n2 < this.end()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar()) {
                n += tNode.getCharWidth(fontMetrics, component, true);
            }
            ++n2;
        }
        return Math.max(n, fontMetrics.stringWidth(" "));
    }

    int getX(Component component, int n) {
        FontMetrics fontMetrics = component.getFontMetrics(this.font.getFont());
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            TNode tNode = this.TNode(n3);
            if (tNode.isChar()) {
                n2 += tNode.getCharWidth(fontMetrics, component, true);
            }
            ++n3;
        }
        return this.x0 + n2;
    }

    int getY() {
        return this.y0;
    }

    boolean contains(int n, int n2) {
        if (this.parent.isFraction()) {
            int n3 = this.parent.getFI().getFormula((int)0).W;
            int n4 = this.parent.getFI().getFormula((int)1).W;
            int n5 = Math.max(n3, n4);
            int n6 = (n5 - this.W) / 2;
            return this.x0 - n6 <= n && n < this.x0 - n6 + n5 && this.y0 - this.A <= n2 && n2 < this.y0 + this.D;
        }
        return this.x0 <= n && n < this.x0 + this.W && this.y0 - this.A <= n2 && n2 < this.y0 + this.D;
    }

    void calcValues(int n, boolean bl, int n2, boolean bl2) {
        int n3 = this.begin();
        while (n3 < this.end()) {
            TNode tNode = this.TNode(n3);
            tNode.calcValues(n, bl, n2, bl2);
            ++n3;
        }
    }

    void setActive(boolean bl) {
        this.active = bl;
    }

    void calcAndSetFonts(TFont tFont) {
        this.setFonts(tFont);
        double d = 1.0;
        int n = 1;
        while (this.getMinFontSize() < 11) {
            TFont tFont2 = new TFont(tFont.getName(), tFont.getStyle(), tFont.getSize() + n++);
            this.setFonts(tFont2);
        }
    }

    void draw(Graphics graphics, Component component, TFont tFont, int n, int n2, boolean bl, boolean bl2) {
        this.locate(component, n, n2);
        this.doDraw(graphics, bl, bl2);
    }

    int getMinFontSize() {
        int n = this.font.getSize();
        int n2 = this.begin();
        while (n2 < this.end()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar() && tNode.getFI() != null) {
                FormulaItem formulaItem = tNode.getFI();
                int n3 = 0;
                while (n3 < formulaItem.size()) {
                    n = Math.min(n, formulaItem.getFormula(n3).getMinFontSize());
                    ++n3;
                }
            }
            ++n2;
        }
        return n;
    }

    void setFonts(TFont tFont) {
        this.font = tFont;
        int n = this.begin();
        int n2 = this.end();
        int n3 = n;
        while (n3 < n2) {
            TNode tNode = this.TNode(n3);
            if (tNode.isChar() && tNode.getFI() != null) {
                FormulaItem formulaItem = tNode.getFI();
                if (tNode.isSubIndex()) {
                    formulaItem.getFormula(0).setFonts(tFont.scale(0.66));
                } else if (tNode.isSuperIndex()) {
                    formulaItem.getFormula(0).setFonts(tFont.scale(0.66));
                } else if (tNode.isFormula()) {
                    formulaItem.getFormula(0).setFonts(tFont);
                } else if (tNode.isFraction()) {
                    formulaItem.getFormula(0).setFonts(tFont.scale(0.9));
                    formulaItem.getFormula(1).setFonts(tFont.scale(0.9));
                } else if (tNode.isRadical()) {
                    formulaItem.getFormula(0).setFonts(tFont.scale(0.8));
                    formulaItem.getFormula(1).setFonts(tFont);
                } else if (tNode.isSum() || tNode.isIntegral()) {
                    formulaItem.getFormula(0).setFonts(tFont.scale(0.8));
                    formulaItem.getFormula(1).setFonts(tFont.scale(0.8));
                    formulaItem.getFormula(2).setFonts(tFont);
                } else {
                    int n4 = 0;
                    while (n4 < formulaItem.size()) {
                        formulaItem.getFormula(n4).setFonts(tFont);
                        ++n4;
                    }
                }
            }
            ++n3;
        }
    }

    void setColors(TColors tColors) {
        this.colors = tColors;
        int n = this.begin();
        while (n < this.end()) {
            TNode tNode = this.TNode(n);
            tNode.setColors(tColors);
            ++n;
        }
    }

    void locate(Component component, int n, int n2) {
        this.x0 = n;
        this.y0 = n2;
        this.A = this.getAscent();
        this.D = this.getDescent();
        this.W = this.getFormulaWidth(component);
        FontMetrics fontMetrics = component.getFontMetrics(this.font.getFont());
        int n3 = this.font.getAscent();
        int n4 = this.font.getDescent();
        int n5 = (n3 - n4) / 2;
        int n6 = this.begin();
        int n7 = this.end();
        int n8 = this.x0;
        int n9 = this.y0;
        int n10 = n6;
        while (n10 < n7) {
            TNode tNode = this.TNode(n10);
            if (tNode.isChar()) {
                Formula formula;
                tNode.setLocation(n8, n9);
                int n11 = tNode.getCharWidth(fontMetrics, component, true);
                Formula formula2 = null;
                if (tNode.getFI() != null) {
                    formula2 = tNode.getFI().getFormula(0);
                }
                if (tNode.isSubIndex()) {
                    formula2.locate(component, n8 + tNode.getdx2(), n9 - n5 + formula2.getAscent());
                } else if (tNode.isSuperIndex()) {
                    formula2.locate(component, n8 + tNode.getdx2(), n9 - n5 - formula2.getDescent());
                } else if (tNode.isFormula()) {
                    formula2.locate(component, n8 + tNode.getdx2(), n9);
                } else if (tNode.isFraction()) {
                    Formula formula3 = tNode.getFI().getFormula(0);
                    formula = tNode.getFI().getFormula(1);
                    int n12 = formula3.getFormulaWidth(component);
                    int n13 = formula.getFormulaWidth(component);
                    int n14 = formula3.getDescent();
                    int n15 = formula3.getHeight();
                    int n16 = formula.getAscent();
                    int n17 = formula.getHeight();
                    formula3.locate(component, n8 + (n11 - n12) / 2, n9 - n5 - n14);
                    formula.locate(component, n8 + (n11 - n13) / 2, n9 - n5 + n16);
                } else if (tNode.isRadical()) {
                    Formula formula4 = tNode.getFI().getFormula(0);
                    formula = tNode.getFI().getFormula(1);
                    formula4.locate(component, n8, n9 - n5 - formula4.getDescent());
                    formula.locate(component, n8 + tNode.getX1() + tNode.getdx2(), n9);
                } else if (tNode.isSum()) {
                    Formula formula5 = tNode.getFI().getFormula(0);
                    formula = tNode.getFI().getFormula(1);
                    Formula formula6 = tNode.getFI().getFormula(2);
                    formula.locate(component, n8 + (tNode.getX1() - formula.getFormulaWidth(component)) / 2, n9 - n3 - formula.getDescent() + 1);
                    formula5.locate(component, n8 + (tNode.getX1() - formula5.getFormulaWidth(component)) / 2, n9 + n4 + formula5.getAscent() - 2);
                    formula6.locate(component, n8 + tNode.getX1(), n9);
                } else if (tNode.isIntegral()) {
                    Formula formula7 = tNode.getFI().getFormula(0);
                    formula = tNode.getFI().getFormula(1);
                    Formula formula8 = tNode.getFI().getFormula(2);
                    formula.locate(component, n8 + tNode.getdX2() + 4, n9 - n3 - formula.getDescent() + 1);
                    formula7.locate(component, n8 + tNode.getdX2() - 1, n9 + n4 + formula7.getAscent() - 2);
                    formula8.locate(component, n8 + tNode.getX1() + 3, n9);
                } else if (tNode.isMatrix()) {
                    int n18 = 0;
                    while (n18 < tNode.getFI().size()) {
                        tNode.getFI().getFormula(n18).locate(component, n8 + 4 * tNode.getdx2() + n18 % tNode.getColumns() * ((tNode.getW() - 2 * tNode.getdx2()) / tNode.getColumns()), n9 - n5 + tNode.getMaxA() - tNode.getMatrixHeight() / 2 + n18 / tNode.getColumns() * (tNode.getMatrixHeight() / tNode.getRows()));
                        ++n18;
                    }
                }
                n8 += n11;
            }
            ++n10;
        }
        if (this.segMarked()) {
            this.x1 = this.getX(component, Math.max(n6, this.segMin()));
            this.x2 = this.getX(component, Math.min(n7, this.segMax()));
            if (this.x1 == this.x0) {
                this.x1 -= 2;
            }
            this.x3 = this.getX(component, n7);
        }
    }

    void doDraw(Graphics graphics, boolean bl, boolean bl2) {
        Color color = graphics.getColor();
        TColors tColors = null;
        if (this.segMarked()) {
            graphics.setColor(BasicText.bestBG(Color.white));
            graphics.fillRect(this.x1, this.y0 - this.A, this.x2 - this.x1, this.A + this.D);
        }
        graphics.setColor(color);
        int n = this.begin();
        while (n < this.end()) {
            TNode tNode = this.TNode(n);
            if (tNode.isColors()) {
                tColors = tNode.getColors();
                if (tColors != null && tColors.getTextColor() != null) {
                    color = tColors.getTextColor();
                    graphics.setColor(color);
                }
            } else if (!tNode.isTFont() && tNode.isChar()) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                boolean bl3;
                boolean bl4 = bl3 = bl2 || this.segMarked() && this.segMin() <= n && n < this.segMax();
                if (bl3) {
                    graphics.setColor(BasicText.bestFG(Color.white));
                } else {
                    graphics.setColor(color);
                }
                graphics.setFont(this.font.getFont());
                FormulaItem formulaItem = tNode.getFI();
                if (tNode.isRadical()) {
                    int n11;
                    n10 = tNode.getX();
                    n9 = tNode.getY();
                    n8 = n10;
                    n7 = n10 + tNode.getX1();
                    n6 = n7 - tNode.getdX2();
                    n5 = (n6 + n7) / 2;
                    n4 = n10 + tNode.getW();
                    n2 = n3 = n9 - tNode.gethe() + 1;
                    int n12 = n9 + tNode.getD() - 2;
                    int n13 = n11 = n9 - formulaItem.getFormula(1).getAscent() - 1;
                    Formula.fillBack(bl3, graphics, tColors, tNode);
                    Color color2 = graphics.getColor();
                    formulaItem.doDraw(graphics, bl, bl3);
                    graphics.setColor(color2);
                    graphics.drawLine(n8 + 2, n3, n6 + 1, n2);
                    graphics.drawLine(n6, n2, n5, n12);
                    graphics.drawLine(n5, n12, n7, n11);
                    graphics.drawLine(n7, n11, n4, n13);
                } else if (tNode.isFormula() || tNode.isSubIndex() || tNode.isSuperIndex()) {
                    Formula.fillBack(bl3, graphics, tColors, tNode);
                    formulaItem.doDraw(graphics, bl, bl3);
                } else if (tNode.isFraction()) {
                    Formula.fillBack(bl3, graphics, tColors, tNode);
                    Color color3 = graphics.getColor();
                    formulaItem.doDraw(graphics, bl, bl3);
                    graphics.setColor(color3);
                    graphics.drawLine(tNode.getX() + tNode.getdx2(), tNode.getY() - tNode.gethe(), tNode.getX() + tNode.getW() - tNode.getdx2(), tNode.getY() - tNode.gethe());
                } else if (tNode.isSum()) {
                    Formula.fillBack(bl3, graphics, tColors, tNode);
                    graphics.drawString("\u2211", tNode.getX() + (tNode.getX1() - tNode.getdX2()) / 2, tNode.getY());
                    formulaItem.doDraw(graphics, bl, bl3);
                } else if (tNode.isIntegral()) {
                    Formula.fillBack(bl3, graphics, tColors, tNode);
                    graphics.setFont(this.font.scale(1.5).getFont());
                    graphics.drawString("\u222b", tNode.getX(), tNode.getY() - 1 + (int)Math.round(0.21 * (double)graphics.getFont().getSize()));
                    graphics.setFont(this.font.getFont());
                    formulaItem.doDraw(graphics, bl, bl3);
                } else if (tNode.isMatrix()) {
                    Formula.fillBack(bl3, graphics, tColors, tNode, this.A, this.D);
                    n10 = tNode.getX() + tNode.getdx2();
                    n9 = tNode.getY();
                    n8 = tNode.getW() - 2 * tNode.getdx2();
                    n7 = n10;
                    n6 = n10 + n8;
                    n5 = n9 - tNode.getA() + 4;
                    n4 = n9 + tNode.getD() - 4;
                    graphics.drawLine(n7, n5, n7, n4);
                    graphics.drawLine(n7, n5, n7 + 2, n5 - 2);
                    graphics.drawLine(n7, n4, n7 + 2, n4 + 2);
                    graphics.drawLine(n6, n5, n6, n4);
                    graphics.drawLine(n6, n5, n6 - 2, n5 - 2);
                    graphics.drawLine(n6, n4, n6 - 2, n4 + 2);
                    formulaItem.doDraw(graphics, bl, bl3);
                } else {
                    n10 = tNode.getX() + tNode.getdx2();
                    n9 = tNode.getY();
                    n8 = tNode.getW() - 2 * tNode.getdx2();
                    n7 = 2;
                    n6 = tNode.getA();
                    n5 = tNode.getD();
                    if (tNode.isChar() && (tNode.getChar().equals("(") || tNode.getChar().equals(")"))) {
                        if (tNode.getChar().equals("(")) {
                            n4 = 0;
                            n3 = 1;
                            n2 = n + 1;
                            while (n2 <= this.end()) {
                                TNode tNode2 = this.TNode(n2);
                                if (")".equals(tNode2.getChar())) {
                                    if (--n3 == 0) {
                                        n4 = 1;
                                        break;
                                    }
                                } else if ("(".equals(tNode2.getChar())) {
                                    ++n3;
                                }
                                n6 = Math.max(n6, tNode2.getA());
                                n5 = Math.max(n5, tNode2.getD());
                                ++n2;
                            }
                        } else {
                            n4 = 0;
                            n3 = -1;
                            n2 = n - 1;
                            while (n2 >= this.begin()) {
                                TNode tNode3 = this.TNode(n2);
                                if ("(".equals(tNode3.getChar())) {
                                    if (++n3 == 0) {
                                        n4 = 1;
                                        break;
                                    }
                                } else if (")".equals(tNode3.getChar())) {
                                    --n3;
                                }
                                n6 = Math.max(n6, tNode3.getA());
                                n5 = Math.max(n5, tNode3.getD());
                                --n2;
                            }
                        }
                        n4 = n9 - (n6 - n5) / 2;
                        n3 = (int)Math.round((double)(n8 * n8 + (n6 + n5) * (n6 + n5)) / (4.0 * (double)n8));
                        n2 = (int)Math.round(153.0 * Math.asin((double)(n6 + n5) / (2.0 * (double)n3)) / Math.PI);
                        Formula.fillBack(bl3, graphics, tColors, tNode, n6, n5);
                        if (tNode.getChar().equals("(")) {
                            graphics.drawArc(n10 + n8 / 2, n4 - n3, 2 * n3, 2 * n3, 180 - n2, 2 * n2);
                        } else if (tNode.isChar() && tNode.getChar().equals(")")) {
                            graphics.drawArc(n10 + n8 / 2 - 2 * n3, n4 - n3, 2 * n3, 2 * n3, -n2, 2 * n2);
                        }
                    } else {
                        Formula.fillBack(bl3, graphics, tColors, tNode);
                        graphics.drawString(tNode.getChar(), n10, n9);
                    }
                    if (this.font.isUnderline()) {
                        graphics.drawLine(n10, n9 + n7, n10 + n8 - 1, n9 + n7);
                        if (this.font.isBold()) {
                            graphics.drawLine(n10, n9 + n7 + 1, n10 + n8 - 1, n9 + n7 + 1);
                        }
                    }
                    if (this.font.isOverline()) {
                        graphics.drawLine(n10, n9 - n6, n10 + n8 - 1, n9 - n6);
                        if (this.font.isBold()) {
                            graphics.drawLine(n10, n9 - n6 + 1, n10 + n8 - 1, n9 - n6 + 1);
                        }
                    }
                }
                if (bl && tNode.isExpr()) {
                    graphics.drawRect(tNode.getX() + 1, tNode.getY() - tNode.getA(), tNode.getW() - 2, tNode.getA() + tNode.getD());
                }
            }
            ++n;
        }
        graphics.setColor(color);
        if (bl && (this.active || this.getParent().isFormula())) {
            int n14 = 1;
            if (this.getParent().isFormula()) {
                n14 = -1;
            }
            if (this.getParent() != null) {
                n14 += this.getParent().getdX1();
            }
            graphics.drawRect(this.x0 - n14, this.y0 - this.A, this.W + 2 * n14, this.A + this.D);
        }
    }

    private static void fillBack(boolean bl, Graphics graphics, TColors tColors, TNode tNode) {
        Formula.fillBack(bl, graphics, tColors, tNode, tNode.getA(), tNode.getD());
    }

    private static void fillBack(boolean bl, Graphics graphics, TColors tColors, TNode tNode, int n, int n2) {
        if (!bl && tColors != null && tColors.getBackColor() != null) {
            graphics.setColor(tColors.getBackColor());
            graphics.fillRect(tNode.getX(), tNode.getY() - n, tNode.getW(), n + n2);
            graphics.setColor(tColors.getTextColor());
        }
    }

    public Formula cloneFormula() {
        RTF rTF = new RTF(this);
        String string = rTF.toRTF(false);
        Formula formula = new Formula(this.getParser(), this.font.cloneTFont(), this.colors.getBackColor(), this.colors.getTextColor());
        formula.parser = this.parser;
        RTF.parseRTF(string, formula);
        return formula;
    }

    public String toExpresion(boolean bl) {
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        boolean bl4 = false;
        int n = 0;
        int n2 = this.begin();
        while (n2 < this.end()) {
            ++n;
            TNode tNode = (TNode)this.info.elementAt(n2);
            if (tNode.isChar() && !tNode.isWhiteSpace()) {
                if (tNode.isAlgebraicToken()) {
                    String string3 = tNode.getChar();
                    if (!(!bl2 || bl3 && tNode.isNumSymbol() || "(".equals(string2) || ")".equals(string3) || "[".equals(string2) || "]".equals(string3) || string3 != null && string3.startsWith("_"))) {
                        string = string + "*";
                        bl4 = true;
                    }
                    bl3 = tNode.isNumSymbol();
                    bl2 = true;
                    string2 = string3;
                    if (string2 == null) {
                        string2 = "";
                    }
                } else {
                    bl2 = false;
                    bl3 = false;
                    string2 = "";
                    bl4 = true;
                }
                string = string + tNode.toExpresion(bl);
            }
            ++n2;
        }
        return string;
    }

    public void replaceRandomVariables(Vector vector, boolean bl) {
        if (vector.size() > 0) {
            if (bl && this.end() == this.begin() + 1) {
                this.TNode(this.begin()).replaceRandomVariables(vector, true);
            } else {
                int n = this.begin();
                while (n < this.end()) {
                    this.TNode(n).replaceRandomVariables(vector, false);
                    ++n;
                }
            }
            this.cleanSigns();
        }
    }

    private void cleanSigns() {
        TFont tFont = this.getTFont();
        TColors tColors = this.getColors();
        int n = this.begin();
        TNode tNode = null;
        while (n < this.end()) {
            String string;
            TNode tNode2 = this.TNode(n);
            if (tNode != null && tNode.isPureChar() && tNode2.isPureChar() && (string = tNode2.getChar()).startsWith("-") && string.length() > 1) {
                if (tNode.getChar().equals("+")) {
                    tNode.setChar("-");
                    tNode2.setChar(string.substring(1));
                } else if (tNode.getChar().equals("-")) {
                    TNode tNode3 = null;
                    if (n >= this.begin() + 2) {
                        tNode3 = this.TNode(n - 2);
                    }
                    if (tNode3 != null && tNode3.isPureChar() && (tNode3.getChar().equals("=") || tNode3.getChar().equals("("))) {
                        this.remove(--n);
                    } else {
                        tNode.setChar("+");
                    }
                    tNode2.setChar(string.substring(1));
                }
            }
            tNode = tNode2;
            ++n;
        }
    }
}

