/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.gui.MouseCursorHandler;
import com.mja.img.ImageDialog;
import com.mja.lang.translator;
import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.MathEditor;
import com.mja.text.TFont;
import com.mja.text.TNode;
import com.mja.text.Text;
import com.mja.text.TextCanvas;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class EditorCanvas
extends TextCanvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    private boolean moveimg;
    private boolean moveimg2;
    private int cursorX;
    private MouseCursorHandler mch;
    private static final int left = 1;
    private static final int right = 2;
    private static final int up = 3;
    private static final int down = 4;
    private static final int home = 5;
    private static final int end = 6;
    private char UC_base = '\u0000';
    private int mouseX;
    private int mouseY;
    private int activeImage = -1;
    private int activeImage2 = -1;
    private boolean pressed = false;
    private boolean dragged = false;
    private Point point;
    private int dblclckpos = -1;
    private long dblclckmillis = -1L;

    public EditorCanvas(Applet applet, Frame frame, translator translator2, MouseCursorHandler mouseCursorHandler, Parser parser, TFont tFont, Color color, boolean bl, boolean bl2, boolean bl3) {
        this(applet, frame, translator2, mouseCursorHandler, parser, tFont, color, bl, false, bl2, bl3);
    }

    public EditorCanvas(Applet applet, Frame frame, translator translator2, MouseCursorHandler mouseCursorHandler, Parser parser, TFont tFont, Color color, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(applet, frame, translator2, parser, tFont, color, bl3, bl4);
        this.mch = mouseCursorHandler;
        this.moveimg = bl;
        this.moveimg2 = bl2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setText(Text text) {
        if (this.isEditing()) {
            this.removeListeners();
        }
        super.setText(text);
        if (this.isEditing()) {
            this.addListeners();
        }
    }

    public void setEditing(boolean bl) {
        if (this.editing) {
            this.unmarkSegment();
            this.removeListeners();
        }
        this.editing = bl;
        if (this.editing) {
            this.addListeners();
        }
        this.updateSize();
        this.updateScreen();
        this.updateCursorThread();
    }

    public void setMoveImages(boolean bl) {
        this.moveimg = bl;
    }

    public boolean getMoveImages() {
        return this.moveimg;
    }

    public void setMoveImages2(boolean bl) {
        this.moveimg2 = bl;
    }

    public boolean getMoveImages2() {
        return this.moveimg2;
    }

    public void insertExpr(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            this.F.insertExpr(string);
            this.mainF.calcValues(this.dec, this.fixed, this.aL, this.editing);
            this.updateScreen();
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertFunction(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertText(string);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertRadical(String string, String string2) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertRadical(string, string2);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertSum(String string, String string2, String string3) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertSum(string, string2, string3);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertIntegral(String string, String string2, String string3) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertIntegral(string, string2, string3);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertMatrix(String[][] stringArray) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertMatrix(stringArray);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertFraction(String string, String string2) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertFraction(string, string2);
            this.F.setCursorPos(n);
            n = this.F.getCursorPos();
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertSubIndex(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertSubIndex(string);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertSuperIndex(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertSuperIndex(string);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    void smallMoveRight() {
        int n = this.F.firstChar(this.F.getCursorPos());
        TNode tNode = this.F.TNode(n);
        if (tNode.isSubIndex() || tNode.isSuperIndex() || tNode.isFraction() || tNode.isRadical() || tNode.isSum() || tNode.isIntegral() || tNode.isMatrix()) {
            this.setEditingFormula(tNode.getFI().getFormula(0));
        } else {
            TNode tNode2;
            BasicText basicText = tNode.getParent();
            boolean bl = false;
            if (this.F.afterLastChar(n) && basicText instanceof Formula && (tNode2 = ((Formula)basicText).getParent()) != null && (tNode2.isFraction() || tNode2.isRadical() || tNode2.isSum() || tNode2.isIntegral() || tNode2.isMatrix())) {
                int n2 = 0;
                while (n2 < tNode2.getFI().size() - 1) {
                    if (tNode2.getFI().getFormula(n2) == this.F) {
                        this.setEditingFormula(tNode2.getFI().getFormula(n2 + 1));
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                if (this.F.afterLastChar(n)) {
                    this.doEscape();
                }
                if (this.F != null) {
                    this.moveRight();
                } else {
                    this.moveCursor(false, true, 2);
                }
            }
        }
    }

    void smallMoveLeft() {
        int n = this.F.getCursorPos();
        TNode tNode = this.F.TNode(n);
        if (n > this.F.firstChar(this.F.begin())) {
            this.moveLeft();
            n = this.F.getCursorPos();
            tNode = this.F.TNode(n);
            if (tNode.isSubIndex() || tNode.isSuperIndex() || tNode.isFraction() || tNode.isRadical() || tNode.isSum() || tNode.isIntegral() || tNode.isMatrix()) {
                this.setEditingFormula(tNode.getFI().getFormula(tNode.getFI().size() - 1));
                this.F.setCursorPos(this.F.end());
            }
        } else {
            TNode tNode2;
            BasicText basicText = tNode.getParent();
            boolean bl = false;
            if (basicText instanceof Formula && (tNode2 = ((Formula)basicText).getParent()) != null && (tNode2.isFraction() || tNode2.isRadical() || tNode2.isSum() || tNode2.isIntegral() || tNode2.isMatrix())) {
                int n2 = tNode2.getFI().size() - 1;
                while (n2 > 0) {
                    if (tNode2.getFI().getFormula(n2) == this.F) {
                        this.setEditingFormula(tNode2.getFI().getFormula(n2 - 1));
                        this.F.setCursorPos(this.F.end());
                        bl = true;
                        break;
                    }
                    --n2;
                }
            }
            if (!bl) {
                this.doEscape();
            }
        }
    }

    boolean moveRight() {
        int n = this.F.getCursorPos();
        this.F.setCursorPos(this.F.firstChar(n));
        if (this.F.getCursorPos() < this.F.end()) {
            this.F.setCursorPos(this.F.getCursorPos() + 1);
        }
        return this.F.getCursorPos() != n;
    }

    boolean moveLeft() {
        if (this.F != null) {
            int n = this.F.getCursorPos();
            this.F.setCursorPos(this.F.prevChar(n));
            if (this.F.getCursorPos() != n) {
                return true;
            }
        }
        return false;
    }

    boolean doEscape() {
        BasicText basicText;
        TNode tNode = this.F.getParent();
        if (tNode != null && (basicText = tNode.getParent()) instanceof Formula) {
            this.setEditingFormula((Formula)basicText);
            this.F.setCursorPos(tNode);
            return true;
        }
        if (!this.onlyFormula) {
            this.mainF = null;
            this.setEditingFormula(null);
            this.mainFIndex = -1;
        }
        return false;
    }

    boolean goToUpperFormula() {
        TNode tNode;
        int n = this.F.getCursorPos();
        TNode tNode2 = this.F.TNode(n);
        BasicText basicText = tNode2.getParent();
        if (basicText instanceof Formula && (tNode = ((Formula)basicText).getParent()) != null) {
            if (tNode.isFraction()) {
                if (tNode.getFI().getFormula(1) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(0));
                    return true;
                }
            } else if (tNode.isRadical()) {
                if (tNode.getFI().getFormula(1) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(0));
                    return true;
                }
            } else if ((tNode.isSum() || tNode.isIntegral()) && (tNode.getFI().getFormula(2) == this.F || tNode.getFI().getFormula(0) == this.F)) {
                this.setEditingFormula(tNode.getFI().getFormula(1));
                return true;
            }
        }
        return false;
    }

    boolean goToLowerFormula() {
        TNode tNode;
        int n = this.F.getCursorPos();
        TNode tNode2 = this.F.TNode(n);
        BasicText basicText = tNode2.getParent();
        if (basicText instanceof Formula && (tNode = ((Formula)basicText).getParent()) != null) {
            if (tNode.isFraction()) {
                if (tNode.getFI().getFormula(0) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(1));
                    return true;
                }
            } else if (tNode.isRadical()) {
                if (tNode.getFI().getFormula(0) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(1));
                    return true;
                }
            } else if ((tNode.isSum() || tNode.isIntegral()) && (tNode.getFI().getFormula(2) == this.F || tNode.getFI().getFormula(1) == this.F)) {
                this.setEditingFormula(tNode.getFI().getFormula(0));
                return true;
            }
        }
        return false;
    }

    private void moveCursor(boolean bl, boolean bl2, int n) {
        this.eraseCursor();
        if (this.F != null) {
            if ((n == 4 || n == 3) && bl2) {
                switch (n) {
                    case 4: {
                        this.insertSubIndex("");
                        break;
                    }
                    case 3: {
                        this.insertSuperIndex("");
                    }
                }
                if (this.F.segMarked()) {
                    this.F.unmarkSegment();
                    this.updateScreenFromTNode(this.mainFIndex);
                }
            } else if (bl) {
                int n2 = this.F.getCursorPos();
                switch (n) {
                    case 1: {
                        this.moveLeft();
                        break;
                    }
                    case 2: {
                        this.moveRight();
                    }
                }
                if (n2 != this.F.getCursorPos()) {
                    if (!this.F.segMarked()) {
                        this.F.markSegment(n2, this.F.getCursorPos());
                    } else {
                        this.F.updateSegment();
                    }
                    this.updateScreenFromTNode(this.mainFIndex);
                }
            } else if (bl2) {
                if (this.F.segMarked()) {
                    this.F.unmarkSegment();
                    this.updateScreenFromTNode(this.mainFIndex);
                }
                switch (n) {
                    case 1: {
                        if (this.doEscape()) break;
                        this.moveLeft();
                        break;
                    }
                    case 2: {
                        this.doEscape();
                        if (this.F != null) {
                            this.moveRight();
                            break;
                        }
                        this.moveCursor(false, false, 2);
                        break;
                    }
                    case 3: {
                        this.goToUpperFormula();
                        break;
                    }
                    case 4: {
                        this.goToLowerFormula();
                    }
                }
            } else {
                if (this.F.segMarked()) {
                    this.F.unmarkSegment();
                    this.updateScreenFromTNode(this.mainFIndex);
                }
                switch (n) {
                    case 1: {
                        this.smallMoveLeft();
                        break;
                    }
                    case 2: {
                        this.smallMoveRight();
                        break;
                    }
                    case 3: {
                        this.goToUpperFormula();
                        break;
                    }
                    case 4: {
                        this.goToLowerFormula();
                        break;
                    }
                    case 5: {
                        this.F.setCursorPos(this.F.startOfLine(this.F.getCursorPos()));
                        break;
                    }
                    case 6: {
                        this.F.setCursorPos(this.F.endOfLine(this.F.getCursorPos()));
                    }
                }
            }
        } else {
            int n3 = this.T.getCursorPos();
            switch (n) {
                case 1: {
                    this.T.setCursorPos(this.T.prevChar(this.T.getCursorPos()));
                    if (bl2 || !this.T.TNode(this.T.getCursorPos()).isFormula()) break;
                    int n4 = this.T.getCursorPos();
                    this.mainF = this.T.TNode(n4).getFI().getFormula(0);
                    this.setActiveFormulaAt(n4, this.mainF, 0, 0);
                    this.moveCursor(false, false, 6);
                    break;
                }
                case 2: {
                    this.T.setCursorPos(this.T.firstChar(this.T.getCursorPos()));
                    if (this.T.getCursorPos() >= this.T.end()) break;
                    if (!bl2 && this.T.TNode(this.T.getCursorPos()).isFormula()) {
                        int n5 = this.T.getCursorPos();
                        this.mainF = this.T.TNode(n5).getFI().getFormula(0);
                        this.setActiveFormulaAt(n5, this.mainF, 0, 0);
                        break;
                    }
                    this.T.setCursorPos(this.T.getCursorPos() + 1);
                    break;
                }
                case 3: {
                    if (!this.inVerticalMotion) {
                        this.cursorX = this.T.getX(this, this.T.getCursorPos());
                        this.inVerticalMotion = true;
                    }
                    int n6 = this.T.previousLine(this.T.getCursorPos());
                    this.T.setCursorPos(n6 + this.T.getOffsetOfTNodeAtPixel(this, n6, this.cursorX));
                    break;
                }
                case 4: {
                    if (!this.inVerticalMotion) {
                        this.cursorX = this.T.getX(this, this.T.getCursorPos());
                        this.inVerticalMotion = true;
                    }
                    int n7 = this.T.nextLine(this.T.getCursorPos());
                    this.T.setCursorPos(n7 + this.T.getOffsetOfTNodeAtPixel(this, n7, this.cursorX));
                    break;
                }
                case 5: {
                    this.T.setCursorPos(this.T.startOfLine(this.T.getCursorPos()));
                    break;
                }
                case 6: {
                    this.T.setCursorPos(this.T.endOfLine(this.T.getCursorPos()));
                }
            }
            if (n3 != this.T.getCursorPos()) {
                if (bl) {
                    if (!this.T.segMarked()) {
                        this.T.markSegment(n3, this.T.getCursorPos());
                    } else {
                        this.T.updateSegment();
                    }
                    if (this.T.getY(this, n3) != this.T.getY(this, this.T.getCursorPos())) {
                        this.updateScreenLineAtTNode(n3);
                    }
                    this.updateScreenLineAtTNode(this.T.getCursorPos());
                } else if (this.T.segMarked()) {
                    this.T.unmarkSegment();
                    this.updateScreenSegment(this.T.segMin(), this.T.segMax());
                }
            }
        }
        this.paintCursor();
    }

    boolean editNode(int n, int n2) {
        if (this.F != null) {
            TNode tNode;
            int n3 = this.F.getCursorPos();
            int n4 = n3;
            if (!this.F.TNode(n4).isExpr() && n4 > this.F.begin()) {
                --n4;
            }
            if ((tNode = this.F.TNode(n4)).isExpr()) {
                MathEditor mathEditor = new MathEditor(this.parent, this.Tr, tNode.getExpr(), tNode.getDecExpr(), tNode.getFixed());
                mathEditor.display(true, true);
                if (mathEditor.ok) {
                    tNode.setExpr(mathEditor.getExpr());
                    tNode.setDecExpr(mathEditor.getDecExpr());
                    tNode.setFixed(mathEditor.getFixed());
                    this.mainF.calcValues(this.dec, this.fixed, this.aL, this.editing);
                    this.updateScreen();
                }
                mathEditor.dispose();
                return true;
            }
        }
        return false;
    }

    public void editImages() {
        Point point = this.getLocationOnScreen();
        ImageDialog imageDialog = new ImageDialog(this.A, this.parent, " Im\u00e1genes", this.image, this.activeImage);
        imageDialog.show();
        this.image = imageDialog.getImages();
        this.activeImage = imageDialog.getActiveImage();
        this.selectImage(this.activeImage);
        imageDialog.dispose();
        this.updateBackground();
        this.updateScreen();
    }

    public int getActiveImage() {
        return this.activeImage;
    }

    private void removeListeners() {
        this.removeKeyListener(this);
    }

    private void addListeners() {
        this.addKeyListener(this);
    }

    public void setUnicodeBase(int n) {
        this.UC_base = (char)(n - 97);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        this.updating = true;
        if (keyEvent.getKeyChar() >= ' ') {
            if (keyEvent.getKeyChar() >= 'A' && keyEvent.getKeyChar() < '[' || keyEvent.getKeyChar() >= 'a' && keyEvent.getKeyChar() < '{') {
                this.insertChar((char)(keyEvent.getKeyChar() + this.UC_base));
            } else if (keyEvent.getKeyChar() != '\u007f') {
                this.insertChar(keyEvent.getKeyChar());
            }
            if (this.F != null && this.F.getCursorPos() == this.F.end() && keyEvent.getKeyChar() == '(') {
                this.insertChar(')');
                this.moveLeft();
            }
        }
        this.updating = false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        this.updating = true;
        if (keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40) {
            this.inVerticalMotion = false;
        }
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isAltDown();
        boolean bl4 = false;
        block0 : switch (keyEvent.getKeyChar()) {
            case '/': 
            case '_': {
                if (this.F == null) break;
                bl4 = true;
                this.insertFraction("", "");
                break;
            }
            case '^': {
                if (this.F == null) break;
                bl4 = true;
                this.insertSuperIndex("");
                break;
            }
            default: {
                switch (keyEvent.getKeyCode()) {
                    case 87: {
                        if (!bl2 || this.F == null) break block0;
                        System.out.println(this.F.toString());
                        break block0;
                    }
                    case 70: 
                    case 81: {
                        if (!bl2) break block0;
                        if (this.F != null) {
                            bl4 = true;
                            this.insertFraction("", "");
                            break block0;
                        }
                        this.insertFormula("");
                        break block0;
                    }
                    case 69: {
                        if (!bl2 || this.F == null) break block0;
                        bl4 = true;
                        this.insertExpr("1");
                        break block0;
                    }
                    case 83: {
                        if (!bl2 || this.F == null) break block0;
                        bl4 = true;
                        this.insertSum("", "", "");
                        break block0;
                    }
                    case 82: {
                        if (!bl2 || this.F == null) break block0;
                        bl4 = true;
                        this.insertRadical("", "");
                        break block0;
                    }
                    case 73: {
                        if (!bl2 || this.F == null) break block0;
                        bl4 = true;
                        this.insertIntegral("", "", "");
                        break block0;
                    }
                    case 80: {
                        if (!bl2 || this.F == null) break block0;
                        break block0;
                    }
                    case 27: {
                        if (this.F == null) break block0;
                        this.eraseCursor();
                        this.doEscape();
                        this.paintCursor();
                        break block0;
                    }
                    case 10: {
                        if (this.F != null) break block0;
                        this.insertText("\n");
                        break block0;
                    }
                    case 37: {
                        this.moveCursor(bl, bl2, 1);
                        break block0;
                    }
                    case 39: {
                        this.moveCursor(bl, bl2, 2);
                        break block0;
                    }
                    case 40: {
                        this.moveCursor(bl, bl2, 4);
                        break block0;
                    }
                    case 38: {
                        this.moveCursor(bl, bl2, 3);
                        break block0;
                    }
                    case 35: {
                        this.moveCursor(bl, bl2, 6);
                        break block0;
                    }
                    case 36: {
                        this.moveCursor(bl, bl2, 5);
                        break block0;
                    }
                    case 127: {
                        if (this.F != null && this.F.segMarked() || this.F == null && this.T.segMarked()) {
                            this.removeMarkedSegment();
                            break block0;
                        }
                        this.delete();
                        break block0;
                    }
                    case 8: {
                        if (this.F != null && this.F.segMarked() || this.F == null && this.T.segMarked()) {
                            this.removeMarkedSegment();
                            break block0;
                        }
                        this.backSpace();
                        break block0;
                    }
                    case 67: {
                        if (this.F != null) {
                            if (!bl2) break block0;
                            if (bl) {
                                this.insertFraction("", "");
                                if (!this.F.segMarked()) break block0;
                                bl4 = true;
                                break block0;
                            }
                            if (!this.F.segMarked()) break block0;
                            this.F.copy();
                            break block0;
                        }
                        if (!bl2 || !this.T.segMarked()) break block0;
                        this.T.copy();
                        break block0;
                    }
                    case 88: {
                        if (this.F != null) {
                            if (!bl2 || !this.F.segMarked()) break block0;
                            this.F.copy();
                            this.removeMarkedSegment();
                            this.updateSize();
                            break block0;
                        }
                        if (!bl2 || !this.T.segMarked()) break block0;
                        this.T.copy();
                        this.removeMarkedSegment();
                        this.updateSize();
                        break block0;
                    }
                    case 86: {
                        if (!bl2) break block0;
                        if (this.F != null) {
                            if (this.F.segMarked()) {
                                this.removeMarkedSegment();
                            }
                            int n = this.F.getCursorPos();
                            if (this.editing) {
                                this.F.paste();
                                this.updateSize();
                            }
                            this.updateScreenFromTNode(this.mainFIndex);
                            break block0;
                        }
                        if (this.T.segMarked()) {
                            this.removeMarkedSegment();
                        }
                        int n = this.T.getCursorPos();
                        this.T.paste();
                        this.updateScreenFromTNode(n);
                        this.updateSize();
                    }
                }
            }
        }
        if (bl4 && this.F.segMarked()) {
            this.F.unmarkSegment();
            this.updateScreenFromTNode(this.mainFIndex);
        }
        this.updating = false;
        this.updateSelectors();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void updateImageCursor(int n, int n2) {
        this.activeImage = -1;
        this.activeImage2 = -1;
        int n3 = this.image.length - 1;
        while (n3 >= 0) {
            if (this.moveimg && this.image[n3].getLocation().x <= n && n < this.image[n3].getLocation().x + this.image[n3].getWidth() && this.image[n3].getLocation().y <= n2 && n2 < this.image[n3].getLocation().y + this.image[n3].getHeight()) {
                this.activeImage = n3;
                break;
            }
            --n3;
        }
        int n4 = this.image2.length - 1;
        while (n4 >= 0) {
            if (this.image2[n4].getLocation().x <= n && n < this.image2[n4].getLocation().x + this.image2[n4].getWidth() && this.image2[n4].getLocation().y <= n2 && n2 < this.image2[n4].getLocation().y + this.image2[n4].getHeight()) {
                this.activeImage2 = n4;
                break;
            }
            --n4;
        }
        if (this.activeImage >= 0 || this.activeImage2 >= 0) {
            if (this.getCursor() != Cursor.getPredefinedCursor(13)) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else {
            this.setCursor(null);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.F != null) {
            int n = this.F.getIndexOfTNodeAtPixel(this, mouseEvent.getX(), mouseEvent.getY());
            if (this.isEditing() && this.F.segMarked() && this.F.segMin() <= n && n <= this.F.segMax()) {
                this.pressed = true;
                this.point = mouseEvent.getComponent().getLocationOnScreen();
                this.F.copy();
            } else {
                this.doMousePressed(mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            int n = this.T.getIndexOfTNodeAtPixel(this, mouseEvent.getX(), mouseEvent.getY());
            if (this.isEditing() && this.T.segMarked() && this.T.segMin() <= n && n <= this.T.segMax()) {
                this.pressed = true;
                this.point = mouseEvent.getComponent().getLocationOnScreen();
            } else {
                this.doMousePressed(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void doMousePressed(int n, int n2) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.F != null) {
            Formula formula;
            if (!this.hasFocus) {
                this.requestFocus();
            }
            this.eraseCursor();
            if (this.F.segMarked()) {
                this.F.unmarkSegment();
                this.updateScreenFromTNode(this.mainFIndex);
            }
            if ((formula = this.mainF.getFormulaAt(n, n2)) == null) {
                this.setCursorPos(n, n2);
            } else {
                this.setActiveFormulaAt(this.mainFIndex, formula, n, n2);
            }
            this.paintCursor();
            this.updateSelectors();
        } else if (this.isEditing()) {
            this.eraseCursor();
            this.unmarkSegment();
            this.setCursorPos(n, n2);
            this.T.setSegment(this.T.getCursorPos(), this.T.getCursorPos());
            this.paintCursor();
            this.updateSelectors();
            this.requestFocus();
        } else if (this.moveimg || this.moveimg2) {
            this.mouseX = n;
            this.mouseY = n2;
            this.updateImageCursor(this.mouseX, this.mouseY);
        }
        this.selectImage(this.activeImage);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.F != null) {
            if (this.pressed) {
                this.pressed = false;
                if (this.dragged) {
                    boolean bl;
                    this.dragged = false;
                    Point point = this.getLocationOnScreen();
                    int n = this.point.x + mouseEvent.getX() - point.x;
                    int n2 = this.point.y + mouseEvent.getY() - point.y;
                    boolean bl2 = bl = 0 <= n && n < this.getSize().width && 0 <= n2 && n2 < this.getSize().height;
                    if (bl) {
                        if (!mouseEvent.isControlDown()) {
                            this.F.removeMarkedSegment();
                        }
                        this.F.unmarkSegment();
                        this.doMousePressed(n, n2);
                        if (this.F != null) {
                            this.F.paste();
                            this.updateScreen();
                            this.updateSize();
                        }
                    } else {
                        this.unmarkSegment();
                    }
                    this.point = null;
                    return;
                }
                this.point = null;
                this.eraseCursor();
                this.unmarkSegment();
                this.setCursorPos(mouseEvent.getX(), mouseEvent.getY());
                this.F.setSegment(this.F.getCursorPos(), this.F.getCursorPos());
                this.paintCursor();
                this.updateSelectors();
                this.requestFocus();
                return;
            }
        } else {
            if (this.pressed) {
                this.pressed = false;
                if (this.dragged) {
                    boolean bl;
                    this.dragged = false;
                    Point point = this.getLocationOnScreen();
                    int n = this.point.x + mouseEvent.getX() - point.x;
                    int n3 = this.point.y + mouseEvent.getY() - point.y;
                    boolean bl3 = bl = 0 <= n && n < this.getSize().width && 0 <= n3 && n3 < this.getSize().height;
                    if (bl) {
                        this.T.copy();
                        if (!mouseEvent.isControlDown()) {
                            this.T.removeMarkedSegment();
                        }
                        int n4 = this.T.segMin();
                        this.T.unmarkSegment();
                        this.doMousePressed(n, n3);
                        n4 = Math.min(n4, this.T.getCursorPos());
                        this.T.paste();
                        this.updateScreenFromTNode(n4);
                        this.updateSize();
                    } else {
                        this.unmarkSegment();
                    }
                    this.point = null;
                    return;
                }
                this.point = null;
                this.eraseCursor();
                this.unmarkSegment();
                this.setCursorPos(mouseEvent.getX(), mouseEvent.getY());
                this.T.setSegment(this.T.getCursorPos(), this.T.getCursorPos());
                this.paintCursor();
                this.updateSelectors();
                this.requestFocus();
                return;
            }
            if (!this.isEditing() && (this.moveimg || this.moveimg2)) {
                this.setCursor(null);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.isEditing()) {
            if (mouseEvent.getClickCount() == 2) {
                if (!this.editNode(mouseEvent.getX(), mouseEvent.getY())) {
                    this.dblclckpos = this.getCursorPos();
                    this.dblclckmillis = System.currentTimeMillis();
                    this.selectWordAt(this.dblclckpos);
                }
            } else if (mouseEvent.getClickCount() == 1) {
                if (System.currentTimeMillis() < this.dblclckmillis + 500L && this.dblclckpos == this.getCursorPos()) {
                    this.selectLineAt(this.getCursorPos());
                }
                this.dblclckmillis = -1L;
                this.dblclckpos = -1;
            }
        } else if (this.F == null && (this.moveimg || this.moveimg2) && mouseEvent.getModifiers() == 4) {
            this.editImages();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.isEditing()) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        } else if (this.moveimg || this.moveimg2) {
            // empty if block
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        this.setCursor(null);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.isEditing()) {
            if (this.getCursor() != Cursor.getPredefinedCursor(2)) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        } else if (this.moveimg || this.moveimg2) {
            this.updateImageCursor(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.F != null) {
            if (this.pressed) {
                this.dragged = true;
                return;
            }
            if (this.isEditing()) {
                this.setCursorPosInFormula(mouseEvent.getX(), mouseEvent.getY());
                if (this.F.segEnd() != this.F.getCursorPos()) {
                    this.F.markSegment(this.F.segBegin(), this.F.getCursorPos());
                    this.updateScreenLineAtTNode(this.mainFIndex);
                }
            }
        } else {
            if (this.pressed) {
                this.dragged = true;
                return;
            }
            if (this.isEditing()) {
                this.setCursorPosInText(mouseEvent.getX(), mouseEvent.getY());
                if (this.T.segEnd() != this.T.getCursorPos()) {
                    this.T.markSegment(this.T.segBegin(), this.T.getCursorPos());
                    this.updateScreenSegment(this.T.segMin(), this.T.segMax());
                }
            } else if (this.moveimg || this.moveimg2) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (this.activeImage >= 0 || this.activeImage2 >= 0) {
                    if (this.activeImage >= 0) {
                        int n3 = this.image[this.activeImage].getLocation().x;
                        int n4 = this.image[this.activeImage].getLocation().y;
                        this.image[this.activeImage].setLocation(n3 + n - this.mouseX, n4 + n2 - this.mouseY);
                    } else {
                        int n5 = this.image2[this.activeImage2].getLocation().x;
                        int n6 = this.image2[this.activeImage2].getLocation().y;
                        this.image2[this.activeImage2].setLocation(n5 + n - this.mouseX, n6 + n2 - this.mouseY);
                    }
                    this.updateBackground();
                    this.updateScreen();
                }
                this.mouseX = n;
                this.mouseY = n2;
            }
        }
    }
}

