/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.cmp.mjaButton;
import com.mja.cmp.mjaConst;
import com.mja.cmp.mjaPanel;
import com.mja.gui.Explainer;
import com.mja.gui.MouseCursorHandler;
import com.mja.gui.edit.ColorButton;
import com.mja.gui.edit.editColorDialog;
import com.mja.gui.editDialog;
import com.mja.gui.editFrame;
import com.mja.gui.mjaColor;
import com.mja.gui.mjaText;
import com.mja.lang.translator;
import com.mja.text.EditorCanvas;
import com.mja.text.ExplText;
import com.mja.text.RTF;
import com.mja.text.TColors;
import com.mja.text.TFont;
import com.mja.text.UnicodeSelector;
import com.mja.util.Attribute;
import com.mja.util.BasicStr;
import com.mja.util.Expl;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class EditorButtons
extends Panel
implements ActionListener,
ItemListener,
MouseListener,
MouseMotionListener,
Explainer {
    public static final int FUENTES = 0;
    public static final int COLORES = 1;
    public static final int fract = 2;
    public static final int power = 3;
    public static final int radical = 4;
    public static final int sum = 5;
    public static final int integral = 6;
    public static final int matrix = 7;
    public static final int expr = 8;
    public static final int FORMULAS = 9;
    public static final int CARACTERES = 10;
    public static final int UNICODE = 11;
    public static final int TO_RTF = 12;
    public static final int IMAGES = 13;
    public static final String[] attrName = new String[]{"fuentes", "colores", "fracciones", "potencias", "radicales", "series", "integrales", "matrices", "expresiones", "formulas", "caracteres", "unicode", "rtf", "im\u00e1genes"};
    public static final String[] attrSymbol = new String[]{"fuentes", "colores", "a/b", "x\u00b2", "\u221a\u00af", "\u2211", "\u222b", "(::)", "ex", "[F]", "caracteres", "unicode", "rtf", "im\u00e1genes"};
    public static final String TextEditorAttributes = "fuentes=si colores=si formulas=si fracciones=si potencias=si radicales=si series=si integrales=si expresiones=no caracteres=no unicode=si rtf=si im\u00e1genes=no";
    public static final String PECEIAttributes = "fuentes=si colores=si formulas=si fracciones=no potencias=no radicales=no series=no integrales=no expresiones=no caracteres=no unicode=si rtf=no im\u00e1genes=si";
    public static final String DescartesAttributes = "fuentes=si colores=si formulas=si fracciones=si potencias=si radicales=si series=si integrales=si matrices=si expresiones=si caracteres=no unicode=si rtf=no im\u00e1genes=no";
    public static final String AuthorAttributes = "fuentes=si colores=si formulas=si fracciones=si potencias=si radicales=si series=si integrales=si matrices=si expresiones=si caracteres=si unicode=no rtf=no im\u00e1genes=no";
    public static final String StudentAttributes = "fuentes=no colores=no formulas=no fracciones=si potencias=si radicales=si series=si integrales=si matrices=si expresiones=no caracteres=si unicode=no rtf=no im\u00e1genes=no";
    public static final String DefaultAttributes = "fuentes=si colores=si formulas=no fracciones=si potencias=si radicales=si series=no integrales=no matrices=si expresiones=no caracteres=si unicode=no rtf=no im\u00e1genes=no";
    public boolean[] boolAttr = new boolean[attrName.length];
    private Choice ch_type;
    private Choice ch_size;
    private Checkbox chb_edit;
    private Checkbox chb_show;
    private Checkbox chb_bold;
    private Checkbox chb_italic;
    private Checkbox chb_underline;
    private Checkbox chb_overline;
    private ColorButton colorButton;
    public Button b_img;
    private Button b_uc;
    private Button b_for;
    private Button b_rtf;
    private Button b_help;
    private static final String[] bFTit = new String[]{"Fracci\u00f3n", "Potencia", "Radical", "Suma", "Integral", "Matriz", "Expresi\u00f3n"};
    private Button[] bFEC = new Button[7];
    private Choice ch_symb;
    private mjaPanel NP;
    private mjaPanel spsymb;
    private String[] lbSymb = new String[]{"Latino", "S\u00edmbolos", "Griegas", "GRIEGAS"};
    private int[] charunicodes = new int[]{97, 8704, 945, 913};
    private int base = 0;
    private mjaButton[] bSymb = new mjaButton[26];
    private editFrame ef_rtf;
    private editFrame ef_symbol;
    private editFrame ef_special;
    private TextArea t_rtf;
    private editColorDialog ecd;
    private Frame pf;
    private translator Tr;
    private MouseCursorHandler mch;
    private MouseCursorHandler extra_mch;
    private boolean editable;
    private boolean symbTbl;
    private boolean images;
    private boolean toRTF;
    private boolean inFormula;
    private Applet A;
    private EditorCanvas EC;
    private int ixOther = -1;
    private TextField tf;
    private boolean fill;
    private boolean useKB;
    private boolean useListeners = false;
    private boolean empty = true;
    private int isymb = -1;
    private int ifec = -1;
    private int as_in = -1;
    private boolean dragged = false;

    public EditorButtons(Applet applet, Frame frame, translator translator2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.A = applet;
        this.pf = frame;
        this.Tr = translator2;
        this.editable = bl;
        this.images = bl2;
        this.fill = bl3;
        this.useKB = bl4;
        this.mch = new MouseCursorHandler(this, this);
        this.setFont(mjaText.Serif);
        this.b_help = new Button("?");
        this.ch_type = new Choice();
        int n = 0;
        while (n < RTF.Java2FontNames.length) {
            this.ch_type.add(RTF.Java2FontNames[n]);
            ++n;
        }
        this.ch_type.select(1);
        this.ch_size = new Choice();
        int n2 = 8;
        while (n2 < 80) {
            if (n2 >= 30) {
                n2 += 2;
            }
            if (n2 > 40) {
                n2 += 4;
            }
            this.ch_size.addItem(Integer.toString(n2));
            n2 += 2;
        }
        this.chb_bold = new Checkbox("n");
        this.chb_bold.setFont(mjaConst.SansSerif_B);
        this.chb_italic = new Checkbox("it");
        this.chb_italic.setFont(mjaConst.SansSerif_I);
        this.chb_underline = new Checkbox("_");
        this.chb_overline = new Checkbox(new Character('\u00af').toString());
        this.colorButton = new ColorButton("C");
        this.ch_symb = new Choice();
        this.setCharsList(this.lbSymb, this.charunicodes);
        this.ch_symb.addItemListener(this);
        this.ch_symb.addMouseListener(this.mch);
        this.b_uc = new Button("tabla");
        this.b_rtf = new Button("rtf");
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.chb_edit = new Checkbox("ed", checkboxGroup, true);
        this.chb_show = new Checkbox("mo", checkboxGroup, false);
        this.b_img = new Button("img");
        this.b_for = new Button("[F]");
        this.spsymb = new mjaPanel();
        int n3 = 0;
        while (n3 < this.bSymb.length) {
            this.bSymb[n3] = new mjaButton(6);
            this.bSymb[n3].addActionListener(this);
            this.bSymb[n3].addMouseListener(this);
            this.bSymb[n3].addMouseListener(this.mch);
            this.bSymb[n3].addMouseMotionListener(this);
            this.bSymb[n3].setFont(mjaConst.Monospaced);
            ++n3;
        }
        this.tf = new TextField(4);
        this.tf.setBackground(Color.white);
        this.tf.addActionListener(this);
        this.tf.addMouseListener(this.mch);
        this.colorButton.setTextColor(new mjaColor(Color.black));
        this.colorButton.setBackColor(new mjaColor(Color.white));
        this.colorButton.addMouseListener(this);
        this.b_uc.addActionListener(this);
        this.b_img.addActionListener(this);
        this.b_for.addActionListener(this);
        this.b_rtf.addActionListener(this);
        this.b_help.addActionListener(this);
        this.addItemListeners(true);
        this.ch_type.addMouseListener(this.mch);
        this.ch_size.addMouseListener(this.mch);
        this.chb_bold.addMouseListener(this.mch);
        this.chb_italic.addMouseListener(this.mch);
        this.chb_underline.addMouseListener(this.mch);
        this.chb_overline.addMouseListener(this.mch);
        this.colorButton.addMouseListener(this.mch);
        this.b_help.addMouseListener(this.mch);
        this.b_uc.addMouseListener(this.mch);
        this.b_img.addMouseListener(this.mch);
        this.b_for.addMouseListener(this.mch);
        this.b_rtf.addMouseListener(this.mch);
        this.chb_edit.addMouseListener(this.mch);
        this.chb_show.addMouseListener(this.mch);
        String string = applet.getParameter("EditorConfig");
        if (BasicStr.hasContent(string)) {
            this.setAttributes(string);
        } else {
            this.setAttributes(DefaultAttributes);
        }
    }

    public void setCharsList(String[] stringArray, int[] nArray) {
        this.lbSymb = stringArray;
        this.charunicodes = nArray;
        this.ch_symb.removeAll();
        int n = 0;
        while (n < stringArray.length) {
            this.ch_symb.add(stringArray[n]);
            ++n;
        }
        if (stringArray.length > 0) {
            this.ch_symb.select(0);
        }
    }

    public void setAttributes(String string) {
        Attribute[] attributeArray = Attribute.parse(string);
        this.empty = true;
        int n = 0;
        while (n < this.boolAttr.length) {
            String string2 = Attribute.getValue(attributeArray, attrName[n]);
            boolean bl = this.boolAttr[n] = BasicStr.hasContent(string2) && !string2.equalsIgnoreCase("no") && !string2.equalsIgnoreCase("0");
            if (this.boolAttr[n]) {
                this.empty = false;
            }
            ++n;
        }
        this.rebuild();
        this.updateSymbols();
    }

    public void setEditorCanvas(EditorCanvas editorCanvas, boolean bl) {
        if (this.EC != null) {
            this.EC.removeMouseListener(this);
            this.EC.removeMouseMotionListener(this);
        }
        this.EC = editorCanvas;
        this.EC.addMouseListener(this);
        this.EC.addMouseMotionListener(this);
        if (bl) {
            this.setEditing(this.EC.isEditing());
            this.updateSelectors();
            this.EC.activateButtons();
        }
    }

    public void addExtraMH(MouseCursorHandler mouseCursorHandler) {
        this.extra_mch = mouseCursorHandler;
    }

    public void removeExtraMH() {
        this.extra_mch = null;
    }

    private void rebuild() {
        this.removeAll();
        this.NP = new mjaPanel();
        this.NP.setBackground(mjaConst.backGray);
        this.NP.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (this.fill) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
        } else {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (this.boolAttr[0]) {
            this.NP.add((Component)this.ch_type, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP.add((Component)this.ch_size, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP.add((Component)this.chb_bold, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.chb_bold.setFont(mjaConst.SansSerif_B);
            this.NP.add((Component)this.chb_italic, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.chb_italic.setFont(mjaConst.SansSerif_I);
            this.NP.add((Component)this.chb_underline, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP.add((Component)this.chb_overline, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[1]) {
            this.NP.add((Component)this.colorButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        int n = 0;
        while (n < this.bFEC.length) {
            this.bFEC[n] = new Button(attrSymbol[2 + n]);
            if (this.boolAttr[2 + n]) {
                this.NP.add((Component)this.bFEC[n], gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
            this.bFEC[n].addActionListener(this);
            this.bFEC[n].addMouseListener(this);
            this.bFEC[n].addMouseListener(this.mch);
            this.bFEC[n].addMouseMotionListener(this);
            ++n;
        }
        if (this.boolAttr[9]) {
            this.NP.add((Component)this.b_for, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[10]) {
            this.NP.add((Component)this.ch_symb, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[11]) {
            this.NP.add((Component)this.b_uc, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.images && this.boolAttr[13]) {
            this.NP.add((Component)this.chb_edit, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP.add((Component)this.chb_show, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP.add((Component)this.b_img, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[12]) {
            this.NP.add((Component)this.b_rtf, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (!this.empty) {
            this.NP.add((Component)this.b_help, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[10]) {
            this.setLayout(new GridLayout(2, 1));
            this.add(this.NP);
            this.add(this.spsymb);
        } else {
            this.setLayout(new GridLayout(1, 1));
            this.add(this.NP);
        }
        this.ch_size.select("24");
        this.ch_symb.select(0);
    }

    private void updateSymbols() {
        this.spsymb.removeAll();
        this.base = 97;
        this.ixOther = -1;
        int n = 0;
        if ("S\u00edmbolos".equals(this.ch_symb.getSelectedItem()) || "Symbols".equals(this.ch_symb.getSelectedItem())) {
            this.base = 8704;
            int n2 = 0;
            this.bSymb[n2++].setLabel("+");
            this.bSymb[n2++].setLabel("-");
            this.bSymb[n2++].setLabel(new Character('\u00b7').toString());
            this.bSymb[n2++].setLabel(new Character('\u00d7').toString());
            this.bSymb[n2++].setLabel(new Character('\u00f7').toString());
            this.bSymb[n2++].setLabel(new Character('\u00b1').toString());
            this.bSymb[n2++].setLabel("=");
            this.bSymb[n2++].setLabel(new Character((char)(this.base + 96)).toString());
            this.bSymb[n2++].setLabel(new Character((char)(this.base + 100)).toString());
            this.bSymb[n2++].setLabel(new Character((char)(this.base + 101)).toString());
            this.bSymb[n2++].setLabel(new Character((char)(this.base + 72)).toString());
            this.bSymb[n2++].setLabel(new Character((char)(this.base + 97)).toString());
            this.bSymb[n2++].setLabel(new Character('\u0192').toString());
            this.bSymb[n2++].setLabel(new Character((char)(this.base + 30)).toString());
            this.ixOther = n2;
            this.bSymb[n2++].setLabel("otros");
            n = n2;
            this.spsymb.setLayout(new FlowLayout(1, 0, 0));
            int n3 = 0;
            while (n3 < this.bSymb.length) {
                if (n3 < n) {
                    this.spsymb.add(this.bSymb[n3]);
                }
                ++n3;
            }
            this.spsymb.add(this.tf);
        } else {
            int n4 = 0;
            while (n4 < this.charunicodes.length) {
                if (this.lbSymb[n4].equals(this.ch_symb.getSelectedItem())) {
                    this.base = this.charunicodes[n4];
                    n = this.bSymb.length;
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.bSymb.length) {
                this.bSymb[n5].setLabel(new Character((char)(this.base + n5)).toString());
                ++n5;
            }
            this.spsymb.setLayout(new GridLayout(1, n));
            int n6 = 0;
            while (n6 < this.bSymb.length) {
                if (this.base == 945 || n6 != 17) {
                    this.spsymb.add(this.bSymb[n6]);
                }
                ++n6;
            }
        }
        if (this.EC != null && this.useKB) {
            this.EC.setUnicodeBase(this.base);
        }
    }

    private void updateEnabling() {
        this.colorButton.setEnabled(this.editable);
        this.ch_type.setEnabled(this.editable);
        this.ch_size.setEnabled(this.editable);
        this.chb_bold.setEnabled(this.editable);
        this.chb_italic.setEnabled(this.editable);
        this.chb_underline.setEnabled(this.editable);
        this.chb_overline.setEnabled(this.editable);
        this.b_uc.setEnabled(this.editable);
        this.b_for.setEnabled(this.editable);
        this.b_rtf.setEnabled(this.editable);
        int n = 0;
        while (n < this.bFEC.length) {
            this.bFEC[n].setEnabled(this.editable);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.bSymb.length) {
            this.bSymb[n2].setEnabled(this.editable);
            ++n2;
        }
        if (this.editable) {
            int n3 = 0;
            while (n3 < this.bFEC.length) {
                this.bFEC[n3].setEnabled(this.inFormula);
                ++n3;
            }
            this.b_for.setEnabled(!this.inFormula);
        }
    }

    public void updateTranslation() {
        this.chb_bold.setLabel(this.Tr.getTr(233));
        this.chb_italic.setLabel(this.Tr.getTr(234));
        this.chb_underline.setLabel(this.Tr.getTr(235));
        this.chb_overline.setLabel(this.Tr.getTr(236));
        this.colorButton.setLabel(this.Tr.getTr(26));
        this.b_uc.setLabel(this.Tr.getTr(226));
        this.b_for.setLabel(this.Tr.getTr(237));
        this.chb_edit.setLabel(this.Tr.getTr(231));
        this.chb_show.setLabel(this.Tr.getTr(232));
        this.b_img.setLabel(this.Tr.getTr(269));
    }

    public void addItemListeners(boolean bl) {
        this.useListeners = bl;
        this.addItemListeners();
    }

    public void removeItemListeners(boolean bl) {
        this.removeItemListeners();
        this.useListeners = !bl;
    }

    private void addItemListeners() {
        if (this.useListeners) {
            this.ch_type.addItemListener(this);
            this.ch_size.addItemListener(this);
            this.chb_bold.addItemListener(this);
            this.chb_italic.addItemListener(this);
            this.chb_underline.addItemListener(this);
            this.chb_overline.addItemListener(this);
            this.chb_edit.addItemListener(this);
            this.chb_show.addItemListener(this);
        }
    }

    private void removeItemListeners() {
        if (this.useListeners) {
            this.ch_type.removeItemListener(this);
            this.ch_size.removeItemListener(this);
            this.chb_bold.removeItemListener(this);
            this.chb_italic.removeItemListener(this);
            this.chb_underline.removeItemListener(this);
            this.chb_overline.removeItemListener(this);
            this.chb_edit.removeItemListener(this);
            this.chb_show.removeItemListener(this);
        }
    }

    public void updateSelectors() {
        if (this.EC != null) {
            TColors tColors = this.EC.getCursorColors();
            TFont tFont = this.EC.getCursorTFont();
            this.removeItemListeners();
            this.ch_type.select(tFont.getName());
            this.chb_edit.setState(this.EC.isEditing());
            this.chb_show.setState(!this.EC.isEditing());
            this.b_img.setEnabled(!this.EC.isEditing());
            this.chb_bold.setState(tFont.isBold());
            this.chb_italic.setState(tFont.isItalic());
            this.chb_underline.setState(tFont.isUnderline());
            this.chb_overline.setState(tFont.isOverline());
            this.ch_size.select(Integer.toString(tFont.getSize()));
            this.colorButton.setColors(new mjaColor(tColors.getBackColor()), new mjaColor(tColors.getTextColor()));
            this.tf.setText(this.EC.getCharAtCursor());
            this.addItemListeners();
        }
    }

    TColors getColorsFromControls() {
        return new TColors(this.colorButton.getBackColor().getAdaptedColor(), this.colorButton.getTextColor().getAdaptedColor());
    }

    TFont getTFontFromControls() {
        int n = 12;
        try {
            n = Integer.parseInt(this.ch_size.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new TFont(this.ch_type.getSelectedItem(), this.chb_bold.getState(), this.chb_italic.getState(), this.chb_underline.getState(), this.chb_overline.getState(), n);
    }

    void insertTFont() {
        this.EC.insertTFont(this.getTFontFromControls());
    }

    private void openSymbolsDialog(Component component) {
        String string = UnicodeSelector.getUnicodeChar(this.pf, this.Tr);
        if (string != null && string.length() > 0) {
            this.EC.insertText(string);
        }
        component.setEnabled(false);
        this.EC.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand()) {
            if (actionEvent.getSource() == this.EC && actionEvent.getActionCommand().equals("focus") && !this.useListeners) {
                this.addItemListeners(true);
            }
            if (actionEvent.getSource() == this.b_uc) {
                this.openSymbolsDialog(this.b_uc);
            } else if (actionEvent.getSource() == this.b_img) {
                this.EC.editImages();
            } else if (actionEvent.getSource() == this.b_for) {
                this.EC.insertFormula("");
                this.EC.activateButtons();
                this.EC.requestFocus();
            } else if (actionEvent.getSource() == this.b_rtf) {
                mjaText.showPlainText(this.pf, "  RTF  ", " \n" + this.EC.toRTF(false));
            } else if (actionEvent.getSource() == this.b_help) {
                this.mch.setHand();
            } else if (actionEvent.getSource() == this.EC) {
                if (actionEvent.getActionCommand().equals("UpdateSelectors")) {
                    this.updateSelectors();
                } else if (actionEvent.getActionCommand().equals("ActivateFormulaButtons") || actionEvent.getActionCommand().equals("ActivateTextButtons")) {
                    this.inFormula = actionEvent.getActionCommand().equals("ActivateFormulaButtons");
                    this.updateEnabling();
                }
            } else if (actionEvent.getSource() == this.tf) {
                String string = this.tf.getText();
                if (string.startsWith("0x")) {
                    string = string.substring(2);
                }
                try {
                    this.EC.insertChar((char)Integer.parseInt(string, 16));
                }
                catch (Exception exception) {
                    System.out.println("Invalid hexadecimal expresion");
                }
            }
        }
    }

    public void setEditing(boolean bl) {
        this.editable = bl;
        this.EC.setEditing(bl);
        this.removeItemListeners();
        this.chb_show.setState(!this.editable);
        this.chb_edit.setState(this.editable);
        this.b_img.setEnabled(!this.editable);
        this.addItemListeners();
        this.updateEnabling();
    }

    public String getExplLabel(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (this.extra_mch != null) {
            return "Controles del texto.";
        }
        if (component instanceof ColorButton) {
            return "Colores de texto y fondo.";
        }
        if (component instanceof Button) {
            Button button = (Button)component;
            int n = 0;
            while (n < this.bFEC.length) {
                if (button == this.bFEC[n]) {
                    return bFTit[n];
                }
                ++n;
            }
            return button.getLabel();
        }
        if (component instanceof mjaButton) {
            mjaButton mjaButton2 = (mjaButton)component;
            int n = 0;
            while (n < this.bSymb.length) {
                if (mjaButton2 == this.bSymb[n]) {
                    if (n == this.ixOther) {
                        return "Otros caracteres";
                    }
                    return "S\u00edmbolo especial";
                }
                ++n;
            }
            return mjaButton2.getLabel();
        }
        if (component instanceof Choice) {
            Choice choice = (Choice)component;
            if (choice == this.ch_type) {
                return "tipo de letra";
            }
            if (choice == this.ch_size) {
                return "tama\u00f1o de letra";
            }
        } else if (component instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)component;
            return checkbox.getLabel();
        }
        return "";
    }

    public String getExplanation(MouseEvent mouseEvent) {
        String[] stringArray = null;
        Component component = (Component)mouseEvent.getSource();
        if (this.extra_mch != null) {
            stringArray = ExplText.AlgebraTutor[10];
            this.extra_mch.setNull();
            this.extra_mch = null;
        } else if (component instanceof Choice) {
            Choice choice = (Choice)component;
            if (choice == this.ch_type) {
                stringArray = ExplText.EditText[0];
            } else if (choice == this.ch_size) {
                stringArray = ExplText.EditText[1];
            } else if (choice == this.ch_symb) {
                stringArray = ExplText.EditText[14];
            }
        } else if (component instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)component;
            if (checkbox == this.chb_bold) {
                stringArray = ExplText.EditText[2];
            } else if (checkbox == this.chb_italic) {
                stringArray = ExplText.EditText[3];
            } else if (checkbox == this.chb_underline) {
                stringArray = ExplText.EditText[4];
            } else if (checkbox == this.chb_overline) {
                stringArray = ExplText.EditText[5];
            } else if (checkbox == this.chb_edit) {
                stringArray = ExplText.EditText[6];
            } else if (checkbox == this.chb_show) {
                stringArray = ExplText.EditText[7];
            }
        } else if (component instanceof Button) {
            Button button = (Button)component;
            if (button == this.colorButton) {
                stringArray = ExplText.EditText[8];
            } else if (button == this.b_help) {
                stringArray = ExplText.EditText[9];
            } else if (button == this.b_uc) {
                stringArray = ExplText.EditText[10];
            } else if (button == this.b_img) {
                stringArray = ExplText.EditText[16];
            } else if (button == this.b_for) {
                stringArray = ExplText.EditText[11];
            } else if (button == this.b_rtf) {
                stringArray = ExplText.EditText[12];
            } else {
                int n = 0;
                while (n < this.bFEC.length) {
                    if (button == this.bFEC[n]) {
                        stringArray = ExplText.EditFormula[n];
                        break;
                    }
                    ++n;
                }
            }
        } else if (component instanceof mjaButton) {
            mjaButton mjaButton2 = (mjaButton)component;
            int n = 0;
            while (n < this.bSymb.length) {
                if (mjaButton2 == this.bSymb[n]) {
                    stringArray = n == this.ixOther ? ExplText.EditText[10] : ExplText.EditText[13];
                    break;
                }
                ++n;
            }
        } else if (component instanceof ColorButton) {
            ColorButton colorButton = (ColorButton)component;
            if (colorButton == this.colorButton) {
                stringArray = ExplText.EditText[7];
            }
        } else if (component instanceof TextField && component == this.tf) {
            stringArray = ExplText.EditText[15];
        }
        return Expl.get(stringArray, this.Tr.getActiveLanguage());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.extra_mch != null) {
                this.updateSelectors();
                return;
            }
            if (!this.mch.isHand()) {
                if (itemEvent.getSource() == this.chb_edit || itemEvent.getSource() == this.chb_show) {
                    boolean bl = this.chb_edit.getState();
                    this.setEditing(bl);
                    this.EC.requestFocus();
                } else if (itemEvent.getSource() == this.ch_type || itemEvent.getSource() == this.ch_size || itemEvent.getSource() == this.chb_bold || itemEvent.getSource() == this.chb_italic || itemEvent.getSource() == this.chb_underline || itemEvent.getSource() == this.chb_overline) {
                    this.insertTFont();
                    if (!this.EC.segIsMarked()) {
                        this.EC.requestFocus();
                    }
                } else if (itemEvent.getSource() == this.ch_symb) {
                    this.updateSymbols();
                    this.paintAll(this.getGraphics());
                }
            }
        } else if (!(this.mch.isHand() || itemEvent.getSource() != this.chb_bold && itemEvent.getSource() != this.chb_italic && itemEvent.getSource() != this.chb_underline && itemEvent.getSource() != this.chb_overline)) {
            this.insertTFont();
            if (!this.EC.segIsMarked()) {
                this.EC.requestFocus();
            }
        }
        this.updateSelectors();
    }

    private void insertNewFormulaItem(int n) {
        switch (2 + n) {
            case 2: {
                this.EC.setEditing(true);
                this.EC.insertFraction("", "");
                break;
            }
            case 3: {
                this.EC.setEditing(true);
                this.EC.insertSuperIndex("");
                break;
            }
            case 4: {
                this.EC.setEditing(true);
                this.EC.insertRadical("", "");
                break;
            }
            case 5: {
                this.EC.setEditing(true);
                this.EC.insertSum("", "", "");
                break;
            }
            case 6: {
                this.EC.setEditing(true);
                this.EC.insertIntegral("", "", "");
                break;
            }
            case 7: {
                Frame frame = new Frame();
                editDialog editDialog2 = new editDialog(frame, "matriz mxn", true, "aceptar", "cancelar");
                Label label = new Label("m =");
                Label label2 = new Label("n =");
                TextField textField = new TextField("2");
                TextField textField2 = new TextField("2");
                Panel panel = new Panel();
                panel.setLayout(new GridLayout(2, 2, 8, 8));
                panel.add(label);
                panel.add(textField);
                panel.add(label2);
                panel.add(textField2);
                editDialog2.add("Center", panel);
                editDialog2.display(true, true);
                if (editDialog2.ok) {
                    int n2 = BasicStr.parseInteger(textField.getText(), 2, 2);
                    int n3 = BasicStr.parseInteger(textField2.getText(), 2, 2);
                    this.EC.setEditing(true);
                    String[][] stringArray = new String[n2][n3];
                    this.EC.insertMatrix(stringArray);
                }
                frame.dispose();
                editDialog2.dispose();
                break;
            }
            case 8: {
                this.EC.setEditing(true);
                this.EC.insertExpr("1");
            }
        }
        this.EC.requestFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand()) {
            this.ifec = -1;
            this.isymb = -1;
            int n = 0;
            while (n < this.bFEC.length) {
                if (mouseEvent.getSource() == this.bFEC[n]) {
                    this.ifec = n;
                    break;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.bSymb.length) {
                if (mouseEvent.getSource() == this.bSymb[n2]) {
                    this.isymb = n2;
                    break;
                }
                ++n2;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand() && mouseEvent.getModifiers() != 4) {
            if (mouseEvent.getSource() == this.colorButton && (mouseEvent.getModifiers() == 16 || mouseEvent.getModifiers() == 18)) {
                if (this.ecd == null) {
                    this.ecd = new editColorDialog(this.pf, "", true, "", "");
                }
                this.ecd.setTitle(this.Tr.getTr(26));
                this.ecd.setLabels(this.Tr.getTr(85), this.Tr.getTr(84));
                this.ecd.setCopyLabels(this.Tr.getTr(124), this.Tr.getTr(125));
                this.ecd.setColorNames(this.Tr);
                if (mouseEvent.getModifiers() == 16) {
                    this.ecd.setMjaColor(this.colorButton.getTextColor());
                } else {
                    this.ecd.setMjaColor(this.colorButton.getBackColor());
                }
                this.ecd.display();
                if (this.ecd.ok) {
                    if (mouseEvent.getModifiers() == 16) {
                        this.colorButton.setTextColor(this.ecd.getMjaColor());
                    } else {
                        this.colorButton.setBackColor(this.ecd.getMjaColor());
                    }
                    this.EC.insertColors(this.getColorsFromControls());
                    if (!this.EC.segIsMarked()) {
                        this.colorButton.setEnabled(false);
                        this.EC.requestFocus();
                    }
                }
            }
            if (this.isymb >= 0 || this.ifec >= 0) {
                if (!this.dragged) {
                    int n = 0;
                    while (n < this.bFEC.length) {
                        if (mouseEvent.getSource() == this.bFEC[n]) {
                            this.insertNewFormulaItem(n);
                            return;
                        }
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < this.bSymb.length) {
                        if (mouseEvent.getSource() == this.bSymb[n2]) {
                            if (n2 == this.ixOther) {
                                this.openSymbolsDialog(this.bSymb[this.ixOther]);
                            } else {
                                this.EC.insertText(this.bSymb[n2].getLabel());
                                this.EC.requestFocus();
                            }
                            return;
                        }
                        ++n2;
                    }
                } else {
                    Point point = null;
                    if (this.isymb >= 0) {
                        point = this.bSymb[this.isymb].getLocationOnScreen();
                    } else if (this.ifec >= 0) {
                        point = this.bFEC[this.ifec].getLocationOnScreen();
                    }
                    Point point2 = this.EC.getLocationOnScreen();
                    int n = point.x + mouseEvent.getX() - point2.x;
                    int n3 = point.y + mouseEvent.getY() - point2.y;
                    if (0 <= n && n < this.EC.getSize().width && 0 <= n3 && n3 < this.EC.getSize().height) {
                        this.EC.doMousePressed(n, n3);
                        if (this.isymb >= 0) {
                            if (this.isymb != this.ixOther) {
                                this.EC.insertText(this.bSymb[this.isymb].getLabel());
                                this.EC.requestFocus();
                            }
                        } else if (this.ifec >= 0) {
                            this.insertNewFormulaItem(this.ifec);
                        }
                    }
                }
                this.isymb = -1;
                this.ifec = -1;
                this.setCursor(null);
            }
        }
        this.dragged = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand() && mouseEvent.getSource() == this.EC && !this.dragged) {
            this.updateEnabling();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand() && (this.ifec >= 0 || this.isymb >= 0 && this.isymb != this.ixOther)) {
            this.setCursor(Cursor.getPredefinedCursor(13));
            this.dragged = true;
        }
    }
}

