/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.Formula;
import com.mja.text.TColors;
import com.mja.text.TFont;
import com.mja.text.TNode;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Vector;

public class BasicText {
    protected Vector info;
    protected TFont font;
    protected TColors colors = new TColors(Color.white, Color.black);
    protected Parser parser;
    private int initialTNodes;
    private int finalTNodes;
    private int segBegin;
    private int segEnd;
    boolean segMarked;
    static Vector textBuffer;
    private int cursorPos;

    public BasicText(Parser parser) {
        this(parser, null, null, null);
    }

    public BasicText(Parser parser, TFont tFont) {
        this(parser, tFont, null, null);
    }

    public BasicText(Parser parser, TFont tFont, Color color, Color color2) {
        this.parser = parser;
        this.colors = new TColors(color, color2);
        this.font = tFont != null ? tFont : new TFont(new Font("Serif", 0, 24));
        this.info = new Vector();
        this.cursorPos = this.initialTNodes = 0;
        this.info.addElement(new TNode(this, "\u001a"));
        this.finalTNodes = 1;
    }

    public void println() {
        int n = 0;
        while (n < this.info.size()) {
            System.out.print(n + " " + this.TNode(n).toExpresion(true) + ";");
            ++n;
        }
        System.out.println("");
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    Parser getParser() {
        return this.parser;
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.info.size()) {
            TNode tNode = (TNode)this.info.elementAt(n);
            string = string + tNode.toString();
            ++n;
        }
        return string;
    }

    void setInfo(Vector vector) {
        this.info = vector;
    }

    Vector getInfo() {
        return this.info;
    }

    Font getFont() {
        return this.font.getFont();
    }

    TFont getTFont() {
        return this.font;
    }

    TColors getColors() {
        return this.colors;
    }

    TNode TNode(int n) {
        Vector vector = this.info;
        synchronized (vector) {
            TNode tNode = (TNode)this.info.elementAt(n);
            return tNode;
        }
    }

    int getCursorPos() {
        return this.cursorPos;
    }

    void setCursorPos(int n) {
        this.cursorPos = Math.min(n, this.info.size() - 1);
    }

    int indexOf(TNode tNode) {
        int n = this.begin();
        while (n < this.end()) {
            if (tNode == (TNode)this.info.elementAt(n)) {
                return n;
            }
            ++n;
        }
        return this.begin();
    }

    void setCursorPos(TNode tNode) {
        this.setCursorPos(this.indexOf(tNode));
    }

    public int begin() {
        return this.initialTNodes;
    }

    public int end() {
        Vector vector = this.info;
        synchronized (vector) {
            int n = this.info.size() - this.finalTNodes;
            return n;
        }
    }

    int infoSize() {
        return this.info.size();
    }

    int segBegin() {
        return this.segBegin;
    }

    int segEnd() {
        return this.segEnd;
    }

    void setSegment(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        while (n4 - 1 >= this.begin() && !this.TNode(n4 - 1).isChar()) {
            --n4;
        }
        if (n == n3) {
            this.segBegin = n;
            this.segEnd = n4;
        } else {
            this.segBegin = n4;
            this.segEnd = n2;
        }
    }

    boolean segMarked() {
        return this.segMarked;
    }

    public void markSegment(int n, int n2) {
        this.segMarked = true;
        this.setSegment(n, n2);
    }

    void updateSegment() {
        this.setSegment(this.segBegin, this.cursorPos);
    }

    void unmarkSegment() {
        this.segMarked = false;
    }

    int segMin() {
        return Math.min(this.segBegin, this.segEnd);
    }

    int segMax() {
        return Math.max(this.segBegin, this.segEnd);
    }

    int firstLine() {
        return this.firstChar(this.initialTNodes);
    }

    int firstChar(int n) {
        int n2 = n;
        while (n2 < this.end() && !this.TNode(n2).isChar()) {
            ++n2;
        }
        if (n2 == this.end()) {
            return n;
        }
        return n2;
    }

    int firstFormula(int n) {
        int n2 = n;
        while (n2 < this.end() && !this.TNode(n2).isFormula()) {
            ++n2;
        }
        if (n2 == this.end()) {
            return -1;
        }
        return n2;
    }

    boolean afterLastChar(int n) {
        if (this.TNode(n).isChar()) {
            return n == this.end();
        }
        int n2 = n + 1;
        while (n2 < this.end()) {
            if (this.TNode(n2).isChar()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    int startOfLine(int n) {
        int n2 = n;
        while (n2 > this.initialTNodes && !this.TNode(n2 - 1).isEndOfLine()) {
            --n2;
        }
        return this.firstChar(n2);
    }

    int endOfLine(int n) {
        int n2 = n;
        while (n2 < this.end() && !this.TNode(n2).isEndOfLine()) {
            ++n2;
        }
        return n2;
    }

    int nextChar(int n) {
        int n2 = this.firstChar(n);
        if (n2 < this.end()) {
            ++n2;
        }
        return this.firstChar(n2);
    }

    int prevChar(int n) {
        int n2 = n;
        if (n2 > this.initialTNodes) {
            --n2;
        }
        while (n2 > this.initialTNodes && !this.TNode(n2).isChar()) {
            --n2;
        }
        return this.firstChar(n2);
    }

    int nextLine(int n) {
        return this.firstChar(this.startOfLine(this.endOfLine(Math.min(this.end(), this.endOfLine(n) + 1))));
    }

    int previousLine(int n) {
        return this.firstChar(this.startOfLine(Math.max(this.begin(), this.prevChar(this.startOfLine(n)))));
    }

    public void insertString(String string) {
        String string2 = new String(string);
        if (Node.inAlgebraTutor) {
            string2 = BasicStr.replace(string2, "eqn", "#");
            string2 = BasicStr.replace(string2, "eqa", "@");
            string2 = BasicStr.replace(string2, "eqx", "~");
        }
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c != '\r') {
                this.insertChar(c);
            }
            ++n;
        }
    }

    void insertChar(char c) {
        this.insertText(new Character(c).toString());
    }

    void insertText(String string) {
        this.insert(new TNode(this, string), this.cursorPos);
    }

    boolean delete() {
        int n = this.firstChar(this.cursorPos);
        if (n < this.end()) {
            this.remove(n);
            return true;
        }
        return false;
    }

    boolean backSpace() {
        int n = this.prevChar(this.firstChar(this.cursorPos));
        if (n != this.cursorPos && n < this.end()) {
            this.remove(n);
            return true;
        }
        return false;
    }

    void removeMarkedSegment() {
        if (this.segMarked) {
            this.remove(this.segMin(), this.segMax());
            this.segMarked = false;
        }
    }

    void copy() {
        textBuffer = new Vector();
        int n = this.segMax();
        int n2 = this.segMin();
        while (n2 < n) {
            TNode tNode = this.TNode(n2).cloneTNode(this);
            textBuffer.addElement(tNode);
            ++n2;
        }
    }

    void paste() {
        int n = this.cursorPos;
        int n2 = 0;
        while (n2 < textBuffer.size()) {
            this.insert(((TNode)textBuffer.elementAt(n2)).cloneTNode(this), this.cursorPos);
            ++n2;
        }
    }

    private boolean charInSeg(int n) {
        return this.segMarked && this.segMin() <= n && n < this.segMax();
    }

    protected Vector cloneInfo() {
        Vector<TNode> vector = new Vector<TNode>();
        int n = 0;
        while (n < this.info.size()) {
            vector.addElement(((TNode)this.info.elementAt(n)).cloneTNode(this));
            ++n;
        }
        return vector;
    }

    synchronized void insert(TNode tNode, int n) {
        Vector vector = this.info;
        synchronized (vector) {
            this.info.insertElementAt(tNode, n);
        }
        if (n <= this.cursorPos) {
            ++this.cursorPos;
        }
        if (n <= this.segBegin) {
            ++this.segBegin;
        }
        if (n <= this.segEnd) {
            ++this.segEnd;
        }
    }

    synchronized void remove(int n) {
        Vector vector = this.info;
        synchronized (vector) {
            this.info.removeElementAt(n);
        }
        if (n < this.cursorPos) {
            --this.cursorPos;
        }
        if (n < this.segBegin) {
            --this.segBegin;
        }
        if (n < this.segEnd) {
            --this.segEnd;
        }
    }

    void remove(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.remove(n);
            ++n3;
        }
    }

    void clearColors() {
        this.clearColors(this.begin(), this.end());
    }

    void clearColors(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 < n4) {
            if (this.TNode(n3).isColors()) {
                this.remove(n3);
                --n4;
                continue;
            }
            ++n3;
        }
    }

    void clearFonts(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 < n4) {
            if (this.TNode(n3).isTFont()) {
                this.remove(n3);
                --n4;
                continue;
            }
            ++n3;
        }
    }

    FontMetrics getFontMetrics(Component component, TFont tFont) {
        return component.getFontMetrics(tFont.getFont());
    }

    TColors getColorsAtTNode(int n) {
        return this.getColorsAtTNode(n, true);
    }

    TColors getColorsAtTNode(int n, boolean bl) {
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.TNode(n2).isColors()) {
                return this.TNode(n2).getColors();
            }
            --n2;
        }
        if (bl) {
            return this.getColors();
        }
        return null;
    }

    TFont getTFontAtTNode(int n) {
        if (this instanceof Formula) {
            return this.font;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.TNode(n2).isTFont()) {
                return this.TNode(n2).getTFont();
            }
            --n2;
        }
        return this.getTFont();
    }

    void calcValues(int n, boolean bl, int n2, boolean bl2) {
        int n3 = this.begin();
        while (n3 < this.end()) {
            if (this.TNode(n3).isFormula()) {
                this.TNode(n3).getFI().getFormula(0).calcValues(n, bl, n2, bl2);
            }
            ++n3;
        }
    }

    FontMetrics getFontMetricsAtTNode(Component component, int n) {
        return this.getFontMetrics(component, this.getTFontAtTNode(n));
    }

    int getLineAscentAtTNode(Component component, int n) {
        int n2 = this.startOfLine(n);
        TFont tFont = this.getTFontAtTNode(n2);
        int n3 = tFont.getAscent();
        while (!this.TNode(n2).isEndOfLine()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar()) {
                n3 = Math.max(n3, tNode.getAscent(tFont));
            } else if (tNode.isTFont()) {
                tFont = tNode.getTFont();
            }
            ++n2;
        }
        return n3;
    }

    int getLineDescentAtTNode(Component component, int n) {
        int n2 = this.startOfLine(n);
        TFont tFont = this.getTFontAtTNode(n2);
        int n3 = tFont.getDescent();
        while (!this.TNode(n2).isEndOfLine()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar()) {
                n3 = Math.max(n3, tNode.getDescent(tFont));
            } else if (tNode.isTFont()) {
                tFont = tNode.getTFont();
            }
            ++n2;
        }
        return n3;
    }

    int getLineHeightAtTNode(Component component, int n) {
        int n2 = this.getLineAscentAtTNode(component, n);
        int n3 = this.getLineDescentAtTNode(component, n);
        return n2 + n3 + 1;
    }

    int getCharWidthAtTNode(Component component, int n, boolean bl) {
        TNode tNode = this.TNode(n);
        if (tNode.isChar()) {
            FontMetrics fontMetrics = this.getFontMetricsAtTNode(component, n);
            return tNode.getCharWidth(fontMetrics, component, bl);
        }
        return 0;
    }

    int getCharVisualLimitAtTNode(Component component, int n, boolean bl) {
        TNode tNode = this.TNode(n);
        if (tNode.isChar()) {
            FontMetrics fontMetrics = this.getFontMetricsAtTNode(component, n);
            int n2 = tNode.getCharWidth(fontMetrics, component, bl);
            if (tNode.isFormula()) {
                return n2 - (int)Math.round(1.0 * (double)fontMetrics.stringWidth("a") / 3.0);
            }
            return (int)Math.round(2.0 * (double)n2 / 3.0);
        }
        return 0;
    }

    static Color bestBG(Color color) {
        if (color.getRed() + color.getGreen() + color.getBlue() < 382) {
            return Color.white;
        }
        return Color.black;
    }

    static Color bestFG(Color color) {
        if (color.getRed() + color.getGreen() + color.getBlue() < 382) {
            return Color.black;
        }
        return Color.white;
    }
}

