/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.gui.mjaColor;
import com.mja.math.R3;
import com.mja.poly.Face;
import java.awt.Color;

public class viewModel {
    public static final int COLOR = 0;
    public static final int LIGHT = 1;
    public static final int METAL = 2;
    public static final int WIRE = 3;
    private static final float maxI = 0.00390625f;
    private static float[] Int = new float[]{0.4f, 0.5f, 0.3f};
    private static final R3[] Light = new R3[]{new R3(0.5, 0.5, 0.7), new R3(0.5, -0.5, 0.3), new R3(0.2, 0.0, -0.8)};
    private static R3[] light;
    private int model = 0;

    public viewModel(int n) {
        this.model = n;
        if (light == null) {
            light = new R3[Int.length];
            int n2 = 0;
            while (n2 < Int.length) {
                viewModel.light[n2] = Light[n2].ScalarProduct(1.0 / Light[n2].Norm());
                ++n2;
            }
        }
    }

    public int getModel() {
        return this.model;
    }

    Color getFaceColor(Face face) {
        float f;
        float f2;
        float f3;
        Color color = face.getFrontColor();
        if (this.model == 3) {
            return color;
        }
        if (!face.pointsOut) {
            color = face.getBackColor();
        }
        if (this.model == 0) {
            return color;
        }
        R3 r3 = face.unitNormal;
        if (!face.pointsOut) {
            r3 = r3.ScalarProduct(-1.0);
        }
        if (this.model == 1) {
            f3 = 0.4f;
            f2 = 0.9f;
            f = 0.1f;
        } else {
            f3 = 0.5f;
            f2 = 0.1f;
            f = 0.9f;
        }
        int n = 0;
        while (n < light.length) {
            float f4 = Math.max(0.0f, (float)light[n].DotProduct(r3));
            float f5 = Math.max(0.0f, (float)R3.reflectedRay(light[n], r3).DotProduct(face.unitToEye));
            f3 += Int[n] * (f2 * f4 + f * f5 * f5);
            ++n;
        }
        f3 = Math.min(f3 / 256.0f, 0.00390625f);
        return mjaColor.scaleColor(f3, color);
    }
}

