/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.gui.mjaColor;
import com.mja.math.LinearTransformation;
import com.mja.math.R2;
import com.mja.math.R3;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.poly.Face;
import com.mja.poly.Surface;
import com.mja.poly.viewModel;
import com.mja.text.MathText;
import com.mja.util.Attribute;
import com.mja.util.BasicStr;
import java.awt.Color;

public class mjaSurface {
    public static final double oneDegree = Math.PI / 180;
    public boolean split = false;
    public Node cond;
    private Node[] var;
    private Node[] node;
    private Node NNu;
    private Node NNv;
    private Node Ngr;
    private Node Nw;
    private Node Nl;
    private Node Nh;
    private Node X;
    private Node Y;
    private Node Z;
    private Node U;
    private Node V;
    private Node An;
    private Node La;
    private Node Al;
    private mjaColor fc;
    private mjaColor bc;
    private boolean edges;
    private Node[] irN = new Node[3];
    private Node[] ipN = new Node[3];
    private Node[] rN = new Node[3];
    private Node[] pN = new Node[3];
    private viewModel vM;
    private Parser p;
    private int special = 0;
    private R3[] v;
    private Color[] Fc;
    private Color[] Bc;
    private boolean fixed;
    private MathText mt;
    Node[] Vx;
    Node[] Vy;
    Node[] Vz;
    R3[] vertices3D;
    R2[] vertices;
    Node[] VX;
    Node[] VY;

    public mjaSurface(Parser parser, int n, String string, String string2, String string3, String string4, String string5, String string6, mjaColor mjaColor3, mjaColor mjaColor4, boolean bl, String string7, String string8, String string9, String string10, viewModel viewModel2, boolean bl2) {
        this.p = parser;
        this.special = n;
        this.X = parser.Var("x");
        this.Y = parser.Var("y");
        this.Z = parser.Var("z");
        this.An = parser.Var("ancho");
        this.La = parser.Var("largo");
        this.Al = parser.Var("alto");
        this.U = parser.Var("u");
        this.V = parser.Var("v");
        this.setNu(string);
        this.setNv(string2);
        this.Ngr = parser.Analyse(string3, "1");
        this.Nw = parser.Analyse(string4, "2");
        this.Nl = parser.Analyse(string5, "2");
        this.Nh = parser.Analyse(string6, "2");
        this.fc = mjaColor3;
        this.bc = mjaColor4;
        this.fc.analyse(parser);
        this.bc.analyse(parser);
        this.edges = bl;
        String[] stringArray = new String[]{};
        try {
            stringArray = BasicStr.getTokens(string7);
            if (stringArray.length >= 3) {
                int n2 = 0;
                while (n2 < this.irN.length) {
                    this.irN[n2] = parser.Analyse(stringArray[n2], 0.0);
                    ++n2;
                }
            } else {
                this.irN[0] = parser.Analyse("0");
                this.irN[1] = this.irN[0];
                this.irN[2] = this.irN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] stringArray2 = new String[]{};
        try {
            stringArray2 = BasicStr.getTokens(string8);
            if (stringArray2.length >= 3) {
                int n3 = 0;
                while (n3 < this.ipN.length) {
                    this.ipN[n3] = parser.Analyse(stringArray2[n3], 0.0);
                    ++n3;
                }
            } else {
                this.ipN[0] = parser.Analyse("0");
                this.ipN[1] = this.ipN[0];
                this.ipN[2] = this.ipN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] stringArray3 = new String[]{};
        try {
            stringArray3 = BasicStr.getTokens(string9);
            if (stringArray3.length >= 3) {
                int n4 = 0;
                while (n4 < this.rN.length) {
                    this.rN[n4] = parser.Analyse(stringArray3[n4], 0.0);
                    ++n4;
                }
            } else {
                this.rN[0] = parser.Analyse("0");
                this.rN[1] = this.rN[0];
                this.rN[2] = this.rN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] stringArray4 = new String[]{};
        try {
            stringArray4 = BasicStr.getTokens(string10);
            if (stringArray4.length >= 3) {
                int n5 = 0;
                while (n5 < this.pN.length) {
                    this.pN[n5] = parser.Analyse(stringArray4[n5], 0.0);
                    ++n5;
                }
            } else {
                this.pN[0] = parser.Analyse("0");
                this.pN[1] = this.pN[0];
                this.pN[2] = this.pN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vM = viewModel2;
        this.fixed = bl2;
    }

    public void setMathText(MathText mathText) {
        this.mt = mathText;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setEquation(String string) {
        this.special = 0;
        String string2 = BasicStr.replace(string, "\\n", " ");
        Attribute[] attributeArray = Attribute.parse(string2);
        this.var = new Node[attributeArray.length];
        this.node = new Node[attributeArray.length];
        int n = 0;
        while (n < attributeArray.length) {
            this.var[n] = this.p.Var(attributeArray[n].name);
            this.node[n] = this.p.Analyse(attributeArray[n].value);
            ++n;
        }
    }

    public void set3DVertices(String string) {
        this.Vx = new Node[3];
        this.Vy = new Node[3];
        this.Vz = new Node[3];
        int n = 0;
        while (n < 3) {
            this.Vx[n] = this.p.Analyse("0", 0.0);
            this.Vy[n] = this.p.Analyse("0", 0.0);
            this.Vz[n] = this.p.Analyse("0", 0.0);
            ++n;
        }
        try {
            String[] stringArray = BasicStr.getTokens(string);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2 / 3 && n3 < 3) {
                int n4 = 3 * n3;
                if (n4 < stringArray.length) {
                    this.Vx[n3] = this.p.Analyse(stringArray[n4++], 0.0);
                }
                if (n4 < stringArray.length) {
                    this.Vy[n3] = this.p.Analyse(stringArray[n4++], 0.0);
                }
                if (n4 < stringArray.length) {
                    this.Vz[n3] = this.p.Analyse(stringArray[n4++], 0.0);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.calculate3DVertices();
    }

    private void calculate3DVertices() {
        this.vertices3D = new R3[this.Vx.length];
        int n = 0;
        while (n < this.Vx.length) {
            this.vertices3D[n] = new R3(this.Vx[n].Evaluate(0.0), this.Vy[n].Evaluate(0.0), this.Vz[n].Evaluate(0.0));
            ++n;
        }
    }

    public void setVertices(String string) {
        this.VX = new Node[0];
        this.VY = new Node[0];
        try {
            String[] stringArray = BasicStr.getTokens(string);
            int n = stringArray.length;
            if (n % 2 != 0) {
                --n;
            }
            if (n > 0) {
                this.VX = new Node[n /= 2];
                this.VY = new Node[n];
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[2 * n2];
                    String string3 = stringArray[2 * n2 + 1];
                    this.VX[n2] = this.p.Analyse(string2, 0.0);
                    this.VY[n2] = this.p.Analyse(string3, 0.0);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.calculateVertices();
    }

    private void calculateVertices() {
        this.vertices = new R2[this.VX.length];
        int n = 0;
        while (n < this.VX.length) {
            double d = this.VX[n].Evaluate(0.0);
            double d2 = this.VY[n].Evaluate(0.0);
            this.vertices[n] = new R2(d, d2);
            ++n;
        }
    }

    public void setNu(String string) {
        this.NNu = this.p.Analyse(string, "7");
    }

    public void setNv(String string) {
        this.NNv = this.p.Analyse(string, "7");
    }

    public Surface create() {
        Object object;
        Object object2;
        Surface surface = null;
        Node node = this.An;
        synchronized (node) {
            object2 = this.La;
            synchronized (object2) {
                object = this.Al;
                synchronized (object) {
                    double d = this.An.r;
                    double d2 = this.La.r;
                    double d3 = this.Al.r;
                    this.An.r = this.Nw.Evaluate(2.0);
                    this.La.r = this.Nl.Evaluate(2.0);
                    this.Al.r = this.Nh.Evaluate(2.0);
                    if (this.special > 0) {
                        double d4 = this.An.r / 2.0;
                        double d5 = this.La.r / 2.0;
                        double d6 = this.Al.r / 2.0;
                        switch (this.special) {
                            case 5: {
                                this.calculate3DVertices();
                                surface = mjaSurface.getFace(this.vertices3D);
                                break;
                            }
                            case 6: {
                                this.calculateVertices();
                                surface = mjaSurface.getFace(this.vertices);
                                break;
                            }
                            case 8: {
                                surface = mjaSurface.getBox(d4, d5, d6);
                                break;
                            }
                            case 11: {
                                surface = mjaSurface.getRegularTetrahedron(d4);
                                break;
                            }
                            case 12: {
                                double d7 = d4 / Math.sqrt(3.0);
                                surface = mjaSurface.getBox(d7, d7, d7);
                                break;
                            }
                            case 13: {
                                surface = mjaSurface.getRegularOctahedron(d4);
                                break;
                            }
                            case 14: {
                                surface = mjaSurface.getRegularDodecahedron(d4);
                                break;
                            }
                            case 15: {
                                surface = mjaSurface.getRegularIcosahedron(d4);
                            }
                        }
                        surface.setFrontColor(this.fc.getAdaptedColor());
                        surface.setBackColor(this.bc.getAdaptedColor());
                    } else {
                        int n = (int)Math.round(this.NNu.Evaluate(7.0));
                        int n2 = (int)Math.round(this.NNv.Evaluate(7.0));
                        this.calculateVerticesAndColors(n, n2, this.var, this.node);
                        surface = this.makeSurface(n, n2, (int)Math.round(this.Ngr.Evaluate(1.0)));
                    }
                    this.An.r = d;
                    this.La.r = d2;
                    this.Al.r = d3;
                }
            }
        }
        if (surface != null) {
            surface.setDrawEdges(this.edges);
            object2 = new R3(Math.PI / 180 * this.irN[0].Evaluate(0.0), Math.PI / 180 * this.irN[1].Evaluate(0.0), Math.PI / 180 * this.irN[2].Evaluate(0.0));
            object = new R3(this.ipN[0].Evaluate(0.0), this.ipN[1].Evaluate(0.0), this.ipN[2].Evaluate(0.0));
            surface.apply(LinearTransformation.RigidMotion((R3)object2, (R3)object));
            R3 r3 = new R3(Math.PI / 180 * this.rN[0].Evaluate(0.0), Math.PI / 180 * this.rN[1].Evaluate(0.0), Math.PI / 180 * this.rN[2].Evaluate(0.0));
            R3 r32 = new R3(this.pN[0].Evaluate(0.0), this.pN[1].Evaluate(0.0), this.pN[2].Evaluate(0.0));
            surface.apply(LinearTransformation.RigidMotion(r3, r32));
            surface.fixAsInitialPosition();
            surface.setViewModel(this.vM);
        }
        surface.setMathText(this.mt);
        return surface;
    }

    private Surface makeSurface(int n, int n2, int n3) {
        Face[] faceArray = null;
        if (n2 == 0) {
            if (n == 0) {
                faceArray = new Face[]{new Face(this.v[0])};
                faceArray[0].setFrontColor(this.Fc[0]);
                faceArray[0].setBackColor(this.Bc[0]);
                faceArray[0].setWidthness(n3);
            } else {
                faceArray = new Face[n];
                int n4 = 0;
                while (n4 < n) {
                    faceArray[n4] = new Face(this.v[n4], this.v[n4 + 1]);
                    faceArray[n4].setFrontColor(this.Fc[n4]);
                    faceArray[n4].setBackColor(this.Bc[n4]);
                    faceArray[n4].setWidthness(n3);
                    ++n4;
                }
            }
        } else {
            faceArray = new Face[n * n2];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    faceArray[n6 + n * n5] = new Face(this.v[n6 + n5 * (n + 1)], this.v[n6 + 1 + n5 * (n + 1)], this.v[n6 + 1 + (n5 + 1) * (n + 1)], this.v[n6 + (n5 + 1) * (n + 1)]);
                    faceArray[n6 + n * n5].setFrontColor(this.Fc[n6 + n5 * (n + 1)]);
                    faceArray[n6 + n * n5].setBackColor(this.Bc[n6 + n5 * (n + 1)]);
                    ++n6;
                }
                ++n5;
            }
        }
        return new Surface(faceArray);
    }

    private void calculateVerticesAndColors(int n, int n2, Node[] nodeArray, Node[] nodeArray2) {
        this.v = new R3[(n + 1) * (n2 + 1)];
        this.Fc = new Color[(n + 1) * (n2 + 1)];
        this.Bc = new Color[(n + 1) * (n2 + 1)];
        Node node = this.X;
        synchronized (node) {
            Node node2 = this.Y;
            synchronized (node2) {
                Node node3 = this.Z;
                synchronized (node3) {
                    Node node4 = this.U;
                    synchronized (node4) {
                        Node node5 = this.V;
                        synchronized (node5) {
                            int n3;
                            double d = this.X.r;
                            double d2 = this.Y.r;
                            double d3 = this.Z.r;
                            double d4 = this.U.r;
                            double d5 = this.V.r;
                            double[] dArray = new double[nodeArray2.length];
                            int n4 = 0;
                            while (n4 < nodeArray2.length) {
                                dArray[n4] = nodeArray[n4].r;
                                ++n4;
                            }
                            double d6 = 1.0 / (double)n;
                            double d7 = 1.0 / (double)n2;
                            int n5 = 0;
                            this.V.r = 0.0;
                            int n6 = 0;
                            while (n6 <= n2) {
                                this.U.r = 0.0;
                                n3 = 0;
                                while (n3 <= n) {
                                    try {
                                        int n7 = 0;
                                        while (n7 < nodeArray2.length) {
                                            nodeArray[n7].r = nodeArray2[n7].Evaluate();
                                            ++n7;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.Fc[n5] = this.fc.getAdaptedColor();
                                    this.Bc[n5] = this.bc.getAdaptedColor();
                                    this.v[n5++] = new R3(this.X.r, this.Y.r, this.Z.r);
                                    this.U.r += d6;
                                    ++n3;
                                }
                                this.V.r += d7;
                                ++n6;
                            }
                            n3 = 0;
                            while (n3 < nodeArray2.length) {
                                nodeArray[n3].r = dArray[n3];
                                ++n3;
                            }
                            this.X.r = d;
                            this.Y.r = d2;
                            this.Z.r = d3;
                            this.U.r = d4;
                            this.V.r = d5;
                        }
                    }
                }
            }
        }
    }

    private static final Surface getFace(R2[] r2Array) {
        Face[] faceArray = new Face[]{r2Array != null && r2Array.length >= 3 ? new Face(r2Array) : new Face(new R3(-1.0, -1.0, 0.0), new R3(-1.0, 1.0, 0.0), new R3(1.0, 1.0, 0.0), new R3(1.0, -1.0, 0.0))};
        return new Surface(faceArray);
    }

    private static final Surface getFace(R3[] r3Array) {
        Face[] faceArray = new Face[]{r3Array != null && r3Array.length == 3 ? new Face(r3Array) : new Face(new R3(1.0, 0.0, 0.0), new R3(0.0, 1.0, 0.0), new R3(0.0, 0.0, 1.0))};
        return new Surface(faceArray);
    }

    private static final Surface getBox(double d, double d2, double d3) {
        R3[] r3Array = new R3[]{new R3(d, d2, d3), new R3(d, -d2, d3), new R3(-d, -d2, d3), new R3(-d, d2, d3), new R3(d, d2, -d3), new R3(d, -d2, -d3), new R3(-d, -d2, -d3), new R3(-d, d2, -d3)};
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[3], r3Array[2], r3Array[1]), new Face(r3Array[0], r3Array[1], r3Array[5], r3Array[4]), new Face(r3Array[1], r3Array[2], r3Array[6], r3Array[5]), new Face(r3Array[2], r3Array[3], r3Array[7], r3Array[6]), new Face(r3Array[3], r3Array[0], r3Array[4], r3Array[7]), new Face(r3Array[7], r3Array[4], r3Array[5], r3Array[6])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularTetrahedron(double d) {
        R3[] r3Array;
        r3Array = new R3[]{new R3(0.0, 0.0, d), new R3(d * 2.0 * Math.sqrt(2.0) / 3.0, 0.0, -d * 1.0 / 3.0), r3Array[1].RotZ(2.0943951023931953), r3Array[2].RotZ(2.0943951023931953)};
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2]), new Face(r3Array[1], r3Array[3], r3Array[2]), new Face(r3Array[0], r3Array[2], r3Array[3]), new Face(r3Array[0], r3Array[3], r3Array[1])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularOctahedron(double d) {
        R3[] r3Array = new R3[]{new R3(0.0, 0.0, d), new R3(d, 0.0, 0.0), new R3(0.0, d, 0.0), new R3(-d, 0.0, 0.0), new R3(0.0, -d, 0.0), new R3(0.0, 0.0, -d)};
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2]), new Face(r3Array[0], r3Array[2], r3Array[3]), new Face(r3Array[0], r3Array[3], r3Array[4]), new Face(r3Array[0], r3Array[4], r3Array[1]), new Face(r3Array[5], r3Array[2], r3Array[1]), new Face(r3Array[5], r3Array[3], r3Array[2]), new Face(r3Array[5], r3Array[4], r3Array[3]), new Face(r3Array[5], r3Array[1], r3Array[4])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularDodecahedron(double d) {
        R3[] r3Array = new R3[20];
        R3 r3 = new R3(0.0, 0.0, d);
        double d2 = 4.0 / (Math.sqrt(3.0) * (Math.sqrt(5.0) + 1.0));
        double d3 = 1.2566370614359172;
        double d4 = 1.0 - Math.cos(d3);
        d4 = d4 * d4 + Math.sin(d3) * Math.sin(d3);
        double d5 = Math.asin(d2 / Math.sqrt(d4));
        double d6 = 2.0 * Math.asin(Math.sin(0.6283185307179586) * Math.sin(d5));
        r3Array[0] = r3.RotY(d5);
        r3Array[1] = r3Array[0].RotZ(d3);
        r3Array[2] = r3Array[1].RotZ(d3);
        r3Array[3] = r3Array[2].RotZ(d3);
        r3Array[4] = r3Array[3].RotZ(d3);
        r3Array[5] = r3Array[0].RotY(d6);
        r3Array[6] = r3Array[5].RotZ(d3);
        r3Array[7] = r3Array[6].RotZ(d3);
        r3Array[8] = r3Array[7].RotZ(d3);
        r3Array[9] = r3Array[8].RotZ(d3);
        r3Array[10] = r3Array[0].Negative();
        r3Array[11] = r3Array[1].Negative();
        r3Array[12] = r3Array[2].Negative();
        r3Array[13] = r3Array[3].Negative();
        r3Array[14] = r3Array[4].Negative();
        r3Array[15] = r3Array[5].Negative();
        r3Array[16] = r3Array[6].Negative();
        r3Array[17] = r3Array[7].Negative();
        r3Array[18] = r3Array[8].Negative();
        r3Array[19] = r3Array[9].Negative();
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2], r3Array[3], r3Array[4]), new Face(r3Array[0], r3Array[5], r3Array[18], r3Array[6], r3Array[1]), new Face(r3Array[1], r3Array[6], r3Array[19], r3Array[7], r3Array[2]), new Face(r3Array[2], r3Array[7], r3Array[15], r3Array[8], r3Array[3]), new Face(r3Array[3], r3Array[8], r3Array[16], r3Array[9], r3Array[4]), new Face(r3Array[4], r3Array[9], r3Array[17], r3Array[5], r3Array[0]), new Face(r3Array[14], r3Array[13], r3Array[12], r3Array[11], r3Array[10]), new Face(r3Array[11], r3Array[16], r3Array[8], r3Array[15], r3Array[10]), new Face(r3Array[12], r3Array[17], r3Array[9], r3Array[16], r3Array[11]), new Face(r3Array[13], r3Array[18], r3Array[5], r3Array[17], r3Array[12]), new Face(r3Array[14], r3Array[19], r3Array[6], r3Array[18], r3Array[13]), new Face(r3Array[10], r3Array[15], r3Array[7], r3Array[19], r3Array[14])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularIcosahedron(double d) {
        R3[] r3Array = new R3[12];
        r3Array[0] = new R3(0.0, 0.0, d);
        double d2 = 2.0 * Math.sqrt(2.0) / Math.sqrt(5.0 + Math.sqrt(5.0));
        double d3 = 2.0 * Math.asin(d2 / 2.0);
        double d4 = 1.2566370614359172;
        r3Array[1] = r3Array[0].RotY(d3);
        r3Array[2] = r3Array[1].RotZ(d4);
        r3Array[3] = r3Array[2].RotZ(d4);
        r3Array[4] = r3Array[3].RotZ(d4);
        r3Array[5] = r3Array[4].RotZ(d4);
        r3Array[6] = r3Array[1].Negative();
        r3Array[7] = r3Array[2].Negative();
        r3Array[8] = r3Array[3].Negative();
        r3Array[9] = r3Array[4].Negative();
        r3Array[10] = r3Array[5].Negative();
        r3Array[11] = r3Array[0].Negative();
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2]), new Face(r3Array[0], r3Array[2], r3Array[3]), new Face(r3Array[0], r3Array[3], r3Array[4]), new Face(r3Array[0], r3Array[4], r3Array[5]), new Face(r3Array[0], r3Array[5], r3Array[1]), new Face(r3Array[1], r3Array[9], r3Array[2]), new Face(r3Array[2], r3Array[10], r3Array[3]), new Face(r3Array[3], r3Array[6], r3Array[4]), new Face(r3Array[4], r3Array[7], r3Array[5]), new Face(r3Array[5], r3Array[8], r3Array[1]), new Face(r3Array[6], r3Array[7], r3Array[4]), new Face(r3Array[7], r3Array[8], r3Array[5]), new Face(r3Array[8], r3Array[9], r3Array[1]), new Face(r3Array[9], r3Array[10], r3Array[2]), new Face(r3Array[10], r3Array[6], r3Array[3]), new Face(r3Array[11], r3Array[10], r3Array[9]), new Face(r3Array[11], r3Array[9], r3Array[8]), new Face(r3Array[11], r3Array[8], r3Array[7]), new Face(r3Array[11], r3Array[7], r3Array[6]), new Face(r3Array[11], r3Array[6], r3Array[10])};
        return new Surface(faceArray);
    }
}

