/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.math.LinearTransformation;
import com.mja.math.R3;
import com.mja.poly.Face;
import com.mja.poly.viewModel;
import com.mja.poly.viewR3;
import com.mja.text.MathText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class Surface {
    private Face[] face;
    private Face[] ordface;
    private R3[] vertex;
    private R3[] vertex0;

    public Surface(Face[] faceArray) {
        int n;
        Vector<R3> vector = new Vector<R3>();
        int n2 = 0;
        while (n2 < faceArray.length) {
            int n3 = 0;
            while (n3 < faceArray[n2].P.length) {
                if (!vector.contains(faceArray[n2].P[n3])) {
                    n = 1;
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        R3 r3 = (R3)enumeration.nextElement();
                        if (!(r3.Subtract(faceArray[n2].P[n3]).Norm() < 1.0E-8)) continue;
                        n = 0;
                        faceArray[n2].P[n3] = r3;
                        break;
                    }
                    if (n != 0) {
                        vector.addElement(faceArray[n2].P[n3]);
                    }
                }
                ++n3;
            }
            ++n2;
        }
        this.vertex = new R3[vector.size()];
        this.vertex0 = new R3[this.vertex.length];
        Enumeration enumeration = vector.elements();
        n = 0;
        while (n < this.vertex.length) {
            this.vertex[n] = (R3)enumeration.nextElement();
            this.vertex0[n] = this.vertex[n].cloneR3();
            ++n;
        }
        this.face = faceArray;
        this.ordface = new Face[this.face.length];
        int n4 = 0;
        while (n4 < this.face.length) {
            this.ordface[n4] = this.face[n4];
            ++n4;
        }
    }

    private Surface() {
    }

    public Surface cloneSurface() {
        Face[] faceArray = new Face[this.face.length];
        int n = 0;
        while (n < faceArray.length) {
            faceArray[n] = this.face[n].cloneFace();
            ++n;
        }
        Surface surface = new Surface(faceArray);
        return surface;
    }

    void setMathText(MathText mathText) {
        if (mathText != null) {
            int n = 0;
            while (n < this.face.length) {
                this.face[n].setMathText(mathText);
                ++n;
            }
        }
    }

    public int countFaces() {
        return this.face.length;
    }

    public int countVertices() {
        return this.vertex.length;
    }

    public void fixAsInitialPosition() {
        int n = 0;
        while (n < this.vertex.length) {
            this.vertex0[n].x = this.vertex[n].x;
            this.vertex0[n].y = this.vertex[n].y;
            this.vertex0[n].z = this.vertex[n].z;
            ++n;
        }
    }

    public void resetInitialPosition() {
        int n = 0;
        while (n < this.vertex0.length) {
            this.vertex[n].x = this.vertex0[n].x;
            this.vertex[n].y = this.vertex0[n].y;
            this.vertex[n].z = this.vertex0[n].z;
            ++n;
        }
    }

    public void apply(LinearTransformation linearTransformation) {
        int n = 0;
        while (n < this.vertex.length) {
            linearTransformation.Apply(this.vertex[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.face.length) {
            this.face[n2].calculateUnitNormal();
            ++n2;
        }
    }

    public void updateView(viewR3 viewR32) {
        int n = 0;
        while (n < this.face.length) {
            this.face[n].updateView(viewR32);
            ++n;
        }
    }

    public void setViewModel(viewModel viewModel2) {
        int n = 0;
        while (n < this.face.length) {
            this.face[n].setViewModel(viewModel2);
            ++n;
        }
    }

    void setFrontColor(Color color) {
        int n = 0;
        while (n < this.face.length) {
            this.face[n].setFrontColor(color);
            ++n;
        }
    }

    void setEdgeColor(Color color) {
        int n = 0;
        while (n < this.face.length) {
            this.face[n].setEdgeColor(color);
            ++n;
        }
    }

    void setBackColor(Color color) {
        int n = 0;
        while (n < this.face.length) {
            this.face[n].setBackColor(color);
            ++n;
        }
    }

    public void setDrawEdges(boolean bl) {
        int n = 0;
        while (n < this.face.length) {
            this.face[n].setDrawEdges(bl);
            ++n;
        }
    }

    public static Surface add(Surface surface, Surface surface2) {
        if (surface == null) {
            return surface2;
        }
        if (surface2 == null) {
            return surface;
        }
        return Surface.add(surface, surface2.face);
    }

    public static Surface add(Surface surface, Face[] faceArray) {
        if (surface == null) {
            return new Surface(faceArray);
        }
        if (faceArray == null) {
            return surface;
        }
        Face[] faceArray2 = new Face[surface.face.length + faceArray.length];
        int n = 0;
        while (n < surface.face.length) {
            faceArray2[n] = surface.face[n++];
        }
        int n2 = 0;
        while (n2 < faceArray.length) {
            faceArray2[n++] = faceArray[n2++];
        }
        return new Surface(faceArray2);
    }

    public Surface split(Surface surface) {
        int n = 0;
        while (n < this.face.length) {
            Face[] faceArray;
            Vector<Face> vector = new Vector<Face>();
            int n2 = 0;
            while (n2 < surface.face.length) {
                faceArray = this.face[n].split(surface.face[n2]);
                int n3 = 0;
                while (n3 < faceArray.length) {
                    vector.addElement(faceArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            faceArray = new Face[vector.size()];
            Enumeration enumeration = vector.elements();
            int n4 = 0;
            while (n4 < faceArray.length) {
                faceArray[n4] = (Face)enumeration.nextElement();
                ++n4;
            }
            surface = new Surface(faceArray);
            ++n;
        }
        return surface;
    }

    public void sortAndPaint(Component component, Graphics graphics) {
        this.sort();
        int n = 0;
        while (n < this.face.length) {
            this.ordface[n].draw(component, graphics);
            ++n;
        }
    }

    void sort() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i < this.face.length; ++i) {
            if (this.LTHOE(i - 1, i)) continue;
            if (!this.LTHOE(0, i)) {
                this.INSERT(i, 0);
                continue;
            }
            n = 0;
            n2 = i - 1;
            while (true) {
                if (n > n2) break;
                n3 = (n + n2) / 2;
                if (this.LTHOE(n3, i)) {
                    n = n3 + 1;
                    continue;
                }
                n2 = n3 - 1;
            }
            n3 = n;
            this.INSERT(i, n3);
        }
    }

    void INSERT(int n, int n2) {
        Face face = this.ordface[n];
        System.arraycopy(this.ordface, n2, this.ordface, n2 + 1, n - n2);
        this.ordface[n2] = face;
    }

    boolean LTHOE(int n, int n2) {
        if (n2 >= this.face.length) {
            return true;
        }
        return this.ordface[n2].isCloserThan(this.ordface[n]);
    }

    public void painterAlgorithm(Component component, Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.face.length) {
            this.face[n3].facesInFront = new Vector();
            this.face[n3].drawn = false;
            this.face[n3].countFacesBehind = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.face.length) {
            n2 = 0;
            while (n2 < n4) {
                n = this.face[n2].inFrontOf(this.face[n4]);
                if (n > 0) {
                    ++this.face[n2].countFacesBehind;
                    this.face[n4].facesInFront.addElement(this.face[n2]);
                } else if (n < 0) {
                    ++this.face[n4].countFacesBehind;
                    this.face[n2].facesInFront.addElement(this.face[n4]);
                }
                ++n2;
            }
            ++n4;
        }
        n2 = 0;
        n = 0;
        while (true) {
            Face face;
            Enumeration enumeration;
            boolean bl = true;
            Vector<Face> vector = new Vector<Face>();
            int n5 = 0;
            while (n5 < this.face.length) {
                if (!this.face[n5].drawn) {
                    if (this.face[n5].countFacesBehind <= n) {
                        this.face[n5].draw(component, graphics);
                        this.face[n5].drawn = true;
                        enumeration = this.face[n5].facesInFront.elements();
                        while (enumeration.hasMoreElements()) {
                            face = (Face)enumeration.nextElement();
                            vector.addElement(face);
                        }
                    } else {
                        bl = false;
                    }
                }
                ++n5;
            }
            if (vector.size() == 0) {
                if (bl) break;
                ++n;
                continue;
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                face = (Face)enumeration.nextElement();
                --face.countFacesBehind;
            }
            n = 0;
        }
    }

    public void rayTrace(Component component, Graphics graphics, int n, int n2) {
        this.refine(graphics, 0, 0, n, n2, 64);
        int n3 = 0;
        while (n3 < this.face.length) {
            this.face[n3].drawText(component, graphics);
            ++n3;
        }
    }

    private void refine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 < 4) {
            n5 = 1;
        }
        int n6 = n2;
        while (n6 < n2 + n4) {
            int n7 = n;
            while (n7 < n + n3) {
                if (this.touches(n7, n6, n5)) {
                    if (n5 == 1 || this.isAtom(n7, n6, n5)) {
                        double d = Double.MAX_VALUE;
                        int n8 = -1;
                        int n9 = 0;
                        while (n9 < this.face.length) {
                            double d2;
                            if (this.face[n9].contains(n7, n6, n5) && (d2 = this.face[n9].intersectionToEye(n7, n6)) < d) {
                                d = d2;
                                n8 = n9;
                            }
                            ++n9;
                        }
                        if (n8 >= 0) {
                            graphics.setColor(this.face[n8].getColorAt(n7, n6, n5 == 1));
                            graphics.fillRect(n7, n6, n5, n5);
                        }
                    } else {
                        this.refine(graphics, n7, n6, n5, n5, n5 / 2);
                    }
                }
                n7 += n5;
            }
            n6 += n5;
        }
    }

    private boolean touches(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.face.length) {
            if (this.face[n4].touches(n, n2, n3)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private boolean isAtom(int n, int n2, int n3) {
        boolean[] blArray = new boolean[this.face.length];
        int n4 = 0;
        while (n4 < this.face.length) {
            blArray[n4] = this.face[n4].contains(n, n2, n3);
            if (blArray[n4] ? this.face[n4].getDrawEdges() && (this.face[n4].isOnEdge(n, n2) || this.face[n4].isOnEdge(n + n3 - 1, n2) || this.face[n4].isOnEdge(n, n2 + n3 - 1) || this.face[n4].isOnEdge(n + n3 - 1, n2 + n3 - 1)) : this.face[n4].touches(n, n2, n3)) {
                return false;
            }
            ++n4;
        }
        double[] dArray = new double[this.face.length];
        double[] dArray2 = new double[this.face.length];
        int n5 = 0;
        while (n5 < this.face.length) {
            if (blArray[n5]) {
                double d = this.face[n5].intersectionToEye(n, n2);
                double d2 = this.face[n5].intersectionToEye(n + n3 - 1, n2);
                double d3 = this.face[n5].intersectionToEye(n, n2 + n3 - 1);
                double d4 = this.face[n5].intersectionToEye(n + n3 - 1, n2 + n3 - 1);
                dArray[n5] = Math.min(d, Math.min(d2, Math.min(d3, d4)));
                dArray2[n5] = Math.max(d, Math.max(d2, Math.max(d3, d4)));
                int n6 = 0;
                while (n6 < n5) {
                    if (blArray[n6] && (dArray[n5] <= dArray[n6] && dArray[n6] <= dArray2[n5] || dArray[n5] <= dArray2[n6] && dArray2[n6] <= dArray2[n5] || dArray[n6] <= dArray[n5] && dArray[n5] <= dArray2[n6] || dArray[n6] <= dArray2[n5] && dArray2[n5] <= dArray2[n6])) {
                        return false;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return true;
    }
}

