/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.math.R2;
import com.mja.math.R3;
import com.mja.poly.Face2;
import com.mja.poly.viewModel;
import com.mja.poly.viewR3;
import com.mja.text.MathText;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.Enumeration;
import java.util.Vector;

public class Face {
    public static final viewModel colorModel = new viewModel(0);
    public static final viewModel lightModel = new viewModel(1);
    public static final viewModel metalModel = new viewModel(2);
    public static final viewModel wireModel = new viewModel(3);
    static final R3 Ux = new R3(1.0, 0.0, 0.0);
    static final R3 Uy = new R3(0.0, 1.0, 0.0);
    static final R3 Uz = new R3(0.0, 0.0, 1.0);
    static final double epsilon = 1.0E-8;
    R3[] P;
    boolean pointsOut;
    R3 unitToEye = new R3(0.0, 0.0, 0.0);
    R3 unitNormal = new R3(0.0, 0.0, 0.0);
    int countFacesBehind;
    Vector facesInFront;
    boolean drawn;
    private Color FC = Color.white;
    private Color BC = Color.pink;
    private Color EC = Color.gray;
    private boolean drawEdges = false;
    private viewModel vM = colorModel;
    private viewR3 view;
    private int widthness = 1;
    private Polygon poly;
    private R2[] pr;
    private int minx;
    private int miny;
    private int maxx;
    private int maxy;
    private double normalToEye;
    private double aveDistanceToEye;
    private double minDistanceToEye;
    private double maxDistanceToEye;
    private MathText mt;

    public Face cloneFace() {
        R3[] r3Array = new R3[this.P.length];
        int n = 0;
        while (n < this.P.length) {
            r3Array[n] = this.P[n].cloneR3();
            ++n;
        }
        Face face = new Face(r3Array);
        face.init();
        face.FC = this.FC;
        face.BC = this.BC;
        face.EC = this.EC;
        face.drawEdges = this.drawEdges;
        face.vM = this.vM;
        face.mt = this.mt;
        return face;
    }

    public Face(R3[] r3Array) {
        this.P = r3Array;
        this.init();
    }

    public Face(R3 r3) {
        this.P = new R3[1];
        this.P[0] = r3;
        this.init();
    }

    public Face(R3 r3, R3 r32) {
        this.P = new R3[2];
        this.P[0] = r3;
        this.P[1] = r32;
        this.init();
    }

    public Face(R3 r3, R3 r32, R3 r33) {
        this.P = new R3[3];
        this.P[0] = r3;
        this.P[1] = r32;
        this.P[2] = r33;
        this.init();
    }

    public Face(R3 r3, R3 r32, R3 r33, R3 r34) {
        this.P = new R3[4];
        this.P[0] = r3;
        this.P[1] = r32;
        this.P[2] = r33;
        this.P[3] = r34;
        this.init();
    }

    public Face(R3 r3, R3 r32, R3 r33, R3 r34, R3 r35) {
        this.P = new R3[5];
        this.P[0] = r3;
        this.P[1] = r32;
        this.P[2] = r33;
        this.P[3] = r34;
        this.P[4] = r35;
        this.init();
    }

    public Face(R2[] r2Array) {
        this.P = new R3[r2Array.length];
        int n = 0;
        while (n < this.P.length) {
            this.P[n] = new R3(r2Array[n].x, r2Array[n].y, 0.0);
            ++n;
        }
        this.init();
    }

    void setMathText(MathText mathText) {
        this.mt = mathText;
    }

    public void setWidthness(int n) {
        this.widthness = n;
    }

    public void setViewModel(viewModel viewModel2) {
        this.vM = viewModel2;
    }

    public void setFrontColor(Color color) {
        this.FC = color;
    }

    public void setEdgeColor(Color color) {
        this.EC = color;
    }

    public void setBackColor(Color color) {
        this.BC = color;
    }

    public Color getEdgeColor() {
        return this.EC;
    }

    public Color getFrontColor() {
        return this.FC;
    }

    public Color getBackColor() {
        return this.BC;
    }

    public void setDrawEdges(boolean bl) {
        this.drawEdges = bl;
    }

    public boolean getDrawEdges() {
        return this.drawEdges;
    }

    public double getArea() {
        double d = 0.0;
        int n = 1;
        while (n < this.P.length - 1) {
            d += this.P[0].Subtract(this.P[n]).CrossProduct(this.P[0].Subtract(this.P[n + 1])).Norm() / 2.0;
            ++n;
        }
        return d;
    }

    private void init() {
        Vector<R3> vector = new Vector<R3>();
        int n = 0;
        while (n < this.P.length) {
            if (!vector.contains(this.P[n])) {
                boolean bl = true;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    R3 r3 = (R3)enumeration.nextElement();
                    if (!(r3.Subtract(this.P[n]).Norm() < 1.0E-8)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    vector.addElement(this.P[n]);
                }
            }
            ++n;
        }
        this.P = new R3[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (n2 < this.P.length) {
            this.P[n2] = (R3)enumeration.nextElement();
            ++n2;
        }
        this.calculateUnitNormal();
    }

    void calculateUnitNormal() {
        if (this.P.length == 1) {
            this.unitNormal = Ux;
        } else if (this.P.length == 2) {
            R3 r3 = this.P[1].Subtract(this.P[0]);
            R3 r32 = Ux.CrossProduct(r3);
            this.unitNormal = r3.CrossProduct(r32);
        } else {
            this.unitNormal = new R3(0.0, 0.0, 0.0);
            int n = 0;
            while (n < this.P.length - 2) {
                R3 r3 = this.P[n + 1].Subtract(this.P[0]);
                R3 r33 = this.P[n + 2].Subtract(this.P[0]);
                this.unitNormal = this.unitNormal.Add(r3.CrossProduct(r33));
                ++n;
            }
        }
        double d = this.unitNormal.Norm();
        this.unitNormal = d != 0.0 ? this.unitNormal.ScalarProduct(1.0 / d) : Ux;
    }

    void updateView(viewR3 viewR32) {
        this.view = viewR32;
        this.minx = Integer.MAX_VALUE;
        this.miny = Integer.MAX_VALUE;
        this.maxx = -2147483647;
        this.maxy = -2147483647;
        this.pr = new R2[this.P.length + 1];
        this.poly = new Polygon();
        int n = 0;
        while (n < this.P.length) {
            this.pr[n] = this.view.pr(this.P[n]);
            this.poly.addPoint((int)Math.round(this.pr[n].x), (int)Math.round(this.pr[n].y));
            if (this.minx > this.poly.xpoints[n]) {
                this.minx = this.poly.xpoints[n];
            }
            if (this.maxx < this.poly.xpoints[n]) {
                this.maxx = this.poly.xpoints[n];
            }
            if (this.miny > this.poly.ypoints[n]) {
                this.miny = this.poly.ypoints[n];
            }
            if (this.maxy < this.poly.ypoints[n]) {
                this.maxy = this.poly.ypoints[n];
            }
            ++n;
        }
        this.pr[this.P.length] = this.pr[0];
        this.poly.addPoint(this.poly.xpoints[0], this.poly.ypoints[0]);
        this.minDistanceToEye = Double.MAX_VALUE;
        this.maxDistanceToEye = -1.7976931348623157E308;
        int n2 = 0;
        while (n2 < this.P.length) {
            double d = this.P[n2].Subtract(this.view.Eye).Norm();
            this.minDistanceToEye = Math.min(this.minDistanceToEye, d);
            this.maxDistanceToEye = Math.max(this.maxDistanceToEye, d);
            ++n2;
        }
        R3 r3 = new R3(this.P[0].x, this.P[0].y, this.P[0].z);
        int n3 = 1;
        while (n3 < this.P.length) {
            r3.x += this.P[n3].x;
            r3.y += this.P[n3].y;
            r3.z += this.P[n3].z;
            ++n3;
        }
        r3.x /= (double)this.P.length;
        r3.y /= (double)this.P.length;
        r3.z /= (double)this.P.length;
        R3 r32 = this.view.Eye.Subtract(r3);
        this.aveDistanceToEye = r32.Norm();
        this.unitToEye = r32.ScalarProduct(1.0 / this.aveDistanceToEye);
        this.pointsOut = this.unitToEye.DotProduct(this.unitNormal) > 0.0;
        this.normalToEye = r3.Subtract(this.view.Eye).DotProduct(this.unitNormal);
    }

    public void draw(Component component, Graphics graphics) {
        if (this.P.length == 1) {
            graphics.setColor(this.BC);
            graphics.fillOval(this.poly.xpoints[0] - this.widthness, this.poly.ypoints[0] - this.widthness, 1 + 2 * this.widthness, 1 + 2 * this.widthness);
            graphics.setColor(this.FC);
            graphics.drawOval(this.poly.xpoints[0] - this.widthness, this.poly.ypoints[0] - this.widthness, 1 + 2 * this.widthness, 1 + 2 * this.widthness);
        } else if (this.P.length == 2) {
            graphics.setColor(this.FC);
            Face.Line(graphics, this.widthness, this.poly.xpoints[0], this.poly.ypoints[0], this.poly.xpoints[1], this.poly.ypoints[1]);
        } else if (this.vM.getModel() == 3) {
            graphics.setColor(this.FC);
            graphics.drawPolygon(this.poly);
        } else {
            graphics.setColor(this.vM.getFaceColor(this));
            graphics.fillPolygon(this.poly);
            if (this.drawEdges) {
                graphics.setColor(this.EC);
                graphics.drawPolygon(this.poly);
            }
        }
        this.drawText(component, graphics);
    }

    void drawText(Component component, Graphics graphics) {
        if (this.mt != null) {
            Graphics[] graphicsArray = new Graphics[]{graphics};
            R2 r2 = new R2(this.poly.xpoints[0], this.poly.ypoints[0]);
            this.mt.draw(component, r2.ix(), r2.iy(), graphicsArray);
        }
    }

    public static void Line(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (BasicStr.isJava2()) {
            Face2.line(graphics, n, n2, n3, n4, n5);
        } else if (n == 1) {
            graphics.drawLine(n2, n3, n4, n5);
        } else if (n > 1) {
            R2 r2 = new R2(n4 - n2, n5 - n3);
            int n6 = (int)Math.round(r2.norm() * 3.0 / 2.0);
            r2.div(n6);
            int n7 = n / 2;
            double d = n2;
            double d2 = n3;
            int n8 = 0;
            while (n8 <= n6) {
                if (n == 2) {
                    graphics.fillRect((int)Math.round(d) - n7, (int)Math.round(d2) - n7, n, n);
                    d += r2.x;
                    d2 += r2.y;
                } else {
                    graphics.fillOval((int)Math.round(d) - n7, (int)Math.round(d2) - n7, n, n);
                    d += r2.x;
                    d2 += r2.y;
                }
                ++n8;
            }
        }
    }

    Face[] split(Face face) {
        Object object;
        if (this.P.length >= 3 && face.P.length >= 2 && this.intersects(face)) {
            object = null;
            Object object2 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < face.P.length) {
                R3 r3 = this.intersection(face.P[n3], face.P[(n3 + 1) % face.P.length]);
                if (r3 != null) {
                    if (object == null) {
                        object = r3;
                        n = n3;
                        if (face.P.length == 2) {
                            object2 = object;
                            break;
                        }
                    } else if (!r3.equals((R3)object, 1.0E-8)) {
                        object2 = r3;
                        n2 = n3;
                        break;
                    }
                }
                ++n3;
            }
            if (object != null && object2 != null) {
                Object object3;
                int n4;
                boolean bl = this.isInterior((R3)object) || this.isInterior((R3)object2);
                Object object4 = null;
                Object object5 = null;
                if (!bl && face.P.length >= 3) {
                    n4 = 0;
                    while (n4 < this.P.length) {
                        object3 = face.intersection(this.P[n4], this.P[(n4 + 1) % this.P.length]);
                        if (object3 != null) {
                            if (object4 == null) {
                                object4 = object3;
                            } else if (!((R3)object3).equals((R3)object4, 1.0E-8)) {
                                object5 = object3;
                                break;
                            }
                        }
                        ++n4;
                    }
                }
                if (bl || object4 != null && object5 != null && face.isInterior((R3)object4) && face.isInterior((R3)object5)) {
                    int n5;
                    n4 = 1;
                    object3 = face.P;
                    R3[] r3Array = null;
                    R3[] r3Array2 = null;
                    if (((R3[])object3).length == 2) {
                        if (((R3)object).equals(object3[0], 1.0E-8) || ((R3)object).equals(object3[1], 1.0E-8)) {
                            n4 = 0;
                        } else {
                            r3Array = new R3[]{object3[0], object};
                            r3Array2 = new R3[]{object, object3[1]};
                        }
                    } else {
                        r3Array = new R3[2 + n + ((R3[])object3).length - n2];
                        r3Array2 = new R3[n2 - n + 2];
                        int n6 = 0;
                        n5 = 0;
                        boolean bl2 = false;
                        int n7 = 0;
                        while (n7 < ((Object)object3).length) {
                            if (n7 < n) {
                                r3Array[n6++] = object3[n7];
                            } else if (n7 == n) {
                                r3Array[n6++] = object3[n7];
                                r3Array[n6++] = object;
                                r3Array2[n5++] = object;
                            } else if (n7 < n2) {
                                r3Array2[n5++] = object3[n7];
                            } else if (n7 == n2) {
                                r3Array2[n5++] = object3[n7];
                                r3Array2[n5++] = object2;
                                r3Array[n6++] = object2;
                            } else {
                                r3Array[n6++] = object3[n7];
                            }
                            ++n7;
                        }
                    }
                    if (n4 != 0) {
                        Face[] faceArray = new Face[]{new Face(r3Array), new Face(r3Array2)};
                        n5 = 0;
                        while (n5 < faceArray.length) {
                            faceArray[n5].vM = face.vM;
                            faceArray[n5].FC = face.FC;
                            faceArray[n5].BC = face.BC;
                            faceArray[n5].EC = face.EC;
                            faceArray[n5].drawEdges = face.drawEdges;
                            ++n5;
                        }
                        return faceArray;
                    }
                }
            }
        }
        object = new Face[]{face};
        return object;
    }

    private boolean intersects(Face face) {
        return this.intersectsPlane(face) && face.intersectsPlane(this);
    }

    private boolean intersectsPlane(Face face) {
        double d;
        double d2 = face.P[0].DotProduct(face.unitNormal);
        if (Math.abs(d2 - (d = this.P[0].DotProduct(face.unitNormal))) < 1.0E-8) {
            return true;
        }
        int n = 1;
        while (n < this.P.length) {
            double d3 = this.P[n].DotProduct(face.unitNormal);
            if (Math.abs(d2 - d3) < 1.0E-8 || d3 > d2 && d < d2 || d3 < d2 && d > d2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private R3 intersection(R3 r3, R3 r32) {
        double d;
        R3 r33 = r32.Subtract(r3);
        double d2 = r33.DotProduct(this.unitNormal);
        if (d2 != 0.0 && -1.0E-8 < (d = this.P[0].Subtract(r3).DotProduct(this.unitNormal) / d2) && d < 1.00000001) {
            return r3.Add(r33.ScalarProduct(d));
        }
        return null;
    }

    private boolean isInterior(R3 r3) {
        double d = 0.0;
        R3 r32 = this.P[0].Subtract(r3);
        int n = 0;
        while (n < this.P.length) {
            R3 r33 = this.P[(n + 1) % this.P.length].Subtract(r3);
            double d2 = r32.CrossProduct(r33).DotProduct(this.unitNormal);
            if (Math.abs(d2) < 1.0E-8) {
                if (r32.DotProduct(r33) < 0.0) {
                    return true;
                }
            } else {
                if (d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0) {
                    return false;
                }
                r32 = r33;
                d = d2;
            }
            ++n;
        }
        return true;
    }

    boolean isCloserThan(Face face) {
        return this.aveDistanceToEye <= face.aveDistanceToEye;
    }

    int inFrontOf(Face face) {
        if (this.maxx <= face.minx || this.minx >= face.maxx || this.maxy <= face.miny || this.miny >= face.maxy) {
            return 0;
        }
        double d = 0.0;
        double d2 = 0.0;
        R2 r2 = null;
        R2 r22 = null;
        int n = 0;
        while (n < 3) {
            Vector vector = null;
            switch (n) {
                case 0: {
                    vector = this.verticesContainedIn(face);
                    break;
                }
                case 1: {
                    vector = face.verticesContainedIn(this);
                    break;
                }
                case 2: {
                    vector = this.intersections(face);
                }
            }
            if (vector != null && !vector.isEmpty()) {
                if (this.maxDistanceToEye + 1.0E-8 < face.minDistanceToEye) {
                    return 1;
                }
                if (face.maxDistanceToEye + 1.0E-8 < this.minDistanceToEye) {
                    return -1;
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    R2 r23 = (R2)enumeration.nextElement();
                    R3 r3 = this.view.rayFromEye(r23.x, r23.y);
                    try {
                        double d3 = this.distanceToEyeAlong(r3) - face.distanceToEyeAlong(r3);
                        if (d3 > 1.0E-8) {
                            if (!(d3 > d2)) continue;
                            d2 = d3;
                            r2 = r23;
                            continue;
                        }
                        if (!(d3 < -1.0E-8)) continue;
                        if (d3 < d) {
                            d = d3;
                            r22 = r23;
                        }
                        d = Math.min(d, d3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        if (-d > d2 + 1.0E-8) {
            return 1;
        }
        if (d2 > -d + 1.0E-8) {
            return -1;
        }
        return 0;
    }

    private double distanceToEyeAlong(R3 r3) throws Exception {
        double d = this.unitNormal.DotProduct(r3);
        if (Math.abs(d) > 1.0E-8) {
            return this.normalToEye / d;
        }
        throw new Exception("Face is invisible");
    }

    private Vector verticesContainedIn(Face face) {
        if (face.P.length < 3) {
            return null;
        }
        Vector<R2> vector = new Vector<R2>();
        int n = 0;
        while (n < this.P.length) {
            if (!face.seemsVertex(this.P[n]) && face.appearsToContain(this.pr[n])) {
                vector.addElement(this.pr[n]);
            }
            ++n;
        }
        return vector;
    }

    private boolean seemsVertex(R3 r3) {
        int n = 0;
        while (n < this.P.length) {
            if (r3.equals(this.P[n], 1.0E-8)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean appearsToContain(R2 r2) {
        double d = 0.0;
        int n = 0;
        while (n < this.P.length) {
            double d2 = (this.pr[n].x - r2.x) * (this.pr[n + 1].y - r2.y) - (this.pr[n + 1].x - r2.x) * (this.pr[n].y - r2.y);
            if (d != 0.0) {
                if (Math.abs(d2) < 1.0E-8) {
                    if (Math.abs(this.pr[n].x - this.pr[n + 1].x) > 1.0E-8) {
                        return Math.min(this.pr[n].x, this.pr[n + 1].x) <= r2.x + 1.0E-8 && r2.x <= Math.max(this.pr[n].x, this.pr[n + 1].x) + 1.0E-8;
                    }
                    if (Math.abs(this.pr[n].y - this.pr[n + 1].y) > 1.0E-8) {
                        return Math.min(this.pr[n].y, this.pr[n + 1].y) <= r2.y + 1.0E-8 && r2.y <= Math.max(this.pr[n].y, this.pr[n + 1].y) + 1.0E-8;
                    }
                } else if (d > 0.0 && d2 < 0.0 || d < 0.0 && d2 > 0.0) {
                    return false;
                }
            }
            d = d2;
            ++n;
        }
        return true;
    }

    private Vector intersections(Face face) {
        Vector<R2> vector = new Vector<R2>();
        int n = 0;
        while (n < this.P.length) {
            R3 r3 = this.P[n];
            R3 r32 = this.P[(n + 1) % this.P.length];
            int n2 = 0;
            while (n2 < face.P.length) {
                R2 r2;
                R3 r33 = face.P[n2];
                R3 r34 = face.P[(n2 + 1) % face.P.length];
                if (r3 != r33 && r3 != r34 && r32 != r33 && r32 != r34 && (r2 = R2.intersection(this.pr[n], this.pr[n + 1], face.pr[n2], face.pr[n2 + 1])) != null) {
                    vector.addElement(r2);
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    Color getColorAt(int n, int n2, boolean bl) {
        if (bl && this.drawEdges && this.isOnEdge(n, n2)) {
            return this.EC;
        }
        return this.vM.getFaceColor(this);
    }

    double intersectionToEye(double d, double d2) {
        try {
            return this.distanceToEyeAlong(this.view.rayFromEye(d, d2));
        }
        catch (Exception exception) {
            return this.minDistanceToEye;
        }
    }

    boolean contains(int n, int n2, int n3) {
        if (n3 <= 1) {
            return this.contains(n, n2);
        }
        if (this.vM.getModel() == 3) {
            return false;
        }
        return this.contains(n, n2) && this.contains(n + n3 - 1, n2) && this.contains(n + n3 - 1, n2 + n3 - 1) && this.contains(n, n2 + n3 - 1);
    }

    private boolean contains(int n, int n2) {
        if (n < this.minx || n > this.maxx || n2 < this.miny || n2 > this.maxy) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.P.length) {
            if (n == this.poly.xpoints[n3] && n2 == this.poly.ypoints[n3]) {
                return true;
            }
            ++n3;
        }
        if (this.P.length == 1) {
            return false;
        }
        if (this.P.length == 2) {
            return Face.pointInSegment(n, n2, this.poly.xpoints[0], this.poly.ypoints[0], this.poly.xpoints[1], this.poly.ypoints[1]);
        }
        if ((this.drawEdges || this.vM.getModel() == 3) && this.isOnEdge(n, n2)) {
            return true;
        }
        if (this.vM.getModel() == 3) {
            return false;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.P.length) {
            int n6 = (this.poly.xpoints[n5] - n) * (this.poly.ypoints[n5 + 1] - n2) - (this.poly.xpoints[n5 + 1] - n) * (this.poly.ypoints[n5] - n2);
            if (n4 != 0) {
                if (n6 == 0) {
                    if (this.poly.xpoints[n5] != this.poly.xpoints[n5 + 1]) {
                        return Math.min(this.poly.xpoints[n5], this.poly.xpoints[n5 + 1]) <= n && n <= Math.max(this.poly.xpoints[n5], this.poly.xpoints[n5 + 1]);
                    }
                    return Math.min(this.poly.ypoints[n5], this.poly.ypoints[n5 + 1]) <= n2 && n2 <= Math.max(this.poly.ypoints[n5], this.poly.ypoints[n5 + 1]);
                }
                if (n4 > 0 && n6 < 0 || n4 < 0 && n6 > 0) {
                    return false;
                }
            }
            n4 = n6;
            ++n5;
        }
        return true;
    }

    boolean touches(int n, int n2, int n3) {
        if (n3 <= 1) {
            return this.contains(n, n2);
        }
        if (n + n3 - 1 < this.minx || n > this.maxx || n2 + n3 - 1 < this.miny || n2 > this.maxy) {
            return false;
        }
        int n4 = 0;
        while (n4 < this.P.length) {
            if (n <= this.poly.xpoints[n4] && this.poly.xpoints[n4] < n + n3 && n2 <= this.poly.ypoints[n4] && this.poly.ypoints[n4] < n2 + n3) {
                return true;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.P.length) {
            if (Face.rectangleIntersectsSegment(n, n2, n3, n3, this.poly.xpoints[n5], this.poly.ypoints[n5], this.poly.xpoints[n5 + 1], this.poly.ypoints[n5 + 1])) {
                return true;
            }
            ++n5;
        }
        if (this.vM.getModel() == 3) {
            return false;
        }
        return this.contains(n, n2) || this.contains(n + n3 - 1, n2) || this.contains(n, n2 + n3 - 1) || this.contains(n + n3 - 1, n2 + n3 - 1);
    }

    boolean isOnEdge(int n, int n2) {
        int n3 = 0;
        while (n3 < this.P.length) {
            if (Face.pointInSegment(n, n2, this.poly.xpoints[n3], this.poly.ypoints[n3], this.poly.xpoints[n3 + 1], this.poly.ypoints[n3 + 1])) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    static boolean pointInSegment(int n, int n2, int n3, int n4, int n5, int n6) {
        return Face.rectangleIntersectsSegment(n, n2, 1, 1, n3, n4, n5, n6);
    }

    static boolean rectangleIntersectsSegment(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        double d;
        if (n7 != n5) {
            d = (double)(n8 - n6) / (double)(n7 - n5);
            if (Math.min(n5, n7) <= n && n <= Math.max(n5, n7) && n2 <= (n9 = n6 + (int)Math.round(d * (double)(n - n5))) && n9 < n2 + n4) {
                return true;
            }
            if (Math.min(n5, n7) < n + n3 && n + n3 - 1 <= Math.max(n5, n7) && n2 <= (n9 = n6 + (int)Math.round(d * (double)(n - n5 + n3 - 1))) && n9 < n2 + n4) {
                return true;
            }
        } else if (n <= n5 && n5 < n + n3 && n2 <= Math.max(n6, n8) && Math.min(n6, n8) < n2 + n4) {
            return true;
        }
        if (n8 != n6) {
            d = (double)(n7 - n5) / (double)(n8 - n6);
            if (Math.min(n6, n8) <= n2 && n2 <= Math.max(n6, n8) && n <= (n9 = n5 + (int)Math.round(d * (double)(n2 - n6))) && n9 < n + n3) {
                return true;
            }
            if (Math.min(n6, n8) < n2 + n4 && n2 + n4 - 1 <= Math.max(n6, n8) && n <= (n9 = n5 + (int)Math.round(d * (double)(n2 - n6 + n4 - 1))) && n9 < n + n3) {
                return true;
            }
        } else if (n2 <= n6 && n6 < n2 + n4 && n <= Math.max(n5, n7) && Math.min(n5, n7) < n + n3) {
            return true;
        }
        return false;
    }
}

