/*
 * Decompiled with CFR 0.152.
 */
package com.mja.parser;

import com.mja.parser.Algorithm;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;
import java.util.Vector;

public class Node {
    public static boolean inAlgebraTutor = false;
    static final double epsilon = 1.0E-6;
    static final double infinity = 1000000.0;
    static final String derivation_symbol = "\u00b4";
    public double r;
    boolean sequence = false;
    boolean evOnce;
    public boolean format = false;
    double[] array;
    Node[] Narray;
    Node[] var;
    Node left;
    Node range;
    Node func;
    Node size;
    Node arr;
    Node[] right;
    int type;
    int symb;
    Algorithm alg;
    private boolean error;
    private int errType;
    String symbstr;
    private static final double[] zero = new double[]{0.0};
    private static final int noerror = 0;
    private static final int undefined = 1;
    private static final int divzero = 2;
    private static final int outofbounds = 3;
    private static String[][] errMsg = new String[][]{{"", "Function not defined; ", "Division by zero; ", "Index out of bounds"}, {"", "Funci\u00f3n no definida; ", "Divisi\u00f3n por cero; ", "\u00edndice inv\u00e1lido"}};
    public static final int No = 0;
    public static final int Sep = 1;
    public static final int Lp = 2;
    public static final int Coma = 3;
    public static final int Rp = 4;
    public static final int As = 5;
    public static final int If = 6;
    public static final int ThenElse = 7;
    public static final int B0 = 8;
    public static final int B1 = 9;
    public static final int B2 = 10;
    public static final int B3 = 11;
    public static final int In = 12;
    public static final int Us = 13;
    public static final int Ua = 14;
    public static final int Za = 15;
    public static final int Vi = 16;
    public static final int Str = 17;
    public static final int END = 0;
    public static final int SEP = 1;
    public static final int LP = 2;
    public static final int COMA = 3;
    public static final int RP = 4;
    public static final int ASSIGN = 5;
    public static final int IF = 6;
    public static final int THENELSE = 7;
    public static final int RND = 8;
    public static final int IGUAL = 9;
    public static final int NOI = 10;
    public static final int OR = 11;
    public static final int AND = 12;
    public static final int MEN = 13;
    public static final int MAY = 14;
    public static final int MEOI = 15;
    public static final int MAOI = 16;
    public static final int MAS = 17;
    public static final int MENOS = 18;
    public static final int MASMEN = 19;
    public static final int POR = 20;
    public static final int DIV = 21;
    public static final int EXPON = 22;
    public static final int MOD = 23;
    public static final int NO = 24;
    public static final int SQR = 25;
    public static final int SQRT = 26;
    public static final int EXP = 27;
    public static final int LOG = 28;
    public static final int LOG10 = 29;
    public static final int ABS = 30;
    public static final int ENT = 31;
    public static final int SGN = 32;
    public static final int IND = 33;
    public static final int SIN = 34;
    public static final int COS = 35;
    public static final int TAN = 36;
    public static final int COT = 37;
    public static final int SEC = 38;
    public static final int CSC = 39;
    public static final int SINH = 40;
    public static final int COSH = 41;
    public static final int TANH = 42;
    public static final int SECH = 43;
    public static final int CSCH = 44;
    public static final int COTH = 45;
    public static final int ASIN = 46;
    public static final int ACOS = 47;
    public static final int ATAN = 48;
    public static final int MIN = 61;
    public static final int MAX = 62;
    public static final int FUNC = 71;
    public static final int DER = 72;
    public static final int ARRAY = 73;
    public static final int VAR = 74;
    public static final int EQN = 75;
    public static final int EQA = 76;
    public static final int EQX = 77;
    public static final int NUM = 78;
    public static final int NOOP = 79;

    Node cloneNode() {
        Node node = new Node();
        node.symb = this.symb;
        node.symbstr = this.symbstr;
        node.type = this.type;
        node.r = this.r;
        node.size = this.size;
        node.var = this.var;
        node.sequence = this.sequence;
        node.evOnce = this.evOnce;
        node.format = this.format;
        node.array = this.array;
        node.Narray = this.Narray;
        node.var = this.var;
        node.range = this.range;
        node.func = this.func;
        node.size = this.size;
        node.arr = this.arr;
        node.alg = this.alg;
        node.left = null;
        if (this.left != null) {
            node.left = this.left.cloneNode();
        }
        node.right = null;
        if (this.right != null) {
            node.right = new Node[this.right.length];
            int n = 0;
            while (n < this.right.length) {
                node.right[n] = null;
                if (this.right[n] != null) {
                    node.right[n] = this.right[n].cloneNode();
                }
                ++n;
            }
        }
        return node;
    }

    public int getType() {
        return this.type;
    }

    public void assign(Node node) {
        this.type = 16;
        this.left = node;
        if (this.symb == 73) {
            this.Narray = node.Narray;
            this.array = new double[this.Narray.length];
            this.evOnce = node.evOnce;
            this.size = node.size;
            this.arr = node.arr;
        }
    }

    public Node getLeft() {
        return this.left;
    }

    public Node[] getRight() {
        return this.right;
    }

    /*
     * Unable to fully structure code
     */
    static String[] getTokens(String var0) {
        var1_1 = var0.trim();
        var2_2 = 0;
        var3_3 = new Vector<String>();
        var4_4 = "";
        do {
            block11: {
                var5_5 = new StringBuffer();
                var6_6 = '\u0000';
                if (var2_2 < var1_1.length()) ** GOTO lbl13
                var5_5.append(var6_6);
                break block11;
lbl-1000:
                // 1 sources

                {
                    ++var2_2;
lbl13:
                    // 2 sources

                    ** while (Node.isSpace((char)var1_1.charAt((int)var2_2)))
                }
lbl14:
                // 1 sources

                var6_6 = var1_1.charAt(var2_2++);
                var5_5.append(var6_6);
                if (var2_2 < var1_1.length()) {
                    if (Node.isOperator(var6_6)) {
                        while (Node.isOperator(var6_6 = var1_1.charAt(var2_2))) {
                            if (!Node.knownOperator(new String((StringBuffer)var5_5) + String.valueOf(var6_6))) break;
                            var5_5.append(var6_6);
                            if (++var2_2 < var1_1.length()) {
                                continue;
                            }
                            break;
                        }
                    } else if (Node.isAlphaNum(var6_6)) {
                        while (Node.isAlphaNum(var6_6 = var1_1.charAt(var2_2))) {
                            var5_5.append(var6_6);
                            if (++var2_2 < var1_1.length()) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            var4_4 = new String((StringBuffer)var5_5);
            var3_3.addElement(var4_4);
        } while (!Node.isSeparator(var4_4));
        var5_5 = new String[var3_3.size()];
        var6_7 = var3_3.elements();
        var7_8 = 0;
        while (var7_8 < var5_5.length) {
            var5_5[var7_8] = (String)var6_7.nextElement();
            ++var7_8;
        }
        return var5_5;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\b' || c == '\u000b';
    }

    private static boolean isAlphaNum(char c) {
        return Node.isDecimal(c) || Node.isAlpha(c);
    }

    private static boolean isDecimal(char c) {
        return Node.isDigit(c) || c == '.';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isAlpha(char c) {
        switch (c) {
            case '\'': 
            case '_': 
            case '\u00b4': 
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c4': 
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': 
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': 
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d6': 
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': 
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e4': 
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': 
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': 
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f6': 
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': {
                return true;
            }
        }
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isOperator(char c) {
        switch (c) {
            case '!': 
            case '#': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static boolean isSeparator(String string) {
        return string.equals(";") || string.equals("\u0000") || string.equals("\u0016");
    }

    public boolean isANumber() {
        try {
            double d = Double.valueOf(this.symbstr);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getSymbol() {
        return this.symbstr;
    }

    public void equalToMinus() {
        this.symb = 18;
        this.type = 9;
    }

    public Node() {
        this(0.0);
    }

    public Node(double d) {
        this.symbstr = "";
        this.r = d;
        this.type = 16;
    }

    public Node(String string, double d) {
        this.symbstr = string;
        this.r = d;
        this.type = 16;
    }

    public Node(String string, String string2) {
        this.symbstr = string;
        this.type = 17;
    }

    Node(String string, Node node, Node[] nodeArray, boolean bl) {
        this.symbstr = string;
        this.symb = 73;
        this.type = this.nodeType(this.symb);
        this.Narray = nodeArray;
        this.array = new double[this.Narray.length];
        this.evOnce = bl;
        this.size = node;
    }

    Node(String string, Node node) {
        this.symbstr = string;
        this.symb = 73;
        this.type = this.nodeType(this.symb);
        this.arr = node;
    }

    Node(String string, boolean bl, Node node, Algorithm algorithm) {
        this.symbstr = string;
        this.func = node;
        this.symb = bl ? 72 : 71;
        this.alg = algorithm;
        this.type = this.nodeType(this.symb);
    }

    Node(String string, boolean bl) {
        this.symbstr = string;
        if (bl) {
            this.symb = 74;
            this.type = 16;
        } else {
            this.symb = Node.symbol(string);
            this.type = this.nodeType(this.symb);
        }
    }

    public boolean isSequence() {
        return this.symb == 71 && this.func.sequence;
    }

    private int nodeType(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 17: 
            case 18: 
            case 19: {
                return 12;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return 8;
            }
            case 11: {
                return 9;
            }
            case 12: 
            case 20: 
            case 21: {
                return 10;
            }
            case 22: 
            case 23: {
                return 11;
            }
            case 24: {
                return 13;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 61: 
            case 62: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return 14;
            }
            case 74: {
                return 16;
            }
        }
        return 0;
    }

    public static boolean knownOperator(String string) {
        int n = Node.symbol(string);
        return 5 <= n && n <= 24;
    }

    private static int symbol(String string) {
        if (string.equals("\u0000")) {
            return 0;
        }
        if (string.equals(";")) {
            return 1;
        }
        if (string.equals("(")) {
            return 2;
        }
        if (string.equals(")")) {
            return 4;
        }
        if (string.equals("[")) {
            return 2;
        }
        if (string.equals("]")) {
            return 4;
        }
        if (string.equals(",")) {
            return 3;
        }
        if (string.equals(":=")) {
            return 5;
        }
        if (string.equals("?")) {
            return 6;
        }
        if (string.equals(":")) {
            return 7;
        }
        if (string.equals("=")) {
            return 9;
        }
        if (string.equals("==")) {
            return 9;
        }
        if (string.equals("#")) {
            return 10;
        }
        if (string.equals("!=")) {
            return 10;
        }
        if (string.equals("|")) {
            return 11;
        }
        if (string.equals("||")) {
            return 11;
        }
        if (string.equals("&")) {
            return 12;
        }
        if (string.equals("&&")) {
            return 12;
        }
        if (string.equals("<")) {
            return 13;
        }
        if (string.equals(">")) {
            return 14;
        }
        if (string.equals("<=")) {
            return 15;
        }
        if (string.equals(">=")) {
            return 16;
        }
        if (string.equals("+")) {
            return 17;
        }
        if (string.equals("-")) {
            return 18;
        }
        if (string.equals("\u00b1")) {
            return 19;
        }
        if (string.equals("*")) {
            return 20;
        }
        if (string.equals("/")) {
            return 21;
        }
        if (string.equals("^")) {
            return 22;
        }
        if (string.equals("%")) {
            return 23;
        }
        if (string.equals("~")) {
            return 24;
        }
        if (string.equals("!")) {
            return 24;
        }
        if (string.equals("sqr")) {
            return 25;
        }
        if (string.equals("sqrt")) {
            return 26;
        }
        if (string.equals("ra\u00edz")) {
            return 26;
        }
        if (string.equals("exp")) {
            return 27;
        }
        if (string.equals("log")) {
            return 28;
        }
        if (string.equals("log10")) {
            return 29;
        }
        if (string.equals("abs")) {
            return 30;
        }
        if (string.equals("ent")) {
            return 31;
        }
        if (string.equals("sgn")) {
            return 32;
        }
        if (string.equals("ind")) {
            return 33;
        }
        if (string.equals("sin")) {
            return 34;
        }
        if (string.equals("sen")) {
            return 34;
        }
        if (string.equals("cos")) {
            return 35;
        }
        if (string.equals("tan")) {
            return 36;
        }
        if (string.equals("cot")) {
            return 37;
        }
        if (string.equals("sec")) {
            return 38;
        }
        if (string.equals("csc")) {
            return 39;
        }
        if (string.equals("sinh")) {
            return 40;
        }
        if (string.equals("senh")) {
            return 40;
        }
        if (string.equals("cosh")) {
            return 41;
        }
        if (string.equals("tanh")) {
            return 42;
        }
        if (string.equals("coth")) {
            return 43;
        }
        if (string.equals("sech")) {
            return 44;
        }
        if (string.equals("csch")) {
            return 45;
        }
        if (string.equals("asin")) {
            return 46;
        }
        if (string.equals("asen")) {
            return 46;
        }
        if (string.equals("acos")) {
            return 47;
        }
        if (string.equals("atan")) {
            return 48;
        }
        if (string.equals("min")) {
            return 61;
        }
        if (string.equals("max")) {
            return 62;
        }
        if (string.equals("rnd")) {
            return 8;
        }
        if (inAlgebraTutor) {
            if (string.equals("eqn")) {
                return 75;
            }
            if (string.equals("eqa")) {
                return 76;
            }
            if (string.equals("eqx")) {
                return 77;
            }
            if (string.equals("num")) {
                return 78;
            }
        }
        if (string.equals("")) {
            return 79;
        }
        return 74;
    }

    public int NumVars() {
        int n = 0;
        if (this.type == 14) {
            if (this.func != null) {
                n = this.func.var.length;
            } else if (this.symb == 73) {
                n = 1;
            } else {
                switch (this.symb) {
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: {
                        n = 1;
                        break;
                    }
                    case 61: 
                    case 62: {
                        n = 2;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
            }
        }
        return n;
    }

    private double divide(double d, double d2) throws Exception {
        boolean bl;
        boolean bl2 = bl = Math.abs(d2) < 1.0E-6;
        if (d == 0.0 && !bl) {
            return 0.0;
        }
        if (bl) {
            this.error = true;
            this.errType = 2;
            throw new Exception(errMsg[1][this.errType]);
        }
        return d / d2;
    }

    private double log(double d) throws Exception {
        if (d < 1.0E-6) {
            this.error = true;
            this.errType = 1;
            throw new Exception(errMsg[1][this.errType]);
        }
        return Math.log(d);
    }

    private double expon(double d, double d2) throws Exception {
        double d3;
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d >= 0.0) {
            return Math.pow(d, d2);
        }
        d = -d;
        int n = (int)Math.floor(d2);
        if ((double)n == d2) {
            if (n % 2 == 1) {
                return -Math.pow(d, d2);
            }
            return Math.pow(d, d2);
        }
        double d4 = 1.0 / d2;
        int n2 = (int)Math.floor(d4);
        if ((double)n2 == d4) {
            if (n2 % 2 == 1) {
                return -Math.pow(d, d2);
            }
            this.error = true;
            this.errType = 1;
            throw new Exception(errMsg[1][this.errType]);
        }
        n2 = 2;
        while (n2 <= 1000) {
            d3 = d2 * (double)n2;
            if (d3 == Math.floor(d3)) {
                n = (int)Math.round(d3);
                if (n % 2 == 0) {
                    return Math.pow(d, d2);
                }
                if (n2 % 2 != 1) break;
                return -Math.pow(d, d2);
            }
            ++n2;
        }
        n2 = 10000;
        while (n2 <= 100000000) {
            d3 = d2 * (double)n2;
            if (d3 == Math.floor(d3) && (n = (int)Math.round(d3)) % 2 == 0) {
                return Math.pow(d, d2);
            }
            n2 *= 10;
        }
        this.error = true;
        this.errType = 1;
        throw new Exception(errMsg[1][this.errType]);
    }

    private double sqrt(double d) throws Exception {
        if (d < 0.0) {
            this.error = true;
            this.errType = 1;
            throw new Exception(errMsg[1][this.errType]);
        }
        return Math.sqrt(d);
    }

    public boolean rangeOK() {
        try {
            this.Evaluate(false);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private double UnOp(boolean bl, double[] dArray) throws Exception {
        double d = 0.0;
        if (dArray != null && dArray.length > 0) {
            d = dArray[0];
        }
        switch (this.symb) {
            case 24: {
                if (d == 1.0) {
                    return 0.0;
                }
                return 1.0;
            }
            case 17: {
                return d;
            }
            case 18: {
                return -d;
            }
            case 19: {
                return d;
            }
            case 30: {
                if (d < 0.0) {
                    return -d;
                }
                return d;
            }
            case 25: {
                return d * d;
            }
            case 26: {
                return this.sqrt(d);
            }
            case 27: {
                return Math.exp(d);
            }
            case 28: {
                return this.log(d);
            }
            case 29: {
                return this.log(d) / Math.log(10.0);
            }
            case 35: {
                return Math.cos(d);
            }
            case 34: {
                return Math.sin(d);
            }
            case 36: {
                return this.divide(Math.sin(d), Math.cos(d));
            }
            case 38: {
                return this.divide(1.0, Math.cos(d));
            }
            case 39: {
                return this.divide(1.0, Math.sin(d));
            }
            case 37: {
                return this.divide(1.0, Math.tan(d));
            }
            case 40: {
                return (Math.exp(d) - Math.exp(-d)) / 2.0;
            }
            case 41: {
                return (Math.exp(d) + Math.exp(-d)) / 2.0;
            }
            case 42: {
                return this.divide(Math.exp(d) - Math.exp(-d), Math.exp(d) + Math.exp(-d));
            }
            case 45: {
                return this.divide(Math.exp(d) + Math.exp(-d), Math.exp(d) - Math.exp(-d));
            }
            case 43: {
                return 2.0 / (Math.exp(d) + Math.exp(-d));
            }
            case 44: {
                return this.divide(2.0, Math.exp(d) - Math.exp(-d));
            }
            case 31: {
                return Math.floor(d);
            }
            case 32: {
                if (d > 0.0) {
                    return 1.0;
                }
                if (d < 0.0) {
                    return -1.0;
                }
            }
            case 33: {
                if (d != 0.0) {
                    return 1.0;
                }
                return 0.0;
            }
            case 46: {
                return Math.asin(d);
            }
            case 47: {
                return Math.acos(d);
            }
            case 48: {
                return Math.atan(d);
            }
            case 8: {
                return Math.random();
            }
            case 61: {
                return Math.min(dArray[0], dArray[1]);
            }
            case 62: {
                return Math.max(dArray[0], dArray[1]);
            }
            case 71: {
                double d2 = 0.0;
                if (this.func.var != null && this.func.var.length == dArray.length) {
                    if (this.func.sequence) {
                        int n = 0;
                        while (n < dArray.length) {
                            if (dArray[n] != (double)Math.round(dArray[n])) {
                                this.error = true;
                                this.errType = 1;
                                throw new Exception(errMsg[1][1]);
                            }
                            ++n;
                        }
                    }
                    double[] dArray2 = new double[dArray.length];
                    int n = 0;
                    while (n < dArray.length) {
                        dArray2[n] = this.func.var[n].r;
                        this.func.var[n].r = dArray[n];
                        ++n;
                    }
                    boolean bl2 = true;
                    if (bl || this.func.range == null || this.func.range.Evaluate(1.0) > 0.0) {
                        if (this.alg != null && !this.alg.isNull) {
                            this.alg.perform();
                        }
                        try {
                            d2 = this.func.Evaluate(bl);
                        }
                        catch (Exception exception) {
                            bl2 = false;
                        }
                    } else {
                        bl2 = false;
                    }
                    int n2 = 0;
                    while (n2 < dArray.length) {
                        this.func.var[n2].r = dArray2[n2];
                        ++n2;
                    }
                    if (!bl2) {
                        this.error = true;
                        this.errType = 1;
                        throw new Exception(errMsg[1][1]);
                    }
                }
                return d2;
            }
            case 72: {
                double d3 = 0.0;
                double d4 = 0.0;
                if (this.func.var != null && this.func.var.length == dArray.length) {
                    double[] dArray3 = new double[dArray.length];
                    int n = 0;
                    while (n < dArray.length) {
                        dArray3[n] = this.func.var[n].r;
                        this.func.var[n].r = dArray[n];
                        ++n;
                    }
                    boolean bl3 = true;
                    try {
                        if (this.alg != null && !this.alg.isNull) {
                            this.alg.perform();
                        }
                        d3 = this.func.Evaluate(bl);
                        this.func.var[0].r = d + 1.0E-6;
                        if (this.alg != null && !this.alg.isNull) {
                            this.alg.perform();
                        }
                        d4 = this.func.Evaluate(bl);
                    }
                    catch (Exception exception) {
                        bl3 = false;
                    }
                    int n3 = 0;
                    while (n3 < dArray.length) {
                        this.func.var[n3].r = dArray3[n3];
                        ++n3;
                    }
                    if (!bl3) {
                        this.error = true;
                        this.errType = 1;
                        throw new Exception(errMsg[1][1]);
                    }
                }
                return (d4 - d3) / 1.0E-6;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return d;
            }
            case 73: {
                double[] dArray4 = this.arr.array;
                int n = (int)Math.round(d);
                if (dArray4 != null && n >= 0 && n < dArray4.length) {
                    return dArray4[n];
                }
                this.error = true;
                this.errType = 3;
                throw new Exception(errMsg[1][3]);
            }
        }
        return 0.0;
    }

    private double BnOp(double d, double d2) throws Exception {
        switch (this.symb) {
            case 9: {
                if (d == d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 13: {
                if (d < d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 15: {
                if (d <= d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 14: {
                if (d > d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 16: {
                if (d >= d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 10: {
                if (d != d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 12: {
                if (d == 1.0 && d2 == 1.0) {
                    return 1.0;
                }
                return 0.0;
            }
            case 11: {
                if (d == 1.0 || d2 == 1.0) {
                    return 1.0;
                }
                return 0.0;
            }
            case 17: {
                return d + d2;
            }
            case 18: {
                return d - d2;
            }
            case 19: {
                return d + d2;
            }
            case 20: {
                if (d == 0.0 || d2 == 0.0) {
                    return 0.0;
                }
                return d * d2;
            }
            case 21: {
                return this.divide(d, d2);
            }
            case 22: {
                return this.expon(d, d2);
            }
            case 23: {
                return d - d2 * Math.floor(d / d2);
            }
        }
        return 0.0;
    }

    public double Evaluate(boolean bl) throws Exception {
        this.errType = 0;
        this.error = false;
        switch (this.type) {
            case 16: {
                double d = 0.0;
                d = this.left != null ? this.left.Evaluate(bl) : this.r;
                return d;
            }
            case 15: {
                return this.UnOp(bl, zero);
            }
            case 13: 
            case 14: {
                double[] dArray = new double[this.right.length];
                int n = 0;
                while (n < dArray.length) {
                    dArray[n] = this.right[n].Evaluate(bl);
                    ++n;
                }
                return this.UnOp(bl, dArray);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.BnOp(this.left.Evaluate(bl), this.right[0].Evaluate(bl));
            }
            case 5: {
                this.left.r = this.right[0].Evaluate(bl);
                return this.left.r;
            }
            case 6: {
                if (this.left.Evaluate(bl) > 0.0) {
                    return this.right[0].left.Evaluate(bl);
                }
                return this.right[0].right[0].Evaluate(bl);
            }
        }
        return 0.0;
    }

    public double Evaluate() throws Exception {
        return this.Evaluate(false);
    }

    public double Evaluate(double d) {
        try {
            return this.Evaluate(false);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public boolean error() {
        if (this.error) {
            return true;
        }
        switch (this.type) {
            case 13: 
            case 14: {
                int n = 0;
                while (n < this.right.length) {
                    if (this.right[n].error()) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.left.error() || this.right[0].error();
            }
        }
        return false;
    }

    private String translate(int n, int n2) {
        return errMsg[n][n2];
    }

    public String errorMsg(int n) {
        String string = this.translate(n, this.errType);
        switch (this.type) {
            case 13: 
            case 14: {
                int n2 = 0;
                while (n2 < this.right.length) {
                    string = string + this.right[n2].errorMsg(n);
                    ++n2;
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = string + this.left.errorMsg(n) + " " + this.right[0].errorMsg(n);
            }
        }
        return string;
    }

    public boolean contains(String string) {
        if (this.symbstr.equals(string)) {
            return true;
        }
        switch (this.type) {
            case 13: 
            case 14: {
                int n = 0;
                while (n < this.right.length) {
                    if (this.right[n].contains(string)) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.left.contains(string) || this.right[0].contains(string);
            }
        }
        return false;
    }

    public String toString(int n, boolean bl, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.type == 17) {
            stringBuffer.append(this.symbstr);
        } else {
            try {
                double d = this.Evaluate(false);
                stringBuffer.append(BasicStr.DoubleToString(d, n, bl));
            }
            catch (Exception exception) {
                stringBuffer.append(this.errorMsg(n2));
            }
        }
        return new String(stringBuffer);
    }

    private static String symbolStr(int n) {
        switch (n) {
            case 0: {
                return "\u0000";
            }
            case 1: {
                return ";";
            }
            case 2: {
                return "(";
            }
            case 4: {
                return ")";
            }
            case 5: {
                return ":=";
            }
            case 6: {
                return "?";
            }
            case 7: {
                return ":";
            }
            case 9: {
                return "=";
            }
            case 10: {
                return "!=";
            }
            case 11: {
                return "|";
            }
            case 12: {
                return "&";
            }
            case 13: {
                return "<";
            }
            case 14: {
                return ">";
            }
            case 15: {
                return "<=";
            }
            case 16: {
                return ">=";
            }
            case 17: {
                return "+";
            }
            case 18: {
                return "-";
            }
            case 19: {
                return "\u00b1";
            }
            case 20: {
                return "*";
            }
            case 21: {
                return "/";
            }
            case 22: {
                return "^";
            }
            case 23: {
                return "%";
            }
            case 24: {
                return "!";
            }
            case 25: {
                return "sqr";
            }
            case 26: {
                return "sqrt";
            }
            case 27: {
                return "exp";
            }
            case 28: {
                return "log";
            }
            case 29: {
                return "log10";
            }
            case 30: {
                return "abs";
            }
            case 31: {
                return "ent";
            }
            case 32: {
                return "sgn";
            }
            case 33: {
                return "ind";
            }
            case 34: {
                return "sin";
            }
            case 35: {
                return "cos";
            }
            case 36: {
                return "tan";
            }
            case 37: {
                return "cot";
            }
            case 38: {
                return "sec";
            }
            case 39: {
                return "csc";
            }
            case 40: {
                return "sinh";
            }
            case 41: {
                return "cosh";
            }
            case 42: {
                return "tanh";
            }
            case 43: {
                return "coth";
            }
            case 44: {
                return "sech";
            }
            case 45: {
                return "csch";
            }
            case 46: {
                return "asin";
            }
            case 47: {
                return "acos";
            }
            case 48: {
                return "atan";
            }
            case 61: {
                return "min";
            }
            case 62: {
                return "max";
            }
            case 8: {
                return "rnd";
            }
            case 75: {
                return "eqn";
            }
            case 76: {
                return "eqa";
            }
            case 77: {
                return "eqx";
            }
            case 78: {
                return "num";
            }
            case 79: {
                return "";
            }
        }
        return "";
    }

    public String toExpression() {
        return this.toExpression(false);
    }

    public String toExpression(boolean bl) {
        String string = "";
        switch (this.type) {
            case 16: {
                string = string + this.getSymbol();
                break;
            }
            case 15: {
                string = string + this.symbstr;
                break;
            }
            case 13: {
                if (this.symb == 17) {
                    string = string + this.parenthesis(this, this.right, bl);
                    break;
                }
                string = string + this.symbstr + this.parenthesis(this, this.right, bl);
                break;
            }
            case 14: {
                string = string + this.symbstr + this.parenthesis(this, this.right, bl);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = string + this.parenthesis(this, this.left, bl) + this.symbstr + this.parenthesis(this, this.right, bl);
                break;
            }
            case 7: {
                string = string + "(" + this.parenthesis(this, this.left, bl) + this.symbstr + this.parenthesis(this, this.right, bl) + ")";
                break;
            }
            default: {
                string = string + this.getSymbol();
            }
        }
        return string;
    }

    private String parenthesis(Node node, Node node2, boolean bl) {
        Node[] nodeArray = new Node[]{node2};
        return this.parenthesis(node, nodeArray, bl);
    }

    private String parenthesis(Node node, Node[] nodeArray, boolean bl) {
        boolean bl2 = nodeArray != null && nodeArray.length > 1;
        String string = "";
        if (nodeArray != null) {
            if (nodeArray.length == 1 && nodeArray[0].type < 16 && (node.type == 9 && node.symb == 18 || node.type != nodeArray[0].type || node.type == 14 || node.type == 13) && node.right == nodeArray) {
                bl2 = true;
            }
            int n = 0;
            while (n < nodeArray.length) {
                string = string + nodeArray[n].toExpression(bl);
                if (n + 1 < nodeArray.length) {
                    string = string + ",";
                }
                ++n;
            }
            if ((bl || bl2) && string.length() > 1 && !this.isNumber(string)) {
                string = "(" + string + ")";
            }
        }
        return string;
    }

    private boolean isNumber(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Node.isDecimal(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Node binaryToUnaryMinus() {
        Node node = this.cloneNode();
        if (this.type == 9 && this.symb == 18) {
            node.symb = 17;
            node.symbstr = "+";
            Node[] nodeArray = node.right;
            node.right = new Node[1];
            node.right[0] = new Node();
            node.right[0].type = 13;
            node.right[0].symb = 18;
            node.right[0].symbstr = "-";
            node.right[0].right = new Node[nodeArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                node.right[0].right[n] = nodeArray[n].binaryToUnaryMinus();
                ++n;
            }
            node.left = node.left.binaryToUnaryMinus();
        } else {
            if (node.left != null) {
                node.left = node.left.binaryToUnaryMinus();
            }
            if (node.right != null) {
                int n = 0;
                while (n < node.right.length) {
                    node.right[n] = node.right[n].binaryToUnaryMinus();
                    ++n;
                }
            }
        }
        node = node.eliminateConsecutiveMinus();
        return node;
    }

    Node eliminateConsecutiveMinus() {
        Node node = this;
        if (this.type == 13 && this.symb == 18 && this.right[0].type == 13 && this.right[0].symb == 18) {
            node = this.right[0].right[0];
        }
        if (node.left != null) {
            node.left = node.left.eliminateConsecutiveMinus();
        }
        if (node.right != null) {
            int n = 0;
            while (n < node.right.length) {
                node.right[n] = node.right[n].eliminateConsecutiveMinus();
                ++n;
            }
        }
        return node;
    }

    public Node simplify(Parser parser, int n) {
        if (this.symb == 78) {
            Node node = new Node();
            try {
                node.r = this.Evaluate();
                node.symb = 74;
                node.symbstr = BasicStr.DoubleToString(node.r, n, false);
                node.type = 16;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return node;
        }
        if (parser.isVar(this.symbstr)) {
            return this;
        }
        Node node = this.cloneNode();
        if (this.left != null) {
            node.left = this.left.simplify(parser, n);
        }
        if (this.right != null) {
            node.right = new Node[this.right.length];
            int n2 = 0;
            while (n2 < this.right.length) {
                if (this.right[n2] != null) {
                    node.right[n2] = this.right[n2].simplify(parser, n);
                }
                ++n2;
            }
        }
        return node;
    }

    public void orderCanonically() {
        block8: {
            block7: {
                if (this.type == 16) {
                    return;
                }
                if (this.symb != 20 && (this.symb != 17 || this.type != 9)) break block7;
                Vector vector = new Vector();
                this.addOperandNodes(this.type, this.symb, vector);
                this.order(vector);
                Node node = this;
                int n = 0;
                while (n < vector.size() - 1) {
                    Node node2 = (Node)vector.elementAt(n);
                    node.type = this.type;
                    node.symb = this.symb;
                    node.symbstr = this.symbstr;
                    node.left = node2;
                    node.right = new Node[1];
                    if (n < vector.size() - 2) {
                        node.right[0] = new Node();
                        node = node.right[0];
                    } else {
                        node.right[0] = node2 = (Node)vector.elementAt(n + 1);
                    }
                    ++n;
                }
                break block8;
            }
            if (this.left != null) {
                this.left.orderCanonically();
            }
            if (this.right == null) break block8;
            int n = 0;
            while (n < this.right.length) {
                if (this.right[n] != null) {
                    this.right[n].orderCanonically();
                }
                ++n;
            }
        }
    }

    private void addOperandNodes(int n, int n2, Vector vector) {
        if (this.type == n && this.symb == n2) {
            if (this.left != null) {
                this.left.addOperandNodes(n, n2, vector);
            }
            if (this.right != null && this.right.length > 0 && this.right[0] != null) {
                this.right[0].addOperandNodes(n, n2, vector);
            }
        } else {
            this.orderCanonically();
            vector.add(this);
        }
    }

    private void order(Vector vector) {
        int n = 1;
        while (n < vector.size()) {
            Node node = (Node)vector.elementAt(n);
            int n2 = 0;
            while (n2 < n) {
                Node node2 = (Node)vector.elementAt(n2);
                if (node.alfaLessThan(node2)) {
                    vector.remove(n);
                    vector.insertElementAt(node, n2);
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean alfaLessThan(Node node) {
        int n = this.toExpression(false).compareTo(node.toExpression(false));
        if (n < 0) {
            return true;
        }
        if (n == 0 && this.left != null && node.left != null) {
            if (this.left.alfaLessThan(node.left)) {
                return true;
            }
            if (this.left.alfaEquals(node.left) && this.right != null && this.right[0] != null && this.right[0].alfaLessThan(node.right[0])) {
                return true;
            }
        }
        return false;
    }

    private boolean alfaEquals(Node node) {
        return this.symbstr.equals(node.symbstr);
    }

    public static boolean almostEqual(Node node, Node node2, double d) {
        if (node.type != node2.type) {
            return false;
        }
        if (node.symb != node2.symb) {
            return false;
        }
        switch (node.type) {
            case 16: {
                return Math.abs(node.r - node2.r) <= d;
            }
            case 15: {
                return node.symbstr.equals(node2.symbstr);
            }
            case 13: 
            case 14: {
                double[] dArray = new double[node.right.length];
                int n = 0;
                while (n < dArray.length) {
                    if (!Node.almostEqual(node.right[n], node2.right[n], d)) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (!Node.almostEqual(node.left, node2.left, d)) {
                    return false;
                }
                return Node.almostEqual(node.right[0], node2.right[0], d);
            }
            case 5: {
                return Node.almostEqual(node.left, node2.left, d);
            }
        }
        return false;
    }
}

