/*
 * Decompiled with CFR 0.152.
 */
package com.mja.math;

import com.mja.math.R3;

public class LinearTransformation {
    private double[][] M = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    private R3 T = new R3(0.0, 0.0, 0.0);

    public static LinearTransformation Scale(double d) {
        LinearTransformation linearTransformation = new LinearTransformation();
        int n = 0;
        while (n < 3) {
            double[] dArray = linearTransformation.M[n];
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
        return linearTransformation;
    }

    public static LinearTransformation Rotation(int n, double d) {
        LinearTransformation linearTransformation = new LinearTransformation();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        if (n == 0) {
            linearTransformation.M[1][1] = d2;
            linearTransformation.M[1][2] = -d3;
            linearTransformation.M[2][1] = d3;
            linearTransformation.M[2][2] = d2;
        } else if (n == 1) {
            linearTransformation.M[2][2] = d2;
            linearTransformation.M[2][0] = -d3;
            linearTransformation.M[0][2] = d3;
            linearTransformation.M[0][0] = d2;
        } else if (n == 2) {
            linearTransformation.M[0][0] = d2;
            linearTransformation.M[0][1] = -d3;
            linearTransformation.M[1][0] = d3;
            linearTransformation.M[1][1] = d2;
        }
        return linearTransformation;
    }

    public static LinearTransformation Transposed(LinearTransformation linearTransformation) {
        LinearTransformation linearTransformation2 = new LinearTransformation();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                linearTransformation2.M[n][n2] = linearTransformation.M[n2][n];
                ++n2;
            }
            ++n;
        }
        return linearTransformation2;
    }

    public static LinearTransformation Rotation(R3 r3) {
        LinearTransformation linearTransformation = LinearTransformation.Rotation(0, r3.x);
        LinearTransformation linearTransformation2 = LinearTransformation.Rotation(1, r3.y);
        LinearTransformation linearTransformation3 = LinearTransformation.Rotation(2, r3.z);
        return LinearTransformation.Multiply(linearTransformation3, LinearTransformation.Multiply(linearTransformation2, linearTransformation));
    }

    public static LinearTransformation Rotation(LinearTransformation linearTransformation, R3 r3) {
        return LinearTransformation.Multiply(linearTransformation, LinearTransformation.Rotation(r3));
    }

    public static LinearTransformation RigidMotion(R3 r3, R3 r32) {
        LinearTransformation linearTransformation = LinearTransformation.Rotation(r3);
        linearTransformation.T = r32;
        return linearTransformation;
    }

    public void Apply(R3 r3) {
        double d = r3.x;
        double d2 = r3.y;
        double d3 = r3.z;
        r3.x = this.T.x + this.M[0][0] * d + this.M[0][1] * d2 + this.M[0][2] * d3;
        r3.y = this.T.y + this.M[1][0] * d + this.M[1][1] * d2 + this.M[1][2] * d3;
        r3.z = this.T.z + this.M[2][0] * d + this.M[2][1] * d2 + this.M[2][2] * d3;
    }

    public static LinearTransformation Multiply(LinearTransformation linearTransformation, LinearTransformation linearTransformation2) {
        LinearTransformation linearTransformation3 = new LinearTransformation();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                linearTransformation3.M[n][n2] = 0.0;
                int n3 = 0;
                while (n3 < 3) {
                    double[] dArray = linearTransformation3.M[n];
                    int n4 = n2;
                    dArray[n4] = dArray[n4] + linearTransformation.M[n][n3] * linearTransformation2.M[n3][n2];
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return linearTransformation3;
    }

    public static double[][] Minor(int n, int n2, double[][] dArray) {
        double[][] dArray2 = new double[dArray.length - 1][dArray.length - 1];
        int n3 = 0;
        while (n3 < dArray2.length) {
            int n4 = 0;
            while (n4 < dArray2.length) {
                dArray2[n3][n4] = n3 < n ? (n4 < n2 ? dArray[n3][n4] : dArray[n3][n4 + 1]) : (n4 < n2 ? dArray[n3 + 1][n4] : dArray[n3 + 1][n4 + 1]);
                ++n4;
            }
            ++n3;
        }
        return dArray2;
    }

    public static double Determinant(double[][] dArray) {
        if (dArray.length > 1) {
            double d = 0.0;
            double d2 = 1.0;
            int n = 0;
            while (n < dArray.length) {
                d += d2 * dArray[0][n] * LinearTransformation.Determinant(LinearTransformation.Minor(0, n, dArray));
                d2 = -d2;
                ++n;
            }
            return d;
        }
        return dArray[0][0];
    }

    public static double[][] inverse(double[][] dArray) throws Exception {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double d = LinearTransformation.Determinant(dArray);
        if (d == 0.0) {
            throw new Exception("Matrix not invertible");
        }
        double d2 = 1.0 / d;
        if (dArray.length > 1) {
            int n = 0;
            while (n < dArray.length) {
                double d3 = d2;
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray2[n][n2] = d3 * LinearTransformation.Determinant(LinearTransformation.Minor(n, n2, dArray));
                    d3 = -d3;
                    ++n2;
                }
                d2 = -d2;
                ++n;
            }
        } else {
            dArray2[0][0] = d2;
        }
        return dArray2;
    }

    public static R3[] inverse(R3[] r3Array) throws Exception {
        double[][] dArray = new double[3][3];
        int n = 0;
        while (n < 3) {
            dArray[n][0] = r3Array[n].x;
            dArray[n][1] = r3Array[n].y;
            dArray[n][2] = r3Array[n].z;
            ++n;
        }
        double[][] dArray2 = LinearTransformation.inverse(dArray);
        R3[] r3Array2 = new R3[3];
        int n2 = 0;
        while (n2 < 3) {
            r3Array2[n2] = new R3(dArray2[0][n2], dArray2[1][n2], dArray2[2][n2]);
            ++n2;
        }
        return r3Array2;
    }

    public static R3 apply(R3[] r3Array, R3 r3) {
        return new R3(r3Array[0].x * r3.x + r3Array[1].x * r3.y + r3Array[2].x * r3.z, r3Array[0].y * r3.x + r3Array[1].y * r3.y + r3Array[2].y * r3.z, r3Array[0].z * r3.x + r3Array[1].z * r3.y + r3Array[2].z * r3.z);
    }

    public static R3 solve(R3[] r3Array, R3 r3) throws Exception {
        return LinearTransformation.apply(LinearTransformation.inverse(r3Array), r3);
    }
}

