/*
 * Decompiled with CFR 0.152.
 */
package com.mja.img;

import com.mja.file.mjaFile;
import com.mja.util.Attribute;
import com.mja.util.BasicStr;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class mjaImage {
    private Color borderColorOut;
    private Color borderColorIn;
    private int borderSizeOut;
    private int borderSizeIn;
    private boolean visible = true;
    private String fileName;
    private String name = "";
    private Image ima;
    private Point location;
    private int w;
    private int h;
    private Applet A;
    private Color bgcolor = Color.white;
    private Color fgcolor = Color.black;

    public mjaImage(Applet applet) {
        this.A = applet;
        this.location = new Point(0, 0);
        this.fileName = "";
        this.ima = null;
    }

    public mjaImage(Applet applet, String string, int n) {
        this(applet);
        String string2 = Attribute.getValue(string, "IM_" + n);
        String[] stringArray = BasicStr.getElements(string2, ";,");
        if (stringArray != null && stringArray.length > 0) {
            this.fileName = stringArray[0];
            this.loadImage();
            if (stringArray.length > 1) {
                this.location.x = BasicStr.parseInteger(stringArray[1], 0, 0);
                if (stringArray.length > 2) {
                    this.location.y = BasicStr.parseInteger(stringArray[2], 0, 0);
                    if (stringArray.length > 3) {
                        this.name = stringArray[3];
                    }
                }
            }
        }
    }

    public void setBackground(Color color) {
        this.bgcolor = color;
    }

    public void setForeground(Color color) {
        this.fgcolor = color;
    }

    public void setImage(String string) {
        Font font = new Font("SansSerif", 0, 12);
        Graphics graphics = this.A.getGraphics();
        FontMetrics fontMetrics = this.A.getFontMetrics(font);
        this.w = fontMetrics.stringWidth(string) + 16;
        this.h = 24;
        this.ima = this.A.createImage(this.w, this.h);
        Graphics graphics2 = this.ima.getGraphics();
        graphics2.setColor(this.bgcolor);
        graphics2.fillRect(0, 0, this.w, this.h);
        graphics2.setColor(this.fgcolor);
        graphics2.drawString(string, 8, 16);
    }

    public void setImage(Image image) {
        this.ima = image;
        if (this.ima != null) {
            this.w = this.ima.getWidth(this.A);
            this.h = this.ima.getHeight(this.A);
        } else {
            this.w = 0;
            this.h = 0;
        }
    }

    public void loadImage() {
        try {
            this.ima = mjaFile.loadImage(this.A, this.fileName);
            if (this.ima != null) {
                this.w = this.ima.getWidth(this.A);
                this.h = this.ima.getHeight(this.A);
            } else {
                this.w = 0;
                this.h = 0;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception loading image: " + this.fileName);
        }
    }

    public Image getImage() {
        return this.ima;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setBorderColorOut(Color color) {
        this.borderColorOut = color;
    }

    public Color getBorderColorOut() {
        return this.borderColorOut;
    }

    public void setBorderColorIn(Color color) {
        this.borderColorIn = color;
    }

    public Color getBorderColorIn() {
        return this.borderColorIn;
    }

    public void setBorderSizeOut(int n) {
        this.borderSizeOut = n;
    }

    public int getBorderSizeOut() {
        return this.borderSizeOut;
    }

    public void setBorderSizeIn(int n) {
        this.borderSizeIn = n;
    }

    public int getBorderSizeIn() {
        return this.borderSizeIn;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(int n, int n2) {
        this.location.x = n;
        this.location.y = n2;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void paintBorder(Graphics graphics, Color color, int n, int n2) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        int n3 = n;
        int n4 = 1;
        if (n3 < 0) {
            n3 = -n3;
            n4 = -1;
        }
        int n5 = this.location.x + n2;
        int n6 = this.location.y + n2;
        int n7 = this.w - 2 * n2;
        int n8 = this.h - 2 * n2;
        while (n3 > 0) {
            graphics.drawRect(n5, n6, n7, n8);
            n5 += n4;
            n6 += n4;
            n7 -= n4 + n4;
            n8 -= n4 + n4;
            --n3;
        }
        graphics.setColor(color2);
    }

    public void draw(Graphics graphics, Component component) {
        if (this.ima != null) {
            if (this.isVisible()) {
                graphics.drawImage(this.ima, this.location.x, this.location.y, component);
            }
            if (this.borderColorOut != null && this.borderSizeOut != 0) {
                this.paintBorder(graphics, this.borderColorOut, this.borderSizeOut, 0);
            }
            if (this.borderColorIn != null && this.borderSizeIn != 0) {
                this.paintBorder(graphics, this.borderColorIn, this.borderSizeIn, this.borderSizeOut);
            }
        }
    }

    public static boolean equalImages(mjaImage[] mjaImageArray, mjaImage[] mjaImageArray2) {
        boolean bl = true;
        if (mjaImageArray == null && mjaImageArray2 != null || mjaImageArray2 == null && mjaImageArray != null || mjaImageArray.length != mjaImageArray2.length) {
            bl = false;
        } else {
            int n = 0;
            while (n < mjaImageArray.length) {
                if (mjaImageArray[n].getLocation().x != mjaImageArray2[n].getLocation().x || mjaImageArray[n].getLocation().y != mjaImageArray2[n].getLocation().y || !mjaImageArray[n].getFileName().equals(mjaImageArray2[n].getFileName())) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public static mjaImage[] cloneImages(Applet applet, mjaImage[] mjaImageArray) {
        mjaImage[] mjaImageArray2 = new mjaImage[mjaImageArray.length];
        int n = 0;
        while (n < mjaImageArray2.length) {
            mjaImageArray2[n] = new mjaImage(applet);
            mjaImageArray2[n].setFileName(mjaImageArray[n].getFileName());
            mjaImageArray2[n].setName(mjaImageArray[n].getName());
            mjaImageArray2[n].setLocation(mjaImageArray[n].getLocation().x, mjaImageArray[n].getLocation().y);
            ++n;
        }
        return mjaImageArray2;
    }
}

