/*
 * Decompiled with CFR 0.152.
 */
package com.mja.gui;

import com.mja.gui.mjaColor2;
import com.mja.lang.translator;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.image.ColorModel;

public class mjaColor {
    public static final Color DeepBlue = new Color(0x111166);
    public boolean variable;
    public String s_r;
    public String s_g;
    public String s_b;
    public String s_t;
    private Node Nr;
    private Node Ng;
    private Node Nb;
    private Node Nt;
    private Color fullColor;
    private Color adaptedColor;
    private int transp = 0;
    public static ColorModel cm;
    public static final Color[] namedColor;

    public mjaColor(Color color) {
        this(color, 0);
    }

    public mjaColor(Color color, int n) {
        int n2;
        this.transp = n;
        this.fullColor = color;
        if (color != null && cm != null && cm.getPixelSize() == 16) {
            n2 = 8 * (color.getRed() / 8);
            int n3 = 8 * (color.getGreen() / 8);
            int n4 = 8 * (color.getBlue() / 8);
            this.adaptedColor = new Color(n2, n3, n4);
        } else {
            this.adaptedColor = color;
        }
        if (color != null && BasicStr.isJava2() && n > 0) {
            n2 = 255 - n;
            this.adaptedColor = new Color(this.adaptedColor.getRed(), this.adaptedColor.getGreen(), this.adaptedColor.getBlue(), n2);
            this.fullColor = new Color(this.fullColor.getRed(), this.fullColor.getGreen(), this.fullColor.getBlue(), n2);
        }
        this.variable = false;
    }

    public mjaColor(float f, float f2, float f3, float f4) {
        this(new Color(mjaColor.bound(f), mjaColor.bound(f2), mjaColor.bound(f3)), (int)(255.0f * mjaColor.bound(f4)));
    }

    public mjaColor(int n, int n2, int n3, int n4) {
        this(new Color(mjaColor.bound(n), mjaColor.bound(n2), mjaColor.bound(n3)), mjaColor.bound(n4));
    }

    private mjaColor(String string, String string2, String string3, String string4) {
        this(Color.black, 0);
        this.variable = true;
        this.s_r = string;
        this.s_g = string2;
        this.s_b = string3;
        this.s_t = string4;
    }

    public static Color bestContrast(Color color) {
        if (color != null) {
            int n = color.getBlue() + color.getRed() + color.getGreen();
            if (n < 380) {
                return Color.white;
            }
            return Color.black;
        }
        return Color.black;
    }

    public int getTransp() {
        return this.transp;
    }

    public static Color scaleColor(float f, Color color) {
        if (BasicStr.isJava2()) {
            return mjaColor2.scaleColor(f, color);
        }
        return new Color(f * (float)color.getRed(), f * (float)color.getGreen(), f * (float)color.getBlue());
    }

    public static mjaColor make(String string, String string2, String string3, String string4) {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n = Integer.parseInt(string, 16);
            n2 = Integer.parseInt(string2, 16);
            n3 = Integer.parseInt(string3, 16);
            n4 = Integer.parseInt(string4, 16);
            return new mjaColor(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            return new mjaColor(string, string2, string3, string4);
        }
    }

    public void analyse(Parser parser) {
        if (this.variable) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                n = Integer.parseInt(this.s_r, 16);
                this.Nr = new Node((double)n / 255.0);
            }
            catch (NumberFormatException numberFormatException) {
                this.Nr = parser.Analyse(this.s_r, 0.0);
            }
            try {
                n2 = Integer.parseInt(this.s_g, 16);
                this.Ng = new Node((double)n2 / 255.0);
            }
            catch (NumberFormatException numberFormatException) {
                this.Ng = parser.Analyse(this.s_g, 0.0);
            }
            try {
                n3 = Integer.parseInt(this.s_b, 16);
                this.Nb = new Node((double)n3 / 255.0);
            }
            catch (NumberFormatException numberFormatException) {
                this.Nb = parser.Analyse(this.s_b, 0.0);
            }
            try {
                n4 = Integer.parseInt(this.s_t, 16);
                this.Nt = new Node((double)n4 / 255.0);
            }
            catch (NumberFormatException numberFormatException) {
                this.Nt = parser.Analyse(this.s_t, 0.0);
            }
        }
    }

    public Color getFullColor() {
        return this.fullColor;
    }

    public Color getAdaptedColor() {
        if (!this.variable) {
            return this.adaptedColor;
        }
        if (this.Nr != null && this.Ng != null && this.Nb != null) {
            if (BasicStr.isJava2() && this.Nt != null) {
                return mjaColor2.makeColor(mjaColor.bound((float)this.Nr.Evaluate(0.0)), mjaColor.bound((float)this.Ng.Evaluate(0.0)), mjaColor.bound((float)this.Nb.Evaluate(0.0)), mjaColor.bound((float)this.Nt.Evaluate(0.0)));
            }
            return new Color(mjaColor.bound((float)this.Nr.Evaluate(0.0)), mjaColor.bound((float)this.Ng.Evaluate(0.0)), mjaColor.bound((float)this.Nb.Evaluate(0.0)));
        }
        return Color.black;
    }

    static int bound(int n) {
        return Math.min(255, Math.max(0, n));
    }

    static float bound(float f) {
        return Math.min(1.0f, Math.max(0.0f, f));
    }

    public static String rgbHex(int n) {
        String string = Integer.toString(n, 16);
        while (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public static String getOnlyNamedColor(translator translator2, mjaColor mjaColor3) {
        if (mjaColor3 == null) {
            return "";
        }
        if (mjaColor3.variable) {
            return "";
        }
        if (mjaColor3.getFullColor() != null) {
            int n = 0;
            while (n < namedColor.length) {
                if (mjaColor3.getFullColor().equals(namedColor[n])) {
                    return translator2.getColorName(n);
                }
                ++n;
            }
        }
        return "";
    }

    public static String getColorName(translator translator2, mjaColor mjaColor3) {
        if (mjaColor3 == null) {
            return "";
        }
        if (mjaColor3.variable) {
            return "(" + mjaColor3.s_r + "," + mjaColor3.s_g + "," + mjaColor3.s_b + "," + mjaColor3.s_t + ")";
        }
        if (mjaColor3.getFullColor() != null) {
            int n = 0;
            while (n < namedColor.length) {
                if (mjaColor3.getFullColor().equals(namedColor[n])) {
                    return translator2.getColorName(n);
                }
                ++n;
            }
            Color color = mjaColor3.getFullColor();
            String string = mjaColor.rgbHex(color.getRed()) + mjaColor.rgbHex(color.getGreen()) + mjaColor.rgbHex(color.getBlue());
            if (mjaColor3.transp > 0) {
                string = mjaColor.rgbHex(mjaColor3.transp) + string;
            }
            return string;
        }
        return "";
    }

    public static mjaColor parseColor(String string, mjaColor mjaColor3, mjaColor mjaColor4) {
        return mjaColor.parseColor(-1, string, mjaColor3, mjaColor4);
    }

    public static mjaColor parseColor(int n, String string, mjaColor mjaColor3, mjaColor mjaColor4) {
        if (BasicStr.hasContent(string)) {
            int n2;
            if (n >= 0) {
                n2 = 0;
                while (n2 < translator.colorName[n].length) {
                    if (string.equalsIgnoreCase(translator.colorName[n][n2])) {
                        return new mjaColor(namedColor[n2], 0);
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < 5) {
                int n3 = 0;
                while (n3 < translator.colorName[n2].length) {
                    if (string.equalsIgnoreCase(translator.colorName[n2][n3])) {
                        return new mjaColor(namedColor[n3], 0);
                    }
                    ++n3;
                }
                ++n2;
            }
            try {
                long l = Long.parseLong(string, 16);
                int n4 = (int)(l / 0x1000000L);
                return new mjaColor(new Color((int)(l %= 0x1000000L)), n4);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    String[] stringArray = BasicStr.getTokens(string);
                    if (stringArray.length == 4) {
                        return new mjaColor(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
                    }
                    if (stringArray.length == 3) {
                        return new mjaColor(stringArray[0], stringArray[1], stringArray[2], "0.0");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return mjaColor3;
            }
        }
        return mjaColor4;
    }

    static {
        namedColor = new Color[]{Color.black, Color.magenta, Color.blue, Color.cyan, Color.green, Color.yellow, Color.orange, Color.red, Color.pink, Color.darkGray, Color.gray, Color.lightGray, Color.white};
    }
}

