/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descgui;

import com.mja.descartes.Descartes;
import com.mja.descgui.NumericControl;
import com.mja.gui.mjaText;
import com.mja.util.BasicStr;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

public class ScrollBarControl
extends NumericControl
implements AdjustmentListener {
    private Scrollbar sb;
    private boolean vertical;
    private volatile boolean updating = false;

    public ScrollBarControl(Descartes descartes, String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, boolean bl2, String string8, boolean bl3) {
        this.vertical = bl3;
        this.sb = bl3 ? new Scrollbar(1, 0, 10, 0, 110) : new Scrollbar(0, 0, 10, 0, 110);
        if (BasicStr.osIsWindows()) {
            this.sb.setFont(mjaText.SansSerif);
        } else {
            this.sb.setFont(mjaText.SansSerif_11);
        }
        this.init(descartes, string, string2, string3, bl, string4, string5, string6, string7, bl2, string8);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (bl3) {
            int n = 0;
            if (bl2) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagLayout.setConstraints(this.TF, gridBagConstraints);
                this.add(this.TF);
            }
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.sb, gridBagConstraints);
            this.add(this.sb);
            n += 3;
            if (BasicStr.hasContent(this.getTitle())) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagLayout.setConstraints(this.lb, gridBagConstraints);
                this.add(this.lb);
            }
        } else {
            int n = 0;
            if (BasicStr.hasContent(this.getTitle())) {
                gridBagConstraints.gridx = n++;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(this.lb, gridBagConstraints);
                this.add(this.lb);
            }
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.sb, gridBagConstraints);
            this.add(this.sb);
            n += 3;
            if (bl2) {
                gridBagConstraints.gridx = n++;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(this.TF, gridBagConstraints);
                this.add(this.TF);
            }
        }
        this.sb.addAdjustmentListener(this);
        this.sb.addMouseListener(this);
    }

    public void updateVisualComponent() {
        this.TF.setText(this.getStringValue());
        int n = 0;
        if (this.getMin() < this.getMax()) {
            n = (int)Math.round((this.getDoubleValue() - this.getMin()) / (this.getMax() - this.getMin()) * 100.0);
        }
        if (this.vertical) {
            n = 100 - n;
        }
        if (this.sb.getValue() != n && (double)Math.abs(this.sb.getValue() - n) * (this.getMax() - this.getMin()) > 50.0) {
            this.sb.setValue(n);
        }
    }

    private boolean isUpdating() {
        return this.updating;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.sb && !this.isUpdating()) {
            this.updating = true;
            double d = this.sb.getValue();
            if (this.vertical) {
                d = 100.0 - d;
            }
            this.D.updateSpinners(this, true);
            this.defineValue(this.getMin() + (this.getMax() - this.getMin()) * d / 100.0);
            this.D.updateSpinners(this, false);
            this.executeAction();
            this.callListeners("");
            this.updating = false;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
    }
}

