/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descgui;

import com.mja.descartes.Action;
import com.mja.descartes.Descartes;
import com.mja.descgui.mjaGui;
import com.mja.descutil.mjaStr;
import com.mja.gui.mjaText;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;

public abstract class NumericControl
extends Panel
implements MouseListener,
KeyListener {
    Label lb;
    TextField TF = new TextField(3);
    public static final double minDouble = -1.7976931348623157E308;
    public static final double maxDouble = Double.MAX_VALUE;
    Descartes D;
    private Parser parser;
    private BigDecimal V;
    private BigDecimal dV0;
    private double v0;
    private double dv0;
    private Node var;
    private Node dvN;
    private Node pvN;
    private Node minN;
    private Node maxN;
    private Node xN;
    private Node yN;
    private Node wN;
    private Node hN;
    private int p0;
    private Node notexp;
    private boolean fixed;
    private boolean discrete;
    private boolean interior;
    private String title;
    private String explanation;
    private String tooltip;
    private String more;
    private String space;
    private Vector listeners = new Vector();
    private Action a;
    String s_p;
    String s_v;
    String s_vincr;
    String s_vmin;
    String s_vmax;
    String s_notexp;
    private Font expl_f;
    private Font tooltip_f;
    private long T = 0L;

    public abstract void updateVisualComponent();

    void init(Descartes descartes, String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, boolean bl2, String string8) {
        this.D = descartes;
        this.s_p = string3;
        this.fixed = bl;
        this.s_v = string4;
        this.s_vincr = string5;
        this.s_vmin = string6;
        this.s_vmax = string7;
        this.s_notexp = string8;
        this.title = string;
        this.lb = new Label(this.getTitle());
        this.lb.setAlignment(1);
        this.lb.setBackground(Color.lightGray);
        this.lb.setForeground(Color.black);
        this.lb.setAlignment(1);
        this.lb.addMouseListener(this);
        if (BasicStr.osIsWindows()) {
            this.setFont(mjaText.Courier);
            this.lb.setFont(mjaText.Courier);
            this.TF.setFont(mjaText.Courier);
        } else {
            this.setFont(mjaText.Courier_11);
            this.lb.setFont(mjaText.Courier_11);
            this.TF.setFont(mjaText.Courier_11);
        }
        this.TF.addKeyListener(this);
        this.TF.setBackground(Color.white);
        this.TF.setForeground(Color.black);
        this.TF.addMouseListener(this);
        if (!bl2) {
            this.TF.setVisible(false);
        }
        this.setName(string2);
        this.var = descartes.p.Var(this.getName());
        this.reinitialize();
        this.addActionListener(descartes);
    }

    public void reinitialize() {
        this.pvN = this.D.p.Analyse(this.s_p, 2.0);
        this.notexp = this.D.p.Analyse(this.s_notexp, 0.0);
        if (this.pvN.isANumber()) {
            this.p0 = Math.max(0, (int)Math.round(this.pvN.Evaluate(2.0)));
            this.pvN = null;
        }
        this.dvN = this.D.p.Analyse(this.s_vincr, 0.1);
        if (this.dvN.isANumber()) {
            try {
                this.dV0 = new BigDecimal(this.s_vincr);
            }
            catch (Exception exception) {
                this.dV0 = new BigDecimal(0.1);
            }
            this.dv0 = this.dV0.doubleValue();
            this.dvN = null;
        }
        this.minN = this.D.p.Analyse(this.s_vmin, -1.7976931348623157E308);
        this.maxN = this.D.p.Analyse(this.s_vmax, Double.MAX_VALUE);
        this.V = new BigDecimal(0.0);
        this.defineValue(this.s_v);
        this.v0 = this.V.doubleValue();
    }

    public void setDescartes(Descartes descartes) {
        this.D = descartes;
    }

    public void setAction(String string, String string2, Font font, int n) {
        this.a = BasicStr.hasContent(string) ? new Action(this.D, "control='" + this.getName() + "'", string, string2, font, n) : null;
    }

    public void executeAction() {
        if (this.a != null) {
            this.a.execute();
        }
    }

    public Action getAction() {
        return this.a;
    }

    public void setInterior(boolean bl) {
        this.interior = bl;
    }

    public void setNodeBounds(Node node, Node node2, Node node3, Node node4) {
        this.xN = node;
        this.yN = node2;
        this.wN = node3;
        this.hN = node4;
    }

    public void locate() {
        if (this.isInterior() && this.xN != null && this.yN != null && this.wN != null && this.hN != null) {
            double d;
            double d2 = this.wN.Evaluate(100.0);
            if (d2 > (d = this.hN.Evaluate(23.0))) {
                d *= BasicStr.osScaling();
            } else {
                d2 *= BasicStr.osScaling();
            }
            this.setBounds((int)Math.round(this.xN.Evaluate(0.0)), (int)Math.round(this.yN.Evaluate(0.0)), (int)Math.round(d2), (int)Math.round(d));
        }
    }

    public void setSpace(String string) {
        this.space = string;
    }

    public boolean isInterior() {
        return this.interior;
    }

    public String getSpace() {
        return this.space;
    }

    public void setTitle(String string) {
        this.title = string;
        this.lb.setText(string);
    }

    public String getTitle() {
        return this.title;
    }

    public void setDiscrete(boolean bl) {
        this.discrete = bl;
    }

    public void setExplanation(String string, Font font) {
        this.explanation = string;
        this.expl_f = font;
    }

    public void setTooltip(String string, String string2, Font font) {
        this.tooltip = string;
        this.tooltip_f = font;
        this.more = string2;
        if (!BasicStr.hasContent(this.explanation)) {
            this.explanation = string;
        }
    }

    public void updateFromNode() {
        this.setValue(new BigDecimal(this.var.r));
        this.updateVisualComponent();
    }

    public void getTextValue() {
        this.defineValue(this.TF.getText());
    }

    public String getStringValue(double d) {
        int n = this.p0;
        if (this.pvN != null) {
            n = Math.max(0, (int)Math.round(this.pvN.Evaluate(2.0)));
        }
        if (this.notexp.Evaluate(0.0) > 0.0) {
            return mjaStr.notExp(d, n);
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        return BasicStr.BigDecimalToString(bigDecimal, n, this.fixed);
    }

    public String getStringValue() {
        int n = this.p0;
        if (this.pvN != null) {
            n = Math.max(0, (int)Math.round(this.pvN.Evaluate(2.0)));
        }
        if (this.notexp.Evaluate(0.0) > 0.0) {
            return mjaStr.notExp(this.var.r, n);
        }
        return BasicStr.BigDecimalToString(this.V, n, this.fixed);
    }

    public double getDoubleValue() {
        return this.var.r;
    }

    public void defineValue(double d) {
        this.defineValue(Double.toString(d));
    }

    public void defineValue(String string) {
        BigDecimal bigDecimal;
        block6: {
            bigDecimal = this.V;
            try {
                bigDecimal = new BigDecimal(string);
                if (this.discrete) {
                    bigDecimal = new BigDecimal(this.v0 + this.dv0 * (double)Math.round((bigDecimal.doubleValue() - this.v0) / this.dv0));
                }
            }
            catch (Exception exception) {
                if (!BasicStr.hasContent(string)) break block6;
                try {
                    Node node = this.D.p.Analyse(string, false);
                    double d = node.Evaluate();
                    if (this.discrete) {
                        d = this.v0 + this.dv0 * (double)Math.round((bigDecimal.doubleValue() - this.v0) / this.dv0);
                    }
                    bigDecimal = new BigDecimal(d);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        this.setValue(bigDecimal);
        this.updateVisualComponent();
    }

    public void step(boolean bl) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = this.dV0;
        if (this.dvN != null) {
            bigDecimal2 = new BigDecimal(this.dvN.Evaluate(0.01));
        }
        BigDecimal bigDecimal3 = this.V;
        if (bl) {
            BigDecimal bigDecimal4;
            if ((bigDecimal3 = bigDecimal3.add(bigDecimal2)).compareTo(bigDecimal4 = new BigDecimal(this.maxN.Evaluate(Double.MAX_VALUE))) > 0) {
                Toolkit.getDefaultToolkit().beep();
                bigDecimal3 = bigDecimal4;
            }
        } else if ((bigDecimal3 = bigDecimal3.subtract(bigDecimal2)).compareTo(bigDecimal = new BigDecimal(this.minN.Evaluate(-1.7976931348623157E308))) < 0) {
            Toolkit.getDefaultToolkit().beep();
            bigDecimal3 = bigDecimal;
        }
        this.setValue(bigDecimal3);
        this.updateFromNode();
    }

    public double getMin() {
        return this.minN.Evaluate(-1.7976931348623157E308);
    }

    public double getMax() {
        return this.maxN.Evaluate(Double.MAX_VALUE);
    }

    public double getIncr() {
        return this.dV0.doubleValue();
    }

    private void setValue(BigDecimal bigDecimal) {
        this.V = bigDecimal;
        BigDecimal bigDecimal2 = new BigDecimal(this.minN.Evaluate(-1.7976931348623157E308));
        BigDecimal bigDecimal3 = new BigDecimal(this.maxN.Evaluate(Double.MAX_VALUE));
        if (this.V.compareTo(bigDecimal2) < 0) {
            this.V = bigDecimal2;
        }
        if (this.V.compareTo(bigDecimal3) > 0) {
            this.V = bigDecimal3;
        }
        this.var.r = this.V.doubleValue();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    void callListeners(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 9) {
            this.D.updateSpinners(this, true);
            this.defineValue(this.TF.getText());
            this.D.updateSpinners(this, false);
            this.executeAction();
            this.callListeners("");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if ((mouseEvent.getSource() == this.lb || mouseEvent.getSource() instanceof Button) && BasicStr.hasContent(this.tooltip) && this.T < System.currentTimeMillis() - 6000L) {
            mjaGui.showTooltip(this.D, (Component)mouseEvent.getSource(), this.tooltip, this.more, this.tooltip_f);
            this.T = System.currentTimeMillis();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.T = 0L;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4 && BasicStr.hasContent(this.explanation)) {
            mjaText.msg((Component)mouseEvent.getSource(), this.getTitle(), this.explanation, this.expl_f);
        }
    }
}

