/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descedit;

import com.mja.gui.editDialog;
import com.mja.gui.mjaText;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class editTextDialog
extends editDialog
implements ItemListener {
    private static final Font defFont = new Font("Helvetica", 0, 12);
    private static final Font Courier = new Font("Courier", 0, 12);
    private static final Font FontItalic = new Font("Courier", 2, 24);
    private static final Font FontBold = new Font("Courier", 1, 24);
    private static final String[] fNames = new String[]{"Helvetica", "TimesRoman", "Courier"};
    private CheckboxGroup cbgName;
    private Checkbox[] cbName;
    private Checkbox cbItalic;
    private Checkbox cbBold;
    private Choice chSize;
    private Font font;
    private TextArea TA = new TextArea(8, 48);

    public editTextDialog(Frame frame, String string, boolean bl, String string2, String string3) {
        super(frame, string, bl, string2, string3);
        this.add("Center", this.TA);
        this.font = mjaText.Courier;
        this.TA.setFont(this.font);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        this.add("North", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(fNames.length, 1));
        this.cbgName = new CheckboxGroup();
        this.cbName = new Checkbox[fNames.length];
        int n = 0;
        while (n < this.cbName.length) {
            this.cbName[n] = new Checkbox(fNames[n], this.cbgName, false);
            panel2.add(this.cbName[n]);
            ++n;
        }
        panel.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 1));
        this.cbItalic = new Checkbox("K");
        panel3.add(this.cbItalic);
        this.cbBold = new Checkbox("N");
        panel3.add(this.cbBold);
        panel.add(panel3);
        this.chSize = new Choice();
        panel.add(this.chSize);
        int n2 = 6;
        while (n2 < 16) {
            this.chSize.addItem(String.valueOf(n2));
            ++n2;
        }
        int n3 = 16;
        while (n3 < 32) {
            this.chSize.addItem(String.valueOf(n3));
            n3 += 2;
        }
        int n4 = 32;
        while (n4 <= 80) {
            this.chSize.addItem(String.valueOf(n4));
            n4 += 4;
        }
        int n5 = 0;
        while (n5 < this.cbName.length) {
            this.cbName[n5].addItemListener(this);
            this.cbName[n5].setFont(Courier);
            ++n5;
        }
        this.cbItalic.addItemListener(this);
        this.cbItalic.setFont(FontItalic);
        this.cbBold.addItemListener(this);
        this.cbBold.setFont(FontBold);
        this.chSize.addItemListener(this);
        this.chSize.setFont(Courier);
        this.updateAll();
    }

    public Font getSelectedFont() {
        return this.font;
    }

    public void setSelectedFont(Font font) {
        this.font = font;
        this.updateAll();
    }

    public void setText(String string) {
        this.TA.setText(string);
    }

    public String getText() {
        return this.TA.getText();
    }

    private void updateAll() {
        this.cbgName.setSelectedCheckbox(this.cbName[0]);
        int n = 0;
        while (n < this.cbName.length) {
            if (this.cbName[n].getLabel().equals(this.font.getName())) {
                this.cbgName.setSelectedCheckbox(this.cbName[n]);
                break;
            }
            ++n;
        }
        this.cbItalic.setState(this.font.isItalic());
        this.cbBold.setState(this.font.isBold());
        this.chSize.select(String.valueOf(this.font.getSize()));
        this.TA.setFont(this.font);
    }

    private String selectedName() {
        Checkbox checkbox = this.cbgName.getSelectedCheckbox();
        int n = 0;
        while (n < this.cbName.length) {
            if (this.cbName[n] == checkbox) {
                return this.cbName[n].getLabel();
            }
            ++n;
        }
        return this.cbName[0].getLabel();
    }

    private int selectedStyle() {
        int n = 0;
        if (this.cbItalic.getState()) {
            n += 2;
        }
        if (this.cbBold.getState()) {
            ++n;
        }
        return n;
    }

    private int selectedSize() {
        return Integer.parseInt(this.chSize.getSelectedItem());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.font = new Font(this.selectedName(), this.selectedStyle(), this.selectedSize());
        this.TA.setFont(this.font);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.setSelectedFont(this.getSelectedFont());
        super.windowActivated(windowEvent);
    }
}

