/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.SpaceR2;
import com.mja.descartes.graphR2Config;
import com.mja.descartes.imageThread;
import com.mja.descartes.parametrization;
import com.mja.descgui.mjaGui;
import com.mja.file.mjaFile;
import com.mja.gui.mjaColor;
import com.mja.math.R2;
import com.mja.math.R2Newton;
import com.mja.parser.Node;
import com.mja.poly.Face;
import com.mja.text.MathText;
import com.mja.text.TFont;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.TextField;
import java.util.StringTokenizer;

public class mjaGraph {
    Descartes D;
    graphR2Config gc;
    int size = 2;
    parametrization sparz;
    TextField TF;
    imageThread ith;
    Image image;
    private static final double dosPi = Math.PI * 2;
    private static final double Pim = 1.5707963267948966;
    private static final double MAX_INT = 32767.0;
    private static final double epsilon = 1.0E-4;
    private static final int segment = 0;
    private static final int equation = 1;
    private static final int curve = 2;
    private static final int sequence = 3;
    private static final int line = 4;
    private static final int conic = 5;
    private static final int funcOfX = 6;
    private static final int funcOfY = 7;
    private int eqType;
    private int width = -1;
    private int arrow_width = -1;
    private int spear = -1;
    private Node decimals;
    private Node cond;
    private parametrization tparz;
    private MathText mthtxt;
    private static final String[] lineEq = new String[]{"y=m*x+b", "x=m*y+a", "A*x+B*y=C"};
    private static final String[] conicEq = new String[]{"e=sqrt((x-Fx)^2+(y-Fy)^2)/(d+(x-Fx)*cos(t)+(y-Fy)*sen(t))", "e=sqrt((x-Fx)^2+(y-Fy)^2)/(d-((x-Fx)*(Dx-Fx)+(y-Fy)*(Dy-Fy))/d)"};
    private Node F;
    private Node fx;
    private Node fy;
    private int caso;
    private int w;
    private int h;
    private int Fx;
    private int Fy;
    private int x;
    private int y;
    private int z;
    private int dx;
    private int zx;
    private int zxx;
    private int dy;
    private int zy;
    private int zyy;
    private int zxy;
    private Node x1;
    private Node y1;
    private Node x2;
    private Node y2;
    private Node r;
    private Node aN;
    private Node daN;
    private Node Si;
    private Node Sf;
    private Node iniX;
    private Node iniY;
    private Node iniRot;
    private Node[] xNa;
    private Node[] yNa;
    SpaceR2 cs;
    private double X0;
    private double Y0;
    private double X1;
    private double Y1;
    private double XR;
    private double YR;
    private double X1R;
    private double Y1R;
    private double A;
    private double Xini;
    private double Yini;
    private double Cini;
    private double Sini;
    static final int netsz = 8;

    public mjaGraph(Descartes descartes, int n) {
        Space space;
        this.D = descartes;
        this.gc = descartes.cfg.allgR2c[n];
        if (this.gc.type != 61 && this.gc.type != 62 && this.gc.type != 28 && this.gc.type != 66) {
            this.image = mjaFile.loadImage(descartes, this.gc.file);
            this.eqType = 0;
        }
        if ((space = descartes.scene.getSpace(0, this.gc.parentSpace)) instanceof SpaceR2) {
            this.cs = (SpaceR2)space;
        }
    }

    void initialize() {
        this.gc.analyseColors(this.D.p);
        if (this.cs != null) {
            String[] stringArray;
            this.cond = this.D.p.Analyse(this.gc.cond, "1");
            this.decimals = this.D.p.Analyse(this.gc.s_decimals, 2.0);
            this.mthtxt = new MathText(this.D.p, this.D.Tr, this.gc.text, this.decimals, this.gc.fixed, this.gc.font, this.gc.gcolor.getAdaptedColor());
            this.size = BasicStr.parseInteger(this.gc.s_size, 2, 2);
            this.width = BasicStr.parseInteger(this.gc.s_width, 1, 1);
            this.arrow_width = BasicStr.parseInteger(this.gc.s_arrow_w, 1, 1);
            this.spear = BasicStr.parseInteger(this.gc.s_spear, 5, this.spear);
            if (this.gc.isFamily) {
                this.sparz = new parametrization(this.D.p, this.gc.fparam, this.gc.f_interval, this.gc.f_steps);
            }
            if (BasicStr.hasContent(this.gc.parameter)) {
                this.tparz = new parametrization(this.D.p, this.gc.parameter, this.gc.p_interval, this.gc.p_steps);
            }
            if (this.gc.type == 61 || this.gc.type == 62 || this.gc.type == 28) {
                this.analyse();
            } else if (this.gc.type == 66) {
                this.eqType = 0;
                this.xNa = new Node[1];
                this.yNa = new Node[1];
                try {
                    stringArray = BasicStr.getTokens(this.gc.s_center);
                    this.xNa[0] = this.D.p.Analyse(stringArray[0]);
                    this.yNa[0] = this.D.p.Analyse(stringArray[1]);
                }
                catch (Exception exception) {
                    System.out.println("bad expression " + this.gc.s_center);
                }
                this.r = this.D.p.Analyse(this.gc.s_radius);
                if (this.gc.s_ini.startsWith("[") || this.gc.s_ini.startsWith("(")) {
                    try {
                        stringArray = BasicStr.getTokens(this.gc.s_ini);
                        this.x1 = this.D.p.Analyse(stringArray[0]);
                        this.y1 = this.D.p.Analyse(stringArray[1]);
                        stringArray = BasicStr.getTokens(this.gc.s_end);
                        this.x2 = this.D.p.Analyse(stringArray[0]);
                        this.y2 = this.D.p.Analyse(stringArray[1]);
                    }
                    catch (Exception exception) {
                        System.out.println("bad expression " + this.gc.s_center);
                    }
                } else {
                    this.aN = this.D.p.Analyse(this.gc.s_ini);
                    this.daN = this.D.p.Analyse("(" + this.gc.s_end + ")-(" + this.gc.s_ini + ")");
                }
            } else {
                this.eqType = 0;
                try {
                    stringArray = BasicStr.getTokens(this.gc.formula);
                    int n = stringArray.length / 2;
                    int n2 = 0;
                    this.xNa = new Node[n];
                    this.yNa = new Node[n];
                    int n3 = 0;
                    while (n3 < n) {
                        this.xNa[n3] = this.D.p.Analyse(stringArray[n2++]);
                        this.yNa[n3] = this.D.p.Analyse(stringArray[n2++]);
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    System.out.println("bad expression " + this.gc.formula);
                }
            }
            try {
                stringArray = BasicStr.getTokens(this.gc.s_location);
                if (stringArray.length == 2) {
                    this.iniX = this.D.p.Analyse(stringArray[0]);
                    this.iniY = this.D.p.Analyse(stringArray[1]);
                }
                this.iniRot = this.D.p.Analyse(this.gc.s_rotation);
            }
            catch (Exception exception) {
                System.out.println("bad expression " + this.gc.s_location);
            }
        }
    }

    void analyse() {
        block17: {
            if (this.cs != null) {
                if (this.gc.type != 61) {
                    try {
                        String[] stringArray = BasicStr.getTokens(this.gc.formula);
                        int n = 0;
                        if (stringArray.length <= 1) break block17;
                        if (this.gc.type == 28) {
                            this.eqType = 3;
                            this.Si = this.D.p.Analyse("1");
                            this.Sf = this.D.p.Analyse("100");
                            try {
                                String[] stringArray2 = BasicStr.getTokens(this.gc.seqRange);
                                int n2 = 0;
                                if (stringArray2.length > 1) {
                                    this.Si = this.D.p.Analyse(stringArray2[n2++].trim());
                                    this.Sf = this.D.p.Analyse(stringArray2[n2++].trim());
                                }
                            }
                            catch (Exception exception) {}
                        } else {
                            this.eqType = 2;
                        }
                        this.fx = this.D.p.Analyse(stringArray[n++]);
                        this.fy = this.D.p.Analyse(stringArray[n++]);
                        return;
                    }
                    catch (Exception exception) {}
                } else {
                    int n = 0;
                    while (n < lineEq.length) {
                        if (this.gc.formula.equals(lineEq[n])) {
                            this.eqType = 4;
                            return;
                        }
                        ++n;
                    }
                    int n3 = 0;
                    while (n3 < conicEq.length) {
                        if (this.gc.formula.equals(conicEq[n3])) {
                            this.eqType = 5;
                            return;
                        }
                        ++n3;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(this.gc.formula, "=");
                    String string = stringTokenizer.nextToken();
                    if (string.equals("y") || string.equals("x")) {
                        this.F = this.D.p.Analyse(this.gc.formula.substring(this.gc.formula.indexOf(61) + 1, this.gc.formula.length()).trim());
                        if (string.equals("y") && !this.F.contains("y")) {
                            this.eqType = 6;
                            return;
                        }
                        if (string.equals("x") && !this.F.contains("x")) {
                            this.eqType = 7;
                            return;
                        }
                    }
                    this.eqType = 1;
                }
            }
        }
    }

    private R2 TR(R2 r2) {
        return new R2(this.Xini + this.Cini * r2.x - this.Sini * r2.y, this.Yini + this.Sini * r2.x + this.Cini * r2.y);
    }

    void draw(Image image, Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        if (this.cs != null) {
            if (this.cond.Evaluate(1.0) < 1.0 && this.ith != null) {
                this.ith.pleaseStop();
                this.ith = null;
            }
            if (this.cond.Evaluate(1.0) > 0.0 || this.eqType == 6 || this.eqType == 7) {
                int n = 0;
                while (n < graphicsArray.length) {
                    graphicsArray[n].setColor(mjaColorArray[n].getAdaptedColor());
                    ++n;
                }
                if (this.iniX != null && this.iniY != null) {
                    this.Xini = this.iniX.Evaluate(0.0);
                    this.Yini = this.iniY.Evaluate(0.0);
                } else {
                    this.Xini = 0.0;
                    this.Yini = 0.0;
                }
                if (this.iniRot != null) {
                    this.A = this.iniRot.Evaluate(0.0);
                    this.Cini = Math.cos(Math.PI * this.A / 180.0);
                    this.Sini = Math.sin(Math.PI * this.A / 180.0);
                } else {
                    this.A = 0.0;
                    this.Cini = 1.0;
                    this.Sini = 0.0;
                }
                if (this.xNa != null && this.xNa.length > 0 && this.xNa[0] != null && this.yNa[0] != null) {
                    this.X0 = this.xNa[0].Evaluate(0.0);
                    this.Y0 = this.yNa[0].Evaluate(0.0);
                } else {
                    this.X0 = 0.0;
                    this.Y0 = 0.0;
                }
                if (this.xNa != null && this.xNa.length > 1 && this.xNa[1] != null && this.yNa[1] != null) {
                    this.X1 = this.xNa[1].Evaluate(0.0);
                    this.Y1 = this.yNa[1].Evaluate(0.0);
                } else {
                    this.X1 = 0.0;
                    this.Y1 = 0.0;
                }
                this.XR = this.Xini + this.Cini * this.X0 - this.Sini * this.Y0;
                this.YR = this.Yini + this.Sini * this.X0 + this.Cini * this.Y0;
                this.X1R = this.Xini + this.Cini * this.X1 - this.Sini * this.Y1;
                this.Y1R = this.Yini + this.Sini * this.X1 + this.Cini * this.Y1;
                switch (this.eqType) {
                    case 0: {
                        this.drawSegment(image, graphicsArray);
                        break;
                    }
                    case 2: {
                        this.drawCurve(graphicsArray, mjaColorArray);
                        break;
                    }
                    case 3: {
                        this.drawSequence(graphicsArray, mjaColorArray);
                        break;
                    }
                    case 4: {
                        this.drawLine(graphicsArray);
                        break;
                    }
                    case 5: {
                        this.drawConic(graphicsArray);
                        break;
                    }
                    case 6: {
                        this.drawFunctionOfx(graphicsArray, mjaColorArray);
                        break;
                    }
                    case 7: {
                        this.drawFunctionOfy(graphicsArray, mjaColorArray);
                        break;
                    }
                    case 1: {
                        this.drawEquation(graphicsArray, mjaColorArray);
                    }
                }
            }
        }
    }

    static void Arc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 < 0) {
            n5 += n6;
            n6 = -n6;
        }
        if (n == 1) {
            graphics.drawArc(n2 - n4, n3 - n4, 2 * n4, 2 * n4, n5, n6);
        } else if (n > 1) {
            double d = Math.PI / 180;
            double d2 = (double)n5 * d;
            int n7 = n2 + (int)Math.round((double)n4 * Math.cos(d2));
            int n8 = n3 - (int)Math.round((double)n4 * Math.sin(d2));
            int n9 = 1;
            while (n9 <= n6) {
                int n10 = n2 + (int)Math.round((double)n4 * Math.cos(d2));
                int n11 = n3 - (int)Math.round((double)n4 * Math.sin(d2));
                d2 += d;
                Face.Line(graphics, n, n7, n8, n10, n11);
                n7 = n10;
                n8 = n11;
                ++n9;
            }
        }
    }

    static void circle(Graphics graphics, int n, int n2, double d) {
        if (d > 0.0) {
            if (d > 1.4) {
                graphics.fillOval(n - (int)Math.round(d), n2 - (int)Math.round(d), (int)Math.round(2.0 * d), (int)Math.round(2.0 * d));
            } else {
                graphics.drawLine(n, n2, n, n2);
            }
        }
    }

    static void drawPolygon(Graphics[] graphicsArray, int n, Polygon polygon, boolean bl, Color color) {
        int n2;
        if (bl) {
            n2 = 0;
            while (n2 < graphicsArray.length) {
                Color color2 = graphicsArray[n2].getColor();
                graphicsArray[n2].setColor(color);
                graphicsArray[n2].fillPolygon(polygon);
                graphicsArray[n2].setColor(color2);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < graphicsArray.length) {
            int n3 = 1;
            while (n3 < polygon.npoints) {
                Face.Line(graphicsArray[n2], n, polygon.xpoints[n3 - 1], polygon.ypoints[n3 - 1], polygon.xpoints[n3], polygon.ypoints[n3]);
                ++n3;
            }
            ++n2;
        }
    }

    void drawSegment(Image image, Graphics[] graphicsArray) {
        if (this.gc.type == 66) {
            this.drawArc(graphicsArray);
        } else if (this.xNa.length <= 2) {
            R2 r2;
            R2 r22 = new R2(0.0, 0.0);
            try {
                int n;
                R2 r23 = r2 = new R2(this.XR, this.YR);
                if (this.gc.type == 65 || this.gc.type == 46) {
                    r23 = new R2(this.X1R, this.Y1R);
                }
                r2 = this.cs.projection(r2, this.gc.absCoor);
                r23 = this.cs.projection(r23, this.gc.absCoor);
                if (this.gc.type == 68) {
                    n = 0;
                    while (n < graphicsArray.length) {
                        if (this.gc.isAnimated(this.D.Tr)) {
                            if (this.ith == null) {
                                this.ith = new imageThread(graphicsArray[n], this.image, this.cs, this.gc.getAnimFreq());
                            }
                            this.ith.setPos(r2.ix(), r2.iy());
                        }
                        graphicsArray[n].drawImage(this.image, r2.ix(), r2.iy(), this.cs);
                        ++n;
                    }
                } else if (this.gc.type != 46 && (r2.ix() != r23.ix() || r2.iy() != r23.iy())) {
                    n = 0;
                    while (n < graphicsArray.length) {
                        Face.Line(graphicsArray[n], this.width, r2.ix(), r2.iy(), r23.ix(), r23.iy());
                        ++n;
                    }
                }
                if (this.gc.type != 63 && this.size > 0) {
                    if (this.gc.type == 46) {
                        n = 0;
                        while (n < graphicsArray.length) {
                            this.drawArrow(graphicsArray[n], this.gc.arrowColor.getAdaptedColor(), this.gc.gcolor.getAdaptedColor(), r2.ix(), r2.iy(), r23.ix(), r23.iy(), this.arrow_width, this.spear);
                            ++n;
                        }
                    } else if (this.gc.type == 43) {
                        n = r2.ix();
                        int n2 = r2.iy();
                        int n3 = this.cs.getSize().width;
                        int n4 = this.cs.getSize().height;
                        if (0 <= n && 0 <= n2 && n < n3 && n2 < n4) {
                            int[] nArray = mjaGui.grabPixelsFromImage(n3, n4, image);
                            mjaGui.fillShape(graphicsArray, nArray, n3, n4, n, n2);
                        }
                    } else if (this.gc.type != 68) {
                        n = 0;
                        while (n < graphicsArray.length) {
                            if (this.cs.inside(r2)) {
                                mjaGraph.circle(graphicsArray[n], r2.ix(), r2.iy(), this.size);
                            }
                            if ((r2.ix() != r23.ix() || r2.iy() != r23.iy()) && this.cs.inside(r23)) {
                                mjaGraph.circle(graphicsArray[n], r23.ix(), r23.iy(), this.size);
                            }
                            ++n;
                        }
                    }
                }
                r22 = new R2((2 * r2.ix() + r23.ix()) / 3 + this.size + 1, (2 * r2.iy() + r23.iy()) / 3 - this.size - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            r2 = this.getTextPos(graphicsArray[0], r22, this.gc.type == 63);
            this.mthtxt.draw(this.cs, r2.ix(), r2.iy(), graphicsArray);
        } else {
            Polygon polygon = new Polygon();
            try {
                int n = 0;
                while (n < this.xNa.length) {
                    double d = this.xNa[n].Evaluate();
                    double d2 = this.yNa[n].Evaluate();
                    R2 r2 = this.cs.projection(this.TR(new R2(d, d2)), this.gc.absCoor);
                    polygon.addPoint(r2.ix(), r2.iy());
                    ++n;
                }
                mjaGraph.drawPolygon(graphicsArray, this.width, polygon, this.gc.hasFill, this.gc.fillColor.getAdaptedColor());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void drawArc(Graphics[] graphicsArray) {
        R2 r2;
        R2 r22 = new R2(0.0, 0.0);
        try {
            Object object;
            r2 = this.cs.projection(new R2(this.XR, this.YR), this.gc.absCoor);
            int n = (int)Math.round(this.cs.Nesc.r * this.r.Evaluate());
            if (this.gc.absCoor) {
                n = (int)Math.round(this.r.Evaluate());
            }
            int n2 = 0;
            int n3 = 360;
            if (this.aN != null && this.daN != null) {
                n2 = (int)Math.round(this.A + this.aN.Evaluate());
                n3 = (int)Math.round(this.daN.Evaluate());
                if (this.gc.absCoor) {
                    n2 = -n2;
                    n3 = -n3;
                }
            } else {
                R2 r23 = this.cs.projection(this.TR(new R2(this.x1.Evaluate(), this.y1.Evaluate())), this.gc.absCoor);
                object = this.cs.projection(this.TR(new R2(this.x2.Evaluate(), this.y2.Evaluate())), this.gc.absCoor);
                r23.sub(r2);
                r23.normalize();
                ((R2)object).sub(r2);
                ((R2)object).normalize();
                n2 = (int)Math.round(180.0 * Math.asin(-r23.y) / Math.PI);
                if (r23.x < 0.0) {
                    n2 = 180 - n2;
                }
                while (n2 < 0) {
                    n2 += 360;
                }
                while (n2 > 360) {
                    n2 -= 360;
                }
                double d = r23.dot((R2)object);
                n3 = (int)Math.round(180.0 * Math.acos(d) / Math.PI);
                if (r23.det((R2)object) > 0.0) {
                    n3 = -n3;
                }
            }
            if (Math.abs((double)n * (double)n3 * Math.PI / 180.0) >= 1.0 && Math.abs((double)n - r2.norm()) < 4096.0) {
                if (n3 < 0) {
                    n2 += n3;
                    n3 = -n3;
                }
                if (this.gc.hasFill) {
                    int n4 = 0;
                    while (n4 < graphicsArray.length) {
                        object = graphicsArray[n4].getColor();
                        graphicsArray[n4].setColor(this.gc.fillColor.getAdaptedColor());
                        graphicsArray[n4].fillArc(r2.ix() - n, r2.iy() - n, 2 * n, 2 * n, n2, n3);
                        graphicsArray[n4].setColor((Color)object);
                        ++n4;
                    }
                }
                int n5 = 0;
                while (n5 < graphicsArray.length) {
                    mjaGraph.Arc(graphicsArray[n5], this.width, r2.ix(), r2.iy(), n, n2, n3);
                    ++n5;
                }
            }
            r22 = r2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        r2 = this.getTextPos(graphicsArray[0], r22, this.gc.type == 63);
        this.mthtxt.draw(this.cs, r2.ix(), r2.iy(), graphicsArray);
    }

    private R2 getTextPos(Graphics graphics, R2 r2, boolean bl) {
        int n = 0;
        TFont tFont = new TFont(this.gc.font);
        n = -tFont.getAscent();
        if (bl) {
            n = 4;
        }
        return new R2(r2.ix() + this.size, n + r2.iy() - this.size);
    }

    private void drawArrow(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0) {
            n5 = 6;
        }
        n5 = 2 * ((n5 + 1) / 2);
        if (n6 < 0) {
            n6 = n5;
        }
        n6 = 2 * ((n6 + 1) / 2);
        int n7 = n3 - n;
        int n8 = n4 - n2;
        double d = Math.sqrt(n7 * n7 + n8 * n8);
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = Math.acos((double)n7 / d);
        }
        if (n8 < 0) {
            d2 = Math.PI * 2 - d2;
        }
        graphics.setColor(color);
        graphics.fillPolygon(mjaGraph.flecha(n, n2, n5, n6, d, d2));
        graphics.setColor(color2);
        graphics.drawPolygon(mjaGraph.flecha(n, n2, n5, n6, d, d2));
    }

    private static Polygon flecha(int n, int n2, double d, double d2, double d3, double d4) {
        R2[] r2Array = new R2[]{new R2(-d / 2.0, d / 2.0), new R2(d3 - d - d2, d / 2.0), new R2(d3 - 2.0 * d2, d2 + d / 2.0), new R2(d3, 0.0), new R2(d3 - 2.0 * d2, -d2 - d / 2.0), new R2(d3 - d - d2, -d / 2.0), new R2(-d / 2.0, -d / 2.0)};
        int[] nArray = new int[r2Array.length];
        int[] nArray2 = new int[r2Array.length];
        int n3 = 0;
        while (n3 < r2Array.length) {
            r2Array[n3].rot(-d4);
            nArray[n3] = n + (int)Math.round(r2Array[n3].x);
            nArray2[n3] = n2 - (int)Math.round(r2Array[n3].y);
            ++n3;
        }
        return new Polygon(nArray, nArray2, r2Array.length);
    }

    void drawCurve(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        if (this.tparz != null) {
            Node node;
            Node node2 = node = this.D.p.Var(this.tparz.name);
            synchronized (node2) {
                double d = node.r;
                R2 r2 = new R2(0.0, 0.0);
                boolean bl = true;
                int n = (int)Math.round(this.tparz.NN.Evaluate(32.0));
                double d2 = this.tparz.Ni.Evaluate(0.0);
                double d3 = this.tparz.Nf.Evaluate(1.0);
                Polygon polygon = new Polygon();
                boolean bl2 = false;
                double d4 = 0.0;
                double d5 = 0.0;
                int n2 = 0;
                while (n2 <= n) {
                    double d6;
                    double d7;
                    block14: {
                        node.r = d2 + (d3 - d2) * (double)n2 / (double)n;
                        d7 = 0.0;
                        d6 = 0.0;
                        try {
                            d7 = this.fx.Evaluate();
                            d6 = this.fy.Evaluate();
                            d4 = d7;
                            d5 = d6;
                        }
                        catch (Exception exception) {
                            if (n2 <= 0) break block14;
                            d7 = d4;
                            d6 = d5;
                        }
                    }
                    R2 r22 = this.cs.projection(this.TR(new R2(d7, d6)), this.gc.absCoor);
                    polygon.addPoint(r22.ix(), r22.iy());
                    if (BasicStr.hasContent(this.gc.cond) && this.cond.Evaluate(1.0) > 0.0) {
                        if (bl2) {
                            Polygon polygon2 = null;
                            if (this.gc.hasFill && n2 > 1) {
                                polygon2 = new Polygon();
                                polygon2.addPoint(polygon.xpoints[n2 - 2], polygon.ypoints[n2 - 2]);
                                polygon2.addPoint(polygon.xpoints[n2 - 1], polygon.ypoints[n2 - 1]);
                                polygon2.addPoint(polygon.xpoints[n2], polygon.ypoints[n2]);
                            }
                            int n3 = 0;
                            while (n3 < graphicsArray.length) {
                                if (polygon2 != null) {
                                    graphicsArray[n3].setColor(this.gc.fillColor.getAdaptedColor());
                                    graphicsArray[n3].fillPolygon(polygon2);
                                }
                                graphicsArray[n3].setColor(mjaColorArray[n3].getAdaptedColor());
                                Face.Line(graphicsArray[n3], this.width, polygon.xpoints[n2 - 1], polygon.ypoints[n2 - 1], polygon.xpoints[n2], polygon.ypoints[n2]);
                                ++n3;
                            }
                        }
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                    ++n2;
                }
                if (!BasicStr.hasContent(this.gc.cond)) {
                    mjaGraph.drawPolygon(graphicsArray, this.width, polygon, this.gc.hasFill, this.gc.fillColor.getAdaptedColor());
                }
                node.r = d;
            }
        }
    }

    void drawSequence(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        Node node;
        int n = (int)Math.round(this.Si.Evaluate(1.0));
        int n2 = (int)Math.round(this.Sf.Evaluate(1.0));
        Node node2 = node = this.D.p.Var("n");
        synchronized (node2) {
            double d = node.r;
            int n3 = n;
            while (n3 <= n2) {
                node.r = n3;
                if (this.cond.Evaluate(1.0) > 0.0) {
                    try {
                        double d2 = this.fx.Evaluate();
                        double d3 = this.fy.Evaluate();
                        R2 r2 = this.cs.projection(this.TR(new R2(d2, d3)), this.gc.absCoor);
                        int n4 = 0;
                        while (n4 < graphicsArray.length) {
                            graphicsArray[n4].setColor(mjaColorArray[n4].getAdaptedColor());
                            mjaGraph.circle(graphicsArray[n4], r2.ix(), r2.iy(), this.size);
                            ++n4;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                ++n3;
            }
            node.r = d;
        }
    }

    private void drawLine(Graphics[] graphicsArray) {
        double d;
        double d2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.gc.formula.equals(lineEq[0])) {
            d2 = this.D.p.value("m");
            d = this.cs.Nesc.r * this.D.p.value("b");
            n = 0;
            n2 = this.cs.Oy - (int)Math.round(d + d2 * (double)(n - this.cs.Ox));
            n3 = this.cs.getSize().width;
            n4 = this.cs.Oy - (int)Math.round(d + d2 * (double)(n3 - this.cs.Ox));
        }
        if (this.gc.formula.equals(lineEq[1])) {
            d2 = this.D.p.value("m");
            d = this.cs.Nesc.r * this.D.p.value("a");
            n2 = 0;
            n = this.cs.Ox + (int)Math.round(d2 * (double)(n2 - this.cs.Oy) + d);
            n4 = this.cs.getSize().height;
            n3 = this.cs.Ox + (int)Math.round(d2 * (double)(n4 - this.cs.Oy) + d);
        } else if (this.gc.formula.equals(lineEq[2])) {
            double d3;
            double d4;
            d2 = this.D.p.value("A");
            d = this.D.p.value("B");
            double d5 = this.D.p.value("C");
            if (Math.abs(d) > Math.abs(d2)) {
                d4 = -d2 / d;
                d3 = d5 / d * this.cs.Nesc.r;
                n = 0;
                n2 = this.cs.Oy - (int)Math.round(d3 + d4 * (double)(n - this.cs.Ox));
                n3 = this.cs.getSize().width;
                n4 = this.cs.Oy - (int)Math.round(d3 + d4 * (double)(n3 - this.cs.Ox));
            } else if (Math.abs(d2) > 0.01) {
                d4 = -d / d2;
                d3 = -(d5 / d2) * this.cs.Nesc.r;
                n2 = 0;
                n = this.cs.Ox - (int)Math.round(d3 + d4 * (double)(n2 - this.cs.Oy));
                n4 = this.cs.getSize().height;
                n3 = this.cs.Ox - (int)Math.round(d3 + d4 * (double)(n4 - this.cs.Oy));
            } else {
                return;
            }
        }
        int n5 = 0;
        while (n5 < graphicsArray.length) {
            Face.Line(graphicsArray[n5], this.width, n, n2, n3, n4);
            ++n5;
        }
    }

    private void drawConic(Graphics[] graphicsArray) {
        double d;
        double d2;
        boolean bl = false;
        this.w = this.cs.getSize().width;
        this.h = this.cs.getSize().height;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 0.0;
        R2 r2 = this.cs.projection(new R2(this.D.p.value("Fx"), this.D.p.value("Fy")), this.gc.absCoor);
        if (this.gc.formula.equals(conicEq[0])) {
            d4 = this.D.p.value("e");
            if (d4 > 20.0) {
                return;
            }
            d3 = this.cs.Nesc.r * this.D.p.value("d");
            d5 = this.D.p.value("t");
            bl = false;
        } else if (this.gc.formula.equals(conicEq[1])) {
            R2 r22 = this.cs.projection(new R2(this.D.p.value("Dx"), this.D.p.value("Dy")), this.gc.absCoor);
            R2 r23 = this.cs.projection(new R2(this.D.p.value("Px"), this.D.p.value("Py")), this.gc.absCoor);
            d3 = r22.distance(r2);
            d2 = r23.distance(r2);
            d = r23.distance(r22);
            if (d < 0.1 || d2 < 0.1 || d3 < 0.1) {
                return;
            }
            double d6 = r2.y - r22.y;
            double d7 = r2.x - r22.x;
            if (d7 == 0.0) {
                d5 = d6 >= 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            } else {
                d5 = Math.atan(-d6 / d7);
                if (d7 < 0.0) {
                    d5 += Math.PI;
                }
            }
            r23.sub(r2);
            r22.sub(r2);
            d4 = (d3 - r22.dot(r23) / d3) / d2;
            if (d4 < 0.05) {
                return;
            }
            d4 = 1.0 / d4;
            bl = false;
        }
        this.Fx = r2.ix();
        this.Fy = r2.iy();
        this.doDrawConic(graphicsArray, d3, d4, d5);
        if (bl && d4 > 1.0) {
            double d8 = d4 * d4;
            d2 = d3 + d3;
            d = 1.0E16 / d8;
            if ((d8 - 1.0) / d2 > 1.0E-16) {
                d = d8 * d2 / (d8 - 1.0);
            }
            r2.x -= d * Math.cos(d5);
            r2.y += d * Math.sin(d5);
            this.Fx = r2.ix();
            this.Fy = r2.iy();
            this.doDrawConic(graphicsArray, d3, d4, d5 + Math.PI);
        }
    }

    private void Plot(Graphics[] graphicsArray, int n, int n2) {
        int n3 = 0;
        while (n3 < graphicsArray.length) {
            Face.Line(graphicsArray[n3], this.width, n, n2, n, n2);
            ++n3;
        }
    }

    private void Pon(Graphics[] graphicsArray) {
        switch (this.caso) {
            case 0: {
                this.Plot(graphicsArray, this.Fx + this.x, this.Fy + this.y);
                break;
            }
            case 1: {
                this.Plot(graphicsArray, this.Fx + this.y, this.Fy - this.x);
                break;
            }
            case 2: {
                this.Plot(graphicsArray, this.Fx - this.x, this.Fy - this.y);
                break;
            }
            case 3: {
                this.Plot(graphicsArray, this.Fx - this.y, this.Fy + this.x);
            }
        }
    }

    private void Dx() {
        this.x += this.dx;
        this.z += this.zx;
        this.zx += this.zxx;
        this.zy += this.zxy;
    }

    private void Dy() {
        this.y += this.dy;
        this.z += this.zy;
        this.zy += this.zyy;
        this.zx += this.zxy;
    }

    private void loop(Graphics[] graphicsArray) {
        if (Math.abs(this.z + this.zy) < Math.abs(this.z + this.zx)) {
            this.Dy();
            if (Math.abs(this.z) >= Math.abs(this.z + this.zx)) {
                this.Dx();
            }
        } else {
            this.Dx();
            if (Math.abs(this.z) >= Math.abs(this.z + this.zy)) {
                this.Dy();
            }
        }
        this.Pon(graphicsArray);
    }

    private void doDrawConic(Graphics[] graphicsArray, double d, double d2, double d3) {
        boolean bl = d2 < 1.0;
        boolean bl2 = d2 > 1.0;
        double d4 = d3;
        while (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        while (d4 >= Math.PI * 2) {
            d4 -= Math.PI * 2;
        }
        this.caso = 0;
        while (d4 >= 1.5707963267948966) {
            d4 -= 1.5707963267948966;
            ++this.caso;
        }
        if (d4 > 1.5706963267948966) {
            d4 = 0.0;
            this.caso = (this.caso + 1) % 4;
        }
        if (d4 < 1.0E-4) {
            d4 = 0.0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.w;
        int n4 = this.h;
        switch (this.caso) {
            case 0: {
                n = -this.Fx;
                n2 = -this.Fy;
                n3 = this.w - this.Fx;
                n4 = this.h - this.Fy;
                break;
            }
            case 1: {
                n = this.Fy - this.h;
                n2 = -this.Fx;
                n3 = this.Fy;
                n4 = this.w - this.Fx;
                break;
            }
            case 2: {
                n = this.Fx - this.w;
                n2 = this.Fy - this.h;
                n3 = this.Fx;
                n4 = this.Fy;
                break;
            }
            case 3: {
                n = -this.Fy;
                n2 = this.Fx - this.w;
                n3 = this.h - this.Fy;
                n4 = this.Fx;
            }
        }
        double d5 = Math.cos(d4);
        double d6 = -Math.sin(d4);
        double d7 = d * d2 / (1.0 + d2);
        double d8 = d2 * d2 * 32767.0;
        this.x = -((int)Math.round(d7 * d5));
        this.y = -((int)Math.round(d7 * d6));
        int n5 = (int)Math.round(32767.0 - d8 * d5 * d5);
        int n6 = (int)Math.round(32767.0 - d8 * d6 * d6);
        int n7 = -((int)Math.round((d8 *= 2.0) * d5 * d6));
        int n8 = n5 * (this.x + this.x + 1) + n7 * this.y - (int)Math.round((d8 *= d) * d5);
        int n9 = n6 * (this.y + this.y + 1) + n7 * this.x - (int)Math.round(d8 * d6);
        this.zxx = 2 * n5;
        this.zyy = 2 * n6;
        int n10 = this.x;
        int n11 = this.y;
        this.Pon(graphicsArray);
        this.z = 0;
        this.dx = 1;
        this.zx = n8;
        this.dy = 1;
        this.zy = n9;
        this.zxy = n7;
        do {
            this.loop(graphicsArray);
        } while (this.zx <= 0 && this.x <= n3 && (!bl2 || this.y <= n4));
        if (this.zx > 0) {
            this.dy = -1;
            this.zy = this.zyy - this.zy;
            this.zxy = -n7;
            do {
                this.loop(graphicsArray);
            } while (this.x <= n3 && (bl || this.y >= n2) && (!bl || this.zy <= 0));
        }
        this.x = n10;
        this.y = n11;
        this.dx = -1;
        this.zx = this.zxx - n8;
        this.dy = -1;
        this.zy = this.zyy - n9;
        this.zxy = n7;
        this.z = 0;
        do {
            this.loop(graphicsArray);
        } while (this.zy <= 0 && this.y >= n2 && (!bl2 || this.x >= n));
        if (this.zy > 0) {
            this.dx = 1;
            this.zx = this.zxx - this.zx;
            this.zxy = -n7;
            do {
                this.loop(graphicsArray);
            } while (this.x <= n3 && (bl || this.y >= n2) && (!bl || this.zx <= 0));
        }
        if (bl && this.x < n3) {
            this.dx = 1;
            this.dy = 1;
            this.zy = this.zyy - this.zy;
            this.zxy = n7;
            do {
                this.loop(graphicsArray);
            } while (this.zy <= 0 && this.x <= n3 && this.y <= n4);
        }
    }

    static R2 extrapolate(Node node, Node node2, Node node3, double d, double d2) {
        double d3 = node2.r;
        double d4 = d2 / 2.0;
        double d5 = 0.0;
        double d6 = d;
        while (Math.abs(d4) > 1.0E-12) {
            node2.r += d4;
            boolean bl = true;
            if (node.Evaluate(1.0) > 0.0) {
                try {
                    double d7 = d6;
                    d6 = node3.Evaluate();
                    R2 r2 = new R2(Math.min(d7, d6), Math.max(d7, d6));
                    if (mjaGraph.hasSingularity(Math.abs(d2), node2, node3, node2.r - d4, d7, node2.r, d6, r2)) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) {
                d5 += d4;
            } else {
                node2.r -= d4;
            }
            d4 /= 2.0;
        }
        node2.r = d3;
        return new R2(d5 / Math.abs(d2), d6);
    }

    static boolean hasSingularity(double d, Node node, Node node2, double d2, double d3, double d4, double d5, R2 r2) {
        if (Math.abs(d4 - d2) < 1.0E-12 || Math.abs(d4 - d2) < 1.0E-8 && Math.abs(d5 - d3) > Math.abs(d)) {
            return true;
        }
        boolean bl = false;
        double d6 = node.r;
        try {
            node.r = (d2 + d4) / 2.0;
            double d7 = node2.Evaluate();
            if (r2.x <= d7 && d7 <= r2.y) {
                bl = false;
            } else {
                r2.x = Math.min(r2.x, d7);
                r2.y = Math.max(r2.y, d7);
                bl = mjaGraph.hasSingularity(d, node, node2, d2, d3, node.r, d7, r2) || mjaGraph.hasSingularity(d, node, node2, node.r, d7, d4, d5, r2);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        node.r = d6;
        return bl;
    }

    private void drawFunctionOfx(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        Node node = this.D.p.Var("x");
        Node node2 = this.D.p.Var("y");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.r;
                double d2 = node2.r;
                if (this.F.isSequence()) {
                    int n = 0;
                    int n2 = this.cs.getSize().width;
                    if (!this.gc.absCoor) {
                        n = (int)Math.round(-1.0 - (double)this.cs.Ox / this.cs.Nesc.r);
                        n2 = (int)Math.round(1.0 + (double)(-this.cs.Ox + this.cs.getSize().width) / this.cs.Nesc.r);
                    }
                    while (n < n2) {
                        node.r = n;
                        try {
                            double d3 = this.F.Evaluate();
                            int n3 = this.cs.XX(this.width, n, this.gc.absCoor);
                            int n4 = this.cs.YY(this.width, d3, this.gc.absCoor);
                            int n5 = 0;
                            while (n5 < graphicsArray.length) {
                                Face.Line(graphicsArray[n5], this.width, n3, n4, n3, n4);
                                ++n5;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n;
                    }
                } else {
                    boolean bl = false;
                    R2 r2 = new R2(this.cs.Ox, this.cs.Oy);
                    int n = r2.iy();
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    double d4 = 1.0 / this.cs.Nesc.r;
                    double d5 = -d4 * (double)this.cs.Ox;
                    double d6 = 0.0;
                    if (this.gc.absCoor) {
                        d5 = 0.0;
                        d4 = 1.0;
                    }
                    while (n8 < this.cs.getSize().width) {
                        boolean bl2 = true;
                        node.r = d5;
                        if (this.cond.Evaluate(1.0) > 0.0) {
                            try {
                                double d7;
                                node2.r = d7 = this.F.Evaluate();
                                if (bl) {
                                    int n10;
                                    double d8;
                                    double d9 = Math.min(d6, d7);
                                    R2 r22 = new R2(d9, d8 = Math.max(d6, d7));
                                    if (!mjaGraph.hasSingularity(d4, node, this.F, d5 - d4, d6, d5, d7, r22)) {
                                        if (d6 <= d7) {
                                            d6 = r22.x;
                                            d7 = r22.y;
                                        } else {
                                            d7 = r22.x;
                                            d6 = r22.y;
                                        }
                                        int n11 = this.cs.YY(this.width, d6, this.gc.absCoor);
                                        n6 = this.gc.absCoor ? (int)Math.round(d7) : this.cs.YY(this.width, d7, this.gc.absCoor);
                                        n10 = 0;
                                        while (n10 < graphicsArray.length) {
                                            if (this.gc.hasFillminus && n6 > n) {
                                                graphicsArray[n10].setColor(this.gc.fillminusColor.getAdaptedColor());
                                                Face.Line(graphicsArray[n10], this.width, n8, n + 1, n8, n6);
                                            }
                                            if (this.gc.hasFillplus && n6 < n) {
                                                graphicsArray[n10].setColor(this.gc.fillplusColor.getAdaptedColor());
                                                Face.Line(graphicsArray[n10], this.width, n8, n - 1, n8, n6);
                                            }
                                            graphicsArray[n10].setColor(mjaColorArray[n10].getAdaptedColor());
                                            if (n7 != n11) {
                                                Face.Line(graphicsArray[n10], this.width, n9, n7, n9, n11);
                                            }
                                            Face.Line(graphicsArray[n10], this.width, n9, n11, n8, n6);
                                            ++n10;
                                        }
                                    } else {
                                        node.r = d5 - d4;
                                        R2 r23 = mjaGraph.extrapolate(this.cond, node, this.F, d6, d4);
                                        n6 = this.cs.YY(this.width, r23.y, this.gc.absCoor);
                                        n10 = 0;
                                        while (n10 < graphicsArray.length) {
                                            graphicsArray[n10].setColor(mjaColorArray[n10].getAdaptedColor());
                                            Face.Line(graphicsArray[n10], this.width, n9, n7, n9 + (int)Math.round(r23.x), n6);
                                            ++n10;
                                        }
                                        node.r = d5;
                                        R2 r24 = mjaGraph.extrapolate(this.cond, node, this.F, d7, -d4);
                                        n7 = this.cs.YY(this.width, r24.y, this.gc.absCoor);
                                        n6 = this.cs.YY(this.width, d7, this.gc.absCoor);
                                        int n12 = 0;
                                        while (n12 < graphicsArray.length) {
                                            graphicsArray[n12].setColor(mjaColorArray[n12].getAdaptedColor());
                                            Face.Line(graphicsArray[n12], this.width, n8 + (int)Math.round(r24.x), n7, n8, n6);
                                            ++n12;
                                        }
                                    }
                                } else {
                                    R2 r25 = mjaGraph.extrapolate(this.cond, node, this.F, d7, -d4);
                                    n7 = this.cs.YY(this.width, r25.y, this.gc.absCoor);
                                    n6 = this.cs.YY(this.width, d7, this.gc.absCoor);
                                    int n13 = 0;
                                    while (n13 < graphicsArray.length) {
                                        graphicsArray[n13].setColor(mjaColorArray[n13].getAdaptedColor());
                                        Face.Line(graphicsArray[n13], this.width, n8 + (int)Math.round(r25.x), n7, n8, n6);
                                        ++n13;
                                    }
                                }
                                d6 = d7;
                            }
                            catch (Exception exception) {
                                bl2 = false;
                            }
                        } else {
                            bl2 = false;
                        }
                        if (bl && !bl2) {
                            node.r = d5 - d4;
                            node2.r = d6;
                            R2 r26 = mjaGraph.extrapolate(this.cond, node, this.F, d6, d4);
                            n6 = this.cs.YY(this.width, r26.y, this.gc.absCoor);
                            int n14 = 0;
                            while (n14 < graphicsArray.length) {
                                graphicsArray[n14].setColor(mjaColorArray[n14].getAdaptedColor());
                                Face.Line(graphicsArray[n14], this.width, n9, n7, n9 + (int)Math.round(r26.x), n6);
                                ++n14;
                            }
                            node.r = d5;
                        }
                        bl = bl2;
                        d5 += d4;
                        n7 = n6;
                        n9 = n8++;
                    }
                }
                node.r = d;
                node2.r = d2;
            }
        }
    }

    private void drawFunctionOfy(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        Node node = this.D.p.Var("y");
        Node node2 = this.D.p.Var("x");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.r;
                double d2 = node2.r;
                if (this.F.isSequence()) {
                    int n = 0;
                    int n2 = this.cs.getSize().height;
                    if (!this.gc.absCoor) {
                        n = (int)Math.round(-1.0 + (double)(this.cs.Oy - this.cs.getSize().height) / this.cs.Nesc.r);
                        n2 = (int)Math.round(1.0 + (double)this.cs.Oy / this.cs.Nesc.r);
                    }
                    while (n < n2) {
                        node.r = n;
                        try {
                            double d3 = this.F.Evaluate();
                            int n3 = this.cs.XX(this.width, d3, this.gc.absCoor);
                            int n4 = this.cs.YY(this.width, n, this.gc.absCoor);
                            int n5 = 0;
                            while (n5 < graphicsArray.length) {
                                Face.Line(graphicsArray[n5], this.width, n3, n4, n3, n4);
                                ++n5;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n;
                    }
                } else {
                    int n = this.cs.getSize().width;
                    boolean bl = false;
                    R2 r2 = new R2(this.cs.Ox, this.cs.Oy);
                    int n6 = r2.ix();
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    double d4 = 1.0 / this.cs.Nesc.r;
                    double d5 = d4 * (double)this.cs.Oy;
                    double d6 = 0.0;
                    if (this.gc.absCoor) {
                        d5 = 0.0;
                        d4 = -1.0;
                    }
                    while (n7 < this.cs.getSize().height) {
                        boolean bl2 = true;
                        node.r = d5;
                        if (this.cond.Evaluate(1.0) > 0.0) {
                            try {
                                double d7;
                                node2.r = d7 = this.F.Evaluate();
                                if (bl) {
                                    int n11;
                                    double d8;
                                    double d9 = Math.min(d6, d7);
                                    R2 r22 = new R2(d9, d8 = Math.max(d6, d7));
                                    if (!mjaGraph.hasSingularity(d4, node, this.F, d5 + d4, d6, d5, d7, r22)) {
                                        if (d6 <= d7) {
                                            d6 = r22.x;
                                            d7 = r22.y;
                                        } else {
                                            d7 = r22.x;
                                            d6 = r22.y;
                                        }
                                        int n12 = this.cs.XX(this.width, d6, this.gc.absCoor);
                                        n9 = this.cs.XX(this.width, d7, this.gc.absCoor);
                                        n11 = 0;
                                        while (n11 < graphicsArray.length) {
                                            if (this.gc.hasFillplus && n9 > n6) {
                                                graphicsArray[n11].setColor(this.gc.fillplusColor.getAdaptedColor());
                                                Face.Line(graphicsArray[n11], this.width, n6 + 1, n7, n9, n7);
                                            }
                                            if (this.gc.hasFillminus && n9 < n6) {
                                                graphicsArray[n11].setColor(this.gc.fillminusColor.getAdaptedColor());
                                                Face.Line(graphicsArray[n11], this.width, n6 - 1, n7, n9, n7);
                                            }
                                            graphicsArray[n11].setColor(mjaColorArray[n11].getAdaptedColor());
                                            if (n10 != n12) {
                                                Face.Line(graphicsArray[n11], this.width, n10, n8, n12, n8);
                                            }
                                            Face.Line(graphicsArray[n11], this.width, n12, n8, n9, n7);
                                            ++n11;
                                        }
                                    } else {
                                        node.r = d5 + d4;
                                        R2 r23 = mjaGraph.extrapolate(this.cond, node, this.F, d6, -d4);
                                        n9 = this.cs.XX(this.width, r23.y, this.gc.absCoor);
                                        n11 = 0;
                                        while (n11 < graphicsArray.length) {
                                            graphicsArray[n11].setColor(mjaColorArray[n11].getAdaptedColor());
                                            Face.Line(graphicsArray[n11], this.width, n10, n8, n9, n7 + (int)Math.round(r23.x));
                                            ++n11;
                                        }
                                        node.r = d5;
                                        R2 r24 = mjaGraph.extrapolate(this.cond, node, this.F, d7, d4);
                                        n10 = this.cs.XX(this.width, r24.y, this.gc.absCoor);
                                        n9 = this.cs.XX(this.width, d7, this.gc.absCoor);
                                        int n13 = 0;
                                        while (n13 < graphicsArray.length) {
                                            graphicsArray[n13].setColor(mjaColorArray[n13].getAdaptedColor());
                                            Face.Line(graphicsArray[n13], this.width, n10, n8 + (int)Math.round(r24.x), n9, n7);
                                            ++n13;
                                        }
                                    }
                                } else {
                                    R2 r25 = mjaGraph.extrapolate(this.cond, node, this.F, d7, d4);
                                    n10 = this.cs.XX(this.width, r25.y, this.gc.absCoor);
                                    n9 = this.cs.XX(this.width, d7, this.gc.absCoor);
                                    int n14 = 0;
                                    while (n14 < graphicsArray.length) {
                                        graphicsArray[n14].setColor(mjaColorArray[n14].getAdaptedColor());
                                        Face.Line(graphicsArray[n14], this.width, n10, n8 + (int)Math.round(r25.x), n9, n7);
                                        ++n14;
                                    }
                                }
                                d6 = d7;
                            }
                            catch (Exception exception) {
                                bl2 = false;
                            }
                        } else {
                            bl2 = false;
                        }
                        if (bl && !bl2) {
                            node.r = d5 + d4;
                            node2.r = d6;
                            R2 r26 = mjaGraph.extrapolate(this.cond, node, this.F, d6, -d4);
                            n9 = this.cs.XX(this.width, r26.y, this.gc.absCoor);
                            int n15 = 0;
                            while (n15 < graphicsArray.length) {
                                graphicsArray[n15].setColor(mjaColorArray[n15].getAdaptedColor());
                                Face.Line(graphicsArray[n15], this.width, n10, n8, n9, n7 + (int)Math.round(r26.x));
                                ++n15;
                            }
                            node.r = d5;
                        }
                        bl = bl2;
                        d5 -= d4;
                        n10 = n9;
                        n8 = n7++;
                    }
                }
                node.r = d;
                node2.r = d2;
            }
        }
    }

    private void drawEquation(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        Node node = this.D.p.Var("x");
        Node node2 = this.D.p.Var("y");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.r;
                double d2 = node2.r;
                try {
                    int n;
                    R2Newton r2Newton = new R2Newton(this.D.p, this.gc.formula);
                    int n2 = this.cs.getSize().width;
                    int n3 = this.cs.getSize().height;
                    int n4 = n2 / 8;
                    if (n4 < 3) {
                        n4 = 3;
                    }
                    if ((n = n3 / 8) < 3) {
                        n = 3;
                    }
                    boolean[][] blArray = new boolean[n2][n3];
                    R2 r2 = new R2();
                    R2 r22 = new R2();
                    R2 r23 = new R2();
                    int n5 = n / 2;
                    while (n5 < n3) {
                        int n6 = n4 / 2;
                        while (n6 < n2) {
                            R2 r24 = r2Newton.findZero(this.cs.injection(n6, n5, this.gc.absCoor));
                            node.r = r24.x;
                            node2.r = r24.y;
                            R2 r25 = this.cs.projection(r24, this.gc.absCoor);
                            int n7 = r25.ix();
                            int n8 = r25.iy();
                            if (n7 >= 0 && n7 < n2 && n8 >= 0 && n8 < n3 && !blArray[n7][n8]) {
                                blArray[n7][n8] = true;
                                if (r2Newton.rangeOK()) {
                                    int n9 = 0;
                                    while (n9 < graphicsArray.length) {
                                        graphicsArray[n9].setColor(mjaColorArray[n9].getAdaptedColor());
                                        Face.Line(graphicsArray[n9], this.width, n7, n8, n7, n8);
                                        ++n9;
                                    }
                                }
                                r2.x = r24.x;
                                r2.y = r24.y;
                                r22.x = r24.x;
                                r22.y = r24.y;
                                R2 r26 = r2Newton.getUnitNormal();
                                if (r26.x != 0.0 || r26.y != 0.0) {
                                    r26.rotL90();
                                    r23.x = r26.x;
                                    r23.y = r26.y;
                                    int n10 = 0;
                                    int n11 = 0;
                                    boolean bl = false;
                                    while (n11 < 2) {
                                        if (bl) {
                                            r23.x = -r26.x;
                                            r23.y = -r26.y;
                                            r24.x = r2.x;
                                            r24.y = r2.y;
                                            r22.x = r24.x;
                                            r22.y = r24.y;
                                            r25 = this.cs.projection(r24, this.gc.absCoor);
                                            n7 = r25.ix();
                                            n8 = r25.iy();
                                            bl = false;
                                            n10 = 0;
                                        }
                                        if (this.gc.absCoor) {
                                            r24.x += r23.x;
                                            r24.y += r23.y;
                                        } else {
                                            r24.x += r23.x / this.cs.Nesc.r;
                                            r24.y += r23.y / this.cs.Nesc.r;
                                        }
                                        r24 = r2Newton.findZero(r24);
                                        node.r = r24.x;
                                        node2.r = r24.y;
                                        r23.x = r24.x - r22.x;
                                        r23.y = r24.y - r22.y;
                                        r23.normalize();
                                        if (r23.x == 0.0 && r23.y == 0.0) break;
                                        r22.x = r24.x;
                                        r22.y = r24.y;
                                        r25 = this.cs.projection(r24, this.gc.absCoor);
                                        int n12 = r25.ix();
                                        int n13 = r25.iy();
                                        if (n12 != n7 || n13 != n8) {
                                            n7 = n12;
                                            n8 = n13;
                                            if (0 <= n7 && n7 < n2 && 0 <= n8 && n8 < n3) {
                                                n10 = 0;
                                                if (blArray[n7][n8]) break;
                                                blArray[n7][n8] = true;
                                                int n14 = 0;
                                                while (n14 < graphicsArray.length) {
                                                    graphicsArray[n14].setColor(mjaColorArray[n14].getAdaptedColor());
                                                    if (r2Newton.rangeOK()) {
                                                        Face.Line(graphicsArray[n14], this.width, n7, n8, n7, n8);
                                                    }
                                                    ++n14;
                                                }
                                                continue;
                                            }
                                            bl = true;
                                            ++n11;
                                            continue;
                                        }
                                        if (++n10 <= 4) continue;
                                        bl = true;
                                        ++n11;
                                    }
                                }
                            }
                            n6 += n4;
                        }
                        n5 += n;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                node.r = d;
                node2.r = d2;
            }
        }
    }
}

