/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Action;
import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.mjaGraph;
import com.mja.descgui.ButtonControl;
import com.mja.descgui.ChoiceControl;
import com.mja.descgui.NumericControl;
import com.mja.descgui.ScrollBarControl;
import com.mja.descgui.Spinner;
import com.mja.descgui.edit.editField;
import com.mja.descgui.edit.editObject;
import com.mja.descgui.edit.editObjectType;
import com.mja.descutil.Explanations;
import com.mja.descutil.mjaStr;
import com.mja.gui.mjaColor;
import com.mja.gui.mjaText;
import com.mja.lang.data;
import com.mja.lang.translator;
import com.mja.math.R2;
import com.mja.math.R2Newton;
import com.mja.parser.Node;
import com.mja.text.MathText;
import com.mja.text.TFont;
import com.mja.util.Attribute;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.BitSet;

public class controlConfig
extends editObject {
    public int type;
    public translator Tr;
    public String label = "";
    public String explanation = "";
    public String tooltip = "";
    public String parameter = "";
    private static final int[] regions = new int[]{51, 50, 52, 53, 54, 207};
    private static final int[] guis = new int[]{203, 204, 205, 213};
    public int region = 51;
    public int msgloc = 0;
    public static final int ixtype = 0;
    public static final int ixid = 1;
    public static final int ixgui = 2;
    public static final int ixregion = 3;
    public static final int ixspace = 4;
    public static final int ixcolor = 5;
    public static final int ixicolor = 6;
    public static final int ixexpr = 7;
    public static final int ixvalue = 8;
    public static final int ixsize = 9;
    public static final int ixconstraint = 10;
    public static final int ixtext = 11;
    public static final int ixdecimals = 12;
    public static final int ixfixed = 13;
    public static final int ixname = 14;
    public static final int ixincr = 15;
    public static final int ixinf = 16;
    public static final int ixsup = 17;
    public static final int ixdiscrete = 18;
    public static final int ixnotexp = 19;
    public static final int ixvisible = 20;
    public static final int ixtrace = 21;
    public static final int ixcond = 22;
    public static final int ixtooltip = 23;
    public static final int ixexpl = 24;
    public static final int ixoptions = 25;
    public static final int ixaction = 26;
    public static final int ixparam = 27;
    public static final int ixmsgloc = 28;
    public static final int numFields = 29;
    public Font tooltip_font;
    public Font expl_font;
    public Font param_font;
    private static final editField[] controlfield = new editField[]{new editField(56, "", "", 1, 0, -1, true, -1, -1, -1, 194, null), new editField(162, "", "", 1, 6), new editField(202, "spinner", "spinner", 5, 1, -1, true, -1, -1, -1, 194, guis), new editField(49, "south", "south", 5, 1, -1, true, -1, -1, -1, 194, regions), new editField(137, "", "", 5, 1, -1, true, -1, -1, -1, 137, null), new editField(26, "blue", "blue", 2, 1), new editField(126, "red", "red", 2, 1), new editField(55, "(0,0)", "(0,0)", 1, 10, -1, true, -1, -1, -1, 98, null), new editField(60, "0", "0", 1, 6), new editField(29, "4", "4", 1, 4), new editField(58, "", "", 1, 16), new editField(63, "", "", 4, 25, -1, true, -1, 93, -1, 63, null, false, 5), new editField(30, "2", "2", 1, 10), new editField(191, "si", "si", 0, 1), new editField(20, "", "", 1, 6), new editField(40, "0.1", "0.1", 1, 6), new editField(41, "", "", 1, 6), new editField(42, "", "", 1, 6), new editField(201, "no", "no", 0, 1), new editField(115, "", "", 1, 25), new editField(22, "yes", "yes", 0, 1), new editField(23, "gray", "no", 3, 1), new editField(108, "", "", 1, 30), new editField(199, "", "", 4, 45, -1, true, -1, 93, 199, 199, null), new editField(196, "", "", 4, 45, -1, true, -1, 93, 196, 196, null), new editField(206, "", "", 1, 45), new editField(209, "", "", 5, 1, -1, true, -1, -1, -1, 209, Action.actions), new editField(27, "", "", 4, 20, -1, true, -1, 93, 27, 27, null), new editField(260, "center", "center", 5, 1, -1, true, -1, -1, -1, 260, data.msglocs)};
    private static editObjectType[] controlEOT;
    private static final String[] defaultExpresion;
    public R2 cpos;
    public int size;
    public Font font = mjaText.Courier;
    public mjaColor ccolor = new mjaColor(Color.blue);
    public mjaColor icolor = new mjaColor(Color.red);
    public mjaColor tcolor = new mjaColor(Color.gray);
    public boolean hasTrace;
    public static final String _x = ".x";
    public static final String _y = ".y";
    private Descartes D;
    private Space cs;
    private MathText mthtxt;
    private Node constraint;
    private Node decimals;
    private Node cond;
    private Node funcOfX;
    private Node funcOfY;
    private R2Newton newt;
    boolean isActive;

    public void updateInfo(translator translator2) {
        this.type = translator2.getIndex(data.ctrlix, this.s_value[0], 96);
        this.tooltip = BasicStr.replace(this.s_value[23], "\\n", "\n");
        this.tooltip_font = mjaStr.parseFont(this.h_value[23], mjaText.Courier);
        this.explanation = BasicStr.replace(this.s_value[24], "\\n", "\n");
        this.expl_font = mjaStr.parseFont(this.h_value[24], mjaText.Courier);
        this.parameter = BasicStr.replace(this.s_value[27], "\\n", "\n");
        this.param_font = mjaStr.parseFont(this.h_value[27], mjaText.Courier);
        if ("O.x".equals(this.s_value[1])) {
            if (!BasicStr.hasContent(this.s_value[14])) {
                this.s_value[14] = this.s_value[1];
            }
            this.s_value[1] = "Ox";
        } else if ("O.y".equals(this.s_value[1])) {
            if (!BasicStr.hasContent(this.s_value[14])) {
                this.s_value[14] = this.s_value[1];
            }
            this.s_value[1] = "Oy";
        } else if (this.s_value[1].endsWith(".O.x")) {
            if (!BasicStr.hasContent(this.s_value[14])) {
                this.s_value[14] = this.s_value[1];
            }
            this.s_value[1] = this.s_value[1].substring(0, this.s_value[1].length() - 3) + "Ox";
        } else if (this.s_value[1].endsWith(".O.y")) {
            if (!BasicStr.hasContent(this.s_value[14])) {
                this.s_value[14] = this.s_value[1];
            }
            this.s_value[1] = this.s_value[1].substring(0, this.s_value[1].length() - 3) + "Oy";
        }
        if (this.type == 96) {
            this.label = this.s_value[14];
            if (translator.equals(this.s_value[2], 203) || translator.equals(this.s_value[2], 205)) {
                if (!BasicStr.hasContent(this.s_value[14])) {
                    this.s_value[14] = this.s_value[1];
                }
            } else {
                this.s_value[15] = "";
                this.s_value[16] = "";
                this.s_value[17] = "";
            }
        } else if (this.type == 97) {
            this.label = this.s_value[1];
            this.ccolor = translator2.parseColor(this.s_value[5], this.ccolor, this.ccolor);
            this.icolor = translator2.parseColor(this.s_value[6], this.icolor, this.icolor);
            this.font = mjaStr.parseFont(this.h_value[11], this.font);
            mjaColor mjaColor3 = translator2.parseColor(this.s_value[21], this.tcolor, null);
            boolean bl = this.hasTrace = mjaColor3 != null;
            if (this.hasTrace) {
                this.tcolor = mjaColor3;
            }
        }
        this.setId(this.getName() + " (" + translator2.getTr(this.type) + ")");
        if (this.type == 96) {
            this.region = translator2.getIndex(regions, this.s_value[3], this.region);
        }
        this.msgloc = translator.parseLocation(this.s_value[28]);
    }

    public void setEditName(String string) {
        this.setName(string);
    }

    public String getEditName() {
        return this.getName();
    }

    public int getNumTypes() {
        return defaultExpresion.length;
    }

    public String getType(translator translator2, int n) {
        return translator2.getTr(data.ctrlix[n]);
    }

    public String getDefaultExpresion(translator translator2, int n) {
        return defaultExpresion[n];
    }

    public String getListTitle(translator translator2) {
        return translator2.getTr(74);
    }

    public String getTypesInfo(translator translator2) {
        return translator2.getTr(24);
    }

    public int getTypeIndex(translator translator2) {
        int n = 0;
        while (n < data.ctrlix.length) {
            if (this.type == data.ctrlix[n]) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public controlConfig(translator translator2, int n, String string) {
        this(translator2, translator2.getTr(n), string);
    }

    public controlConfig(translator translator2, String string, String string2) {
        this(translator2, translator2.getTr(56) + "=" + string + " " + translator2.getTr(162) + "=" + string2);
    }

    public controlConfig(translator translator2, String string) {
        this.expl = Explanations.Control;
        this.Tr = translator2;
        if (controlEOT == null) {
            controlConfig.createControlEOT();
        }
        Attribute[] attributeArray = Attribute.parse(string);
        this.type = translator2.getIndex(data.ctrlix, translator2.getValue(attributeArray, 56), 96);
        String[] stringArray = new String[29];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = controlConfig.controlfield[n].null_val;
            ++n;
        }
        stringArray[2] = translator2.getTr(203);
        stringArray[3] = translator2.getTr(51);
        if (this.type == 96) {
            String string2 = Attribute.getValue(attributeArray, "id");
            if (translator.equals(string2, 18)) {
                stringArray[1] = "E00.escala";
                stringArray[14] = translator2.getTr(107);
                stringArray[3] = translator2.getTr(50);
                stringArray[8] = "48";
                stringArray[12] = "4*(escala<10)";
                stringArray[15] = "0.1*escala";
                stringArray[16] = "0.001";
                stringArray[17] = "1000000";
                stringArray[20] = "no";
            }
            if (string2.equalsIgnoreCase("Ox") || string2.equalsIgnoreCase("O.x") || translator.equals(string2, 72)) {
                stringArray[1] = "E00.Ox";
                stringArray[14] = "O.x";
                stringArray[3] = translator2.getTr(50);
                stringArray[8] = "0";
                stringArray[12] = "0";
                stringArray[15] = "100";
                stringArray[20] = "no";
            }
            if (string2.equalsIgnoreCase("Oy") || string2.equalsIgnoreCase("O.y") || translator.equals(string2, 73)) {
                stringArray[1] = "E00.Oy";
                stringArray[14] = "O.y";
                stringArray[3] = translator2.getTr(50);
                stringArray[8] = "0";
                stringArray[12] = "0";
                stringArray[15] = "100";
                stringArray[20] = "no";
            }
        }
        this.initialize(translator2, controlfield, controlEOT, string, stringArray);
    }

    private static void createControlEOT() {
        BitSet bitSet = new BitSet(29);
        int n = 0;
        while (n < 29) {
            bitSet.clear(n);
            ++n;
        }
        bitSet.set(1);
        bitSet.set(0);
        bitSet.set(2);
        bitSet.set(3);
        bitSet.set(4);
        bitSet.set(8);
        bitSet.set(7);
        bitSet.set(14);
        bitSet.set(12);
        bitSet.set(13);
        bitSet.set(15);
        bitSet.set(16);
        bitSet.set(17);
        bitSet.set(18);
        bitSet.set(19);
        bitSet.set(20);
        bitSet.set(24);
        bitSet.set(23);
        bitSet.set(25);
        bitSet.set(26);
        bitSet.set(27);
        bitSet.set(28);
        BitSet bitSet2 = new BitSet(29);
        int n2 = 0;
        while (n2 < 29) {
            bitSet2.clear(n2);
            ++n2;
        }
        bitSet2.set(1);
        bitSet2.set(0);
        bitSet2.set(4);
        bitSet2.set(7);
        bitSet2.set(5);
        bitSet2.set(6);
        bitSet2.set(9);
        bitSet2.set(10);
        bitSet2.set(11);
        bitSet2.set(12);
        bitSet2.set(13);
        bitSet2.set(21);
        bitSet2.set(22);
        bitSet2.set(24);
        bitSet2.set(23);
        controlEOT = new editObjectType[2];
        controlConfig.controlEOT[0] = new editObjectType("", bitSet);
        controlConfig.controlEOT[1] = new editObjectType("", bitSet2);
    }

    private void setName(String string) {
        this.s_value[1] = string;
    }

    public String getName() {
        return this.s_value[1];
    }

    static controlConfig[] defaultControls(translator translator2) {
        controlConfig[] controlConfigArray = new controlConfig[]{new controlConfig(translator2, 96, translator2.getTr(18)), new controlConfig(translator2, 96, translator2.getTr(72)), new controlConfig(translator2, 96, translator2.getTr(73))};
        return controlConfigArray;
    }

    NumericControl makeNumericControl(Descartes descartes) {
        Object object;
        String string = "0";
        String string2 = "0";
        String string3 = "100";
        int n = 100;
        int n2 = BasicStr.lineVSize();
        String string4 = String.valueOf(n2);
        try {
            object = BasicStr.getTokens(this.s_value[7]);
            if (((String[])object).length >= 2) {
                string = object[0];
                string2 = object[1];
            }
            if (((String[])object).length >= 4) {
                string3 = object[2];
                string4 = object[3];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = descartes.p.Analyse(string, 0.0);
        Node node = descartes.p.Analyse(string2, 0.0);
        Node node2 = descartes.p.Analyse(string3, n);
        Node node3 = descartes.p.Analyse(string4, n2);
        n = (int)Math.round(node2.Evaluate(n));
        n2 = (int)Math.round(node3.Evaluate(n2));
        descartes.p.Var((String)this.s_value[1]).r = descartes.p.Analyse(this.s_value[8], 0.0).Evaluate(0.0);
        NumericControl numericControl = null;
        numericControl = translator.equals(this.s_value[2], 213) ? new ButtonControl(descartes, this.s_value[14], this.s_value[1], this.s_value[8], this.s_value[16], this.s_value[17]) : (translator.equals(this.s_value[2], 205) ? new ScrollBarControl(descartes, this.s_value[14], this.s_value[1], this.s_value[12], translator.isNotFalse(this.s_value[13]), this.s_value[8], this.s_value[15], this.s_value[16], this.s_value[17], translator.isNotFalse(this.s_value[20]), this.s_value[19], translator.equals(this.s_value[3], 207) && n <= n2) : (translator.equals(this.s_value[2], 204) ? new ChoiceControl(descartes, this.s_value[14], this.s_value[1], this.s_value[12], translator.isNotFalse(this.s_value[13]), this.s_value[8], translator.isNotFalse(this.s_value[20]), this.s_value[19], this.s_value[25]) : new Spinner(descartes, this.s_value[14], this.s_value[1], this.s_value[12], translator.isNotFalse(this.s_value[13]), this.s_value[8], this.s_value[15], this.s_value[16], this.s_value[17], translator.isNotFalse(this.s_value[20]), this.s_value[19])));
        numericControl.setAction(this.s_value[26], this.parameter, this.param_font, this.msgloc);
        numericControl.setInterior(translator.equals(this.s_value[3], 207));
        numericControl.setSpace(this.s_value[4]);
        numericControl.setTooltip(this.tooltip, this.Tr.getTr(200), this.tooltip_font);
        numericControl.setExplanation(this.explanation, this.expl_font);
        numericControl.setDiscrete(translator.isTrue(this.s_value[18]));
        if (numericControl.isInterior()) {
            numericControl.setNodeBounds((Node)object, node, node2, node3);
            numericControl.locate();
        }
        return numericControl;
    }

    public void setRegion(int n) {
        this.region = n;
        this.s_value[3] = this.Tr.getTr(n);
    }

    void setSpace(Space space) {
        this.cs = space;
    }

    void initializeGraphicControl(Descartes descartes) {
        Node node;
        String[] stringArray;
        this.D = descartes;
        this.ccolor.analyse(descartes.p);
        this.icolor.analyse(descartes.p);
        this.tcolor.analyse(descartes.p);
        this.decimals = descartes.p.Analyse(this.s_value[12], 2.0);
        this.mthtxt = new MathText(descartes.p, descartes.Tr, this.s_value[11], this.decimals, translator.isNotFalse(this.s_value[13]), this.font, this.ccolor.getAdaptedColor());
        this.size = BasicStr.parseInteger(this.s_value[9], 2, 2);
        if (BasicStr.hasContent(this.s_value[10])) {
            this.constraint = descartes.p.Analyse(this.s_value[10]);
            if (this.constraint.getSymbol().equals("=")) {
                stringArray = this.constraint.getLeft();
                node = this.constraint.getRight()[0];
                if (stringArray.getSymbol().equals("y") && !node.contains("y")) {
                    this.funcOfX = node;
                } else if (stringArray.getSymbol().equals("x") && !node.contains("x")) {
                    this.funcOfY = node;
                }
                this.constraint.equalToMinus();
                this.newt = new R2Newton(descartes.p, this.constraint);
            } else {
                this.constraint = null;
            }
        }
        this.cond = descartes.p.Analyse(this.s_value[22], "1");
        this.cpos = new R2(0.0, 0.0);
        try {
            stringArray = BasicStr.getTokens(this.s_value[7]);
            if (stringArray.length >= 2) {
                node = descartes.p.Analyse(stringArray[0]);
                Node node2 = descartes.p.Analyse(stringArray[1]);
                this.cpos = new R2(node.Evaluate(0.0), node2.Evaluate(0.0));
            } else {
                System.out.println("wrong expression: " + this.s_value[7]);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        descartes.p.Var((String)new StringBuffer().append((String)this.s_value[1]).append((String)_x).toString()).r = this.cpos.x;
        descartes.p.Var((String)new StringBuffer().append((String)this.s_value[1]).append((String)_y).toString()).r = this.cpos.y;
    }

    void setControlPos(double d, double d2) {
        this.cpos = this.cs.injection(d, d2);
        if (this.constraint != null) {
            try {
                this.cpos = this.newt.findZero(this.cpos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.D.p.Var((String)new StringBuffer().append((String)this.s_value[1]).append((String)_x).toString()).r = this.cpos.x;
        this.D.p.Var((String)new StringBuffer().append((String)this.s_value[1]).append((String)_y).toString()).r = this.cpos.y;
        this.D.updateSpinners(null, false);
    }

    R2 getControlPos() {
        return this.cs.projection(this.cpos);
    }

    void adjust() {
        double d = this.cpos.x;
        double d2 = this.cpos.y;
        this.cpos.x = this.D.p.value(this.s_value[1] + _x);
        this.cpos.y = this.D.p.value(this.s_value[1] + _y);
        Node node = this.D.p.Var("x");
        Node node2 = this.D.p.Var("y");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d3 = node.r;
                double d4 = node2.r;
                node.r = this.cpos.x;
                node2.r = this.cpos.y;
                if (this.constraint != null) {
                    try {
                        if (this.funcOfX != null && this.cpos.x != d) {
                            this.cpos.y = this.funcOfX.Evaluate();
                        } else if (this.funcOfY != null && this.cpos.y != d2) {
                            this.cpos.x = this.funcOfY.Evaluate();
                        } else {
                            this.cpos = this.newt.findZero(this.cpos);
                        }
                    }
                    catch (Exception exception) {
                        this.cpos.x = d;
                        this.cpos.y = d;
                        exception.printStackTrace();
                    }
                }
                node.r = d3;
                node2.r = d4;
            }
        }
        this.D.p.Var((String)new StringBuffer().append((String)this.s_value[1]).append((String)_x).toString()).r = this.cpos.x;
        this.D.p.Var((String)new StringBuffer().append((String)this.s_value[1]).append((String)_y).toString()).r = this.cpos.y;
        this.D.updateSpinners(null, false);
    }

    void drawControl(boolean bl, Graphics[] graphicsArray) {
        Node node = this.D.p.Var("x");
        Node node2 = this.D.p.Var("y");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.r;
                double d2 = node2.r;
                node.r = this.cpos.x;
                node2.r = this.cpos.y;
                if (this.cond.Evaluate(1.0) > 0.0) {
                    R2 r2 = this.cs.projection(this.cpos);
                    int n = 0;
                    while (n < graphicsArray.length) {
                        if (bl) {
                            graphicsArray[n].setColor(this.tcolor.getAdaptedColor());
                            graphicsArray[n].drawOval(r2.ix() - this.size, r2.iy() - this.size, 2 * this.size, 2 * this.size);
                        } else {
                            graphicsArray[n].setColor(this.icolor.getAdaptedColor());
                            mjaGraph.circle(graphicsArray[n], r2.ix(), r2.iy(), this.size);
                            if (this.isActive) {
                                graphicsArray[n].setColor(mjaColor.bestContrast(this.icolor.getAdaptedColor()));
                                graphicsArray[n].drawOval(r2.ix() - this.size + 2, r2.iy() - this.size + 2, 2 * this.size - 4, 2 * this.size - 4);
                            }
                            graphicsArray[n].setColor(this.ccolor.getAdaptedColor());
                            graphicsArray[n].drawOval(r2.ix() - this.size, r2.iy() - this.size, 2 * this.size, 2 * this.size);
                        }
                        ++n;
                    }
                    if (!bl) {
                        int n2 = new TFont(this.font).getAscent();
                        R2 r22 = new R2(r2.ix() + this.size, r2.iy() - this.size - n2);
                        this.mthtxt.draw(this.cs, r22.ix(), r22.iy(), graphicsArray);
                    }
                }
                node.r = d;
                node2.r = d2;
            }
        }
    }

    static {
        defaultExpresion = new String[]{"n?", "g?"};
    }
}

