/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.graphR3Config;
import com.mja.gui.mjaColor;
import com.mja.lang.data;
import com.mja.lang.translator;
import com.mja.math.LinearTransformation;
import com.mja.math.R2;
import com.mja.math.R3;
import com.mja.parser.Node;
import com.mja.poly.Face;
import com.mja.poly.Surface;
import com.mja.poly.SurfaceFactory;
import com.mja.poly.mjaSurface;
import com.mja.poly.viewModel;
import com.mja.poly.viewR3;
import com.mja.text.MathText;
import com.mja.text.TFont;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;

public class SpaceR3
extends Space {
    static final mjaColor dfc = new mjaColor(Color.white);
    static final mjaColor dbc = new mjaColor(Color.pink);
    static final double oneDegree = Math.PI / 180;
    private mjaSurface[] pS;
    private Vector text;
    private Vector tx;
    private Vector ty;
    private Vector tfont;
    private Vector tcol;
    private Vector tcond;
    private Surface Poly;
    private viewR3 view;
    private R3 rot;
    private R3 vr;
    private Graphics[] bga = new Graphics[0];
    private Graphics[] fga = new Graphics[1];
    static final int sortAndPaint = 0;
    static final int painterAlgorithm = 1;
    static final int rayTracing = 2;
    private int renderMethod = 0;
    private Node NRotx;
    private Node NRoty;
    private Node NRotz;
    private Node Ndepth;
    private boolean allFixed;

    public SpaceR3(Descartes descartes, int n) {
        super(descartes, n);
    }

    synchronized void start() {
        super.start();
        String string = this.spcfg.prefix() + "observador";
        double d = this.D.p.isVar(string) || this.D.p.isAux(string) ? this.D.p.value(string) : 2.5 * (double)(this.w + this.h);
        this.Ndepth = this.D.p.Var(string);
        this.Ndepth.r = this.correctedDepth(d);
        this.view = new viewR3(this.Ox, this.Oy, this.Ndepth.r, this.Nesc.r);
        this.vr = new R3(0.0, 0.0, 0.0);
        this.NRotx = this.D.p.Var(this.spcfg.prefix() + "rot.x");
        this.NRoty = this.D.p.Var(this.spcfg.prefix() + "rot.y");
        this.NRotz = this.D.p.Var(this.spcfg.prefix() + "rot.z");
        this.rot = new R3(this.NRotx.r, this.NRoty.r, this.NRotz.r);
        this.pS = new mjaSurface[this.D.cfg.allgR3c.length];
        this.tx = new Vector();
        this.ty = new Vector();
        this.text = new Vector();
        this.tfont = new Vector();
        this.tcol = new Vector();
        this.tcond = new Vector();
        int n = 0;
        while (n < this.pS.length) {
            graphR3Config graphR3Config2 = this.D.cfg.allgR3c[n];
            if (graphR3Config2.s_value[0].equals(this.spcfg.getName())) {
                Object object;
                if (translator.equals(graphR3Config2.s_value[1], 63)) {
                    try {
                        object = BasicStr.getTokens(graphR3Config2.s_value[6]);
                        int n2 = ((String[])object).length / 2;
                        boolean bl = false;
                        this.tx.addElement(this.D.p.Analyse(object[0]));
                        this.ty.addElement(this.D.p.Analyse(object[1]));
                        mjaColor mjaColor3 = this.D.Tr.parseColor(graphR3Config2.s_value[12], new mjaColor(Color.gray), null);
                        MathText mathText = new MathText(this.D.p, this.D.Tr, graphR3Config2.s_value[9], this.D.p.Analyse(graphR3Config2.s_value[10], 2.0), translator.isNotFalse(graphR3Config2.s_value[11]), graphR3Config2.font, mjaColor3.getAdaptedColor());
                        this.text.addElement(mathText);
                        this.tfont.addElement(graphR3Config2.font);
                        mjaColor3.analyse(this.D.p);
                        this.tcol.addElement(mjaColor3);
                        this.tcond.addElement(this.D.p.Analyse(graphR3Config2.getCondition(), 1.0));
                    }
                    catch (Exception exception) {
                        System.out.println("bad expression " + graphR3Config2.s_value[6]);
                    }
                } else {
                    this.pS[n] = SurfaceFactory.getMjaSurface(this.D.p, SpaceR3.canonicType(this.D.Tr, graphR3Config2.s_value[1]), graphR3Config2.s_value[6], graphR3Config2.s_value[17], graphR3Config2.s_value[18], graphR3Config2.s_value[19], graphR3Config2.s_value[20], graphR3Config2.s_value[21], graphR3Config2.s_value[22], this.D.Tr.parseColor(graphR3Config2.s_value[12], dfc, null), this.D.Tr.parseColor(graphR3Config2.s_value[13], dbc, null), translator.isNotFalse(graphR3Config2.s_value[14]), graphR3Config2.s_value[7], graphR3Config2.s_value[8], graphR3Config2.s_value[23], graphR3Config2.s_value[24], SpaceR3.getModel(this.D.Tr, graphR3Config2.s_value[15]), graphR3Config2.s_value[3], translator.isTrue(graphR3Config2.s_value[2]));
                    this.pS[n].split = translator.isTrue(graphR3Config2.s_value[16]);
                    if (translator.equals(graphR3Config2.s_value[1], 64)) {
                        try {
                            object = this.D.Tr.parseColor(graphR3Config2.s_value[12], new mjaColor(Color.gray), null);
                            MathText mathText = new MathText(this.D.p, this.D.Tr, graphR3Config2.s_value[9], this.D.p.Analyse(graphR3Config2.s_value[10], 2.0), translator.isNotFalse(graphR3Config2.s_value[11]), graphR3Config2.font, ((mjaColor)object).getAdaptedColor());
                            this.pS[n].setMathText(mathText);
                        }
                        catch (Exception exception) {
                            System.out.println("bad expression " + graphR3Config2.s_value[6]);
                        }
                    }
                }
            }
            ++n;
        }
        this.renderMethod = translator.equals(this.spcfg.s_value[20], 172) ? 1 : (translator.equals(this.spcfg.s_value[20], 173) ? 2 : 0);
        this.fga[0] = this.gmain;
    }

    R2 injection(double d, double d2) {
        this.view.setView(this.Ox, this.Oy, this.view.getDepth());
        R3 r3 = this.view.getView();
        return new R2((d - r3.x) / this.view.getScale(), (r3.y - d2) / this.view.getScale());
    }

    R2 projection(R2 r2) {
        this.view.setView(this.Ox, this.Oy, this.view.getDepth());
        R3 r3 = this.view.getView();
        return new R2(r3.x + this.view.getScale() * r2.x, r3.y - this.view.getScale() * r2.y);
    }

    void flushImages() {
    }

    void stopMoving() {
        this.vr.x = 0.0;
        this.vr.y = 0.0;
        this.vr.z = 0.0;
    }

    boolean isMoving() {
        return this.vr.x != 0.0 || this.vr.y != 0.0 || this.vr.z != 0.0;
    }

    private void drawTexts() {
        int n = 0;
        while (n < this.text.size()) {
            Node node = (Node)this.tcond.elementAt(n);
            if (node.Evaluate(1.0) > 0.0) {
                mjaColor mjaColor3 = (mjaColor)this.tcol.elementAt(n);
                this.gmain.setColor(mjaColor3.getAdaptedColor());
                MathText mathText = (MathText)this.text.elementAt(n);
                Node node2 = (Node)this.tx.elementAt(n);
                Node node3 = (Node)this.ty.elementAt(n);
                int n2 = (int)Math.round(node2.Evaluate(20.0));
                int n3 = (int)Math.round(node3.Evaluate(20.0));
                Font font = (Font)this.tfont.elementAt(n);
                this.gmain.setFont(font);
                TFont tFont = new TFont(font);
                Graphics[] graphicsArray = new Graphics[]{this.gmain};
                R2 r2 = new R2(n2, n3 - tFont.getAscent());
                mathText.draw(this, r2.ix(), r2.iy(), graphicsArray);
            }
            ++n;
        }
    }

    synchronized void doCalc() {
        if (!this.allFixed) {
            this.Poly = null;
            Surface surface = null;
            this.allFixed = true;
            int n = 0;
            while (n < this.pS.length) {
                if (this.pS[n] != null) {
                    Surface surface2;
                    this.allFixed &= this.pS[n].isFixed();
                    if (this.pS[n].cond.Evaluate(1.0) > 0.0 && (surface2 = this.pS[n].create()) != null) {
                        if (this.spcfg.split || this.pS[n].split) {
                            if (surface != null) {
                                surface2 = surface.split(surface2);
                            }
                            surface = Surface.add(surface, surface2);
                        } else {
                            this.Poly = Surface.add(this.Poly, surface2);
                        }
                    }
                }
                ++n;
            }
            this.Poly = Surface.add(this.Poly, surface);
        }
    }

    synchronized void doFront(boolean bl) {
        this.Nesc.r = this.correctedScale(this.Nesc.r);
        this.view.setView(this.Ox, this.Oy, this.view.getDepth());
        this.view.setScale(this.Nesc.r);
        this.Ndepth.r = this.correctedDepth(this.Ndepth.r);
        this.view.setDepth(this.Ndepth.r);
        this.gmain.drawImage(this.back, 0, 0, null);
        this.drawTexts();
        this.adjustControls();
        if (bl) {
            this.doCalc();
        }
        if (this.Poly != null) {
            this.Poly.resetInitialPosition();
            this.rot.x = this.NRotx.r * Math.PI / 180.0;
            this.rot.y = this.NRoty.r * Math.PI / 180.0;
            this.rot.z = this.NRotz.r * Math.PI / 180.0;
            this.Poly.apply(SpaceR3.R3SpaceRotation(this.rot));
            this.Poly.updateView(this.view);
            if (this.renderMethod == 0) {
                this.Poly.sortAndPaint(this.D, this.gmain);
            } else if (this.renderMethod == 1) {
                this.Poly.painterAlgorithm(this.D, this.gmain);
            } else if (this.renderMethod == 2) {
                this.Poly.rayTrace(this.D, this.gmain, this.w, this.h);
            }
        }
        this.drawControls(this.bga, this.fga);
    }

    void moveOneStep() {
        this.D.updateSpinners(null, true);
        this.NRotx.r += this.vr.x * 180.0 / Math.PI;
        this.NRoty.r += this.vr.y * 180.0 / Math.PI;
        this.NRotz.r += this.vr.z * 180.0 / Math.PI;
        this.D.updateSpinners(null, false);
    }

    double correctedDepth(double d) {
        return Math.max(d, 0.5 * (double)(this.w + this.h));
    }

    boolean onDrag(boolean bl, int n, int n2) {
        if (bl) {
            this.Nesc.r = this.Nesc.r * ((double)this.h - (double)n2) / (double)this.h;
            this.view.setScale(this.Nesc.r);
            this.Ndepth.r = this.correctedDepth(this.Ndepth.r * ((double)this.w + (double)n) / (double)this.w);
            this.view.setView(this.Ox, this.Oy, this.Ndepth.r);
            return this.backColor.variable;
        }
        this.vr.x = 0.0;
        this.vr.y = (double)n2 * (Math.PI / 180) / 2.0;
        this.vr.z = (double)n * (Math.PI / 180) / 2.0;
        this.moveOneStep();
        if (n * n < 4) {
            this.vr.z = 0.0;
        }
        if (n2 * n2 < 4) {
            this.vr.y = 0.0;
        }
        return false;
    }

    void writeCoordinates(Graphics graphics, int n, int n2) {
    }

    private static LinearTransformation R3SpaceRotation(R3 r3) {
        LinearTransformation linearTransformation = LinearTransformation.Rotation(2, r3.z);
        LinearTransformation linearTransformation2 = LinearTransformation.Rotation(1, r3.y);
        return LinearTransformation.Multiply(linearTransformation2, linearTransformation);
    }

    public static String canonicType(translator translator2, String string) {
        int n = 0;
        while (n < data.gtR3ix.length) {
            if (translator.equals(string, data.gtR3ix[n])) {
                return translator2.getTr(data.gtR3ix[n], 1);
            }
            ++n;
        }
        return string;
    }

    static viewModel getModel(translator translator2, String string) {
        if (translator.equals(string, 166)) {
            return Face.lightModel;
        }
        if (translator.equals(string, 167)) {
            return Face.metalModel;
        }
        if (translator.equals(string, 168)) {
            return Face.wireModel;
        }
        return Face.colorModel;
    }
}

