/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.mjaGraph;
import com.mja.descutil.mjaStr;
import com.mja.gui.mjaColor;
import com.mja.gui.mjaText;
import com.mja.math.R2;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.TFont;
import com.mja.util.BasicStr;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class SpaceR2
extends Space {
    private static final double infNotExp = 1.0E-8;
    private static final double supNotExp = 9.9999999999E9;
    private Image front;
    private Graphics fg;
    private Graphics[] bga;
    private Graphics[] tga;
    private Graphics[] fga;
    private boolean fillInFront;
    private R2 v = new R2();

    public SpaceR2(Descartes descartes, int n) {
        super(descartes, n);
    }

    synchronized void start() {
        super.start();
    }

    R2 injection(double d, double d2) {
        return this.injection(d, d2, false);
    }

    R2 injection(double d, double d2, boolean bl) {
        if (bl) {
            return new R2(d, d2);
        }
        return new R2((d - (double)this.Ox) / this.Nesc.r, ((double)this.Oy - d2) / this.Nesc.r);
    }

    R2 projection(R2 r2, boolean bl) {
        double d = r2.x;
        double d2 = r2.y;
        if (!bl) {
            d = (double)this.Ox + this.Nesc.r * r2.x;
            d2 = (double)this.Oy - this.Nesc.r * r2.y;
        }
        return new R2(d, d2);
    }

    R2 projection(R2 r2) {
        return this.projection(r2, false);
    }

    void stopMoving() {
        this.v.x = 0.0;
        this.v.y = 0.0;
    }

    boolean isMoving() {
        return this.v.x != 0.0 || this.v.y != 0.0;
    }

    synchronized void doBack(boolean bl) {
        if (this.initializeGraphicStuff() || bl) {
            super.doBack(true);
            double d = this.Nesc.r;
            int n = 0;
            while (d > (double)(this.w + this.h)) {
                d /= 10.0;
                ++n;
            }
            while (d < (double)((this.w + this.h) / 10)) {
                d *= 10.0;
            }
            if (this.spcfg.isOn[1]) {
                this.gback.setColor(this.spcfg.DC[1].getAdaptedColor());
                this.drawMarks(d / 10.0, -1);
            }
            if (this.spcfg.isOn[2]) {
                this.gback.setColor(this.spcfg.DC[2].getAdaptedColor());
                this.drawMarks(d, -1);
            }
            if (this.spcfg.isOn[3]) {
                this.gback.setFont(mjaText.Courier);
                this.gback.setColor(this.spcfg.DC[3].getAdaptedColor());
                if (this.spcfg.x_On) {
                    this.gback.drawLine(0, this.Oy, this.w, this.Oy);
                }
                if (this.spcfg.y_On) {
                    this.gback.drawLine(this.Ox, 0, this.Ox, this.h);
                }
                if (this.spcfg.numbers) {
                    if (d > (double)((this.w + this.h) / 2)) {
                        this.drawNumbers(d / 5.0, d <= this.Nesc.r ? n + 1 : n);
                    } else if (d > (double)((this.w + this.h) / 4)) {
                        this.drawNumbers(d / 2.0, d <= this.Nesc.r ? n + 1 : n);
                    } else {
                        this.drawNumbers(d, n);
                    }
                }
                this.drawMarks(d, 3);
                this.drawMarks(d /= 2.0, 2);
                this.drawMarks(d /= 5.0, 1);
                this.gback.setColor(this.spcfg.DC[3].getAdaptedColor());
                int n2 = this.Ox - 2 - this.gback.getFontMetrics(this.gback.getFont()).stringWidth(this.spcfg.y_axis);
                int n3 = this.gback.getFontMetrics(this.gback.getFont()).getAscent();
                if (this.spcfg.y_On) {
                    this.gback.drawString(this.spcfg.y_axis, n2, n3);
                }
                n2 = this.w - 3 - this.gback.getFontMetrics(this.gback.getFont()).stringWidth(this.spcfg.x_axis);
                n3 = this.Oy + n3;
                if (this.spcfg.x_On) {
                    this.gback.drawString(this.spcfg.x_axis, n2, n3);
                }
            }
            this.drawGraphsInBack();
        }
        if (this.fillInFront) {
            this.fg.setColor(this.backColor.getAdaptedColor());
            this.fg.fillRect(0, 0, this.w, this.h);
        }
    }

    void doCalc() {
    }

    synchronized void doFront(boolean bl) {
        this.gmain.drawImage(this.back, 0, 0, null);
        this.adjustControls();
        this.drawGraphsInFront();
        this.drawControls(this.bga, this.fga);
    }

    void writeCoordinates(Graphics graphics, int n, int n2) {
        if (this.spcfg.isOn[4]) {
            int n3;
            int n4;
            int n5;
            graphics.setFont(mjaText.Courier);
            graphics.setColor(this.spcfg.DC[4].getAdaptedColor());
            graphics.drawOval(n - 2, n2 - 2, 4, 4);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            TFont tFont = new TFont(mjaText.Courier);
            int n6 = 0;
            while (this.Nesc.r > Math.pow(10.0, n6)) {
                ++n6;
            }
            if (n6 > 0) {
                ++n6;
            }
            String string = "(" + BasicStr.DoubleToString((double)(n - this.Ox) / this.Nesc.r, n6, true) + "," + BasicStr.DoubleToString((double)(this.Oy - n2) / this.Nesc.r, n6, true) + ")";
            int n7 = fontMetrics.stringWidth(string);
            int n8 = n - n7 / 2;
            int n9 = n2 - 12;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n8 > (n5 = this.w - n7)) {
                n8 = n5;
            }
            if (n9 < (n4 = tFont.getAscent())) {
                n9 = n4;
            }
            if (n9 > (n3 = this.h - tFont.getDescent())) {
                n9 = n3;
            }
            graphics.drawString(string, n8, n9);
        }
    }

    void moveOneStep() {
        this.D.updateSpinners(null, true);
        this.Ox = (int)((double)this.Ox + this.v.x);
        this.Oy = (int)((double)this.Oy + this.v.y);
        this.NOx.r = (double)this.Ox - (double)this.w / 2.0;
        this.NOy.r = (double)this.Oy - (double)this.h / 2.0;
        this.D.updateSpinners(null, false);
    }

    boolean onDrag(boolean bl, int n, int n2) {
        if (bl) {
            this.D.updateSpinners(null, true);
            double d = this.Nesc.r;
            this.Nesc.r *= ((double)this.h - (double)n2) / (double)this.h;
            if (this.Nesc.r < 1.0E-6) {
                this.Nesc.r = 1.0E-6;
            }
            if (this.Nesc.r > 1000000.0) {
                this.Nesc.r = 1000000.0;
            }
            this.NOx.r *= this.Nesc.r / d;
            this.NOy.r *= this.Nesc.r / d;
            this.Ox = (int)Math.round(this.NOx.r) + this.w / 2;
            this.Oy = (int)Math.round(this.NOy.r) + this.h / 2;
            this.D.updateSpinners(null, false);
        } else {
            this.v.x = n;
            this.v.y = n2;
            this.moveOneStep();
            this.v.x = 0.0;
            this.v.y = 0.0;
        }
        return this.backColor.variable;
    }

    double X(int n, double d, boolean bl) {
        double d2 = d;
        if (!bl) {
            d2 = (double)this.Ox + this.Nesc.r * d;
        }
        if (d2 < (double)(-n)) {
            d2 = -n;
        }
        if (d2 > (double)(this.w + n)) {
            d2 = this.w + n;
        }
        return d2;
    }

    double Y(int n, double d, boolean bl) {
        double d2 = d;
        if (!bl) {
            d2 = (double)this.Oy - this.Nesc.r * d;
        }
        if (d2 < (double)(-n)) {
            d2 = -n;
        }
        if (d2 > (double)(this.h + n)) {
            d2 = this.h + n;
        }
        return d2;
    }

    int XX(int n, double d, boolean bl) {
        return (int)Math.round(this.X(n, d, bl));
    }

    int YY(int n, double d, boolean bl) {
        return (int)Math.round(this.Y(n, d, bl));
    }

    private boolean initializeGraphicStuff() {
        boolean bl = false;
        if (this.front == null) {
            this.front = this.createImage(this.w, this.h);
            this.fg = this.front.getGraphics();
            this.fg.setFont(mjaText.Courier);
            this.bga = new Graphics[1];
            this.bga[0] = this.gback;
            bl = true;
        }
        this.fillInFront = false;
        int n = 0;
        while (n < this.D.scene.graph.length) {
            if (this.D.scene.graph[n] != null && !this.D.scene.graph[n].gc.isInBack && this.D.scene.graph[n].gc.type == 43) {
                this.fillInFront = true;
                break;
            }
            ++n;
        }
        if (this.fillInFront) {
            this.fga = new Graphics[2];
            this.fga[0] = this.fg;
            this.fga[1] = this.gmain;
            this.tga = new Graphics[3];
            this.tga[0] = this.gback;
            this.tga[1] = this.fg;
            this.tga[2] = this.gmain;
        } else {
            this.fga = new Graphics[1];
            this.fga[0] = this.gmain;
            this.tga = new Graphics[2];
            this.tga[0] = this.gback;
            this.tga[1] = this.gmain;
        }
        bl = this.spaceChanged() | bl;
        return bl;
    }

    private void drawGraphsInBack() {
        int n = 0;
        while (n < this.D.scene.graph.length) {
            if (this.D.scene.graph[n] != null && this.D.scene.graph[n].gc.isInBack) {
                this.drawGraph(this.D.p, this.D.scene.graph[n]);
            }
            ++n;
        }
    }

    private void drawGraphsInFront() {
        int n = 0;
        while (n < this.D.scene.graph.length) {
            if (this.D.scene.graph[n] != null && !this.D.scene.graph[n].gc.isInBack) {
                this.drawGraph(this.D.p, this.D.scene.graph[n]);
            }
            ++n;
        }
    }

    void flushImages() {
        int n = 0;
        while (n < this.D.scene.graph.length) {
            if (this.D.scene.graph[n].ith != null) {
                this.D.scene.graph[n].ith.pleaseStop();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.D.scene.graph.length) {
            if (this.D.scene.graph[n2].image != null) {
                this.D.scene.graph[n2].image.flush();
                this.D.scene.graph[n2].image = null;
            }
            ++n2;
        }
    }

    private void drawMarks(double d, int n) {
        int n2;
        int n3 = 0;
        int n4 = this.w;
        int n5 = 0;
        int n6 = this.h;
        if (n >= 0) {
            n3 = this.Ox - n;
            n4 = this.Ox + n;
            n5 = this.Oy - n;
            n6 = this.Oy + n;
        }
        if (this.spcfg.x_On && n > 0 || n < 0) {
            int n7;
            n2 = -((int)Math.round((double)this.Ox / d));
            while ((n7 = this.Ox + (int)Math.round((double)n2 * d)) < this.w) {
                this.gback.drawLine(n7, n5, n7, n6);
                ++n2;
            }
        }
        if (this.spcfg.y_On && n > 0 || n < 0) {
            int n8;
            n2 = -((int)Math.round((double)this.Oy / d));
            while ((n8 = this.Oy + (int)Math.round((double)n2 * d)) < this.h) {
                this.gback.drawLine(n3, n8, n4, n8);
                ++n2;
            }
        }
    }

    private void drawNumbers(double d, int n) {
        int n2;
        if (this.spcfg.x_On) {
            int n3;
            n2 = -((int)Math.round((double)this.Ox / d));
            while ((n3 = this.Ox + (int)Math.round((double)n2 * d)) < this.w) {
                this.gback.drawString(mjaStr.notExp((double)n2 * d / this.Nesc.r, 1.0E-8, 9.9999999999E9), n3 + 2, this.Oy - 2);
                ++n2;
            }
        }
        if (this.spcfg.y_On) {
            int n4;
            n2 = -((int)Math.round((double)this.Oy / d));
            while ((n4 = this.Oy + (int)Math.round((double)n2 * d)) < this.h) {
                this.gback.drawString(mjaStr.notExp(-((double)n2) * d / this.Nesc.r, 1.0E-8, 9.9999999999E9), this.Ox + 2, n4 - 2);
                ++n2;
            }
        }
    }

    private void drawGraph(Parser parser, mjaGraph mjaGraph2) {
        Node node = parser.Var("x");
        Node node2 = parser.Var("y");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.r;
                double d2 = node2.r;
                if (mjaGraph2.sparz != null) {
                    Node node5;
                    int n = (int)Math.round(mjaGraph2.sparz.NN.Evaluate(32.0));
                    double d3 = mjaGraph2.sparz.Ni.Evaluate(0.0);
                    double d4 = mjaGraph2.sparz.Nf.Evaluate(1.0);
                    Node node6 = node5 = parser.Var(mjaGraph2.sparz.name);
                    synchronized (node6) {
                        double d5 = node5.r;
                        int n2 = 0;
                        while (n2 <= n) {
                            node5.r = d3 + (d4 - d3) * (double)n2 / (double)n;
                            this.drawGraph(mjaGraph2);
                            ++n2;
                        }
                        node5.r = d5;
                    }
                } else {
                    this.drawGraph(mjaGraph2);
                }
                node.r = d;
                node2.r = d2;
            }
        }
    }

    private void drawGraph(mjaGraph mjaGraph2) {
        if (mjaGraph2.cs == this) {
            if (mjaGraph2.gc.isInBack) {
                mjaColor[] mjaColorArray = new mjaColor[this.bga.length];
                int n = 0;
                while (n < this.bga.length) {
                    mjaColorArray[n] = mjaGraph2.gc.gcolor;
                    ++n;
                }
                mjaGraph2.draw(this.back, this.bga, mjaColorArray);
            } else if (mjaGraph2.gc.hasTrace) {
                mjaColor[] mjaColorArray = new mjaColor[this.tga.length];
                int n = 0;
                while (n < this.tga.length) {
                    mjaColorArray[n] = n == 0 ? mjaGraph2.gc.traceColor : mjaGraph2.gc.gcolor;
                    ++n;
                }
                mjaGraph2.draw(this.front, this.tga, mjaColorArray);
            } else {
                mjaColor[] mjaColorArray = new mjaColor[this.fga.length];
                int n = 0;
                while (n < this.fga.length) {
                    mjaColorArray[n] = mjaGraph2.gc.gcolor;
                    ++n;
                }
                mjaGraph2.draw(this.front, this.fga, mjaColorArray);
            }
        }
    }
}

