/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Descartes;
import com.mja.descartes.controlConfig;
import com.mja.descartes.spaceConfig;
import com.mja.descgui.mjaGui;
import com.mja.descutil.mjaStr;
import com.mja.file.mjaFile;
import com.mja.gui.mjaColor;
import com.mja.gui.mjaText;
import com.mja.math.R2;
import com.mja.parser.Node;
import com.mja.util.BasicStr;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class Space
extends Panel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    Descartes D;
    spaceConfig spcfg;
    mjaColor backColor;
    private Image main;
    Image back;
    Image bgimage;
    Graphics gmain;
    Graphics gback;
    Thread thr;
    private boolean pleaseStop;
    static final int bck = 0;
    static final int net = 1;
    static final int net10 = 2;
    static final int axe = 3;
    static final int tex = 4;
    int w = -1;
    int h = -1;
    int Ox;
    int Oy;
    private int Oxa;
    private int Oya;
    private double esca;
    Node NOx;
    Node NOy;
    Node Nesc;
    private int index = 0;
    private int Lx;
    private int Ly;
    private int xa;
    private int ya;
    private controlConfig aC;
    private int acix;
    private controlConfig[] grctrl;
    private boolean dragged;
    private controlConfig ttc;

    abstract void stopMoving();

    abstract void flushImages();

    abstract boolean isMoving();

    abstract void doCalc();

    abstract void doFront(boolean var1);

    abstract void moveOneStep();

    abstract boolean onDrag(boolean var1, int var2, int var3);

    abstract void writeCoordinates(Graphics var1, int var2, int var3);

    abstract R2 injection(double var1, double var3);

    abstract R2 projection(R2 var1);

    public Space(Descartes descartes, int n) {
        this.setLayout(null);
        this.D = descartes;
        this.index = n;
        this.spcfg = descartes.cfg.sc[n];
        this.backColor = this.spcfg.DC[0];
        int n2 = 0;
        int n3 = 0;
        while (n3 < descartes.cfg.cc.length) {
            if (descartes.cfg.cc[n3].type == 97 && descartes.cfg.cc[n3].s_value[4].equals(this.spcfg.getName())) {
                ++n2;
            }
            ++n3;
        }
        this.grctrl = new controlConfig[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < descartes.cfg.cc.length) {
            if (descartes.cfg.cc[n5].type == 97 && descartes.cfg.cc[n5].s_value[4].equals(this.spcfg.getName())) {
                this.grctrl[n4] = descartes.cfg.cc[n5];
                this.grctrl[n4].setSpace(this);
                ++n4;
            }
            ++n5;
        }
        if (BasicStr.hasContent(this.spcfg.bgimage)) {
            this.bgimage = mjaFile.loadImage(descartes, this.spcfg.bgimage);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    void preSize() {
        Dimension dimension = this.D.scene.getSize();
        this.Lx = (int)Math.round(mjaStr.parsePercentageOf(this.spcfg.left, dimension.width, 0.0, 0.0));
        this.Ly = (int)Math.round(mjaStr.parsePercentageOf(this.spcfg.top, dimension.height, 0.0, 0.0));
        this.w = (int)Math.round(mjaStr.parsePercentageOf(this.spcfg.width, dimension.width, 2.147483647E9, 2.147483647E9));
        this.h = (int)Math.round(mjaStr.parsePercentageOf(this.spcfg.height, dimension.height, 2.147483647E9, 2.147483647E9));
        this.Lx = Math.min(Math.max(0, this.Lx), dimension.width);
        this.Ly = Math.min(Math.max(0, this.Ly), dimension.height);
        this.w = Math.min(this.w, dimension.width - this.Lx);
        this.h = Math.min(this.h, dimension.height - this.Ly);
        this.setBounds(this.Lx, this.Ly, this.w, this.h);
        this.D.p.defineVar(this.spcfg.prefix() + "_w", this.w);
        this.D.p.defineVar(this.spcfg.prefix() + "_h", this.h);
        this.getSpaceParameters();
    }

    synchronized void start() {
        int n = 0;
        while (n < this.spcfg.DC.length) {
            this.spcfg.DC[n].analyse(this.D.p);
            ++n;
        }
        this.main = this.createImage(this.w, this.h);
        this.gmain = this.main.getGraphics();
        this.gmain.setFont(mjaText.Courier);
        this.back = this.createImage(this.w, this.h);
        this.gback = this.back.getGraphics();
        this.gback.setFont(mjaText.Courier);
        this.pleaseStop = false;
        this.thr = new Thread(this);
        this.D.threads.push(this);
        this.thr.setPriority(1);
        this.thr.start();
    }

    private void getSpaceParameters() {
        Dimension dimension = this.getSize();
        String string = this.spcfg.prefix() + "escala";
        double d = this.D.p.isVar(string) || this.D.p.isAux(string) ? this.D.p.value(string) : mjaStr.parsePercentageOf(this.spcfg.s_scale, dimension.width, this.D.cfg.escala0, this.D.cfg.escala0);
        this.Nesc = this.D.p.Var(string);
        this.Nesc.r = d;
        string = this.spcfg.prefix() + "Ox";
        if (this.D.p.isVar(string) || this.D.p.isAux(string)) {
            this.Ox = (int)Math.round(this.D.p.value(string) + (double)this.w / 2.0);
        } else {
            this.Ox = (int)Math.round(mjaStr.parsePercentageOf(this.spcfg.s_Ox, dimension.width, 0.0, 0.0) + (double)this.w / 2.0);
            this.D.p.Var((String)string).r = (double)this.Ox - (double)this.w / 2.0;
        }
        this.NOx = this.D.p.Var(string);
        string = this.spcfg.prefix() + "Oy";
        if (this.D.p.isVar(string) || this.D.p.isAux(string)) {
            this.Oy = (int)Math.round(this.D.p.value(string) + (double)this.h / 2.0);
        } else {
            this.Oy = (int)Math.round(mjaStr.parsePercentageOf(this.spcfg.s_Oy, dimension.height, 0.0, 0.0) + (double)this.h / 2.0);
            this.D.p.Var((String)string).r = (double)this.Oy - (double)this.h / 2.0;
        }
        this.NOy = this.D.p.Var(string);
        String[] stringArray = new String[]{"x"};
        String string2 = "(x-" + this.spcfg.prefix() + "Ox-" + Integer.toString(this.w / 2) + ")/" + this.spcfg.prefix() + "escala";
        this.D.p.defineFunc(this.spcfg.prefix() + "_x", stringArray, string2, false);
        String[] stringArray2 = new String[]{"y"};
        string2 = "(" + Integer.toString(this.h / 2) + "-y+" + this.spcfg.prefix() + "Oy)/" + this.spcfg.prefix() + "escala";
        this.D.p.defineFunc(this.spcfg.prefix() + "_y", stringArray2, string2, false);
    }

    synchronized void doBack(boolean bl) {
        if (this.spaceChanged() || bl) {
            if (this.backColor.variable) {
                this.D.setCursor(new Cursor(3));
                Node node = this.D.p.Var("x");
                Node node2 = this.D.p.Var("y");
                Node node3 = node;
                synchronized (node3) {
                    Node node4 = node2;
                    synchronized (node4) {
                        double d = node.r;
                        double d2 = node2.r;
                        int n = 0;
                        while (n < this.h) {
                            node2.r = this.y(n);
                            int n2 = 0;
                            while (n2 < this.w) {
                                node.r = this.x(n2);
                                this.gback.setColor(this.backColor.getAdaptedColor());
                                this.gback.fillRect(n2, n, 1, 1);
                                ++n2;
                            }
                            ++n;
                        }
                        node.r = d;
                        node2.r = d2;
                    }
                }
                this.D.setCursor(null);
            } else {
                this.gback.setColor(this.backColor.getAdaptedColor());
                this.gback.fillRect(0, 0, this.w, this.h);
            }
            if (this.bgimage != null) {
                int n = this.bgimage.getWidth(this);
                int n3 = this.bgimage.getHeight(this);
                switch (this.spcfg.bgdisplay) {
                    case 1: {
                        this.gback.drawImage(this.bgimage, 0, 0, this.w, this.h, this);
                        break;
                    }
                    case 3: {
                        this.gback.drawImage(this.bgimage, (this.w - n) / 2, (this.h - n3) / 2, this);
                        break;
                    }
                    case 2: {
                        int n4 = 0;
                        while (n4 < this.h) {
                            int n5 = 0;
                            while (n5 < this.w) {
                                this.gback.drawImage(this.bgimage, n5, n4, this);
                                n5 += n;
                            }
                            n4 += n3;
                        }
                        break;
                    }
                    default: {
                        this.gback.drawImage(this.bgimage, 0, 0, this);
                    }
                }
            }
        }
    }

    public synchronized void run() {
        this.pleaseStop = false;
        try {
            Thread.sleep(100L);
            while (!this.pleaseStop) {
                Thread.sleep(25L);
                if (this.isMoving()) {
                    this.moveOneStep();
                    this.doBack(false);
                    this.doFront(false);
                    this.paint(this.getGraphics());
                }
                this.wait(25L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thr = null;
    }

    public void stop() {
        this.pleaseStop = true;
        this.flushImages();
    }

    double x(int n) {
        return (double)(n - this.Ox) / this.Nesc.r;
    }

    double y(int n) {
        return (double)(this.Oy - n) / this.Nesc.r;
    }

    boolean inside(R2 r2) {
        return -this.w <= r2.ix() && r2.ix() <= 2 * this.w && -this.h <= r2.iy() && r2.iy() <= 2 * this.h;
    }

    boolean closeEnough(R2 r2, R2 r22, int n) {
        return this.projection(r22).distance(r2) < (double)n;
    }

    void adjustControls() {
        int n = 0;
        while (n < this.grctrl.length) {
            this.grctrl[n].adjust();
            ++n;
        }
    }

    void drawControls(Graphics[] graphicsArray, Graphics[] graphicsArray2) {
        int n = 0;
        while (n < this.grctrl.length) {
            if (this.grctrl[n].hasTrace) {
                this.grctrl[n].drawControl(true, graphicsArray);
            }
            this.grctrl[n].drawControl(false, graphicsArray2);
            ++n;
        }
    }

    void setActiveControl(int n) {
        if (n < 0) {
            n = this.grctrl.length - 1;
        }
        if (n >= this.grctrl.length) {
            n = 0;
        }
        int n2 = 0;
        while (n2 < this.grctrl.length) {
            this.grctrl[n2].isActive = false;
            ++n2;
        }
        this.grctrl[n].isActive = true;
        this.aC = this.grctrl[n];
        this.acix = n;
    }

    boolean spaceChanged() {
        this.Ox = (int)Math.round(this.D.p.value(this.spcfg.prefix() + "Ox") + (double)this.w / 2.0);
        this.Oy = (int)Math.round(this.D.p.value(this.spcfg.prefix() + "Oy") + (double)this.h / 2.0);
        this.Nesc.r = this.correctedScale(this.Nesc.r);
        boolean bl = this.Nesc.r != this.esca || this.Ox != this.Oxa || this.Oy != this.Oya;
        this.esca = this.Nesc.r;
        this.Oxa = this.Ox;
        this.Oya = this.Oy;
        return bl;
    }

    double correctedScale(double d) {
        if (this.Nesc.r < 1.0E-6) {
            this.Nesc.r = 1.0E-6;
        }
        if (this.Nesc.r > 1000000.0) {
            this.Nesc.r = 1000000.0;
        }
        if (d < 1.0E-6) {
            return 1.0E-6;
        }
        if (d > 1000000.0) {
            return 1000000.0;
        }
        return d;
    }

    public void paint(Graphics graphics) {
        if (graphics != null && this.main != null) {
            graphics.drawImage(this.main, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragged = false;
        this.xa = mouseEvent.getX();
        this.ya = mouseEvent.getY();
        if (mouseEvent.getModifiers() == 16) {
            if (this.aC != null) {
                this.aC.isActive = false;
                this.doBack(false);
                this.doFront(false);
                this.paint(this.getGraphics());
            }
            this.aC = null;
            R2 r2 = new R2(this.xa, this.ya);
            boolean bl = false;
            int n = 0;
            while (n < this.grctrl.length) {
                if (this.closeEnough(r2, this.grctrl[n].cpos, this.grctrl[n].size + 1)) {
                    this.setActiveControl(n);
                    bl = true;
                    this.doBack(false);
                    this.doFront(false);
                    this.paint(this.getGraphics());
                    return;
                }
                ++n;
            }
            if (!bl) {
                this.writeCoordinates(this.getGraphics(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragged) {
            this.doBack(false);
            this.doFront(false);
            this.dragged = false;
            this.D.setCursor(null);
            this.dragged = false;
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            R2 r2 = new R2(this.xa, this.ya);
            boolean bl = false;
            int n = 0;
            while (n < this.grctrl.length) {
                if (this.closeEnough(r2, this.grctrl[n].cpos, this.grctrl[n].size + 1) && BasicStr.hasContent(this.grctrl[n].explanation)) {
                    bl = true;
                    this.paint(this.getGraphics());
                    mjaText.msg((Component)mouseEvent.getSource(), this.grctrl[n].label, this.grctrl[n].explanation, this.grctrl[n].expl_font);
                }
                ++n;
            }
            if (!bl) {
                this.D.showExternalSpinners();
            }
        } else if (mouseEvent.getClickCount() == 2) {
            this.D.edit();
        } else if (mouseEvent.getClickCount() == 1) {
            this.stopMoving();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.aC != null) {
            if (mouseEvent.getModifiers() == 16) {
                this.aC.setControlPos(mouseEvent.getX(), mouseEvent.getY());
                this.D.scene.update();
            }
        } else if (!this.spcfg.fixed) {
            this.dragged |= this.onDrag(mouseEvent.getModifiers() == 4, mouseEvent.getX() - this.xa, mouseEvent.getY() - this.ya);
            this.D.updateSpinners(null, true);
            if (!this.dragged) {
                this.doBack(false);
                this.doFront(false);
                this.paint(this.getGraphics());
            } else {
                this.D.setCursor(new Cursor(13));
            }
        } else if (mouseEvent.getModifiers() == 16) {
            this.doBack(false);
            this.doFront(false);
            this.paint(this.getGraphics());
            this.writeCoordinates(this.getGraphics(), mouseEvent.getX(), mouseEvent.getY());
        }
        this.xa = mouseEvent.getX();
        this.ya = mouseEvent.getY();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        int n = 0;
        while (n < this.grctrl.length) {
            R2 r2 = new R2(mouseEvent.getX(), mouseEvent.getY());
            if (this.closeEnough(r2, this.grctrl[n].cpos, this.grctrl[n].size)) {
                bl = true;
                if (this.grctrl[n] == this.ttc) break;
                this.ttc = this.grctrl[n];
                if (!BasicStr.hasContent(this.grctrl[n].tooltip)) break;
                Component component = (Component)mouseEvent.getSource();
                mjaGui.showTooltip(this.D, component, new Point(component.getLocationOnScreen().x + mouseEvent.getX(), component.getLocationOnScreen().y + mouseEvent.getY() + 16), this.grctrl[n].tooltip, this.D.Tr.getTr(200), this.grctrl[n].tooltip_font);
                break;
            }
            ++n;
        }
        if (!bl) {
            this.ttc = null;
            mjaGui.hideTooltip();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this && this.grctrl.length > 0) {
            if (this.aC == null) {
                this.setActiveControl(0);
            }
            if (this.aC != null) {
                controlConfig controlConfig2 = this.aC;
                R2 r2 = this.aC.getControlPos();
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        r2.x -= 1.0;
                        break;
                    }
                    case 39: {
                        r2.x += 1.0;
                        break;
                    }
                    case 38: {
                        r2.y -= 1.0;
                        break;
                    }
                    case 40: {
                        r2.y += 1.0;
                        break;
                    }
                    case 9: {
                        if (keyEvent.getModifiers() == 1) {
                            --this.acix;
                            if (this.acix < 0) {
                                this.acix = this.grctrl.length - 1;
                            }
                        } else {
                            ++this.acix;
                            if (this.acix >= this.grctrl.length) {
                                this.acix = 0;
                            }
                        }
                        this.setActiveControl(this.acix);
                        keyEvent.consume();
                        this.doBack(false);
                        this.doFront(false);
                        this.paint(this.getGraphics());
                        return;
                    }
                    default: {
                        return;
                    }
                }
                controlConfig2.setControlPos(r2.x, r2.y);
                this.D.scene.update();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

