/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Action;
import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.SpaceR2;
import com.mja.descartes.SpaceR3;
import com.mja.descartes.mjaGraph;
import com.mja.descgui.NumericControl;
import com.mja.descgui.OldMjaButton;
import com.mja.descgui.edit.mjaPair;
import com.mja.gui.mjaText;
import com.mja.parser.Algorithm;
import com.mja.parser.Node;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class Scene
extends Panel
implements ActionListener,
Runnable {
    mjaGraph[] graph;
    private Descartes D;
    private Space[] spa;
    private Thread thr;
    private Panel animCtrl;
    private OldMjaButton[] b;
    private Algorithm animAlg;
    private volatile boolean pleaseStop;
    private volatile boolean running;
    private volatile boolean pause;
    private volatile boolean onestep;
    private volatile boolean stay;
    private Vector numCtrl;

    public Scene(Descartes descartes) {
        this.D = descartes;
        this.setBackground(Color.lightGray);
        this.setLayout(null);
        this.animCtrl = new Panel();
        this.b = new OldMjaButton[6];
        this.animCtrl.setLayout(new GridLayout(1, this.b.length));
        this.animCtrl.setVisible(false);
        this.add(this.animCtrl);
        int n = 0;
        while (n < this.b.length) {
            this.b[n] = new OldMjaButton(n);
            this.animCtrl.add(this.b[n]);
            this.b[n].addActionListener(this);
            ++n;
        }
    }

    void initialize() {
        this.removeAll();
        this.add(this.animCtrl);
        this.spa = new Space[this.D.cfg.sc.length];
        int n = this.spa.length - 1;
        while (n >= 0) {
            this.D.cfg.sc[n].updateInfo(this.D.Tr);
            this.spa[n] = this.D.cfg.sc[n].type == 1 ? new SpaceR3(this.D, n) : new SpaceR2(this.D, n);
            this.add(this.spa[n]);
            --n;
        }
        this.graph = new mjaGraph[this.D.cfg.allgR2c.length];
        int n2 = 0;
        while (n2 < this.graph.length) {
            this.graph[n2] = this.D.cfg.allgR2c[n2].type < 0 ? null : new mjaGraph(this.D, n2);
            ++n2;
        }
    }

    void addNumericControls(NumericControl[] numericControlArray) {
        this.numCtrl = new Vector();
        if (numericControlArray != null) {
            int n = 0;
            while (n < numericControlArray.length) {
                if (numericControlArray[n] != null && numericControlArray[n].isInterior()) {
                    Space space = this.getSpace(0, numericControlArray[n].getSpace());
                    if (space == null) {
                        space = this.getSpace(1, numericControlArray[n].getSpace());
                    }
                    if (space != null) {
                        this.numCtrl.addElement(numericControlArray[n]);
                        space.add(numericControlArray[n]);
                    }
                }
                ++n;
            }
        }
    }

    void initAnimation() {
        this.animAlg.initialize();
    }

    void toggleAnimation() {
        if (this.running) {
            this.pause = !this.pause;
        } else {
            this.startAnimation();
        }
        this.updateAnimationButtons();
    }

    Panel getVisibleEquationsPanel() {
        Panel panel = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.D.cfg.auxiliar.length) {
            if (this.D.cfg.auxiliar[n2].type == 103 && this.D.cfg.auxiliar[n2].isEditable) {
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.D.cfg.allgR2c.length) {
            if (this.D.cfg.allgR2c[n3].type >= 0 && this.graph[n3].cs != null && this.graph[n3].gc.isVisible) {
                ++n;
            }
            ++n3;
        }
        if (n > 0) {
            panel = new Panel();
            panel.setLayout(new GridLayout(1, n));
            int n4 = 0;
            while (n4 < this.graph.length) {
                if (this.graph[n4].cs != null && this.graph[n4].gc.isVisible) {
                    this.graph[n4].TF = new TextField(this.graph[n4].gc.formula);
                    this.graph[n4].TF.setForeground(this.graph[n4].gc.gcolor.getAdaptedColor());
                    if (BasicStr.osIsWindows()) {
                        this.graph[n4].TF.setFont(mjaText.Courier);
                    } else {
                        this.graph[n4].TF.setFont(mjaText.Courier_11);
                    }
                    if (this.graph[n4].gc.isEditable) {
                        this.graph[n4].TF.setEditable(true);
                        this.graph[n4].TF.addActionListener(this);
                    } else {
                        this.graph[n4].TF.setEditable(false);
                    }
                    this.graph[n4].TF.setBackground(this.graph[n4].cs.backColor.getAdaptedColor());
                    panel.add(this.graph[n4].TF);
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.D.cfg.auxiliar.length) {
                if (this.D.cfg.auxiliar[n5].type == 103 && this.D.cfg.auxiliar[n5].isEditable) {
                    this.D.cfg.auxiliar[n5].exprEd = new mjaPair(this, 0.1, 0.9, 20);
                    this.D.cfg.auxiliar[n5].exprEd.addActionListener(this);
                    this.D.cfg.auxiliar[n5].exprEd.setInfo(this.D.cfg.auxiliar[n5].getName() + " =", this.D.cfg.auxiliar[n5].s_value[5]);
                    panel.add(this.D.cfg.auxiliar[n5].exprEd);
                }
                ++n5;
            }
        }
        return panel;
    }

    synchronized void update() {
        int n = 0;
        while (n < this.numCtrl.size()) {
            NumericControl numericControl = (NumericControl)this.numCtrl.elementAt(n);
            numericControl.locate();
            ++n;
        }
        this.D.updateSpinners(null, false);
        this.draw(false);
    }

    void clear() {
        this.draw(true);
    }

    void preSizeSpaces() {
        int n = this.spa.length - 1;
        while (n >= 0) {
            this.spa[n].preSize();
            --n;
        }
    }

    void start(boolean bl) {
        int n = this.spa.length - 1;
        while (n >= 0) {
            this.spa[n].start();
            --n;
        }
        int n2 = 0;
        while (n2 < this.graph.length) {
            if (this.graph[n2] != null) {
                this.graph[n2].initialize();
            }
            ++n2;
        }
        this.running = false;
        this.animCtrl.setLocation((this.getSize().width - 120) / 2, this.getSize().height - 22);
        this.animCtrl.setSize(120, 20);
        if (this.D.cfg.animC.active) {
            this.animAlg = new Algorithm(this.D.p, false, this.D.cfg.animC.s_value[5], this.D.cfg.animC.s_value[4], this.D.cfg.animC.s_value[6]);
        }
        this.clear();
        this.draw(false);
        this.pleaseStop = false;
    }

    void stop() {
        this.stopAnimation();
        int n = this.spa.length - 1;
        while (n >= 0) {
            this.spa[n].stop();
            --n;
        }
    }

    private void draw(boolean bl) {
        if (!bl) {
            try {
                this.D.p.doAlgorithms(false);
            }
            catch (Exception exception) {
                Scene.limitExceeded();
            }
        }
        int n = 0;
        while (n < this.spa.length) {
            if (!this.spa[n].isMoving()) {
                this.spa[n].doBack(bl);
                this.spa[n].doFront(true);
                this.spa[n].paint(this.spa[n].getGraphics());
            } else {
                this.spa[n].doCalc();
            }
            ++n;
        }
        Enumeration enumeration = this.D.actions.elements();
        while (enumeration.hasMoreElements()) {
            Action action = (Action)enumeration.nextElement();
            if (!action.checkCondition()) continue;
            action.execute();
        }
    }

    static void limitExceeded() {
        mjaText.ask("Descartes", " \u00a1Se ha excedidio el l\u00edmite de\n 100000 repeticiones en un algoritmo!", "ok", null);
    }

    boolean animationIsRunning() {
        return this.running && !this.pause;
    }

    void StartAnimation(boolean bl) {
        if (bl && this.D.cfg.animC.active && this.D.cfg.animC.autorun) {
            this.startAnimation();
        }
    }

    private synchronized void startAnimation() {
        if (this.D.cfg.animC.controls) {
            this.b[0].type = -1;
            this.animCtrl.setVisible(true);
        }
        this.pause = false;
        this.thr = new Thread(this);
        this.D.threads.push(this);
        this.thr.start();
    }

    void stopAnimation() {
        this.pleaseStop = true;
    }

    Space getSpace(int n, String string) {
        int n2 = 0;
        while (n2 < this.D.cfg.sc.length) {
            if (this.D.cfg.sc[n2].getName().equals(string)) {
                return this.spa[n2];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.D.cfg.sc.length) {
            if (this.D.cfg.sc[n3].type == n) {
                return this.spa[n3];
            }
            ++n3;
        }
        return this.spa[0];
    }

    public synchronized void run() {
        this.pleaseStop = false;
        this.running = true;
        this.onestep = false;
        this.stay = false;
        this.updateAnimationButtons();
        Node node = this.D.p.Analyse(this.D.cfg.animC.s_value[0], "60");
        this.animAlg.initialize();
        try {
            Thread.sleep(500L);
            while (!this.pleaseStop) {
                Thread.sleep(20L);
                do {
                    if (!this.pause || this.onestep) {
                        this.stay = false;
                        this.animAlg.step();
                        this.onestep = false;
                        this.update();
                    }
                    this.wait(Math.max(20L, Math.round(node.Evaluate(50.0))));
                } while (!this.pleaseStop && this.animAlg.repeat());
                if (this.stay || this.D.cfg.animC.loop) {
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.animCtrl.setVisible(false);
        this.running = false;
        this.updateAnimationButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b[0]) {
            this.toggleAnimation();
        } else if (actionEvent.getSource() == this.b[2]) {
            this.animAlg.initialize();
            if (this.pause) {
                this.update();
            }
        } else if (actionEvent.getSource() == this.b[3]) {
            this.pause = true;
            this.backStep();
        } else if (actionEvent.getSource() == this.b[4]) {
            this.pause = true;
            this.onestep = true;
        } else if (actionEvent.getSource() == this.b[5]) {
            this.pause = true;
            this.toEnd();
        } else if (actionEvent.getSource() == this.b[1]) {
            this.stopAnimation();
        } else if (actionEvent.getSource() instanceof mjaPair) {
            int n = 0;
            while (n < this.D.cfg.auxiliar.length) {
                if (this.D.cfg.auxiliar[n].type == 103 && this.D.cfg.auxiliar[n].isEditable) {
                    this.D.p.defineExpr(this.D.cfg.auxiliar[n].getName(), this.D.cfg.auxiliar[n].exprEd.getInfo(this.D.Tr));
                }
                ++n;
            }
            this.clear();
            this.draw(false);
        } else if (actionEvent.getSource() instanceof TextField) {
            int n = 0;
            while (n < this.graph.length) {
                if (this.graph[n].gc.isEditable) {
                    this.graph[n].gc.formula = this.graph[n].TF.getText();
                    this.graph[n].analyse();
                    if (this.graph[n].gc.isInBack) {
                        this.graph[n].cs.doBack(false);
                    }
                }
                ++n;
            }
            this.update();
        }
    }

    private void updateAnimationButtons() {
        this.b[0].type = !this.animationIsRunning() ? 0 : -1;
        this.b[0].repaint();
        this.D.updateAnimationButtons();
    }

    private void backStep() {
        try {
            this.animAlg.backstep();
            this.update();
        }
        catch (Exception exception) {
            Scene.limitExceeded();
        }
    }

    private void toEnd() {
        try {
            this.animAlg.toEnd();
            this.update();
            this.stay = true;
        }
        catch (Exception exception) {
            Scene.limitExceeded();
        }
    }
}

