/*
 * Decompiled with CFR 0.152.
 */
package com.mja.cmp;

import com.mja.cmp.mjaComponent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class mjaLabel
extends mjaComponent {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private Image img;
    private String text;
    private FontMetrics fm;
    private int align = 0;
    int sw;
    int extraSpace = 8;

    public mjaLabel(Image image) {
        this("");
        this.img = image;
        if (image != null) {
            this.setSize(image.getWidth(this), image.getHeight(this));
        }
    }

    public mjaLabel(String string) {
        this(string, 1);
    }

    public mjaLabel(String string, int n) {
        this(string, n, 8);
    }

    public mjaLabel(String string, int n, int n2) {
        this.text = string;
        this.setAlignment(n);
        this.extraSpace = n2;
        this.setFont(this.getFont());
    }

    public void setAlignment(int n) {
        if (n >= 0 && n <= 2) {
            this.align = n;
        }
    }

    private void updateSize() {
        if (this.img == null) {
            this.setSize(2 * this.extraSpace + this.fm.stringWidth(this.text), 4 + this.fm.getMaxAscent() + this.fm.getMaxDescent());
        }
    }

    public Dimension getPreferedSize() {
        if (this.img != null) {
            return new Dimension(this.img.getWidth(this), this.img.getHeight(this));
        }
        return new Dimension(2 * this.extraSpace + this.fm.stringWidth(this.text), 4 + this.fm.getMaxAscent() + this.fm.getMaxDescent());
    }

    public void setFont(Font font) {
        if (this.img == null) {
            super.setFont(font);
            this.fm = this.getFontMetrics(this.getFont());
            this.sw = this.fm.stringWidth(this.text);
            this.updateSize();
        }
    }

    public void setText(String string) {
        this.text = string;
        this.sw = this.fm.stringWidth(string);
        this.paint(this.getGraphics());
    }

    public String getText() {
        return this.text;
    }

    public void setImage(Image image) {
        this.img = image;
        this.paint(this.getGraphics());
    }

    public Image getImage() {
        return this.img;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (graphics != null) {
            if (this.img != null) {
                int n = this.getSize().width;
                int n2 = this.getSize().height;
                int n3 = this.img.getWidth(this);
                int n4 = this.img.getHeight(this);
                int n5 = n;
                int n6 = n * n4 / n3;
                if (n4 > n3) {
                    n6 = n2;
                    n5 = n2 * n3 / n4;
                }
                int n7 = (n - n5) / 2;
                int n8 = (n2 - n6) / 2;
                graphics.drawImage(this.img, n7, n8, n5, n6, this);
            } else {
                graphics.setFont(this.getFont());
                int n = (this.getSize().height - this.fm.getMaxAscent() - this.fm.getMaxDescent()) / 2 + this.fm.getMaxAscent();
                int n9 = this.extraSpace;
                if (this.align == 2) {
                    n9 = this.getSize().width - this.sw - this.extraSpace;
                } else if (this.align == 1) {
                    n9 = (this.getSize().width - this.sw) / 2;
                }
                graphics.setColor(this.getForeground());
                graphics.drawString(this.text, n9, n);
            }
        }
    }
}

